/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import oracle.dmt.dataminer.server.model.ModelLrb;

public class SortSpec {
    private String _attributeName;
    private SortDirection _sortDirection;
    private boolean _useIt;
    private static final String SQL_ASCENDING = "ASC";
    private static final String SQL_DESCENDING = "DESC";

    public SortSpec(String string, SortDirection sortDirection) throws Exception {
        this(string, sortDirection, true);
    }

    public SortSpec(String string, SortDirection sortDirection, boolean bl) throws Exception {
        if (string == null) {
            throw new Exception(ModelLrb.get("SORT_ATTRIBUTE_NAME_ERROR"));
        }
        if (string.length() == 0) {
            throw new Exception(ModelLrb.get("SORT_ATTRIBUTE_NAME_ERROR"));
        }
        this._attributeName = string;
        this._sortDirection = sortDirection;
        this._useIt = bl;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public SortDirection getSortDirection() {
        return this._sortDirection;
    }

    public String getSortSQLString() {
        return this._attributeName + " " + (this.isAscending() ? SQL_ASCENDING : SQL_DESCENDING) + " ";
    }

    public boolean isAscending() {
        return this._sortDirection == SortDirection.ASCENDING;
    }

    public boolean isDecending() {
        return this._sortDirection == SortDirection.DESCENDING;
    }

    public void setAttributeName(String string) {
        this._attributeName = string;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this._sortDirection = sortDirection;
    }

    public void setUseIt(boolean bl) {
        this._useIt = bl;
    }

    public boolean isUseIt() {
        return this._useIt;
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }
}

