/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.ai;

import java.awt.Component;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterNavNode;
import oracle.dmt.dataminer.teditor.ai.DialogsLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterResultType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class AIViewerPanel
extends DataMinerViewGUI {
    private AttrsTableModelEx _models;
    private Map<String, Statistics> _statisticLookupMap = new TreeMap<String, Statistics>();
    private Map<String, String> _attrTypeLookupMap = new HashMap<String, String>();
    private BlockingComponent overLayPanel = null;
    private static final String[] _columnNamesEx = new String[]{DialogsLrb.get("AI_EDITOR_TABLE_COL_NAME"), DialogsLrb.get("AI_EDITOR_TABLE_COL_TYPE"), DialogsLrb.get("AI_EDITOR_TABLE_COL_RANK"), DialogsLrb.get("AI_EDITOR_TABLE_COL_IMPORTANCE")};
    private static final int[] _columnWidthsEx = new int[]{180, 80, 50, 80};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int RANK = 2;
    private static final int IMPORTANCE = 3;
    private JLabel jTargetColumnLabel;
    private JLabel jTargetLabel;
    private DataMinerTablePanel tablePanel;

    public AIViewerPanel(Editor editor, Context context) {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, (Component)this.jTargetColumnLabel, (String)DialogsLrb.get("AI_EDITOR_TARGET_LABEL"));
    }

    @Override
    public void initUI() {
        this._models = new AttrsTableModelEx();
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("AI_EDITOR_TABLE_TITLE"), 0);
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new NumberCellRenderer());
        tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(3);
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 0, 0);
        numberFormat.setMaximumFractionDigits(modelViewerPreferenceSettings.getPercentagePrecisionLevel());
        numberFormat.setMinimumIntegerDigits(1);
        tableColumn.setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this.tablePanel.getTable().setColumnSelectorAvailable(true);
        this.tablePanel.getTable().setShowToolTips(true);
        this.tablePanel.getTable().setUpdateSelectionOnSort(true);
        this.tablePanel.getTable().setRowSelectionAllowed(true);
        this.tablePanel.getTable().setSortColumn(2, true);
        int n = 0;
        for (int n2 : _columnWidthsEx) {
            this.tablePanel.getTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        Object object = new LoadUI();
        ((SwingWorker)object).execute();
    }

    public void reload() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public HelpInfo getHelpInfo() {
        String string = "ai_viewer_help";
        return new HelpInfo(string);
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initComponents() {
        this.jTargetLabel = new JLabel();
        this.jTargetColumnLabel = new JLabel();
        this.tablePanel = new DataMinerTablePanel();
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetColumnLabel.setText("Target Column");
        this.jTargetColumnLabel.setName("jTargetColumnLabel");
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetColumnLabel, -2, 213, -2).addGap(0, 125, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetColumnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 258, Short.MAX_VALUE).addContainerGap()));
    }

    private static class AttrsTableModelEx
    extends GenericBaseTableModel {
        Map<String, Statistics> _statisticLookupMap;

        public int getRowCount() {
            return this._statisticLookupMap != null ? this._statisticLookupMap.size() : 1;
        }

        public AttrsTableModelEx() {
            this(null);
        }

        public AttrsTableModelEx(Map<String, Statistics> map) {
            this._statisticLookupMap = map;
            this.setColumnIdentifiers(_columnNamesEx);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._statisticLookupMap == null) {
                return "Loading...";
            }
            Object[] objectArray = this._statisticLookupMap.keySet().toArray();
            Object object = null;
            if (objectArray.length > 0) {
                Statistics statistics = this._statisticLookupMap.get(objectArray[n]);
                switch (n2) {
                    case 0: {
                        object = objectArray[n];
                        break;
                    }
                    case 1: {
                        object = statistics.getType();
                        break;
                    }
                    case 2: {
                        if (statistics == null) break;
                        object = statistics.getRank();
                        break;
                    }
                    case 3: {
                        if (statistics == null) break;
                        object = statistics.getImportance();
                        break;
                    }
                }
            }
            return object;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean displayRerunNodeMsg = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadResults(ColumnFilterNodeType columnFilterNodeType) throws Exception {
            block10: {
                Connection connection = null;
                try {
                    Object object2;
                    for (Object object2 : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                        AIViewerPanel.this._attrTypeLookupMap.put(object2.getName(), object2.getDataType());
                    }
                    ColumnFilterResultType columnFilterResultType = columnFilterNodeType.getColumnFilterResults();
                    object2 = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute().getName();
                    if (columnFilterResultType == null) break block10;
                    AIViewerPanel.this._statisticLookupMap.clear();
                    connection = Connections.getUniqueConnection(AIViewerPanel.this._context);
                    SQLHelper sQLHelper = new SQLHelper();
                    String string = columnFilterResultType.getAttrImportanceOutput();
                    if (string == null) break block10;
                    try {
                        String string2 = "SELECT ATTRIBUTE_NAME, IMPORTANCE_VALUE, RANK FROM " + string + " WHERE ATTRIBUTE_NAME != :1 ORDER BY RANK";
                        sQLHelper.pstmt = connection.prepareStatement(string2);
                        sQLHelper.pstmt.setString(1, (String)object2);
                        sQLHelper.pstmt.setFetchSize(100);
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        String string3 = null;
                        Integer n = null;
                        Double d = null;
                        while (sQLHelper.rs.next()) {
                            string3 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                            n = sQLHelper.rs.getInt("RANK");
                            d = sQLHelper.rs.getDouble("IMPORTANCE_VALUE");
                            Statistics statistics = new Statistics();
                            statistics.setType((String)AIViewerPanel.this._attrTypeLookupMap.get(string3));
                            statistics.setRank(n);
                            statistics.setImportance(d);
                            AIViewerPanel.this._statisticLookupMap.put(string3, statistics);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                        this.displayRerunNodeMsg = true;
                    }
                    finally {
                        sQLHelper.close();
                    }
                }
                finally {
                    SQLHelper.close(connection);
                }
            }
        }

        protected Object doInBackground() throws Exception {
            try {
                Node node = AIViewerPanel.this._context.getNode();
                if (node instanceof ColumnFilterNavNode) {
                    ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                    ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                    this.loadResults(columnFilterNodeType);
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    AIViewerPanel.this._models = new AttrsTableModelEx(AIViewerPanel.this._statisticLookupMap);
                    AIViewerPanel.this.tablePanel.getTable().setModel((TableModel)((Object)AIViewerPanel.this._models));
                    Node node = AIViewerPanel.this._context.getNode();
                    if (node instanceof ColumnFilterNavNode) {
                        if (this.displayRerunNodeMsg) {
                            AIViewerPanel.this.tablePanel.getTable().setNoEntryInstructionText(DialogsLrb.get("AI_EDITOR_TABLE_FAILURE_MESG_TRY_RERUN"));
                            this.displayRerunNodeMsg = false;
                        } else {
                            ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                            AIViewerPanel.this.jTargetColumnLabel.setText(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute().getName());
                            AIViewerPanel.this.tablePanel.getTable().setSortColumn(2, true);
                        }
                    }
                } else {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("AI_EDITOR_ERROR_MESG"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("AI_EDITOR_ERROR_MESG"), null);
            }
            finally {
                if (AIViewerPanel.this.overLayPanel != null) {
                    AIViewerPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private static class Statistics {
        String _type;
        Integer _rank;
        Double _importance;

        public Statistics() {
            this(null, null, null);
        }

        public Statistics(String string, Integer n, Double d) {
            this._type = string;
            this._rank = n;
            this._importance = d;
        }

        public void setRank(Integer n) {
            this._rank = n;
        }

        public Integer getRank() {
            return this._rank;
        }

        public void setImportance(Double d) {
            this._importance = d;
        }

        public Double getImportance() {
            return this._importance;
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getType() {
            return this._type;
        }
    }
}

