/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dmt.dataminer.teditor.sql.SQLEditorLrb;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.Components;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public abstract class ODMrExtendedTypeEditPanel
extends AbstractPopupCellEditor {
    protected ExtendedType extendedType;
    protected URL saveToURL = null;
    protected static URL _lastSaveUrl;
    protected HeaderPanel<JPanel> savedInfoHeaderPanel;
    protected HeaderPanel<JPanel> localInfoHeaderPanel;
    protected JTable savedDataTable;
    protected JTable localDataTable;
    protected String[] columnNames = new String[]{Messages.getString((String)"ExtendedTypeEditPanel.0"), Messages.getString((String)"ExtendedTypeEditPanel.1")};
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JLabel savedDataImageLabel = new JLabel();
    protected BasicEditorPane savedDataTextArea = EditorFactory.createIdeEditorPane();
    protected JLabel localDataImageLabel = new JLabel();
    protected JTextArea localDataTextArea = new JTextArea();
    protected JCheckBox savedViewAsImageBtn = new JCheckBox();
    protected JCheckBox savedViewAsTextBtn = new JCheckBox();
    protected JCheckBox localViewAsImageBtn = new JCheckBox();
    protected JCheckBox localViewAsTextBtn = new JCheckBox();
    protected JScrollPane savedImageScrollPane = new JScrollPane(this.savedDataImageLabel);
    protected JScrollPane savedTextScrollPane = null;
    protected JScrollPane localImageScrollPane = new JScrollPane(this.localDataImageLabel);
    protected JScrollPane localTextScrollPane = new JScrollPane(this.localDataTextArea);
    protected JTabbedPane tabbedPane;
    protected ComponentWithTitlebar<JComponent> columnComponentWithTitlebar = new ComponentWithTitlebar();
    private SearchField _jFilterCtl = new SearchField();
    private Component _findPane;
    private int _nextOffset = -1;
    protected JPanel infoPanel;
    protected boolean savedShowImage = false;
    protected boolean savedShowText = false;
    protected boolean localShowImage = false;
    protected boolean localShowText = false;
    protected Connection conn = null;
    protected boolean editable = false;
    protected JEWTDialog _dialog = null;
    public static final Color CARET_COLOR;
    public static final Color SELECTION_TEXT_COLOR;
    public static final Color SELECTION_COLOR;
    private boolean _isEdited;

    public ODMrExtendedTypeEditPanel(ExtendedType extendedType) {
        this.extendedType = extendedType;
        this.savedDataTextArea = new BasicEditorPane();
        this.savedDataTextArea.setCaretColor(CARET_COLOR);
        this.savedDataTextArea.setSelectedTextColor(SELECTION_TEXT_COLOR);
        this.savedDataTextArea.setSelectionColor(SELECTION_COLOR);
        BasicDocument basicDocument = new BasicDocument();
        basicDocument.setLanguageSupport("foo.xml");
        this.savedDataTextArea.setDocument((Document)basicDocument);
        this.savedDataTextArea.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        final FindHighlightPlugin findHighlightPlugin = new FindHighlightPlugin();
        this.savedDataTextArea.installPlugin((EditorPlugin)findHighlightPlugin);
        JScrollPane jScrollPane = new JScrollPane((Component)this.savedDataTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setScrollMode(1);
        this.columnComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this.columnComponentWithTitlebar.setControlBar(controlBar);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPrompt(SQLEditorLrb.get("SQL_VIEWER_FIND"));
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                if (ODMrExtendedTypeEditPanel.this._nextOffset != -1) {
                    if (direction == SearchEvent.Direction.FORWARD) {
                        ODMrExtendedTypeEditPanel.this._nextOffset += string.length();
                    }
                }
                ODMrExtendedTypeEditPanel.this._nextOffset = findHighlightPlugin.findText(string, ODMrExtendedTypeEditPanel.this._nextOffset == -1 ? 0 : ODMrExtendedTypeEditPanel.this._nextOffset, direction == SearchEvent.Direction.FORWARD, false, true, false, true);
                Components.setCaretPositionCenter((JTextComponent)ODMrExtendedTypeEditPanel.this.savedDataTextArea, (int)ODMrExtendedTypeEditPanel.this._nextOffset);
                Components.moveCaretPositionCenter((JTextComponent)ODMrExtendedTypeEditPanel.this.savedDataTextArea, (int)(ODMrExtendedTypeEditPanel.this._nextOffset + string.length()));
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.createGUI();
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 180);
        Dimension dimension3 = this.derive(dimension, 100);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    protected abstract void createGUI();

    protected abstract String[][] getTableData();

    public abstract boolean processExtendedType();

    protected abstract void load();

    protected void showAsText(ExtendedType extendedType, boolean bl) {
        if (extendedType != null) {
            try {
                this.savedDataTextArea.setText("");
                InputStream inputStream = null;
                if (bl) {
                    inputStream = extendedType.getBinaryStream();
                } else if (extendedType.getLoadFromURL() != null) {
                    inputStream = extendedType.getLoadFromURL().openStream();
                }
                ShowTextTask showTextTask = new ShowTextTask(Messages.getString((String)"ExtendedTypeEditPanel.23"), true, IRaptorTaskRunMode.MODAL, inputStream);
                showTextTask.getDescriptor().addListener((IRaptorTaskListener)new ShowTextTaskListener(showTextTask, bl));
                RaptorTaskManager.getInstance().addTask((RaptorTask)showTextTask);
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    protected void setNull() {
        this.extendedType.setNULL(true);
    }

    public void dismissPopupEditor() {
        this.savedDataTextArea.setText("");
        this.savedDataImageLabel.setIcon(null);
        this.localDataTextArea.setText("");
        this.localDataImageLabel.setIcon(null);
        super.dismissPopupEditor();
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getDefaultComponent() {
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isNULL() {
        return false;
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public String validateValue() {
        return null;
    }

    protected boolean isFileEdited() {
        return this._isEdited;
    }

    protected void setFileEdited(boolean bl) {
        this._isEdited = bl;
    }

    public void setPopupDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder readText(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, IdeUtil.getIdeEncoding()));
                if (bufferedReader != null) {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string + "\n");
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        return stringBuilder;
    }

    static {
        CARET_COLOR = Color.black;
        SELECTION_TEXT_COLOR = Color.white;
        SELECTION_COLOR = Color.blue;
    }

    private class ShowTextTaskListener
    extends RaptorTaskAdapter {
        private ShowTextTask _task;
        private boolean _savedData;

        ShowTextTaskListener(ShowTextTask showTextTask, boolean bl) {
            this._task = showTextTask;
            this._savedData = bl;
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            try {
                StringBuilder stringBuilder = (StringBuilder)this._task.getResult();
                this.showText(stringBuilder.toString(), null);
            }
            catch (InterruptedException interruptedException) {
                this.showText(null, interruptedException);
            }
            catch (ExecutionException executionException) {
                this.showText(null, executionException);
            }
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showText(null, raptorTaskEvent.getThrowable());
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showText(null, raptorTaskEvent.getThrowable());
        }

        private void showText(final String string, final Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ODMrExtendedTypeEditPanel.this.savedDataTextArea.setEditable(true);
                    if (ShowTextTaskListener.this._savedData) {
                        if (throwable != null) {
                            ODMrExtendedTypeEditPanel.this.savedDataTextArea.setText(RaptorTaskUtils.getErrorMessage((Throwable)throwable));
                        } else {
                            ODMrExtendedTypeEditPanel.this.savedDataTextArea.setText(string);
                        }
                    } else if (throwable != null) {
                        ODMrExtendedTypeEditPanel.this.localDataTextArea.setText(RaptorTaskUtils.getErrorMessage((Throwable)throwable));
                    } else {
                        ODMrExtendedTypeEditPanel.this.localDataTextArea.setText(string);
                    }
                    ODMrExtendedTypeEditPanel.this.savedDataTextArea.setEditable(false);
                }
            });
        }
    }

    private class ShowTextTask
    extends RaptorTask {
        InputStream _in;

        public ShowTextTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, InputStream inputStream) {
            super(string, bl, iRaptorTaskRunMode);
            this._in = null;
            this._in = inputStream;
        }

        protected StringBuilder doWork() throws TaskException {
            return ODMrExtendedTypeEditPanel.this.readText(this._in);
        }
    }
}

