/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.query.Column;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableCellEditor;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.jdbc.OracleResultSet;
import oracle.sql.ROWID;

public class ODMrResultSetTableModel
extends AbstractTableModel {
    private static final Logger theLogger = Logger.getLogger(ODMrResultSetTableModel.class.getName());
    private Connection _connection;
    private Context _context;
    private final List<String> _skipCols = new ArrayList<String>();
    private static final String[] LINK_COLS = new String[]{"SDEV_LINK_OWNER", "SDEV_LINK_NAME", "SDEV_LINK_TYPE"};
    protected volatile ProgressRunnable _runner;
    protected String _sql;
    protected String _tablename;
    protected ResultSet _rs;
    private PreparedStatement _stmt = null;
    private static final int FETCH_SIZE = 50;
    protected boolean _allFetched;
    private List _tablerows;
    protected List _backupRows;
    private boolean _isRunning;
    private boolean _isSorting;
    protected final Object LOCK = new Object();
    private Map<Connection, ReentrantLock> m_locks = new HashMap<Connection, ReentrantLock>();
    private String _whereClause;
    private String _orderByClause;
    private int _sortCol;
    private String _sortDir;
    public static final String SORT_A = " asc";
    public static final String SORT_D = " desc";
    protected List<String> _colNames;
    protected Map<String, String> _colNametoColType;
    protected Map<String, Integer> _colNameOccurance;
    private boolean _runInThread = false;
    private boolean _translatedColNames = true;
    private HashMap _translatedColMap = null;
    private boolean _useStandardColumnSize = false;
    private int _standardColumnSize = 200;
    private boolean _verticalDisplay = false;
    private int[] _colSizes;
    private int[] _types;
    private JLabel _label = new JLabel("");
    protected Map _bindMap = null;
    private TableWorker _queryRrunner;
    private boolean _error = false;
    private boolean _cancelled = false;
    private int fetchSize;
    private List rows;
    private int count;
    private List newRows;
    private DataViewerState state;
    private boolean uiUpdated = false;
    private static final int MAX_RS_FETCHSIZE = 1000;

    public boolean isUIUpdated() {
        return this.uiUpdated;
    }

    public void cancelStmt() {
        if (this._stmt != null) {
            try {
                this._stmt.cancel();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public ODMrResultSetTableModel(DataViewerState dataViewerState) {
        this.state = dataViewerState;
    }

    public boolean isErrorCondition() {
        return this._error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context, ResultSet resultSet, String string) {
        this._context = context;
        try {
            this._connection = Connections.getUniqueConnection(context);
        }
        catch (Exception exception) {
            this._connection = null;
        }
        if (this._connection == null) {
            return;
        }
        for (String string2 : LINK_COLS) {
            this._skipCols.add(string2);
        }
        this.setSql(string);
        if (resultSet != null) {
            this._rs = resultSet;
            Object object = null;
            try {
                object = (PreparedStatement)resultSet.getStatement();
                object.setEscapeProcessing(false);
            }
            catch (SQLException sQLException) {
            }
            catch (ClassCastException classCastException) {
            }
            finally {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
        this.open();
    }

    public String getSQL() {
        if (this._sql == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this._sql);
        if (this._whereClause != null && this._whereClause.trim().length() > 0) {
            if (this._whereClause.trim().toLowerCase().indexOf("where") != 0) {
                stringBuilder.append(" where ");
            }
            stringBuilder.append(this._whereClause);
        }
        if (this._orderByClause != null && this._orderByClause.trim().length() > 0) {
            if (this._orderByClause.trim().toLowerCase().indexOf("order by") != 0) {
                stringBuilder.append(" order by  ");
            }
            stringBuilder.append(this._orderByClause);
        }
        if (this._sortCol > 0) {
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(this.getSortCol());
            stringBuilder.append(this.getSortDirection());
        }
        return ODMrResultSetTableModel._sanitizeOracleSQL(stringBuilder.toString());
    }

    public ResultSet openResultSet() throws SQLException {
        ResultSet resultSet = null;
        String string = this.getSQL();
        this._stmt = this.getConnection().prepareStatement(string);
        this._stmt.setEscapeProcessing(false);
        resultSet = this._stmt.executeQuery();
        return resultSet;
    }

    public ResultSet openResultSet(boolean bl) throws SQLException {
        ResultSet resultSet = null;
        String string = this.getSQL();
        this._stmt = this.getConnection().prepareStatement(string);
        this._stmt.setEscapeProcessing(false);
        resultSet = this._stmt.executeQuery();
        return resultSet;
    }

    public boolean open() {
        return this.open(this._getFetchSize());
    }

    boolean open(int n) {
        this._allFetched = false;
        this._fetchNext(n);
        return true;
    }

    public void closeConnection() {
        SQLHelper.close(this._connection);
    }

    public void refresh(int n) {
        this._queryRrunner = new Refresher(n);
        this._queryRrunner.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cleanup() {
        Object object = this.LOCK;
        synchronized (object) {
            this._tablerows = null;
            this._backupRows = null;
            this._allFetched = false;
            try {
                if (this._rs != null) {
                    this._rs.close();
                }
                this._rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void prepareForSort() {
        this.backupRows();
        this._allFetched = false;
        if (this._rs != null) {
            try {
                this._rs.close();
                this._rs = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            try {
                if (this._stmt != null) {
                    this._stmt.close();
                }
                this._stmt = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    boolean close() {
        if (this._rs != null) {
            try {
                Statement statement = this._rs.getStatement();
                this._cleanup();
                if (statement != null) {
                    statement.close();
                }
                this._stmt = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return true;
    }

    void interruptSorting() {
        try {
            if (this.isSorting()) {
                this._stmt.cancel();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage());
        }
        this.close();
    }

    public void fetchAll() {
        if (this._allFetched) {
            return;
        }
        this._fetchNext(Integer.MAX_VALUE);
    }

    private String rawToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = n2 >>> 4;
            stringBuffer.append(this.nibbletochar(n3));
            int n4 = n2 & 0xF;
            stringBuffer.append(this.nibbletochar(n4));
        }
        return stringBuffer.toString();
    }

    private char nibbletochar(int n) {
        int n2 = 48;
        if (n < 10) {
            n2 = (char)(48 + n);
        } else if (n == 10) {
            n2 = 65;
        } else if (n == 11) {
            n2 = 66;
        } else if (n == 12) {
            n2 = 67;
        } else if (n == 13) {
            n2 = 68;
        } else if (n == 14) {
            n2 = 69;
        } else if (n == 15) {
            n2 = 70;
        }
        return (char)n2;
    }

    public int getLoadedCount() {
        int n = 0;
        if (this._tablerows != null) {
            n = this._tablerows.size();
        } else if (this._backupRows != null) {
            n = this._backupRows.size();
        }
        return n;
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this._tablerows != null) {
            n = this._tablerows.size();
        } else if (this._backupRows != null) {
            n = this._backupRows.size();
        }
        if (n > 0 && !this._allFetched) {
            n += this._getFetchSize() + 1;
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        int n = this._colNames != null ? this._colNames.size() : 0;
        return n + 1;
    }

    public String getRawColumnName(int n) {
        String string = this._colNames.get(n);
        String string2 = this._colNametoColType.get(string);
        try {
            if (!DatabaseMetadataUtils.isDataTypeSupported(string2)) {
                return null;
            }
            if (DatabaseMetadataUtils.isACustomDataType(this._context, string2)) {
                return null;
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
            return null;
        }
        return string;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return DataLrb.get("DATA_VIEWER_ROW_NUMBER");
        }
        if (!this._translatedColNames) {
            return this._colNames.get(n - 1);
        }
        return this._colNames != null ? this.translate(this._colNames.get(n - 1)) : null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        List list;
        if (n2 < 0) {
            return null;
        }
        List list2 = list = this._tablerows != null ? this._tablerows : this._backupRows;
        if (list != null) {
            boolean bl = false;
            if (!this.isSorting()) {
                if (n >= list.size() && !this._isRunning) {
                    bl = true;
                }
                if (bl) {
                    this._fetchNext(n - (list.size() - 1));
                }
            }
            if (n < list.size()) {
                if (n2 == 0) {
                    return n + 1;
                }
                List list3 = (List)list.get(n);
                if (list3 != null && list3.size() > n2 - 1) {
                    return list3.get(n2 - 1);
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Object object = this.getValueAt(0, n);
        return object != null ? object.getClass() : Object.class;
    }

    public Column getQueryColumn(int n, int n2) {
        Column column = null;
        return column;
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        int n3 = this.getType(n2 - 1);
        return !ODMrResultSetTableCellEditor.isInPlaceEditingAllowed(n3) || ODMrResultSetTableCellEditor.hasExtendedEdit(n3);
    }

    public boolean isCellEditorEditable(int n, int n2) {
        return false;
    }

    protected static String _sanitizeOracleSQL(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    private void _createColumnNamesList() throws SQLException {
        ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this._colNames = new ArrayList<String>();
        this._colNameOccurance = new HashMap<String, Integer>();
        if (this._verticalDisplay) {
            this._types = new int[2];
            this._colSizes = new int[2];
            this._colNames.add(this.translate("Name"));
            this._colNames.add(this.translate("Value"));
            this._colSizes[0] = 30;
            this._colSizes[1] = 60;
            this._types[0] = 12;
            this._types[1] = 12;
        } else {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n5 = 0;
            boolean bl = false;
            for (n2 = 1; n2 <= n; ++n2) {
                bl = false;
                for (int i = 0; this._skipCols != null && i < this._skipCols.size(); ++i) {
                    if (!this._skipCols.get(i).toUpperCase().equals(resultSetMetaData.getColumnName(n2).toUpperCase())) continue;
                    bl = true;
                }
                if (bl) continue;
                String string = resultSetMetaData.getColumnTypeName(n2);
                String string2 = resultSetMetaData.getColumnLabel(n2);
                String string3 = this.getUniqueColumnName(string2);
                this._colNames.add(string3);
                if (this._colNametoColType == null) {
                    this._colNametoColType = new HashMap<String, String>();
                }
                this._colNametoColType.put(string3, string);
                this._label.setText(string3);
                n3 = Double.valueOf(this._label.getPreferredSize().getWidth()).intValue();
                n4 = resultSetMetaData.getColumnDisplaySize(n2);
                nArray2[n5] = n3 > n4 ? n3 : n4;
                nArray[n5] = resultSetMetaData.getColumnType(n2);
                ++n5;
            }
            this._types = nArray;
            if (this._useStandardColumnSize) {
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    nArray2[n2] = this._standardColumnSize;
                }
            }
            this._colSizes = nArray2;
        }
    }

    private String getUniqueColumnName(String string) {
        if (this._colNames.contains(string)) {
            this._colNameOccurance.put(string, this._colNameOccurance.get(string) + 1);
            return string + "_" + (this._colNameOccurance.get(string) - 1);
        }
        this._colNameOccurance.put(string, 1);
        return string;
    }

    public void reorderColumnNamesList(int n, int n2) throws Exception {
        if (!this._verticalDisplay) {
            if (this._types != null) {
                this.reorderArray(this._types, n, n2);
            }
            if (this._colSizes != null) {
                this.reorderArray(this._colSizes, n, n2);
            }
            if (this._colNames != null) {
                String string = this._colNames.get(n);
                this._colNames.remove(n);
                this._colNames.add(n2, string);
            }
        }
    }

    private void reorderArray(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        if (n > n2) {
            System.arraycopy(nArray, n2, nArray, n2 + 1, n - n2);
        } else {
            System.arraycopy(nArray, n + 1, nArray, n, n2 - n);
        }
        nArray[n2] = n3;
    }

    private synchronized void _fetchNext(int n) {
        if (this._allFetched) {
            return;
        }
        this.fetchSize = this._getFetchSize();
        if (this._tablerows == null) {
            this._tablerows = new ArrayList();
        }
        this.rows = this._tablerows;
        this.count = Math.max(this.fetchSize, n);
        this.newRows = new ArrayList(this.fetchSize);
        this._error = false;
        this._cancelled = false;
        this.setRunning(true);
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && editor instanceof DataEditor && ((DataEditor)editor).getOverLayPanel() != null) {
            ((DataEditor)editor).getOverLayPanel().setState(BlockingComponent.State.BLOCKED);
        }
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ODMrResultSetTableModel.this.loadData();
                return null;
            }

            @Override
            protected void done() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ODMrResultSetTableModel.this.state.isClosing()) {
                            ODMrResultSetTableModel.this.closeConnection();
                            return;
                        }
                        ODMrResultSetTableModel.this.updateUI();
                        if (ODMrResultSetTableModel.this.state.isClosing()) {
                            ODMrResultSetTableModel.this.closeConnection();
                            return;
                        }
                        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                        if (editor != null && editor instanceof DataEditor && ((DataEditor)editor).getOverLayPanel() != null) {
                            ((DataEditor)editor).getOverLayPanel().setState(BlockingComponent.State.UNBLOCKED);
                        }
                    }
                });
            }
        };
        swingWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadData() {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                if (!this.lock(this.getConnection())) {
                    return;
                }
                if (this.getConnection().isClosed()) {
                    return;
                }
                if (this._rs != null) return;
                this._rs = this.openResultSet();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                this.unlock(this.getConnection());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object updateUI() {
        this.uiUpdated = false;
        int n = this.count;
        ArrayList<String> arrayList = null;
        Object object = this.LOCK;
        synchronized (object) {
            try {
                if (this._rs == null || this._rs.getFetchSize() == 0) {
                    return null;
                }
                this._createColumnNamesList();
                while (n > 0 && this._rs.next()) {
                    int n2;
                    if (this._verticalDisplay) {
                        for (n2 = 1; n2 <= this._rs.getMetaData().getColumnCount(); ++n2) {
                            arrayList = new ArrayList();
                            arrayList.add(this._rs.getMetaData().getColumnName(n2));
                            this.cacheObjectInARow(arrayList, n2, this._rs);
                            this.newRows.add(arrayList);
                        }
                        continue;
                    }
                    arrayList = new ArrayList<String>();
                    for (int i = 1; i <= this._rs.getMetaData().getColumnCount(); ++i) {
                        n2 = 0;
                        for (int j = 0; n2 == 0 && this._skipCols != null && j < this._skipCols.size(); ++j) {
                            if (!this._skipCols.get(j).toUpperCase().equals(this._rs.getMetaData().getColumnName(i).toUpperCase())) continue;
                            n2 = 1;
                        }
                        if (n2 == 0) {
                            this.cacheObjectInARow(arrayList, i, this._rs);
                        }
                        if (!this._cancelled) continue;
                        throw new InterruptedException();
                    }
                    try {
                        String string = this._rs.getString("SDEV_LINK_NAME");
                        String string2 = this._rs.getString("SDEV_LINK_OWNER");
                        String string3 = this._rs.getString("SDEV_LINK_TYPE");
                        if (string3.equals("PACKAGE BODY")) {
                            string3 = "PACKAGE+BODY";
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.newRows.add(arrayList);
                    --n;
                }
            }
            catch (InterruptedException interruptedException) {
                if (this._backupRows != null && !this._backupRows.isEmpty()) {
                    this.rows.addAll(this._backupRows);
                }
            }
            catch (Exception exception) {
                this._error = true;
            }
            List list = this.newRows;
            int n3 = list.size();
            if (n3 > 0) {
                this.rows.addAll(list);
            }
            if (n3 < this.fetchSize || this._allFetched) {
                this._allFetched = true;
            }
        }
        this.setRunning(false);
        this.fireTableStructureChanged();
        object = EditorManager.getEditorManager().getCurrentEditor();
        if (object != null && object instanceof DataEditor && ((DataEditor)object).getOverLayPanel() != null) {
            ((DataEditor)object).getOverLayPanel().setState(BlockingComponent.State.UNBLOCKED);
        }
        this.uiUpdated = true;
        return null;
    }

    protected int _getFetchSize() {
        return 50;
    }

    private static int getRSFetchSize(int n) {
        return Math.max(Math.min(n, 1000), 1);
    }

    public int[] getColSizes() {
        return this._colSizes;
    }

    public void setColSizes(int[] nArray) {
        this._colSizes = nArray;
    }

    public int[] getTypes() {
        return this._types;
    }

    public int getType(int n) {
        return this._types != null && this._types.length > n ? this._types[n] : 0;
    }

    public void setTypes(int[] nArray) {
        this._types = nArray;
    }

    public boolean allFetched() {
        return this._allFetched;
    }

    public void setResultSet(ResultSet resultSet) {
        this._rs = resultSet;
    }

    public ResultSet getResultSetCopy() throws SQLException {
        return this.openResultSet();
    }

    public void setRunning(boolean bl) {
        this._isRunning = bl;
        this.updateEditor();
    }

    public void setSorting(boolean bl) {
        this._isSorting = bl;
        this.updateEditor();
    }

    private void updateEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                if (editor != null && editor.getContext() != null && editor instanceof DataEditor) {
                    ((DataEditor)editor).updateToolbar();
                }
            }
        });
    }

    private void backupRows() {
        if (this._tablerows != null && this._tablerows.size() > 0) {
            this._backupRows = null;
            this._backupRows = new ArrayList(this._tablerows.size());
            this._backupRows.addAll(this._tablerows);
            this._tablerows.clear();
            this._tablerows = null;
        }
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public boolean isSorting() {
        return this._isSorting;
    }

    public void setThreaded(boolean bl) {
        this._runInThread = bl;
    }

    public boolean getThreaded() {
        return this._runInThread;
    }

    public void setTranslatedColNames(boolean bl) {
        this._translatedColNames = bl;
    }

    public boolean isTranslatedColNames() {
        return this._translatedColNames;
    }

    public void setTranslatedColMap(HashMap hashMap) {
        this._translatedColMap = hashMap;
    }

    public HashMap getTranslatedColMap() {
        return this._translatedColMap;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setSql(String string) {
        this._sql = string;
        int n = this._sql.toLowerCase().indexOf("from");
        this._tablename = n < 0 ? "" : this._sql.substring(n + "from".length(), this._sql.length()).trim();
    }

    protected String getSql() {
        return this._sql;
    }

    public void setVerticalDisplay(boolean bl) {
        this._verticalDisplay = bl;
    }

    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    public List<String> getSkipCols() {
        return this._skipCols;
    }

    public void setSkipCols(List<String> list) {
        this._skipCols.clear();
        for (String string : LINK_COLS) {
            this._skipCols.add(string);
        }
        if (list != null) {
            this._skipCols.addAll(list);
        }
    }

    public void setWhere(String string) {
        this._whereClause = string;
    }

    public String getWhere() {
        return this._whereClause;
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String string) {
        this._sortDir = string;
    }

    public void setSortCol(int n) {
        if (this._sortCol == n && SORT_A.equals(this._sortDir)) {
            this._sortCol = n;
            this._sortDir = SORT_D;
        } else if (this._sortCol == n && SORT_D.equals(this._sortDir)) {
            this._sortCol = -1;
            this._sortDir = null;
        } else {
            this._sortDir = SORT_A;
            this._sortCol = n;
        }
    }

    public int getSortCol() {
        return this._sortCol;
    }

    public void setContext(Context context) {
        this._context = context;
        if (this._connection != null) {
            return;
        }
        try {
            this._connection = Connections.getUniqueConnection(context);
            if (this._connection != null) {
                ConnectionFolder.setConnectionAlterSessionFixes(this._connection);
            }
        }
        catch (Exception exception) {
            this._connection = null;
        }
    }

    public String getConnName() throws Exception {
        return Connections.getUserAccountName(this._context);
    }

    public void setConnection(Connection connection) throws Exception {
        if (this._connection == null) {
            this._connection = connection;
            if (this._connection != null) {
                ConnectionFolder.setConnectionAlterSessionFixes(this._connection);
            }
        }
    }

    public void setAlterSessionFixedConnection(Connection connection) throws Exception {
        if (this._connection == null) {
            this._connection = connection;
        }
    }

    public void setBindMap(Map map) {
        this._bindMap = map;
    }

    private boolean lock(Connection connection) {
        ReentrantLock reentrantLock = this.getLock(connection);
        return this.lock(reentrantLock);
    }

    public void unlock(Connection connection) {
        ReentrantLock reentrantLock = this.getLock(connection);
        reentrantLock.unlock();
    }

    private ReentrantLock getLock(Connection connection) {
        if (this.m_locks.get(connection) == null) {
            this.m_locks.put(connection, new ReentrantLock());
        }
        return this.m_locks.get(connection);
    }

    private boolean lock(ReentrantLock reentrantLock) {
        boolean bl = false;
        do {
            try {
                if (!reentrantLock.tryLock(500L, TimeUnit.MILLISECONDS)) continue;
                bl = true;
                break;
            }
            catch (InterruptedException interruptedException) {
                theLogger.log(Level.FINEST, "Interrupted while trying to get a lock");
            }
        } while (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)"Connection currrently busy.  Try again?", (String)"Connection busy", null, (boolean)false, (String)"Try Again", (String)"Abort"));
        return bl;
    }

    public static void handleException() {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataLrb.get("DATA_VIEWER_FAILURE_MESDAGE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), null);
    }

    public static void handleExceptionDetailed(Exception exception) {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getLocalizedMessage(), (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), null);
    }

    private String translate(String string) {
        String string2 = string;
        if (this._translatedColMap != null) {
            String string3 = (String)this._translatedColMap.get(string);
            string2 = string3 != null ? string3 : string;
        }
        return string2;
    }

    private void cacheObjectInARow(List list, int n, ResultSet resultSet) throws SQLException {
        Object object = null;
        try {
            object = resultSet instanceof OracleResultSet ? ((OracleResultSet)resultSet).getOracleObject(n) : resultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            object = resultSet.getObject(n);
        }
        int n2 = resultSet.getMetaData().getColumnType(n);
        if (object instanceof byte[]) {
            list.add(this.rawToHex((byte[])object));
        } else if (n2 == 1111 && object instanceof ROWID) {
            String string = resultSet.getString(n);
            byte[] byArray = string.getBytes();
            list.add(new ROWID(byArray));
        } else if (n2 == 93 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getDATE(n));
        } else if (n2 == -102 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getTIMESTAMPLTZ(n));
        } else if (n2 == -101 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getTIMESTAMPTZ(n));
        } else if (n2 == 91 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getDATE(n));
        } else if (object instanceof OracleResultSet) {
            ArrayList arrayList = new ArrayList();
            try {
                OracleResultSet oracleResultSet = (OracleResultSet)object;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 1; i <= oracleResultSet.getMetaData().getColumnCount(); ++i) {
                    arrayList2.add(oracleResultSet.getMetaData().getColumnName(i));
                }
                arrayList.add(arrayList2);
                while (oracleResultSet.next()) {
                    ArrayList arrayList3 = new ArrayList();
                    for (int i = 1; i <= oracleResultSet.getMetaData().getColumnCount(); ++i) {
                        this.cacheObjectInARow(arrayList3, i, (ResultSet)oracleResultSet);
                    }
                    arrayList.add(arrayList3);
                }
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
            list.add(arrayList);
        } else {
            list.add(object);
        }
    }

    public String getOrderBy() {
        return this._orderByClause;
    }

    public void setOrderBy(String string) {
        this._orderByClause = string;
    }

    public void setUseStandardColumnSize(boolean bl) {
        this._useStandardColumnSize = bl;
    }

    public boolean isUseStandardColumnSize() {
        return this._useStandardColumnSize;
    }

    public void setStandardColumnSize(int n) {
        this._standardColumnSize = n;
    }

    public int getStandardColumnSize() {
        return this._standardColumnSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sortColumn(int n) throws Exception {
        int n2;
        SQLException sQLException = null;
        int n3 = Math.max(50, n);
        ArrayList arrayList = new ArrayList(50);
        ArrayList<String> arrayList2 = null;
        try {
            if (!this.lock(this.getConnection())) {
                return;
            }
            this._rs = this.openResultSet(true);
            while (n3 > 0) {
                int n4;
                if (!this._rs.next()) {
                    break;
                }
                if (this._verticalDisplay) {
                    for (n4 = 1; n4 <= this._rs.getMetaData().getColumnCount(); ++n4) {
                        arrayList2 = new ArrayList();
                        arrayList2.add(this._rs.getMetaData().getColumnName(n4));
                        this.cacheObjectInARow(arrayList2, n4, this._rs);
                        arrayList.add(arrayList2);
                    }
                    continue;
                }
                arrayList2 = new ArrayList<String>();
                for (n2 = 1; n2 <= this._rs.getMetaData().getColumnCount(); ++n2) {
                    n4 = 0;
                    for (int i = 0; n4 == 0 && this._skipCols != null && i < this._skipCols.size(); ++i) {
                        if (!this._skipCols.get(i).toUpperCase().equals(this._rs.getMetaData().getColumnName(n2).toUpperCase())) continue;
                        n4 = 1;
                    }
                    if (n4 != 0) continue;
                    this.cacheObjectInARow(arrayList2, n2, this._rs);
                }
                arrayList.add(arrayList2);
                --n3;
            }
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
            arrayList.clear();
        }
        catch (Exception exception) {
            arrayList.clear();
            theLogger.log(Level.SEVERE, exception.getMessage());
            this.close();
        }
        finally {
            this.unlock(this.getConnection());
            this.setSorting(false);
            this.setSortCol(-1);
            if (this.getOrderBy() != null) {
                this.setOrderBy(this.getOrderBy());
            } else {
                this.setOrderBy("");
            }
            if (this.getWhere() != null) {
                this.setWhere(this.getWhere());
            } else {
                this.setWhere("");
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        ArrayList arrayList3 = arrayList;
        n2 = arrayList3.size();
        Object object = this.LOCK;
        synchronized (object) {
            this._tablerows = new ArrayList();
            if (n2 > 0) {
                this._tablerows.addAll(arrayList3);
            }
            if (this._backupRows != null) {
                this._backupRows.clear();
            }
        }
        if (n2 < 50 || this._allFetched) {
            this._allFetched = true;
        }
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    protected class Refresher
    extends TableWorker {
        Refresher(int n) {
            super(n);
            this.bRefresh = true;
        }
    }

    protected class TableWorker
    extends SwingWorker {
        protected Exception _ex = null;
        protected boolean _success = false;
        protected int _fetchSize;
        protected boolean bRefresh;

        protected TableWorker(int n) {
            this._fetchSize = n;
        }

        protected Object doInBackground() throws Exception {
            try {
                this._sortColumn(this._fetchSize);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            block5: {
                super.done();
                try {
                    if (this._success && this._ex == null) break block5;
                    if (this._ex != null) {
                        ODMrResultSetTableModel.handleExceptionDetailed(this._ex);
                        break block5;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataLrb.get("AT_APPLY_DATA_SETTINGS_FAILURE_TITLE"), (String)DataLrb.get("APPLY_DATA_SETTINGS_FAILURE_MESG"), null);
                }
                catch (Exception exception) {
                    ODMrResultSetTableModel.handleException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void _sortColumn(int n) throws Exception {
            int n2;
            int n3 = Math.max(50, n);
            ArrayList arrayList = new ArrayList(50);
            ArrayList<String> arrayList2 = null;
            try {
                if (!ODMrResultSetTableModel.this.lock(ODMrResultSetTableModel.this.getConnection())) {
                    return;
                }
                ODMrResultSetTableModel.this._rs = ODMrResultSetTableModel.this.openResultSet(this.bRefresh);
                while (n3 > 0) {
                    int n4;
                    if (!ODMrResultSetTableModel.this._rs.next()) {
                        break;
                    }
                    if (ODMrResultSetTableModel.this._verticalDisplay) {
                        for (n4 = 1; n4 <= ODMrResultSetTableModel.this._rs.getMetaData().getColumnCount(); ++n4) {
                            arrayList2 = new ArrayList();
                            arrayList2.add(ODMrResultSetTableModel.this._rs.getMetaData().getColumnName(n4));
                            ODMrResultSetTableModel.this.cacheObjectInARow(arrayList2, n4, ODMrResultSetTableModel.this._rs);
                            arrayList.add(arrayList2);
                        }
                        continue;
                    }
                    arrayList2 = new ArrayList<String>();
                    for (n2 = 1; n2 <= ODMrResultSetTableModel.this._rs.getMetaData().getColumnCount(); ++n2) {
                        n4 = 0;
                        for (int i = 0; n4 == 0 && ODMrResultSetTableModel.this._skipCols != null && i < ODMrResultSetTableModel.this._skipCols.size(); ++i) {
                            if (!((String)ODMrResultSetTableModel.this._skipCols.get(i)).toUpperCase().equals(ODMrResultSetTableModel.this._rs.getMetaData().getColumnName(n2).toUpperCase())) continue;
                            n4 = 1;
                        }
                        if (n4 != 0) continue;
                        ODMrResultSetTableModel.this.cacheObjectInARow(arrayList2, n2, ODMrResultSetTableModel.this._rs);
                    }
                    arrayList.add(arrayList2);
                    --n3;
                }
            }
            catch (SQLException sQLException) {
                this._ex = sQLException;
                arrayList.clear();
            }
            catch (Exception exception) {
                arrayList.clear();
                theLogger.log(Level.SEVERE, exception.getMessage());
                ODMrResultSetTableModel.this.close();
            }
            finally {
                ODMrResultSetTableModel.this.unlock(ODMrResultSetTableModel.this.getConnection());
                ODMrResultSetTableModel.this.setSorting(false);
                ODMrResultSetTableModel.this.setSortCol(-1);
                if (ODMrResultSetTableModel.this.getOrderBy() != null) {
                    ODMrResultSetTableModel.this.setOrderBy(ODMrResultSetTableModel.this.getOrderBy());
                } else {
                    ODMrResultSetTableModel.this.setOrderBy("");
                }
                if (ODMrResultSetTableModel.this.getWhere() != null) {
                    ODMrResultSetTableModel.this.setWhere(ODMrResultSetTableModel.this.getWhere());
                } else {
                    ODMrResultSetTableModel.this.setWhere("");
                }
            }
            if (this._ex != null) {
                throw this._ex;
            }
            ArrayList arrayList3 = arrayList;
            n2 = arrayList3.size();
            Object object = ODMrResultSetTableModel.this.LOCK;
            synchronized (object) {
                ODMrResultSetTableModel.this._tablerows = new ArrayList();
                if (n2 > 0) {
                    ODMrResultSetTableModel.this._tablerows.addAll(arrayList3);
                }
                if (ODMrResultSetTableModel.this._backupRows != null) {
                    ODMrResultSetTableModel.this._backupRows.clear();
                }
            }
            if (n2 < 50 || ODMrResultSetTableModel.this._allFetched) {
                ODMrResultSetTableModel.this._allFetched = true;
            }
        }
    }
}

