/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.teditor.graph.AbstractDialog;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.teditor.graph.XYMultiSeriesPanel;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public class AddGraphDialog
extends AbstractDialog {
    private boolean dialogOk = false;
    private Context context;
    private List<AttributeType> nodeAttributes;
    private JPanel graphDefinitionPanel;
    private XYMultiSeriesPanel xyPlotPanel = null;
    private GraphSettingsType settings;
    private GraphSettingsType origSettings;
    private JToggleButton btnBar;
    private JToggleButton btnBox;
    private JButton btnCancel;
    private JButton btnHelp;
    private JToggleButton btnHistogram;
    private JToggleButton btnLine;
    private JButton btnOk;
    private JToggleButton btnScatter;
    private JPanel buttonPanel;
    private JLabel commentLbl;
    private JTextField commentValue;
    private JPanel graphQueryPanel;
    private ButtonGroup graphTypeBtnGroup;
    private JPanel graphTypePanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel titleLbl;
    private JPanel titlePanel;
    private JTextField titleValue;

    public AddGraphDialog(Frame frame, Context context, boolean bl, List<AttributeType> list, GraphSettingsType graphSettingsType) {
        super(frame, bl);
        this.origSettings = graphSettingsType;
        this.context = context;
        this.settings = (GraphSettingsType)MetaDataHelper.copyMetadataObject(graphSettingsType);
        this.nodeAttributes = list;
        this.initComponents();
        this.setLocationRelativeTo((Component)Ide.getMainWindow());
        this.initUI();
    }

    public GraphSettingsType getSettings() {
        return this.settings;
    }

    private void initComponents() {
        this.graphTypeBtnGroup = new ButtonGroup();
        this.graphTypePanel = new JPanel();
        this.titlePanel = new JPanel();
        this.titleLbl = new JLabel();
        this.titleValue = new JTextField();
        this.commentLbl = new JLabel();
        this.commentValue = new JTextField();
        this.buttonPanel = new JPanel();
        this.btnLine = new JToggleButton();
        this.btnScatter = new JToggleButton();
        this.btnBar = new JToggleButton();
        this.btnHistogram = new JToggleButton();
        this.btnBox = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.graphQueryPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.btnHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 200));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.graphTypePanel.setMinimumSize(new Dimension(407, 240));
        this.titleLbl.setText("Title:");
        this.titleValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddGraphDialog.this.titleValueActionPerformed(actionEvent);
            }
        });
        this.commentLbl.setText("Comment:");
        GroupLayout groupLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentLbl).addComponent(this.titleLbl)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleValue).addComponent(this.commentValue))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLbl).addComponent(this.titleValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commentLbl).addComponent(this.commentValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.graphTypeBtnGroup.add(this.btnLine);
        this.btnLine.setText("Line");
        this.btnLine.setPreferredSize(new Dimension(90, 23));
        this.buttonPanel.add(this.btnLine);
        this.graphTypeBtnGroup.add(this.btnScatter);
        this.btnScatter.setText("Scatter");
        this.btnScatter.setMaximumSize(new Dimension(0, 0));
        this.btnScatter.setPreferredSize(new Dimension(90, 23));
        this.buttonPanel.add(this.btnScatter);
        this.graphTypeBtnGroup.add(this.btnBar);
        this.btnBar.setText("Bar");
        this.btnBar.setMaximumSize(new Dimension(0, 0));
        this.btnBar.setPreferredSize(new Dimension(90, 23));
        this.buttonPanel.add(this.btnBar);
        this.graphTypeBtnGroup.add(this.btnHistogram);
        this.btnHistogram.setText("Histogram");
        this.btnHistogram.setPreferredSize(new Dimension(90, 23));
        this.buttonPanel.add(this.btnHistogram);
        this.graphTypeBtnGroup.add(this.btnBox);
        this.btnBox.setText("Box");
        this.btnBox.setPreferredSize(new Dimension(90, 23));
        this.buttonPanel.add(this.btnBox);
        GroupLayout groupLayout2 = new GroupLayout(this.graphTypePanel);
        this.graphTypePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addComponent(this.buttonPanel, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.buttonPanel, -2, -1, -2).addGap(7, 7, 7).addComponent(this.titlePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnCancel.setText("Cancel");
        this.btnOk.setText("OK");
        this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder("Graph Settings"));
        this.graphQueryPanel.setLayout(new BoxLayout(this.graphQueryPanel, 2));
        this.jPanel2.setLayout(new BorderLayout());
        this.graphQueryPanel.add(this.jPanel2);
        this.btnHelp.setText("Help");
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.btnHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 290, Short.MAX_VALUE).addComponent(this.btnOk, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addGap(2, 2, 2)).addComponent(this.graphQueryPanel, -2, 0, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addComponent(this.graphQueryPanel, -1, 296, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnCancel).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnHelp))).addContainerGap()));
        GroupLayout groupLayout4 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.graphTypePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.graphTypePanel, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void titleValueActionPerformed(ActionEvent actionEvent) {
    }

    public boolean isDialogOK() {
        return this.dialogOk;
    }

    private boolean doValidation() {
        Object object;
        GraphType graphType;
        if (this.btnLine.isSelected()) {
            graphType = GraphType.LINE;
        } else if (this.btnScatter.isSelected()) {
            graphType = GraphType.SCATTER;
        } else if (this.btnBar.isSelected()) {
            graphType = GraphType.BAR;
        } else if (this.btnHistogram.isSelected()) {
            graphType = GraphType.HISTOGRAM;
        } else if (this.btnBox.isSelected()) {
            graphType = GraphType.BOX_PLOT;
        } else {
            throw new RuntimeException("Unexpected graph type");
        }
        ((XYMultiSeriesPanel)this.graphDefinitionPanel).doWork();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.titleValue.getText().isEmpty()) {
            arrayList.add(GraphLrb.get("EMPTY_TITLE"));
        } else if (!GraphUtils.validateGraphName(this.context, this.titleValue.getText(), this.origSettings)) {
            arrayList.add(GraphLrb.get("NAME_NOT_UNIQUE"));
        } else if (StringUtils.checkDataLossWithMsg(this.context, this.titleValue.getText(), GraphLrb.get("VALIDATION_ISSUES_TITLE"))) {
            return false;
        }
        if (this.settings.getXAttribute() == null) {
            arrayList.add(GraphLrb.get("NO_X_SPECIFIED"));
        } else if (this.settings.getXAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            arrayList.add(GraphLrb.get("INVALID_X_SPECIFIED"));
        }
        if (GraphUtils.isYRequired(graphType)) {
            if (this.settings.getYAttributes().getYAttribute().isEmpty()) {
                arrayList.add(GraphLrb.get("NO_Y_SPECIFIED"));
            } else {
                for (Object object2 : this.settings.getYAttributes().getYAttribute()) {
                    if (object2.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        arrayList.add(GraphLrb.get("INVALID_Y_SPECIFIED"));
                        break;
                    }
                    if (this.settings.getXAttribute() != null && object2.getName().equals(this.settings.getXAttribute().getName())) {
                        arrayList.add(GraphLrb.get("SAME_X_AND_Y"));
                        break;
                    }
                    if (!this.settings.getGroupByOption().isGroupByEnabled() || this.settings.getGroupByOption().getGroupByAttribute() == null || !object2.getName().equals(this.settings.getGroupByOption().getGroupByAttribute().getName())) continue;
                    arrayList.add(GraphLrb.get("SAME_Y_AND_GROUPBY"));
                    break;
                }
            }
        }
        if (this.settings.getType().equals((Object)GraphType.BAR) && this.settings.getYAttributes().getAggregationFunction() == null) {
            arrayList.add(GraphLrb.get("NO_AGGREGATE_FUNCTION"));
        }
        if (this.settings.getGroupByOption().isGroupByEnabled()) {
            object = this.settings.getGroupByOption().getGroupByAttribute();
            if (object == null || GraphUtils.isDummyGroupByAttr((AttributeType)object)) {
                arrayList.add(GraphLrb.get("NO_GROUPBY_SPECIFIED"));
            } else {
                if (object.getStatus().equals((Object)AttributeStatus.INVALID)) {
                    arrayList.add(GraphLrb.get("INVALID_GROUPBY_SPECIFIED"));
                }
                if (this.settings.getXAttribute() != null && object.getName().equals(this.settings.getXAttribute().getName())) {
                    arrayList.add(GraphLrb.get("SAME_X_AND_GROUPBY"));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            object = new StringBuilder(GraphLrb.get("VALIDATION_ISSUES"));
            ((StringBuilder)object).append("\n\n");
            for (String string : arrayList) {
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("\n");
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)((StringBuilder)object).toString(), (String)GraphLrb.get("VALIDATION_ISSUES_TITLE"), null);
            return false;
        }
        this.settings.setType(graphType);
        this.settings.setName(this.titleValue.getText());
        this.settings.setComment(this.commentValue.getText());
        return true;
    }

    private void initUI() {
        if (this.settings.getType() == null) {
            this.settings.setType(GraphType.LINE);
        }
        this.graphDefinitionPanel = new XYMultiSeriesPanel(this.context, this.nodeAttributes, this.settings);
        this.graphQueryPanel.add((Component)this.graphDefinitionPanel, "West");
        this.pack();
        if (this.graphDefinitionPanel instanceof XYMultiSeriesPanel) {
            this.xyPlotPanel = (XYMultiSeriesPanel)this.graphDefinitionPanel;
        }
        if (this.settings.getXAttribute() == null && this.settings.getYAttributes().getYAttribute().isEmpty() && this.settings.getGroupByOption().getGroupByAttribute() == null) {
            this.setTitle(GraphLrb.get("GRAPH_DIALOG_TITLE_NEW"));
        } else {
            this.setTitle(GraphLrb.get("GRAPH_DIALOG_TITLE_EDIT"));
        }
        this.btnHelp.setText(CommonLrb.get("COMMON_HELP"));
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp(new HelpInfo("graph_editor_new_graph", 0));
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddGraphDialog.this.btnOkActionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddGraphDialog.this.btnCancelActionPerformed();
            }
        });
        this.btnOk.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.btnLine.setIcon(DataMinerIcons.get(Icons.LINE_GRAPH));
        this.btnScatter.setIcon(DataMinerIcons.get(Icons.SCATTER_GRAPH));
        this.btnBar.setIcon(DataMinerIcons.get(Icons.BAR_GRAPH));
        this.btnHistogram.setIcon(DataMinerIcons.get(Icons.HISTOGRAM_GRAPH));
        this.btnBox.setIcon(DataMinerIcons.get(Icons.BOX_GRAPH));
        this.titleValue.setText(this.settings.getName());
        this.commentValue.setText(this.settings.getComment());
        this.commentValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (StringUtils.checkDataLossWithMsg(AddGraphDialog.this.context, AddGraphDialog.this.commentValue.getText(), GraphLrb.get("VALIDATION_ISSUES_TITLE"))) {
                    AddGraphDialog.this.commentValue.setText("");
                }
            }
        });
        JToggleButton jToggleButton = null;
        if (this.settings.getType() == GraphType.LINE) {
            this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_LINE_TITLE")));
            jToggleButton = this.btnLine;
        } else if (this.settings.getType() == GraphType.SCATTER) {
            this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_SCATTER_TITLE")));
            jToggleButton = this.btnScatter;
        } else if (this.settings.getType() == GraphType.BAR) {
            this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_BAR_TITLE")));
            jToggleButton = this.btnBar;
        } else if (this.settings.getType() == GraphType.HISTOGRAM) {
            this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_HISTOGRAM_TITLE")));
            jToggleButton = this.btnHistogram;
        } else if (this.settings.getType() == GraphType.BOX_PLOT) {
            this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_BOX_TITLE")));
            jToggleButton = this.btnBox;
        }
        jToggleButton.setSelected(true);
        jToggleButton.requestFocusInWindow();
        this.btnLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((XYMultiSeriesPanel)AddGraphDialog.this.graphDefinitionPanel).setGraphType(GraphType.LINE);
                AddGraphDialog.this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_LINE_TITLE")));
            }
        });
        this.btnScatter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((XYMultiSeriesPanel)AddGraphDialog.this.graphDefinitionPanel).setGraphType(GraphType.SCATTER);
                AddGraphDialog.this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_SCATTER_TITLE")));
            }
        });
        this.btnBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((XYMultiSeriesPanel)AddGraphDialog.this.graphDefinitionPanel).setGraphType(GraphType.BAR);
                AddGraphDialog.this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_BAR_TITLE")));
            }
        });
        this.btnHistogram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((XYMultiSeriesPanel)AddGraphDialog.this.graphDefinitionPanel).setGraphType(GraphType.HISTOGRAM);
                AddGraphDialog.this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_HISTOGRAM_TITLE")));
            }
        });
        this.btnBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((XYMultiSeriesPanel)AddGraphDialog.this.graphDefinitionPanel).setGraphType(GraphType.BOX_PLOT);
                AddGraphDialog.this.graphQueryPanel.setBorder(BorderFactory.createTitledBorder(GraphLrb.get("GRAPH_TYPE_BOX_TITLE")));
            }
        });
    }

    @Override
    public void btnOkActionPerformed() {
        if (!this.doValidation()) {
            return;
        }
        super.btnOkActionPerformed();
        this.setVisible(false);
        this.dialogOk = true;
    }

    @Override
    public void btnCancelActionPerformed() {
        super.btnCancelActionPerformed();
        this.setVisible(false);
    }
}

