/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.teditor.graph.AbstractDialog;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphPreferences;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class BinningSettingsDialog
extends AbstractDialog {
    private BinningSettingsType binningSettings;
    private boolean dialogOk;
    private boolean isGroupBySettings;
    private Context context;
    private static String DEFAULT_BIN_COUNT = "10";
    List<String> model = new ArrayList<String>();
    List<String> selected = new ArrayList<String>();
    private JButton btnCancel;
    private ButtonGroup btnGroup;
    private JButton btnHelp;
    private JButton btnOk;
    private JCheckBox btnShowNulls;
    private JPanel containerPanel;
    private JLabel lblBinCount;
    private JLabel lblTitle;
    private JRadioButton rdoAutoBin;
    private JRadioButton rdoRawValues;
    private NumberTextField txtBinCount;

    public BinningSettingsDialog(Dialog dialog, Context context, boolean bl, BinningSettingsType binningSettingsType, boolean bl2) {
        super(dialog, bl);
        this.context = context;
        this.binningSettings = binningSettingsType;
        this.dialogOk = false;
        this.isGroupBySettings = bl2;
        this.initComponents();
        this.setLocationRelativeTo(dialog);
        this.initUI();
    }

    private void initComponents() {
        this.btnGroup = new ButtonGroup();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.containerPanel = new JPanel();
        this.rdoRawValues = new JRadioButton();
        this.lblTitle = new JLabel();
        this.rdoAutoBin = new JRadioButton();
        this.lblBinCount = new JLabel();
        this.btnShowNulls = new JCheckBox();
        this.txtBinCount = new NumberTextField();
        this.btnHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.btnCancel.setText("Cancel");
        this.btnOk.setText("OK");
        this.btnGroup.add(this.rdoRawValues);
        this.rdoRawValues.setText("Raw Values (as is)");
        this.lblTitle.setText("Display As:");
        this.btnGroup.add(this.rdoAutoBin);
        this.rdoAutoBin.setText("Binned Automatically");
        this.lblBinCount.setLabelFor((Component)this.txtBinCount);
        this.lblBinCount.setText("Bins:");
        this.btnShowNulls.setText("Show Nulls");
        GroupLayout groupLayout = new GroupLayout(this.containerPanel);
        this.containerPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle, -1, 336, Short.MAX_VALUE).addComponent(this.rdoRawValues, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.rdoAutoBin, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnShowNulls, -2, 106, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblBinCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtBinCount, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdoRawValues).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdoAutoBin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBinCount).addComponent((Component)this.txtBinCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnShowNulls).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnHelp.setText("Help");
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.containerPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.btnHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.containerPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk).addComponent(this.btnHelp)).addContainerGap()));
        this.pack();
    }

    private void initUI() {
        this.setTitle(GraphLrb.get("NUM_SETTINGS_TITLE"));
        this.lblTitle.setText(GraphLrb.get("NUM_SETTINGS_LABEL_DISPLAY_AS"));
        this.rdoRawValues.setText(GraphLrb.get("NUM_SETTINGS_RAW_VALUES"));
        this.rdoAutoBin.setText(GraphLrb.get("NUM_SETTINGS_AUTO_BIN"));
        ResourceUtils.resLabel((JLabel)this.lblBinCount, (Component)this.txtBinCount, (String)GraphLrb.get("NUM_SETTINGS_NUM_BINS"));
        this.btnShowNulls.setText(GraphLrb.get("NUM_SETTINGS_SHOW_NULLS"));
        BinningSettingsType binningSettingsType = this.binningSettings;
        if (binningSettingsType.getBinningKind().equals((Object)BinningType.EQUAL_WIDTH)) {
            this.rdoAutoBin.setSelected(true);
        } else {
            this.rdoRawValues.setSelected(true);
        }
        NumberTextField numberTextField = this.txtBinCount;
        numberTextField.setDataType(Integer.class);
        numberTextField.setSigned(false);
        this.txtBinCount.setLocale(this.getLocale());
        this.txtBinCount.setToolTipText("");
        String string = binningSettingsType.getNumericBinCount() == null ? DEFAULT_BIN_COUNT : binningSettingsType.getNumericBinCount().toString();
        numberTextField.setNumber((Number)Integer.valueOf(string));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BinningSettingsDialog.this.btnCancelActionPerformed();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BinningSettingsDialog.this.btnOkActionPerformed();
            }
        });
        this.btnHelp.setText(CommonLrb.get("COMMON_HELP"));
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp(new HelpInfo("graph_node_binning_settings", 0));
            }
        });
        final GraphPreferences graphPreferences = GraphPreferences.getInstance();
        boolean bl = this.isGroupBySettings ? graphPreferences.isShowGroupByNullsBin() : graphPreferences.isShowNullsBin();
        this.btnShowNulls.setSelected(bl);
        this.btnShowNulls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                if (BinningSettingsDialog.this.isGroupBySettings) {
                    graphPreferences.setShowGroupByNullsBin(bl);
                } else {
                    graphPreferences.setShowNullsBin(bl);
                }
            }
        });
    }

    @Override
    protected void btnCancelActionPerformed() {
        super.btnCancelActionPerformed();
        this.setVisible(false);
    }

    @Override
    protected void btnOkActionPerformed() {
        this.dialogOk = true;
        BinningSettingsType binningSettingsType = this.binningSettings;
        Integer n = (Integer)this.txtBinCount.getNumber();
        if (n < 2) {
            MessageDialog.error((Component)this, (Object)GraphLrb.get("NUM_SETTINGS_INVALID_BIN_COUNT_MSG"), (String)GraphLrb.get("NUM_SETTINGS_INVALID_BIN_COUNT_TITLE"), null);
            return;
        }
        if (this.rdoAutoBin.isSelected()) {
            binningSettingsType.setBinningEnabled(true);
            binningSettingsType.setBinningKind(BinningType.EQUAL_WIDTH);
            binningSettingsType.setNumericBinCount(BigInteger.valueOf(Integer.valueOf(this.txtBinCount.getText()).intValue()));
            binningSettingsType.setCustomBinning(null);
        } else {
            binningSettingsType.setCustomBinning(null);
            binningSettingsType.setNumericBinCount(null);
            binningSettingsType.setBinningEnabled(false);
            binningSettingsType.setBinningKind(BinningType.NONE);
        }
        super.btnOkActionPerformed();
        this.setVisible(false);
    }
}

