/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.math.BigInteger;
import java.sql.Connection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinGeneration;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressRunnable;

public class CategoricalBinningWorker
extends ProgressRunnable {
    private boolean _canceled;
    private Vector<NameValuePair> values = null;
    private Context context;
    private AttributeType binnedAttribute;
    public static final int DEFAULT_TOPN = 10;

    public CategoricalBinningWorker(Context context, AttributeType attributeType) {
        this.context = context;
        this.binnedAttribute = attributeType;
    }

    public Vector<NameValuePair> getValues() {
        return this.values;
    }

    public Object doWork() throws Exception {
        Connection connection = null;
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.context.getNode();
        WorkflowNode workflowNode = GraphUtils.getWorkflowNavNode(baseTreeNode);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        String string = GraphUtils.getSampleTableName(this.context);
        try {
            connection = ConnectionFolder.getConnectionFolder(this.context).getUniqueConnection();
            TransformationType.Binning binning = new TransformationType.Binning();
            TransformationType.Binning.TopN topN = new TransformationType.Binning.TopN();
            BinGeneration binGeneration = new BinGeneration();
            binGeneration.setAuto(new BinGeneration.Auto());
            topN.setBinCount(BigInteger.valueOf(1000L));
            binning.setTopN(topN);
            this.values = TransformationStatisticsState.generateDefaultBins(connection, "select * from " + string, this.binnedAttribute.getName(), this.binnedAttribute.getDataType(), binning);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected void finish(Object object) {
    }

    protected void doCancel() {
        super.doCancel();
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public static Vector<NameValuePair> getDefaultBins(Context context, AttributeType attributeType, boolean bl) throws Exception {
        Vector<NameValuePair> vector = new Vector();
        if (!bl) {
            CategoricalBinningWorker categoricalBinningWorker = new CategoricalBinningWorker(context, attributeType);
            categoricalBinningWorker.doWork();
            return categoricalBinningWorker.getValues();
        }
        CategoricalBinningWorker categoricalBinningWorker = new CategoricalBinningWorker(context, attributeType);
        categoricalBinningWorker.setTitle("Getting Values");
        categoricalBinningWorker.setMessage("Getting Distinct Values");
        categoricalBinningWorker.setCancelable(false);
        categoricalBinningWorker.start(true);
        vector = categoricalBinningWorker.getValues();
        return vector;
    }
}

