/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.teditor.AbstractDataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.graph.AddGraphDialog;
import oracle.dmt.dataminer.teditor.graph.GraphEditorPanel;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelDegreeEditorDialog;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupByType;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class GraphEditor
extends AbstractDataEditor
implements Dirtyable {
    private Toolbar _toolBar;
    private static Logger theLogger = Logger.getLogger(GraphEditor.class.getName());
    private JButton _refreshButton = new JButton();
    private JButton _addButton = new JButton();
    private JComboBox dataCombo;
    private boolean isDirty = false;
    private WorkflowNode navNode = null;
    private AbstractNode wfNode = null;
    private boolean alreadyActive = false;
    private boolean isViewingSample;
    private boolean needsRefresh = false;
    final JButton parallelViewDialog = new JButton();
    private static int inc = 1;
    private static final String defaultTitle = GraphLrb.get("GRAPH_DEF_NAME_ROOT");
    private DataSelectionItem[] viewChoices = new DataSelectionItem[]{new DataSelectionItem(DataLrb.get("DATA_VIEWER_DATASOURCE_ACTUAL"), false), new DataSelectionItem(GraphLrb.get("VIEW_SAMPLE_DATA"), true)};
    private BlockingComponent overLayPanel = null;
    public boolean handling = false;

    public void setNeedsRefresh() {
        this.needsRefresh = true;
    }

    public GraphEditor() throws Exception {
        this._context = this.getContext();
        this.createActions();
    }

    public void initialize() {
        this._context = this.getContext();
    }

    @Override
    public void close() {
        super.close();
        ((GraphEditorPanel)this._gui).close();
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        String string = connectionFolder.getConnectionName();
        runManager.removeListener(this, string);
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return null;
    }

    @Override
    public Component getGUI() {
        try {
            if (this._gui == null) {
                this.navNode = (WorkflowNode)this.getContext().getProperty("wfNode");
                this.wfNode = (AbstractNode)this.getContext().getProperty("dataNode");
                this._gui = new GraphEditorPanel(this, this.getContext());
                if (this.overLayPanel == null) {
                    this.overLayPanel = new BlockingComponent((JComponent)this._gui);
                    this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
                    this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
                    ((GraphEditorPanel)this._gui).setBlockingComponent(this.overLayPanel);
                }
                AddinManager addinManager = AddinManager.getAddinManager();
                RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
                String string = connectionFolder.getConnectionName();
                runManager.addListener(this, string);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return this.overLayPanel.getBlockingComponent();
    }

    public HelpInfo getHelpInfo() {
        assert (this._gui != null) : "getHelpInfo can not be called if _gui has not been loaded.";
        return ((GraphEditorPanel)this._gui).getHelpInfo();
    }

    public Toolbar getToolbar() {
        return this._toolBar;
    }

    public Component getFixedTopMargin() {
        if (this._toolBar == null) {
            this._toolBar = new Toolbar();
            this._refreshButton.setIcon(DataMinerIcons.get(Icons.REFRESH_ICON));
            this._refreshButton.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this._refreshButton.setToolTipText(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this._refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GraphEditor.this.refresh();
                }
            });
            this._addButton.setIcon(DataMinerIcons.get(Icons.ADD));
            this._addButton.getAccessibleContext().setAccessibleDescription(GraphLrb.get("GRAPH_DIALOG_TITLE_NEW"));
            this._addButton.setToolTipText(GraphLrb.get("GRAPH_DIALOG_TITLE_NEW"));
            this._addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GraphEditor.this.handleAddGraph();
                }
            });
            JLabel jLabel = new JLabel(GraphLrb.get("VIEW_LABEL"));
            this.dataCombo = new JComboBox<DataSelectionItem>(this.viewChoices);
            jLabel.setLabelFor(this.dataCombo);
            FontMetrics fontMetrics = this.dataCombo.getFontMetrics(this.dataCombo.getFont());
            int n = Math.max(fontMetrics.stringWidth(DataLrb.get("DATA_VIEWER_DATASOURCE_ACTUAL")), fontMetrics.stringWidth(GraphLrb.get("VIEW_SAMPLE_DATA")));
            Dimension dimension = this.dataCombo.getMaximumSize();
            dimension.setSize((double)(n + 20), dimension.getHeight());
            this.dataCombo.setMaximumSize(dimension);
            this.updateDataSelector();
            this.setViewingSample(GraphUtils.isSampleAvailable(this.getContext()));
            if (this.isViewingSample()) {
                this.dataCombo.setSelectedIndex(1);
            } else {
                this.dataCombo.setSelectedIndex(0);
            }
            this.dataCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    DataSelectionItem dataSelectionItem = (DataSelectionItem)jComboBox.getSelectedItem();
                    GraphEditor.this.isViewingSample = dataSelectionItem.isSample();
                    GraphEditor.this.refresh();
                }
            });
            this.parallelViewDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ParallelDegreeEditorDialog parallelDegreeEditorDialog = new ParallelDegreeEditorDialog(GraphEditor.this);
                    parallelDegreeEditorDialog.invoke(null);
                }
            });
            this._toolBar.add((Component)this._addButton);
            this._toolBar.add((Component)this._refreshButton);
            this._toolBar.add((Component)jLabel);
            this._toolBar.add((Component)this.dataCombo);
            this._toolBar.addSeparator();
            this._toolBar.add((Component)this.parallelViewDialog);
            this._toolBar.addFiller();
        }
        return this._toolBar;
    }

    public void setViewingSample(boolean bl) {
        this.isViewingSample = bl;
    }

    @Override
    public void updateParallelViewBtnTitle() {
        String string = parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
        if (string == null || !Boolean.parseBoolean(string)) {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_OFF"));
        } else {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_ON"));
        }
    }

    public boolean isViewingSample() {
        return this.isViewingSample;
    }

    private void updateDataSelector() {
        Node node = GraphUtils.findWorkflowNode(this.getContext());
        boolean bl = false;
        if (node instanceof GraphNode) {
            boolean bl2;
            bl = ((GraphNodeType)node.getData()).isSampleDirty();
            boolean bl3 = bl2 = GraphUtils.isSampleAvailable(this.getContext()) && !bl;
            if (!bl2 && this.dataCombo.getSelectedItem() != this.viewChoices[0]) {
                this.dataCombo.setSelectedItem(this.viewChoices[0]);
            }
            this.dataCombo.setEnabled(bl2);
        } else {
            if (this.dataCombo.getSelectedItem() != this.viewChoices[1]) {
                this.dataCombo.setSelectedItem(this.viewChoices[1]);
            }
            this.dataCombo.setEnabled(false);
        }
    }

    @Override
    public void editorShown() {
        super.editorShown();
        this.updateParallelViewBtnTitle();
    }

    @Override
    public void open() {
        super.open();
        this.updateParallelViewBtnTitle();
    }

    public void activate() {
        super.activate();
        Node node = GraphUtils.findWorkflowNode(this.getContext());
        if (node instanceof GraphNode) {
            GraphNode graphNode = (GraphNode)node;
            GraphNodeType graphNodeType = (GraphNodeType)node.getData();
            if (graphNodeType.isViewDirty().booleanValue()) {
                try {
                    graphNode.findOrCreateView(this.getContext());
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, "Failed to drop and create view", exception);
                }
            }
            this.updateDataSelector();
            if (this.needsRefresh) {
                this.refresh();
            }
            if (this.alreadyActive) {
                return;
            }
            this.alreadyActive = true;
            List list = graphNodeType.getGraphSettings().getGraphSetting();
            for (GraphSettingsType graphSettingsType : list) {
                ((GraphEditorPanel)this._gui).addGraph(graphSettingsType);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((GraphEditorPanel)GraphEditor.this._gui).updateGraphContainers();
                }
            });
            if (list.isEmpty()) {
                this.handleAddGraph();
            }
        } else if (GraphUtils.getGraphSettings(this.getContext()).getGraphSetting().isEmpty()) {
            this.handleAddGraph();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddGraph() {
        if (this.handling) {
            return;
        }
        try {
            String string;
            Object object;
            this.handling = true;
            List list = null;
            Node node = GraphUtils.findWorkflowNode(this.getContext());
            boolean bl = false;
            if (this.wfNode instanceof GraphNode) {
                bl = true;
                object = node.findParentNode();
                if (!(object instanceof DataProvider)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("MISSING_DATA_NODE"), (String)GraphLrb.get("NO_SAMPLE_TITLE"), null);
                    return;
                }
                list = ((DataProvider)object).getAttributes().getAttribute();
            } else if (this.wfNode instanceof DataProvider) {
                object = (DataProvider)((Object)this.wfNode);
                list = object.getAttributes().getAttribute();
            }
            boolean bl2 = true;
            do {
                string = defaultTitle + inc++;
                if (!GraphUtils.validateGraphName(this.getContext(), string, null)) continue;
                bl2 = false;
            } while (bl2);
            GraphSettingsType graphSettingsType = new GraphSettingsType();
            graphSettingsType.setYAttributes(new GraphSettingsType.YAttributes());
            BinningSettingsType binningSettingsType = new BinningSettingsType();
            binningSettingsType.setNumericBinCount(new BigInteger("10"));
            binningSettingsType.setBinningKind(BinningType.EQUAL_WIDTH);
            GroupByType groupByType = new GroupByType();
            BinningSettingsType binningSettingsType2 = new BinningSettingsType();
            binningSettingsType2.setNumericBinCount(new BigInteger("10"));
            binningSettingsType2.setBinningKind(BinningType.EQUAL_WIDTH);
            groupByType.setBinningSettings(binningSettingsType2);
            graphSettingsType.setXBinningSettings(binningSettingsType);
            graphSettingsType.setGroupByOption(groupByType);
            graphSettingsType.setType(GraphType.LINE);
            graphSettingsType.setName(string);
            graphSettingsType.setId(UUID.randomUUID().toString());
            graphSettingsType.setComment("");
            AddGraphDialog addGraphDialog = new AddGraphDialog((Frame)Ide.getMainWindow(), this._context, true, list, graphSettingsType);
            addGraphDialog.setVisible(true);
            if (!addGraphDialog.isDialogOK()) {
                --inc;
                return;
            }
            graphSettingsType = addGraphDialog.getSettings();
            GraphUtils.updateGraphNodeSettings(this._context, graphSettingsType, GraphUtils.UpdateAction.ADD);
            ((GraphEditorPanel)this._gui).addGraph(graphSettingsType);
            BaseTreeNode baseTreeNode = (BaseTreeNode)this.getContext().getNode();
            if (node instanceof GraphNode) {
                WorkflowNode workflowNode = GraphUtils.getWorkflowNavNode(baseTreeNode);
                workflowNode.markDirty(true);
            }
        }
        finally {
            this.handling = false;
        }
    }

    @Override
    public void refresh() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        super.refresh();
        if (this._gui != null) {
            ((GraphEditorPanel)this._gui).refresh();
            this.updateDataSelector();
        }
        this.needsRefresh = false;
    }

    private void createActions() {
    }

    void updateToolbar() {
        View.updateToolbarActions((Toolbar)this._toolBar);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty(boolean bl) {
        this.isDirty = bl;
        this.getContext().getNode().markDirty(bl);
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        super.update(object, updateMessage);
        if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
            this.closeEditor();
        } else if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.refresh();
        }
    }

    class DataSelectionItem {
        private Boolean isSample;
        private String uiText;

        public DataSelectionItem(String string, Boolean bl) {
            this.isSample = bl;
            this.uiText = string;
        }

        public String toString() {
            return this.uiText;
        }

        public Boolean isSample() {
            return this.isSample;
        }
    }
}

