/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.graph.GraphContainerPanel;
import oracle.dmt.dataminer.teditor.graph.GraphLoader;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.teditor.graph.OdmrGraph;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettings;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public class GraphEditorPanel
extends DataMinerViewGUI
implements Scrollable {
    private Map<String, GraphContainerPanel> graphs = new HashMap<String, GraphContainerPanel>();
    private int nextGraphId = 1;
    private BlockingComponent overLayPanel = null;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public GraphEditorPanel(Editor editor, Context context) {
        super(editor, context);
        this.setDoubleBuffered(true);
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        UIResourceHelper.setComponentText(hashMap);
        this.initHelp();
    }

    public void close() {
    }

    private void initHelp() {
        HelpUtils.setHelpID((JComponent)this, (String)"graph_node_graph_edit_dialog");
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("graph_node_editor");
    }

    @Override
    public void initUI() {
        this.setLayout(new ModifiedFlowLayout(0));
    }

    private void unzoom() {
        int n = this.getComponentCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            GraphContainerPanel graphContainerPanel;
            Component component = this.getComponent(i);
            if (!(component instanceof GraphContainerPanel) || !(graphContainerPanel = (GraphContainerPanel)component).isZoomed()) continue;
            graphContainerPanel.toggleZoom();
            break;
        }
    }

    public void addGraph(GraphSettingsType graphSettingsType) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.unzoom();
        String string = UUID.randomUUID().toString();
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        OdmrGraph odmrGraph = new OdmrGraph((ErrorHandler)defaultErrorHandler);
        odmrGraph.setTabularData(new ArrayList());
        odmrGraph.showLegend(false);
        odmrGraph.setLineDataLineDisplayed(true);
        odmrGraph.setGraphicAntialiasing(false);
        odmrGraph.setDisplayGroupsLimit(5000);
        GraphContainerPanel graphContainerPanel = new GraphContainerPanel(this.getContext(), odmrGraph, graphSettingsType);
        graphContainerPanel.setName(string);
        graphContainerPanel.setSize(OdmrGraph.NORMAL_DIM);
        graphContainerPanel.setPreferredSize(OdmrGraph.NORMAL_DIM);
        this.graphs.put(string, graphContainerPanel);
        this.add(graphContainerPanel);
        this.validate();
        this.repaint();
        GraphLoader graphLoader = new GraphLoader(string, graphSettingsType, this._context, graphContainerPanel);
        graphLoader.setBlockingComponent(this.overLayPanel);
        graphLoader.execute();
    }

    public void updateGraphContainers() {
        for (GraphContainerPanel graphContainerPanel : this.graphs.values()) {
            graphContainerPanel.updateToolbarLayout();
        }
        this.invalidate();
        this.repaint();
    }

    public void refresh() {
        Set<String> set = this.graphs.keySet();
        for (String string : set) {
            GraphContainerPanel graphContainerPanel = this.graphs.get(string);
            graphContainerPanel.setBlockingComponent(this.overLayPanel);
            graphContainerPanel.refresh();
        }
    }

    public void reloadGraph(GraphContainerPanel graphContainerPanel, GraphSettingsType graphSettingsType, int n) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        OdmrGraph odmrGraph = graphContainerPanel.getGraph();
        odmrGraph.setGraphType(n);
        odmrGraph.setTabularData(new ArrayList());
        this.validate();
        this.repaint();
        GraphLoader graphLoader = new GraphLoader(graphContainerPanel.getName(), graphSettingsType, this._context, graphContainerPanel);
        graphLoader.setBlockingComponent(this.overLayPanel);
        graphLoader.execute();
    }

    public void removeGraph(GraphContainerPanel graphContainerPanel) {
        String string = graphContainerPanel.getName();
        GraphContainerPanel graphContainerPanel2 = this.graphs.get(string);
        this.remove(graphContainerPanel2);
        this.validate();
        this.repaint();
        GraphSettings graphSettings = GraphUtils.getGraphSettings(this.getContext());
        List list = graphSettings.getGraphSetting();
        if (!list.contains(graphContainerPanel2.getSettings())) {
            throw new RuntimeException("Unexpected graph settings metadata state");
        }
        list.remove(graphContainerPanel2.getSettings());
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.getContext().getNode();
        Node node = GraphUtils.findWorkflowNode(this.getContext());
        if (node instanceof GraphNode) {
            WorkflowNode workflowNode = GraphUtils.getWorkflowNavNode(baseTreeNode);
            workflowNode.markDirty(true);
        }
        this.graphs.remove(string);
    }

    public Map<String, GraphContainerPanel> getGraphs() {
        return this.graphs;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 100;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public class ModifiedFlowLayout
    extends FlowLayout {
        public ModifiedFlowLayout() {
        }

        public ModifiedFlowLayout(int n) {
            super(n);
        }

        public ModifiedFlowLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.computeMinSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.computeSize(container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension computeSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets;
                int n = this.getHgap();
                int n2 = this.getVgap();
                int n3 = container.getWidth();
                if (n3 == 0) {
                    n3 = Integer.MAX_VALUE;
                }
                if ((insets = container.getInsets()) == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                int n4 = 0;
                int n5 = n3 - (insets.left + insets.right + n * 2);
                int n6 = container.getComponentCount();
                int n7 = 0;
                int n8 = insets.top + n2;
                int n9 = 0;
                for (int i = 0; i < n6; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension = component.getPreferredSize();
                    if (n7 == 0 || n7 + dimension.width <= n5) {
                        if (n7 > 0) {
                            n7 += n;
                        }
                        n7 += dimension.width;
                        n9 = Math.max(n9, dimension.height);
                    } else {
                        n7 = dimension.width;
                        n8 += n2 + n9;
                        n9 = dimension.height;
                    }
                    n4 = Math.max(n4, n7);
                }
                n8 += n9;
                return new Dimension(n4 + insets.left + insets.right, n8 += insets.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension computeMinSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                boolean bl = false;
                int n3 = container.getComponentCount();
                for (int i = 0; i < n3; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    bl = true;
                    Dimension dimension = component.getPreferredSize();
                    n = Math.min(n, dimension.width);
                    n2 = Math.min(n2, dimension.height);
                }
                if (bl) {
                    return new Dimension(n, n2);
                }
                return new Dimension(0, 0);
            }
        }
    }
}

