/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class GraphPreferences
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dmt.dataminer.teditor.graph.GraphPreferences";
    public static final String SHOW_NULLS_BIN = "show_nulls_bin";
    public static final String USE_VIEW = "use_view";
    public static final String USE_SIDE_BY_SIDE_GRAPH = "use_side_by_side_graph";
    public static final String SHOW_GROUPBY_NULLS_BIN = "show_groupby_nulls_bin";
    public static final String GRAPH_PANEL_WIDTH = "graph_panel_width";
    public static final String GRAPH_PANEL_HEIGHT = "graph_panel_height";

    static GraphPreferences getInstance() {
        return GraphPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private GraphPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static GraphPreferences getInstance(PropertyStorage propertyStorage) {
        return new GraphPreferences(GraphPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public boolean isShowNullsBin() {
        return this._hash.getBoolean(SHOW_NULLS_BIN, false);
    }

    public void setShowNullsBin(boolean bl) {
        this._hash.putBoolean(SHOW_NULLS_BIN, bl);
    }

    public boolean isUseSideBySideGraph() {
        return this._hash.getBoolean(USE_SIDE_BY_SIDE_GRAPH, true);
    }

    public void setUseSideBySideGraph(boolean bl) {
        this._hash.putBoolean(USE_SIDE_BY_SIDE_GRAPH, bl);
    }

    public boolean isUseView() {
        return this._hash.getBoolean(USE_VIEW, true);
    }

    public void setUseView(boolean bl) {
        this._hash.putBoolean(USE_VIEW, bl);
    }

    public boolean isShowGroupByNullsBin() {
        return this._hash.getBoolean(SHOW_GROUPBY_NULLS_BIN, false);
    }

    public void setShowGroupByNullsBin(boolean bl) {
        this._hash.putBoolean(SHOW_GROUPBY_NULLS_BIN, bl);
    }

    public int getGraphPanelWidth() {
        return this._hash.getInt(GRAPH_PANEL_WIDTH, 300);
    }

    public void setGraphPanelWidth(int n) {
        this._hash.putInt(GRAPH_PANEL_WIDTH, n);
    }

    public int getGraphPanelHeigh() {
        return this._hash.getInt(GRAPH_PANEL_HEIGHT, 300);
    }

    public void setGraphPanelHeight(int n) {
        this._hash.putInt(GRAPH_PANEL_HEIGHT, n);
    }
}

