/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.graph.AttrItem;
import oracle.dmt.dataminer.teditor.graph.GraphEditor;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.XYMultiSeriesPanel;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphAggregationFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettings;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupByType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.ide.Context;

public class GraphUtils {
    public static final String DUMMY_STR = "<dummy>";

    public static AttrItem findInList(List<AttrItem> list, String string) {
        AttrItem attrItem = null;
        for (AttrItem attrItem2 : list) {
            if (!attrItem2.getName().equals(string)) continue;
            attrItem = attrItem2;
            break;
        }
        return attrItem;
    }

    public static void loadCombo(JComboBox jComboBox, Collection<AttrItem> collection, String string, boolean bl, boolean bl2) {
        AttrItem object2 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AttrItem object3 : collection) {
            if (GraphUtils.isDummyGroupByAttr(object3.getAttribute())) continue;
            String string2 = object3.getAttribute().getDataType();
            boolean bl3 = GraphUtils.isCategoricalType(string2);
            boolean bl4 = DatabaseMetadataUtils.isNumericType(string2);
            boolean bl5 = DatabaseMetadataUtils.isDateType(string2);
            if (bl && bl3 || bl2 && bl5 || !bl4 && !bl3 && !bl5) continue;
            arrayList.add(object3);
            if (object2 != null || !object3.getAttribute().getName().equals(string)) continue;
            object2 = object3;
        }
        if (object2 == null) {
            arrayList.add(0, GraphLrb.get("SELECT_HINT"));
        }
        Object[] objectArray = arrayList.toArray();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        jComboBox.setModel(defaultComboBoxModel);
        if (object2 != null) {
            jComboBox.setSelectedItem(object2);
        }
    }

    public static void loadList(JList jList, Collection<AttrItem> collection, Collection<AttrItem> collection2, boolean bl, boolean bl2) {
        DefaultListModel<AttrItem> defaultListModel = new DefaultListModel<AttrItem>();
        boolean bl3 = false;
        for (AttrItem attrItem : collection) {
            if (attrItem.getAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
                bl3 = true;
            }
            boolean bl4 = GraphUtils.isCategoricalType(attrItem.getAttribute().getDataType());
            boolean bl5 = DatabaseMetadataUtils.isDateType(attrItem.getAttribute().getDataType());
            boolean bl6 = DatabaseMetadataUtils.isNumericType(attrItem.getAttribute().getDataType());
            if (bl && bl4 || bl2 && bl5 || !bl6 && !bl4 && !bl5) continue;
            defaultListModel.addElement(attrItem);
        }
        jList.setModel(defaultListModel);
        Object[] objectArray = defaultListModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            AttrItem attrItem = (AttrItem)objectArray[i];
            if (!collection2.contains(attrItem)) continue;
            jList.addSelectionInterval(i, i);
        }
        if (bl3) {
            jList.setCellRenderer(new XYMultiSeriesPanel.ComboRenderer());
        }
    }

    public static boolean isSingleSeriesGraph(GraphType graphType) {
        return graphType.equals((Object)GraphType.BOX_PLOT) || graphType.equals((Object)GraphType.BAR);
    }

    public static boolean isMultipleSeriesGraph(GraphType graphType) {
        return graphType.equals((Object)GraphType.LINE) || graphType.equals((Object)GraphType.SCATTER);
    }

    public static boolean isYRequired(GraphType graphType) {
        if (graphType.equals((Object)GraphType.BOX_PLOT)) {
            return false;
        }
        return GraphUtils.isSingleSeriesGraph(graphType) || GraphUtils.isMultipleSeriesGraph(graphType);
    }

    public static String getSQLAggregationFunctionClause(GraphAggregationFunctionType graphAggregationFunctionType) {
        String string = "";
        if (graphAggregationFunctionType == null) {
            return string;
        }
        if (graphAggregationFunctionType.equals((Object)GraphAggregationFunctionType.MEAN)) {
            string = "avg";
        } else if (graphAggregationFunctionType.equals((Object)GraphAggregationFunctionType.MEDIAN)) {
            string = "median";
        } else if (graphAggregationFunctionType.equals((Object)GraphAggregationFunctionType.COUNT)) {
            string = "count";
        } else if (graphAggregationFunctionType.equals((Object)GraphAggregationFunctionType.MAX)) {
            string = "max";
        } else if (graphAggregationFunctionType.equals((Object)GraphAggregationFunctionType.MIN)) {
            string = "min";
        } else if (graphAggregationFunctionType.equals((Object)GraphAggregationFunctionType.SUM)) {
            string = "sum";
        }
        return string;
    }

    public static String getAggregatedAxisName(String string, GraphAggregationFunctionType graphAggregationFunctionType) {
        return GraphUtils.getSQLAggregationFunctionClause(graphAggregationFunctionType) + "(" + string + ")";
    }

    public static void clearBinningDefinitions(BinningSettingsType binningSettingsType) {
        binningSettingsType.getStringFilterValues().clear();
    }

    public static void setStringFilterValues(BinningSettingsType binningSettingsType, List<String> list) {
        List list2 = binningSettingsType.getStringFilterValues();
        list2.clear();
        list2.addAll(list);
    }

    public static String getSampleTableName(Context context) {
        GraphEditor graphEditor = (GraphEditor)context.getView();
        Boolean bl = graphEditor.isViewingSample();
        String string = null;
        Node node = GraphUtils.findWorkflowNode(context);
        NodeType nodeType = node.getData();
        if (nodeType instanceof GraphNodeType) {
            GraphNodeType graphNodeType = (GraphNodeType)nodeType;
            string = !bl.booleanValue() ? graphNodeType.getViewName() : graphNodeType.getSampleSettings().getOutputTable().getName();
        } else {
            throw new RuntimeException("Unexpected node type");
        }
        return string;
    }

    public static List<String> getCategoricalBinValues(BinningSettingsType binningSettingsType) {
        if (binningSettingsType.getBinningKind() != BinningType.TOP_N) {
            return new ArrayList<String>();
        }
        return binningSettingsType.getStringFilterValues();
    }

    public static WorkflowNode getWorkflowNavNode(BaseTreeNode baseTreeNode) {
        return (WorkflowNode)baseTreeNode.getParent().getAncestor(WorkflowNode.class);
    }

    public static void updateSettings(GraphSettingsType graphSettingsType, GraphSettingsType graphSettingsType2) {
        graphSettingsType.setName(graphSettingsType2.getName());
        graphSettingsType.setComment(graphSettingsType2.getComment());
        graphSettingsType.setGroupByOption(graphSettingsType2.getGroupByOption());
        graphSettingsType.setType(graphSettingsType2.getType());
        graphSettingsType.setXAttribute(graphSettingsType2.getXAttribute());
        graphSettingsType.setXBinningSettings(graphSettingsType2.getXBinningSettings());
        graphSettingsType.setYAttributes(graphSettingsType2.getYAttributes());
    }

    public static boolean updateAttributeStatus(Context context, GraphSettingsType graphSettingsType) {
        List<AttributeType> list = GraphUtils.getSourceAttributes(context);
        return GraphUtils.updateAttributeStatus(list, graphSettingsType);
    }

    public static boolean updateAttributeStatus(List<AttributeType> list, GraphSettingsType graphSettingsType) {
        AttributeType attributeType2;
        boolean bl = true;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType2 : list) {
            hashMap.put(attributeType2.getName(), attributeType2);
        }
        attributeType2 = graphSettingsType.getXAttribute();
        AttributeType attributeType3 = (AttributeType)hashMap.get(attributeType2.getName());
        if (attributeType3 != null && attributeType3.getDataType().equals(attributeType2.getDataType())) {
            attributeType2.setStatus(attributeType3.getStatus());
        } else {
            attributeType2.setStatus(AttributeStatus.INVALID);
            bl = false;
        }
        List list2 = graphSettingsType.getYAttributes().getYAttribute();
        for (AttributeType attributeType4 : list2) {
            attributeType3 = (AttributeType)hashMap.get(attributeType4.getName());
            if (attributeType3 != null && attributeType3.getDataType().equals(attributeType4.getDataType())) {
                attributeType4.setStatus(attributeType3.getStatus());
                continue;
            }
            attributeType4.setStatus(AttributeStatus.INVALID);
            bl = false;
        }
        if (graphSettingsType.getGroupByOption().isGroupByEnabled()) {
            AttributeType attributeType5 = graphSettingsType.getGroupByOption().getGroupByAttribute();
            attributeType3 = (AttributeType)hashMap.get(attributeType5.getName());
            if (attributeType3 != null && attributeType3.getDataType().equals(attributeType5.getDataType())) {
                attributeType5.setStatus(attributeType3.getStatus());
            } else {
                bl = false;
                attributeType5.setStatus(AttributeStatus.INVALID);
            }
        }
        return bl;
    }

    public static SampleSettings getSampleSettings(Node node) {
        SampleSettings sampleSettings = null;
        if (node instanceof GraphNode) {
            sampleSettings = ((GraphNodeType)node.getData()).getSampleSettings();
        }
        return sampleSettings;
    }

    public static boolean isSampleAvailable(Context context) {
        Node node = GraphUtils.findWorkflowNode(context);
        SampleSettings sampleSettings = GraphUtils.getSampleSettings(node);
        boolean bl = sampleSettings != null && sampleSettings.isGenerateCache() && sampleSettings.getOutputTable() != null && sampleSettings.getOutputTable().getName() != null && sampleSettings.getOutputTable().getName().length() > 0;
        return bl;
    }

    public static Node findWorkflowNode(Context context) {
        Node node = (Node)context.getProperty("dataNode");
        WorkflowModel workflowModel = node.getModel();
        return workflowModel.findNodeByName(node.getData().getName());
    }

    public static List<AttributeType> getSourceAttributes(Context context) {
        Node node = GraphUtils.findWorkflowNode(context);
        List list = null;
        if (node instanceof GraphNode) {
            DataProvider dataProvider = (DataProvider)((Object)node.findParentNode());
            list = dataProvider.getAttributes().getAttribute();
        } else if (node instanceof DataProvider) {
            list = ((DataProvider)((Object)node)).getAttributes().getAttribute();
        }
        return list;
    }

    public static boolean validateGraphName(Context context, String string, GraphSettingsType graphSettingsType) {
        Node node = GraphUtils.findWorkflowNode(context);
        boolean bl = true;
        if (node instanceof GraphNode) {
            GraphNodeType graphNodeType = (GraphNodeType)node.getData();
            GraphSettings graphSettings = graphNodeType.getGraphSettings();
            List list = graphSettings.getGraphSetting();
            for (GraphSettingsType graphSettingsType2 : list) {
                if (graphSettingsType2 == graphSettingsType || !string.equals(graphSettingsType2.getName())) continue;
                if (graphSettingsType == null) {
                    return false;
                }
                String string2 = graphSettingsType.getId();
                String string3 = graphSettingsType2.getId();
                if (null == string2 || null == string3) {
                    bl = false;
                    break;
                }
                if (string2.equals(string3)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static void generateGraphSettingsIds(GraphSettings graphSettings) {
        List list = graphSettings.getGraphSetting();
        for (GraphSettingsType graphSettingsType : list) {
            graphSettingsType.setId(UUID.randomUUID().toString());
        }
    }

    public static void regenerateGraphSettingId(GraphSettingsType graphSettingsType) {
        graphSettingsType.setId(UUID.randomUUID().toString());
    }

    public static GraphSettings getGraphSettings(Context context) {
        GraphSettings graphSettings = null;
        Node node = GraphUtils.findWorkflowNode(context);
        if (!(node instanceof GraphNode)) {
            throw new RuntimeException("Unexpected node type encountered");
        }
        GraphNode graphNode = (GraphNode)node;
        GraphNodeType graphNodeType = (GraphNodeType)graphNode.getData();
        graphSettings = graphNodeType.getGraphSettings();
        return graphSettings;
    }

    public static void updateGraphNodeSettings(Context context, GraphSettingsType graphSettingsType, UpdateAction updateAction) {
        Node node = GraphUtils.findWorkflowNode(context);
        GraphSettings graphSettings = null;
        graphSettings = GraphUtils.getGraphSettings(context);
        List list = graphSettings.getGraphSetting();
        if (updateAction == UpdateAction.ADD) {
            list.add(graphSettingsType);
            if (node instanceof GraphNode) {
                ((GraphNode)node).validate(false, false);
            }
            return;
        }
        int n = -1;
        for (GraphSettingsType graphSettingsType2 : list) {
            if (!graphSettingsType2.getName().equals(graphSettingsType.getName())) continue;
            n = list.indexOf(graphSettingsType2);
            break;
        }
        if (n == -1) {
            throw new RuntimeException("Unexpected State: Unable to find graph settings obj");
        }
        if (updateAction == UpdateAction.REMOVE) {
            list.remove(n);
        } else if (updateAction == UpdateAction.REPLACE) {
            list.remove(n);
            if (n > list.size() - 1) {
                list.add(graphSettingsType);
            } else {
                list.add(n, graphSettingsType);
            }
        }
        if (node instanceof GraphNode) {
            ((GraphNode)node).validate(false, false);
        }
    }

    public static int getDefaultGraphType(GraphType graphType) {
        int n;
        if (graphType == GraphType.BAR) {
            n = 18;
        } else if (graphType == GraphType.HISTOGRAM) {
            n = 18;
        } else if (graphType == GraphType.BOX_PLOT) {
            n = 101;
        } else if (graphType == GraphType.LINE) {
            n = 41;
        } else if (graphType == GraphType.SCATTER) {
            n = 61;
        } else {
            throw new RuntimeException("Unknow graph type. Please update known graph types in GraphUtils.getDefaultGraphType ()");
        }
        return n;
    }

    public static String getDateConversionClause(String string, String string2) {
        String string3 = "";
        if (string.equals("DATE")) {
            string3 = "TO_DATE ('" + string2 + "', 'DD.MM.YYYY HH24:MI:SS')";
        } else if (string.equals("TIMESTAMP")) {
            string3 = "TO_TIMESTAMP ('" + string2 + "', 'DD-MON-RR HH:MI:SS.FF AM')";
        } else if (string.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
            string3 = "TO_TIMESTAMP_TZ ('" + string2 + "', 'YYYY-MM-DD HH:MI:SS TZH:TZM')";
        } else if (string.equals("TIMESTAMP WITH TIME ZONE")) {
            string3 = "TO_TIMESTAMP_TZ ('" + string2 + "', 'YYYY-MM-DD HH:MI:SS TZH:TZM')";
        }
        return string3;
    }

    public static void initDummyGroupByAttr(GroupByType groupByType) {
        if (groupByType.isGroupByEnabled() && groupByType.getGroupByAttribute() != null) {
            return;
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setName(DUMMY_STR);
        attributeType.setAlias(DUMMY_STR);
        attributeType.setDataType(DUMMY_STR);
        attributeType.setStatus(AttributeStatus.MISSING);
        groupByType.setGroupByAttribute(attributeType);
    }

    public static boolean isDummyGroupByAttr(AttributeType attributeType) {
        return attributeType.getName().equals(DUMMY_STR) && attributeType.getStatus().equals((Object)AttributeStatus.MISSING);
    }

    public static boolean isNumericType(String string) {
        return DatabaseMetadataUtils.isNumericType(string) || DatabaseMetadataUtils.isDateType(string);
    }

    public static boolean isCategoricalType(String string) {
        return string.equals("VARCHAR2") || string.equals("CHAR") || string.equals("NVARCHAR2") || string.equals("NCHAR");
    }

    public static enum UpdateAction {
        REPLACE,
        REMOVE,
        ADD;

    }
}

