/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.teditor.graph.AttrItem;
import oracle.dmt.dataminer.teditor.graph.BinningSettingsDialog;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.teditor.graph.GroupByPanel;
import oracle.dmt.dataminer.teditor.graph.GroupByValuesDialog;
import oracle.dmt.dataminer.teditor.graph.YSingleSelectContainer;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithHint;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.util.SwingUtils;

public class XYMultiSeriesPanel
extends JPanel {
    private Context context;
    private GraphSettingsType settings;
    private GroupByPanel groupByPanel;
    private JCheckBox chkGroupBy;
    private JTextField hintTxt;
    private final List<AttrItem> availableItems = new ArrayList<AttrItem>();
    private boolean isComplete;
    private final List<AttrItem> selectedY = new ArrayList<AttrItem>();
    private AttrItem selectedYSingle = null;
    private Map<String, BinningSettingsType> binningGroupBySettingsCache = new HashMap<String, BinningSettingsType>();
    private Map<String, BinningSettingsType> binningXSettingsCache = new HashMap<String, BinningSettingsType>();
    private JList multiSeriesYListBox;
    private YSingleSelectContainer singleSeriesYContainer;
    private JPanel axesPanel;
    private Box.Filler filler1;
    private ButtonGroup groupByBtnGrp;
    private JPanel groupByContainer;
    private JPanel hintContainer;
    private JLabel lblX;
    private JLabel lblXSettings;
    private JLabel lblY;
    private JComboBox xAttrSelector;
    private JPanel yAttrsPanel;

    public XYMultiSeriesPanel(Context context, List<AttributeType> list, GraphSettingsType graphSettingsType) {
        Object object;
        this.context = context;
        this.settings = graphSettingsType;
        this.isComplete = false;
        this.multiSeriesYListBox = null;
        this.singleSeriesYContainer = null;
        for (AttributeType object32 : list) {
            object = new AttrItem(object32);
            this.availableItems.add((AttrItem)object);
        }
        AttributeType attributeType = graphSettingsType.getXAttribute();
        if (attributeType != null) {
            AttrItem attrItem = GraphUtils.findInList(this.availableItems, attributeType.getName());
            this.updateAttrState(attrItem, attributeType);
            if (attrItem == null) {
                AttrItem attrItem2 = new AttrItem(attributeType);
                this.availableItems.add(attrItem2);
            } else {
                graphSettingsType.setXAttribute(attrItem.getAttribute());
            }
        }
        List list2 = graphSettingsType.getYAttributes().getYAttribute();
        for (Object object2 : list2) {
            AttrItem attrItem = GraphUtils.findInList(this.availableItems, object2.getName());
            this.updateAttrState(attrItem, (AttributeType)object2);
            if (attrItem != null) continue;
            this.availableItems.add(new AttrItem((AttributeType)object2));
        }
        object = graphSettingsType.getGroupByOption().getGroupByAttribute();
        if (object != null && !object.getName().equals("<dummy>")) {
            Object object2;
            object2 = GraphUtils.findInList(this.availableItems, object.getName());
            this.updateAttrState((AttrItem)object2, (AttributeType)object);
            if (object2 == null) {
                this.availableItems.add(new AttrItem((AttributeType)object));
            }
        }
        Collections.sort(this.availableItems);
        this.initComponents();
        this.initUI();
    }

    private void updateAttrState(AttrItem attrItem, AttributeType attributeType) {
        if (null == attrItem) {
            attributeType.setStatus(AttributeStatus.INVALID);
            return;
        }
        if (!attrItem.getAttribute().getDataType().equals(attributeType.getDataType())) {
            attrItem.getAttribute().setStatus(AttributeStatus.INVALID);
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    private void initComponents() {
        this.groupByBtnGrp = new ButtonGroup();
        this.axesPanel = new JPanel();
        this.xAttrSelector = new JComboBox();
        this.lblY = new JLabel();
        this.yAttrsPanel = new JPanel();
        this.lblX = new JLabel();
        this.hintContainer = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 30), new Dimension(0, 30), new Dimension(Short.MAX_VALUE, 40));
        this.lblXSettings = new JLabel();
        this.groupByContainer = new JPanel();
        this.xAttrSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.xAttrSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XYMultiSeriesPanel.this.xAttrSelectorActionPerformed(actionEvent);
            }
        });
        this.lblY.setText("Y Axis:");
        this.yAttrsPanel.setMinimumSize(new Dimension(0, 0));
        this.yAttrsPanel.setPreferredSize(new Dimension(0, 0));
        this.yAttrsPanel.setLayout(new BorderLayout());
        this.lblX.setText("X Axis:");
        this.hintContainer.setLayout(new BorderLayout());
        this.hintContainer.add((Component)this.filler1, "Before");
        this.lblXSettings.setText("Settings...");
        this.groupByContainer.setLayout(null);
        GroupLayout groupLayout = new GroupLayout(this.axesPanel);
        this.axesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblX, -1, -1, Short.MAX_VALUE).addComponent(this.lblY, -1, 71, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.yAttrsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hintContainer, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.xAttrSelector, 0, 309, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblXSettings, -1, -1, Short.MAX_VALUE).addGap(8, 8, 8)))).addComponent(this.groupByContainer, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblX).addComponent(this.xAttrSelector, -2, -1, -2).addComponent(this.lblXSettings)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblY).addComponent(this.yAttrsPanel, -1, 136, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupByContainer, -2, 69, -2).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.axesPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.axesPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void xAttrSelectorActionPerformed(ActionEvent actionEvent) {
    }

    public void setGraphType(GraphType graphType) {
        this.settings.setType(graphType);
        if (GraphUtils.isMultipleSeriesGraph(graphType)) {
            this.loadYMulti();
        } else if (graphType.equals((Object)GraphType.BAR)) {
            this.loadYSingle();
        } else if (graphType.equals((Object)GraphType.HISTOGRAM)) {
            this.loadHistogram();
        } else if (graphType.equals((Object)GraphType.BOX_PLOT)) {
            this.loadBox();
        }
        if (this.settings.getType().equals((Object)GraphType.BOX_PLOT) || this.settings.getType().equals((Object)GraphType.HISTOGRAM)) {
            ResourceUtils.resLabel((JLabel)this.lblX, (Component)this.xAttrSelector, (String)GraphLrb.get("ATTRIBUTE_LABEL"));
        } else {
            ResourceUtils.resLabel((JLabel)this.lblX, (Component)this.xAttrSelector, (String)GraphLrb.get("X_LABEL"));
        }
        boolean bl = this.selectedY.size() <= 1 || this.settings.getType() != GraphType.LINE && this.settings.getType() != GraphType.SCATTER;
        this.updateGroupByState(bl);
    }

    private void initUI() {
        AttributeType attributeType2;
        if (this.settings.getYAttributes().getYAttribute().size() == 1) {
            this.selectedYSingle = GraphUtils.findInList(this.availableItems, ((AttributeType)this.settings.getYAttributes().getYAttribute().get(0)).getName());
            if (this.selectedYSingle == null) {
                this.selectedYSingle = new AttrItem((AttributeType)this.settings.getYAttributes().getYAttribute().get(0));
            }
        }
        for (AttributeType attributeType2 : this.settings.getYAttributes().getYAttribute()) {
            AttrItem attrItem = GraphUtils.findInList(this.availableItems, attributeType2.getName());
            if (attrItem != null) {
                this.selectedY.add(attrItem);
                continue;
            }
            this.selectedY.add(new AttrItem(attributeType2));
        }
        this.yAttrsPanel.setLayout(new BorderLayout());
        if (GraphUtils.isMultipleSeriesGraph(this.settings.getType())) {
            this.loadYMulti();
        } else if (this.settings.getType().equals((Object)GraphType.BAR)) {
            this.loadYSingle();
        } else if (this.settings.getType().equals((Object)GraphType.HISTOGRAM)) {
            this.loadHistogram();
        } else if (this.settings.getType().equals((Object)GraphType.BOX_PLOT)) {
            this.loadBox();
        }
        this.hintTxt = new JTextField(this.getHintText(this.selectedY));
        this.hintTxt.setEditable(false);
        ComponentWithHint componentWithHint = new ComponentWithHint();
        componentWithHint.setComponent((Component)this.hintTxt);
        componentWithHint.setHint(GraphLrb.get("Y_SELECTED_HINT"));
        this.hintContainer.add((Component)componentWithHint, "Center");
        this.groupByPanel = new GroupByPanel();
        this.chkGroupBy = new JCheckBox(GraphLrb.get("GROUP_BY_CHK"));
        attributeType2 = new TitledSeparator((JComponent)this.chkGroupBy, TitledSeparator.STYLE.LINE);
        this.groupByContainer.setLayout(new BoxLayout(this.groupByContainer, 1));
        this.groupByContainer.add((Component)attributeType2);
        this.groupByContainer.add(this.groupByPanel);
        boolean bl = this.selectedY.size() <= 1;
        this.updateGroupByState(bl);
        this.groupByPanel.getEditSettingsLbl().setText(GraphLrb.get("EDIT_SETTINGS_TEXT"));
        if (this.settings.getGroupByOption().isGroupByEnabled() && this.settings.getGroupByOption().getGroupByAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.groupByPanel.getCmbGroupByAttribute().setRenderer(new ComboRenderer());
        }
        String string = this.settings.getGroupByOption().getGroupByAttribute() == null ? "" : this.settings.getGroupByOption().getGroupByAttribute().getName();
        GraphUtils.loadCombo(this.groupByPanel.getCmbGroupByAttribute(), this.availableItems, string, false, false);
        if (this.settings.getXAttribute() != null && this.settings.getXAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.xAttrSelector.setRenderer(new ComboRenderer());
        }
        this.xAttrSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof AttrItem) {
                    AttrItem attrItem = (AttrItem)object;
                    XYMultiSeriesPanel.this.settings.setXAttribute(attrItem.getAttribute());
                    BinningSettingsType binningSettingsType = (BinningSettingsType)XYMultiSeriesPanel.this.binningXSettingsCache.get(attrItem.getAttribute().getName());
                    if (binningSettingsType != null) {
                        XYMultiSeriesPanel.this.settings.setXBinningSettings(binningSettingsType);
                    } else {
                        boolean bl = XYMultiSeriesPanel.this.settings.getXBinningSettings().isBinningEnabled();
                        BinningSettingsType binningSettingsType2 = new BinningSettingsType();
                        binningSettingsType2.setNumericBinCount(new BigInteger("10"));
                        binningSettingsType2.setBinningKind(BinningType.EQUAL_WIDTH);
                        binningSettingsType2.setBinningEnabled(bl);
                        XYMultiSeriesPanel.this.settings.setXBinningSettings(binningSettingsType2);
                        XYMultiSeriesPanel.this.binningXSettingsCache.put(XYMultiSeriesPanel.this.settings.getXAttribute().getName(), XYMultiSeriesPanel.this.settings.getXBinningSettings());
                    }
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        this.groupByPanel.getCmbGroupByAttribute().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof AttrItem) {
                    AttrItem attrItem = (AttrItem)object;
                    XYMultiSeriesPanel.this.settings.getGroupByOption().setGroupByAttribute(attrItem.getAttribute());
                    BinningSettingsType binningSettingsType = (BinningSettingsType)XYMultiSeriesPanel.this.binningGroupBySettingsCache.get(attrItem.getAttribute().getName());
                    if (binningSettingsType != null) {
                        XYMultiSeriesPanel.this.settings.getGroupByOption().setBinningSettings(binningSettingsType);
                    } else {
                        boolean bl = XYMultiSeriesPanel.this.settings.getGroupByOption().getBinningSettings().isBinningEnabled();
                        BinningSettingsType binningSettingsType2 = new BinningSettingsType();
                        binningSettingsType2.setNumericBinCount(new BigInteger("10"));
                        binningSettingsType2.setBinningKind(BinningType.EQUAL_WIDTH);
                        binningSettingsType2.setBinningEnabled(bl);
                        XYMultiSeriesPanel.this.settings.getGroupByOption().setBinningSettings(binningSettingsType2);
                        XYMultiSeriesPanel.this.binningGroupBySettingsCache.put(XYMultiSeriesPanel.this.settings.getGroupByOption().getGroupByAttribute().getName(), XYMultiSeriesPanel.this.settings.getGroupByOption().getBinningSettings());
                    }
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        boolean bl2 = this.settings.getGroupByOption().isGroupByEnabled();
        this.chkGroupBy.setSelected(bl2);
        this.enableGroupByComponents(bl2);
        this.chkGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                boolean bl = jCheckBox.isSelected();
                XYMultiSeriesPanel.this.settings.getGroupByOption().setGroupByEnabled(bl);
                XYMultiSeriesPanel.this.enableGroupByComponents(bl);
                XYMultiSeriesPanel.this.groupByPanel.getEditSettingsLbl().setText(XYMultiSeriesPanel.this.settings.getGroupByOption().isGroupByEnabled() ? GraphLrb.get("EDIT_SETTINGS_TEXT") : GraphLrb.get("EDIT_SETTINGS_TEXT_DISABLED"));
            }
        });
        this.groupByPanel.getEditSettingsLbl().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AttributeType attributeType = XYMultiSeriesPanel.this.settings.getGroupByOption().getGroupByAttribute();
                if (attributeType == null || attributeType.getDataType().equals("<dummy>")) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("NO_GROUPBY_SPECIFIED"), (String)GraphLrb.get("NO_GROUPBY_SPECIFIED_TITLE"), null);
                    return;
                }
                Dialog dialog = SwingUtils.getAncestorDialog((Component)XYMultiSeriesPanel.this);
                if (GraphUtils.isNumericType(attributeType.getDataType())) {
                    BinningSettingsDialog binningSettingsDialog = new BinningSettingsDialog(dialog, XYMultiSeriesPanel.this.context, true, XYMultiSeriesPanel.this.settings.getGroupByOption().getBinningSettings(), true);
                    binningSettingsDialog.setVisible(true);
                } else {
                    GroupByValuesDialog groupByValuesDialog = new GroupByValuesDialog(dialog, XYMultiSeriesPanel.this.context, true, XYMultiSeriesPanel.this.settings.getGroupByOption().getBinningSettings(), XYMultiSeriesPanel.this.settings.getGroupByOption().getGroupByAttribute());
                    groupByValuesDialog.setVisible(true);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.lblXSettings.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AttributeType attributeType = XYMultiSeriesPanel.this.settings.getXAttribute();
                if (attributeType == null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("NO_X_SPECIFIED"), (String)GraphLrb.get("NO_X_SPECIFIED_TITLE"), null);
                    return;
                }
                Dialog dialog = SwingUtils.getAncestorDialog((Component)XYMultiSeriesPanel.this);
                if (GraphUtils.isNumericType(attributeType.getDataType())) {
                    BinningSettingsDialog binningSettingsDialog = new BinningSettingsDialog(dialog, XYMultiSeriesPanel.this.context, true, XYMultiSeriesPanel.this.settings.getXBinningSettings(), false);
                    binningSettingsDialog.setVisible(true);
                } else {
                    GroupByValuesDialog groupByValuesDialog = new GroupByValuesDialog(dialog, XYMultiSeriesPanel.this.context, true, XYMultiSeriesPanel.this.settings.getXBinningSettings(), XYMultiSeriesPanel.this.settings.getXAttribute());
                    groupByValuesDialog.setVisible(true);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        if (this.settings.getType().equals((Object)GraphType.BOX_PLOT) || this.settings.getType().equals((Object)GraphType.HISTOGRAM)) {
            ResourceUtils.resLabel((JLabel)this.lblX, (Component)this.xAttrSelector, (String)GraphLrb.get("ATTRIBUTE_LABEL"));
        } else {
            ResourceUtils.resLabel((JLabel)this.lblX, (Component)this.xAttrSelector, (String)GraphLrb.get("X_LABEL"));
        }
        ResourceUtils.resLabel((JLabel)this.lblY, null, (String)GraphLrb.get("Y_LABEL"));
        this.chkGroupBy.setText(GraphLrb.get("GROUP_BY_CHK"));
        this.groupByPanel.getEditSettingsLbl().setText(this.settings.getGroupByOption().isGroupByEnabled() ? GraphLrb.get("EDIT_SETTINGS_TEXT") : GraphLrb.get("EDIT_SETTINGS_TEXT_DISABLED"));
        this.lblXSettings.setText(GraphLrb.get("EDIT_SETTINGS_TEXT"));
    }

    private void loadYMulti() {
        this.yAttrsPanel.removeAll();
        this.lblXSettings.setVisible(false);
        if (this.multiSeriesYListBox == null) {
            this.multiSeriesYListBox = new JList();
            GraphUtils.loadList(this.multiSeriesYListBox, this.availableItems, this.selectedY, true, true);
            this.multiSeriesYListBox.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JList jList = (JList)listSelectionEvent.getSource();
                    Object[] objectArray = jList.getSelectedValues();
                    XYMultiSeriesPanel.this.selectedY.clear();
                    for (Object object : objectArray) {
                        AttrItem attrItem = (AttrItem)object;
                        XYMultiSeriesPanel.this.selectedY.add(attrItem);
                    }
                    XYMultiSeriesPanel.this.hintTxt.setText(XYMultiSeriesPanel.this.getHintText(XYMultiSeriesPanel.this.selectedY));
                    boolean bl = objectArray.length <= 1;
                    XYMultiSeriesPanel.this.updateGroupByState(bl);
                }
            });
        }
        String string = this.settings.getXAttribute() == null ? "" : this.settings.getXAttribute().getName();
        GraphUtils.loadCombo(this.xAttrSelector, this.availableItems, string, true, true);
        this.yAttrsPanel.add(new JScrollPane(this.multiSeriesYListBox));
        this.setYVisible(true, true);
    }

    private void loadYSingle() {
        Object object;
        this.yAttrsPanel.removeAll();
        this.lblXSettings.setVisible(true);
        if (this.singleSeriesYContainer == null) {
            this.singleSeriesYContainer = new YSingleSelectContainer(this.settings.getYAttributes().getAggregationFunction());
            object = this.singleSeriesYContainer.getSelectorCombo();
            GraphUtils.loadCombo((JComboBox)object, this.availableItems, this.selectedYSingle != null ? this.selectedYSingle.getName() : "", true, true);
            ((JComboBox)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (object instanceof AttrItem) {
                        XYMultiSeriesPanel.this.selectedYSingle = (AttrItem)object;
                        if (jComboBox.getItemAt(0) instanceof String) {
                            jComboBox.removeItemAt(0);
                        }
                    }
                }
            });
        }
        object = this.settings.getXAttribute() == null ? "" : this.settings.getXAttribute().getName();
        GraphUtils.loadCombo(this.xAttrSelector, this.availableItems, (String)object, false, false);
        this.yAttrsPanel.add(this.singleSeriesYContainer);
        this.setYVisible(true, false);
    }

    private void loadHistogram() {
        this.lblXSettings.setVisible(true);
        String string = this.settings.getXAttribute() == null ? "" : this.settings.getXAttribute().getName();
        GraphUtils.loadCombo(this.xAttrSelector, this.availableItems, string, false, false);
        this.setYVisible(false, false);
    }

    private void loadBox() {
        this.lblXSettings.setVisible(false);
        String string = this.settings.getXAttribute() == null ? "" : this.settings.getXAttribute().getName();
        GraphUtils.loadCombo(this.xAttrSelector, this.availableItems, string, true, true);
        this.setYVisible(false, false);
    }

    private void setYVisible(boolean bl, boolean bl2) {
        this.yAttrsPanel.setVisible(bl);
        this.hintContainer.setVisible(bl && bl2);
        this.lblY.setVisible(bl);
        this.yAttrsPanel.validate();
        this.yAttrsPanel.repaint();
    }

    private void updateGroupByState(boolean bl) {
        this.chkGroupBy.setEnabled(bl);
        if (!bl) {
            this.chkGroupBy.setSelected(false);
            this.settings.getGroupByOption().setGroupByEnabled(false);
        }
        this.enableGroupByComponents(this.chkGroupBy.isSelected());
    }

    private void enableGroupByComponents(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.groupByPanel.getComponents()) {
            if (component instanceof JCheckBox) continue;
            component.setEnabled(bl);
        }
    }

    private String getHintText(List<AttrItem> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AttrItem attrItem : list) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(attrItem.getName());
        }
        return stringBuilder.toString();
    }

    public boolean doWork() {
        boolean bl = true;
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (GraphUtils.isSingleSeriesGraph(this.settings.getType())) {
            if (this.selectedYSingle != null) {
                arrayList.add(this.selectedYSingle.getAttribute());
            }
        } else {
            for (AttrItem attrItem2 : this.selectedY) {
                arrayList.add(attrItem2.getAttribute());
            }
        }
        if (!arrayList.isEmpty()) {
            this.settings.getYAttributes().getYAttribute().clear();
            this.settings.getYAttributes().getYAttribute().addAll(arrayList);
            for (AttributeType attributeType : arrayList) {
                if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        if (this.singleSeriesYContainer != null && this.settings.getType().equals((Object)GraphType.BAR)) {
            this.settings.getYAttributes().setAggregationFunction(this.singleSeriesYContainer.getAggregateFunction());
        }
        BinningSettingsType binningSettingsType = this.settings.getXBinningSettings();
        BinningSettingsType binningSettingsType2 = this.settings.getGroupByOption().getBinningSettings();
        if (this.settings.getType().equals((Object)GraphType.BAR) || this.settings.getType().equals((Object)GraphType.HISTOGRAM)) {
            binningSettingsType.setBinningEnabled(true);
            if (GraphUtils.isNumericType(this.settings.getXAttribute().getDataType())) {
                if (binningSettingsType.getBinningKind() != BinningType.EQUAL_WIDTH && binningSettingsType.getBinningKind() != BinningType.NONE) {
                    binningSettingsType.setBinningKind(BinningType.EQUAL_WIDTH);
                }
            } else {
                if (binningSettingsType.getBinningKind() != BinningType.TOP_N) {
                    binningSettingsType.setBinningKind(BinningType.TOP_N);
                }
                binningSettingsType.setCustomBinning(null);
                binningSettingsType.setNumericBinCount(null);
            }
            if (this.settings.getGroupByOption().isGroupByEnabled()) {
                AttributeType attributeType = this.settings.getGroupByOption().getGroupByAttribute();
                if (attributeType != null && GraphUtils.isNumericType(attributeType.getDataType())) {
                    if (binningSettingsType2.getBinningKind() != BinningType.EQUAL_WIDTH && binningSettingsType2.getBinningKind() != BinningType.NONE) {
                        binningSettingsType2.setBinningKind(BinningType.EQUAL_WIDTH);
                    }
                } else {
                    if (binningSettingsType2.getBinningKind() != BinningType.TOP_N) {
                        binningSettingsType2.setBinningKind(BinningType.TOP_N);
                    }
                    binningSettingsType2.setCustomBinning(null);
                    binningSettingsType2.setNumericBinCount(null);
                }
            } else {
                GraphUtils.initDummyGroupByAttr(this.settings.getGroupByOption());
            }
        } else {
            binningSettingsType.setBinningEnabled(false);
            GraphUtils.initDummyGroupByAttr(this.settings.getGroupByOption());
        }
        return bl;
    }

    public boolean isGroupByEnabled() {
        return this.chkGroupBy.isSelected();
    }

    public static class ComboRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof AttrItem) {
                AttrItem attrItem = (AttrItem)object;
                if (attrItem.getAttribute().getStatus() == AttributeStatus.INVALID) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
                } else {
                    jLabel.setIcon(OracleIcons.getIcon((String)"spacer.png"));
                }
            }
            return jLabel;
        }
    }
}

