/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.TableChooserModel;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.structure.StructureLrb;
import oracle.dmt.dataminer.teditor.structure.StructureViewState;
import oracle.dmt.dataminer.teditor.structure.StructureViewTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class StructureViewPanel
extends DataMinerViewGUI {
    private boolean _loadFromNode = true;
    private boolean _loadFromSQLExpression = false;
    private TableChooserModel.TableRow _selectedTable = null;
    private String SYN_SELECTED_TABLE = "syn_selected_table";
    private String _connectionName;
    private String _schemaName;
    private String _tableName;
    private String _sqlExpression;
    private boolean _completedHiddenColumnsDefinition = false;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel structurePanel;
    private StructureViewState _state;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public StructureViewPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(Context context) throws Exception {
        super(null, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(Context context, boolean bl) throws Exception {
        super(null, context);
        this._loadFromNode = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(String string, String string2, String string3) throws Exception {
        super(null, null);
        this._loadFromNode = true;
        this._connectionName = string;
        this._schemaName = string2;
        this._tableName = string3;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(Context context, String string) throws Exception {
        super(null, context);
        this._loadFromNode = false;
        this._loadFromSQLExpression = true;
        this._sqlExpression = string;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.structurePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.structurePanel, -1, 478, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.structurePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.structurePanel.setTitle(StructureLrb.get("TABLE_STRUCTURE_EDITOR_GRID_TITLE"));
    }

    @Override
    public void initUI() {
        this._state = this._context != null ? (this._loadFromSQLExpression ? new StructureViewState(this._context, this._sqlExpression) : new StructureViewState(this._context, this._loadFromNode)) : new StructureViewState(this._connectionName, this._schemaName, this._tableName);
        this.setLoading(true);
        this.initializeControls(this._loadFromNode || this._loadFromSQLExpression);
        if (this._loadFromNode || this._loadFromSQLExpression) {
            LoadUI loadUI = new LoadUI();
            loadUI.execute();
        }
    }

    public void reload() {
        this.initUI();
    }

    public StructureViewState getState() {
        return this._state;
    }

    private void setLoadingStatus(boolean bl) {
        TableModel tableModel = this.structurePanel.getTable().getModel();
        if (tableModel instanceof StructureViewTableModel) {
            if (bl) {
                ((StructureViewTableModel)((Object)tableModel)).showLoading();
            } else {
                ((StructureViewTableModel)((Object)tableModel)).showSelectionRequired();
            }
        }
    }

    public void loadTable(TableChooserModel.TableRow tableRow) {
        this.setLoading(true);
        this.enableControls(true);
        this.setSelectedTable(tableRow);
        this.setLoadingStatus(tableRow != null);
        LoadUISync loadUISync = new LoadUISync(tableRow != null ? tableRow.getSchema() : "", tableRow != null ? tableRow.getTableName() : "");
        loadUISync.execute();
    }

    public void loadTable(String string) {
        this.setLoading(true);
        this.enableControls(true);
        this.setSelectedSQLExpression(string);
        this.setLoadingStatus(string != null);
        LoadUISync loadUISync = new LoadUISync(string);
        loadUISync.execute();
    }

    public StructureViewTableModel getColumnsTableModel() {
        return this._state.getTableModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableChooserModel.TableRow getSelectedTable() {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            return this._selectedTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTable(TableChooserModel.TableRow tableRow) {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            this._selectedTable = tableRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedSQLExpression(String string) {
        String string2 = this.SYN_SELECTED_TABLE;
        synchronized (string2) {
            this._sqlExpression = string;
        }
    }

    public void close() {
        this._state.close();
    }

    private void initializeControls(boolean bl) {
        if (!bl) {
            this.structurePanel.getTable().setNoEntryInstructionText(DataLrb.get("DATA_VIEWER_EDITOR_SELECTION_REQUIRED"));
        } else {
            this.structurePanel.getTable().setNoEntryInstructionText(DataLrb.get("DATA_VIEWER_EDITOR_LOADING"));
        }
        this.enableControls(false);
    }

    public HelpInfo getHelpInfo() {
        String string = "data_structure_viewer_help";
        return new HelpInfo(string);
    }

    private void setColumnWidths(TableColumnModel tableColumnModel) {
        tableColumnModel.getColumn(0).setPreferredWidth(295);
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        tableColumnModel.getColumn(2).setPreferredWidth(100);
        tableColumnModel.getColumn(3).setPreferredWidth(80);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
    }

    private void setupTable(StructureViewTableModel structureViewTableModel) {
        if (structureViewTableModel != null) {
            this.structurePanel.setup((TableModel)((Object)structureViewTableModel), null, new String[]{StructureViewTableModel._colNames.get(0), StructureViewTableModel._colNames.get(1), StructureViewTableModel._colNames.get(2)}, 0);
            this.structurePanel.getTable().setSortColumn(0, true);
            TableColumnModel tableColumnModel = this.structurePanel.getTable().getColumnModel();
            this.setColumnWidths(tableColumnModel);
            if (!this._completedHiddenColumnsDefinition) {
                this.structurePanel.getTable().setHiddenColumns(new int[]{4, 5});
                this._completedHiddenColumnsDefinition = true;
            }
        } else {
            this.structurePanel.getTable().setNoEntryInstructionText(DataLrb.get("DATA_VIEWER_ACTUAL_NO_QUERY_AVAILABLE"));
        }
    }

    private void enableControls(boolean bl) {
        this.structurePanel.getSearchField().setEnabled(bl);
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        protected Object doInBackground() throws Exception {
            try {
                StructureViewPanel.this._state.load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return StructureViewPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                    StructureViewPanel.this.structurePanel.trySearch();
                    StructureViewPanel.this.enableControls(true);
                    StructureViewPanel.this.setLoaded(true);
                } else {
                    StructureViewPanel.this.structurePanel.getTable().setNoEntryInstructionText(DataLrb.get("DATA_VIEWER_FAILURE_MESG_TRY_RERUN"));
                    if (StructureViewPanel.this._state.getTableModel() != null) {
                        StructureViewPanel.this._state.getTableModel().setFailedStatus();
                        StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                    }
                    if (this._ex == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
            }
            finally {
                StructureViewPanel.this.setLoading(false);
                if (StructureViewPanel.this.overLayPanel != null) {
                    StructureViewPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private class LoadUISync
    extends SwingWorker {
        Exception _ex = null;
        static final String _syncObject = "SyncObject";
        boolean _success = false;
        String _schema = null;
        String _table = null;
        String _sqlExpression = null;
        boolean _abandon = false;

        public LoadUISync(String string, String string2) {
            this._schema = string;
            this._table = string2;
        }

        public LoadUISync(String string) {
            this._sqlExpression = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            try {
                String string = _syncObject;
                synchronized (_syncObject) {
                    if (this._sqlExpression != null) {
                        StructureViewPanel.this._state.setSqlExpression(this._sqlExpression);
                        StructureViewPanel.this._state.load();
                        this._abandon = false;
                        this._success = true;
                    } else {
                        TableChooserModel.TableRow tableRow = StructureViewPanel.this.getSelectedTable();
                        if (tableRow == null) {
                            this._abandon = true;
                            this._success = false;
                        } else if (tableRow.getSchema().compareTo(this._schema) == 0 && tableRow.getTableName().compareTo(this._table) == 0) {
                            StructureViewPanel.this._state.setTableName(this._schema, this._table);
                            StructureViewPanel.this._state.load();
                            tableRow = StructureViewPanel.this.getSelectedTable();
                            if (tableRow == null) {
                                this._abandon = true;
                            } else if (tableRow.getSchema().compareTo(this._schema) != 0 || tableRow.getTableName().compareTo(this._table) != 0) {
                                this._abandon = true;
                            } else {
                                this._success = true;
                            }
                        } else {
                            this._abandon = true;
                            this._success = false;
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                this._abandon = true;
            }
            {
                return StructureViewPanel.this._state;
            }
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._abandon) {
                    return;
                }
                if (this._success && this._ex == null) {
                    TableChooserModel.TableRow tableRow;
                    if (this._sqlExpression == null && ((tableRow = StructureViewPanel.this.getSelectedTable()).getSchema().compareTo(this._schema) != 0 || tableRow.getTableName().compareTo(this._table) != 0)) {
                        return;
                    }
                    StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                    StructureViewPanel.this.structurePanel.trySearch();
                    StructureViewPanel.this.enableControls(true);
                    StructureViewPanel.this.setLoaded(true);
                } else if (!this._success && this._table != null && this._table.equals("")) {
                    StructureViewPanel.this._state.getTableModel().showSelectionRequired();
                } else {
                    if (StructureViewPanel.this._state.getTableModel() != null) {
                        StructureViewPanel.this._state.getTableModel().setFailedStatus();
                        StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
            }
            if (StructureViewPanel.this.overLayPanel != null) {
                StructureViewPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
        }
    }
}

