/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureLrb;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class StructureViewTableModel
extends GenericBaseTableModel {
    public static final Vector<String> _colNames = new Vector();
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_DATA_TYPE = 1;
    public static final int _COLUMN_MINING_TYPE = 2;
    public static final int _COLUMN_LENGTH = 3;
    public static final int _COLUMN_PRECISION = 4;
    public static final int _COLUMN_SCALE = 5;
    public static final int _COLUMN_ID = 6;
    private Vector<ColumnDataRow> _data = new Vector();

    public StructureViewTableModel(List<ColumnDataRow> list) {
        this.setColumnIdentifiers(_colNames);
        for (ColumnDataRow columnDataRow : list) {
            this._data.add(columnDataRow);
        }
        this.setRowCount(this._data.size());
    }

    public StructureViewTableModel(boolean bl) {
        this.setColumnIdentifiers(_colNames);
        if (bl) {
            this.showLoading();
        } else {
            this.showSelectionRequired();
        }
    }

    public void showLoading() {
        this._data.clear();
        ColumnDataRow columnDataRow = new ColumnDataRow();
        columnDataRow.setName(StructureLrb.get("TABLE_STRUCTURE_EDITOR_LOADING"));
        this._data.add(columnDataRow);
        this.setRowCount(this._data.size());
    }

    public void showSelectionRequired() {
        this._data.clear();
        ColumnDataRow columnDataRow = new ColumnDataRow();
        columnDataRow.setName(StructureLrb.get("TABLE_STRUCTURE_EDITOR_SELECTION_REQUIRED"));
        this._data.add(columnDataRow);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ColumnDataRow columnDataRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = columnDataRow.getName();
                break;
            }
            case 1: {
                object = columnDataRow.getDataType();
                break;
            }
            case 2: {
                if (columnDataRow.getDataType() == null) {
                    object = null;
                    break;
                }
                object = columnDataRow.getDataType().isEmpty() ? columnDataRow.getDataType() : DatabaseMetadataUtils.getDefaultUIMiningType(columnDataRow.getDataType());
                break;
            }
            case 3: {
                object = columnDataRow.getLength();
                break;
            }
            case 4: {
                object = columnDataRow.getPrecision();
                break;
            }
            case 5: {
                object = columnDataRow.getScale();
                break;
            }
            case 6: {
                object = columnDataRow.getColumn_id();
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public void setFailedStatus() {
        ColumnDataRow columnDataRow = new ColumnDataRow();
        columnDataRow.setName(StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILED_TO_LOAD_TABLE_STRUCTURE"));
        this._data.clear();
        this._data.add(columnDataRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public Vector<ColumnDataRow> getDataVector() {
        return this._data;
    }

    static {
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_NAME"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_TYPE"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_MINING_TYPE"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_LENGTH"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_PRECISION"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_SCALE"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_COLUMN_ID"));
    }
}

