/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.SwingWorker;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.workflow.WorkflowContextMenu;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;

public abstract class AbstractTestEditor
extends DataMinerEditor {
    protected static final Logger theLogger = Logger.getLogger(AbstractTestEditor.class.getName());
    protected SharedTestEditorState _sharedState;
    protected long _lastUpdatedTime;
    protected BlockingComponent overLayPanel = null;
    private BaseTreeNode _projectFolder = null;
    private BaseTreeNode _connectionFolder = null;
    private BaseTreeNode _connectionsFolder = null;
    private WorkflowNode _wfNode = null;

    @Override
    public void open() {
        Context context = this.getContext();
        BaseTreeNode baseTreeNode = (BaseTreeNode)context.getNode();
        if (baseTreeNode instanceof AbstractHiddenNode) {
            this.attach(((AbstractHiddenNode)baseTreeNode).getContext() != null);
        }
    }

    public abstract void reloadPanel();

    @Override
    public void refresh() {
        super.refresh();
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        LoadClassCompare loadClassCompare = new LoadClassCompare();
        loadClassCompare.execute();
    }

    @Override
    public void close() {
        super.close();
        this.attach(false);
    }

    private void attach(boolean bl) {
        if (bl) {
            AbstractHiddenNode abstractHiddenNode = (AbstractHiddenNode)this.getContext().getNode();
            if (!(this._wfNode instanceof WorkflowNode)) {
                return;
            }
            this._wfNode = (WorkflowNode)abstractHiddenNode.getContext().getNode();
            TNode tNode = this._wfNode.getParent();
            this._projectFolder = (BaseTreeNode)tNode.getData();
            this._connectionFolder = (BaseTreeNode)tNode.getAncestor(ConnectionFolder.class, true);
            this._connectionsFolder = (BaseTreeNode)tNode.getAncestor(Connections.class, true);
            this._projectFolder.attach((Observer)this);
            this._connectionFolder.attach((Observer)this);
            this._connectionsFolder.attach((Observer)this);
        } else {
            if (this._projectFolder != null) {
                this._projectFolder.detach((Observer)this);
                this._projectFolder = null;
            }
            if (this._connectionFolder != null) {
                this._connectionFolder.detach((Observer)this);
                this._connectionFolder = null;
            }
            if (this._connectionsFolder != null) {
                this._connectionsFolder.detach((Observer)this);
                this._connectionsFolder = null;
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List list = updateMessage.getRemoveObjects();
            if (list.contains(this._projectFolder) || list.contains(this._connectionFolder) || list.contains(this._connectionsFolder) || list.contains(this._wfNode)) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED && object == this._connectionFolder) {
            this.closeEditor();
        }
    }

    public Component getCurrentGUI() {
        return this._gui;
    }

    public Container getParent() {
        return this._gui.getParent();
    }

    protected void initSharedTestEditorState(Context context) {
        Node node = context.getNode();
        assert (node != null) : "Tree Node is not null";
        this._sharedState = new SharedTestEditorState(node);
        this._lastUpdatedTime = this._sharedState.getLastUpdateTime();
    }

    public Object getCachedLegendState() {
        return this._sharedState;
    }

    public void setCachedLegendState(Object object) {
        this._sharedState = (SharedTestEditorState)object;
    }

    protected boolean isReloadDueToUpdates() {
        if (this._sharedState == null) {
            return true;
        }
        return this._lastUpdatedTime != this._sharedState.getLastUpdateTime();
    }

    private class LoadClassCompare
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        private JMenuItem menuItem;
        private TestCompareNode rn = null;
        private View view = null;
        private WorkflowNode wfNode;

        public LoadClassCompare() {
            AbstractTestEditor.this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }

        protected Object doInBackground() throws Exception {
            try {
                WorkflowNode workflowNode = WorkflowNode.findParentWorkflowNode(AbstractTestEditor.this.getContext());
                Object object = workflowNode.getRepositoryData();
                if (object instanceof Workflow) {
                    Workflow workflow = (Workflow)object;
                    WorkflowModel workflowModel = workflowNode.getWorkflowModel();
                    Node node = AbstractTestEditor.this.getContext().getNode();
                    String string = workflowNode.getConnectionFolder().getUserAccountName();
                    if (node instanceof TestCompareNode) {
                        TestCompareNode testCompareNode = (TestCompareNode)node;
                        TestCompareNode testCompareNode2 = null;
                        AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(testCompareNode.getParentNodeId());
                        if (abstractNode instanceof ClassificationBuildNode) {
                            ClassificationBuildNode classificationBuildNode = (ClassificationBuildNode)abstractNode;
                            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)classificationBuildNode.getData();
                            testCompareNode2 = WorkflowContextMenu.createClassTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, classificationBuildNodeType, classificationBuildNodeType.getResults().getClassificationResult());
                        } else if (abstractNode instanceof RegressionBuildNode) {
                            RegressionBuildNode regressionBuildNode = (RegressionBuildNode)abstractNode;
                            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)regressionBuildNode.getData();
                            testCompareNode2 = WorkflowContextMenu.createRegressTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, string, regressionBuildNodeType, (List<? extends MiningResultType>)regressionBuildNodeType.getResults().getRegressionResult());
                        } else if (abstractNode instanceof TestNode) {
                            TestNode testNode = (TestNode)abstractNode;
                            TestNodeType testNodeType = (TestNodeType)testNode.getData();
                            if (testNodeType.getResults().getClassificationResult() != null && testNodeType.getResults().getClassificationResult().size() > 0) {
                                testCompareNode2 = WorkflowContextMenu.createClassTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, string, testNodeType, testNodeType.getResults().getClassificationResult());
                            } else if (testNodeType.getResults().getRegressionResult() != null && testNodeType.getResults().getRegressionResult().size() > 0) {
                                ArrayList<MiningResultType> arrayList = null;
                                arrayList = new ArrayList<MiningResultType>();
                                for (MiningResultType miningResultType : testNodeType.getResults().getRegressionResult()) {
                                    if (miningResultType.getCreationDate() == null) continue;
                                    arrayList.add(miningResultType);
                                }
                                testCompareNode2 = WorkflowContextMenu.createRegressTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, string, testNodeType, arrayList);
                            }
                        }
                        AbstractTestEditor.this.getContext().setNode(testCompareNode2);
                    } else {
                        TestResultNode testResultNode = (TestResultNode)node;
                        TestResultNode testResultNode2 = null;
                        AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(testResultNode.getParentClassificationNodeId());
                        if (abstractNode instanceof ClassificationBuildNode) {
                            ClassTestResult classTestResult = (ClassTestResult)testResultNode.getRepositoryData();
                            String string2 = classTestResult.getName();
                            ClassificationBuildNode classificationBuildNode = (ClassificationBuildNode)abstractNode;
                            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)classificationBuildNode.getData();
                            ClassificationResultType classificationResultType = null;
                            for (ClassificationResultType classificationResultType2 : classificationBuildNodeType.getResults().getClassificationResult()) {
                                if (!classificationResultType2.getName().equals(string2)) continue;
                                classificationResultType = classificationResultType2;
                                break;
                            }
                            testResultNode2 = WorkflowContextMenu.createClassTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string2, classificationBuildNodeType, classificationResultType);
                        } else if (abstractNode instanceof RegressionBuildNode) {
                            RegressTestResult regressTestResult = (RegressTestResult)testResultNode.getRepositoryData();
                            String string3 = regressTestResult.getName();
                            RegressionBuildNode regressionBuildNode = (RegressionBuildNode)abstractNode;
                            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)regressionBuildNode.getData();
                            RegressionResultType regressionResultType = null;
                            for (RegressionResultType regressionResultType2 : regressionBuildNodeType.getResults().getRegressionResult()) {
                                if (!regressionResultType2.getName().equals(string3)) continue;
                                regressionResultType = regressionResultType2;
                                break;
                            }
                            testResultNode2 = WorkflowContextMenu.createRegressTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string3, regressionBuildNodeType, regressionResultType);
                        } else if (abstractNode instanceof TestNode) {
                            TestNode testNode = (TestNode)abstractNode;
                            TestNodeType testNodeType = (TestNodeType)testNode.getData();
                            if (testResultNode.getRepositoryData() instanceof ClassTestResult) {
                                ClassTestResult classTestResult = (ClassTestResult)testResultNode.getRepositoryData();
                                String string4 = classTestResult.getName();
                                ClassificationResultType classificationResultType = null;
                                for (ClassificationResultType classificationResultType3 : testNodeType.getResults().getClassificationResult()) {
                                    if (!classificationResultType3.getName().equals(string4)) continue;
                                    classificationResultType = classificationResultType3;
                                    break;
                                }
                                testResultNode2 = WorkflowContextMenu.createClassTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string4, testNodeType, classificationResultType);
                            } else if (testResultNode.getRepositoryData() instanceof RegressTestResult) {
                                RegressTestResult regressTestResult = (RegressTestResult)testResultNode.getRepositoryData();
                                String string5 = regressTestResult.getName();
                                RegressionResultType regressionResultType = null;
                                for (RegressionResultType regressionResultType3 : testNodeType.getResults().getRegressionResult()) {
                                    if (!regressionResultType3.getName().equals(string5)) continue;
                                    regressionResultType = regressionResultType3;
                                    break;
                                }
                                testResultNode2 = WorkflowContextMenu.createRegressTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string5, testNodeType, regressionResultType);
                            }
                        }
                        AbstractTestEditor.this.getContext().setNode(testResultNode2);
                    }
                    AbstractTestEditor.this._lastUpdatedTime = System.currentTimeMillis();
                }
                this._success = true;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                this._ex = exception;
                this._success = false;
            }
            return true;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                AbstractTestEditor.this.reloadPanel();
            } else if (this._ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
        }
    }
}

