/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.lift.LiftEditor;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixEditor;
import oracle.dmt.dataminer.tviewer.performance.PerformanceEditor;
import oracle.dmt.dataminer.tviewer.profit.ProfitEditor;
import oracle.dmt.dataminer.tviewer.residual.ResidualEditor;
import oracle.dmt.dataminer.tviewer.roc.ROCEditor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;

public class AbstractTestEditorAddin
extends EditorAddin {
    protected MenuSpec _mspec = null;
    private MeasureType _type = null;

    public AbstractTestEditorAddin(MeasureType measureType) {
        this._type = measureType;
    }

    public Class getEditorClass() {
        switch (this._type) {
            case PERFORMANCE: {
                return PerformanceEditor.class;
            }
            case RESIDUAL: {
                return ResidualEditor.class;
            }
            case ROC: {
                return ROCEditor.class;
            }
            case LIFT: {
                return LiftEditor.class;
            }
            case PROFIT: {
                return ProfitEditor.class;
            }
            case MATRIX: {
                return PMatrixEditor.class;
            }
        }
        return null;
    }

    public boolean isDefault() {
        return true;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._mspec == null) {
            this._mspec = new MenuSpec(TestViewerLrb.get("EDITOR_PANEL_NAME"), this.getIcon());
        }
        return this._mspec;
    }

    public Icon getIcon() {
        return DataMinerIcons.get(Icons.BATMAN);
    }

    public void initialize() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.registerDynamic((EditorAddin)this);
        Class clazz = this.getEditorClass();
        editorManager.registerPreferredLayoutListener(TestResultNode.class, clazz, "dataminer.tviewer", (PreferredLayoutListener)new MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(TestCompareNode.class, clazz, "dataminer.tviewer", (PreferredLayoutListener)new MyPreferredLayoutListener());
    }

    public float getEditorWeight(Element element) {
        TestResult testResult = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (element instanceof TestResultNode || element instanceof TestCompareNode) {
            if (element instanceof TestResultNode) {
                testResult = (TestResult)((TestResultNode)element).getRepositoryData();
                if (testResult instanceof ClassTestResult) {
                    bl = ((ClassTestResult)testResult).isAccuracyMetricsResult();
                    bl2 = ((ClassTestResult)testResult).isConfusionMatrixResult();
                    bl3 = ((ClassTestResult)testResult).isLiftProfitResult();
                    bl4 = ((ClassTestResult)testResult).isROCResult();
                } else if (testResult instanceof RegressTestResult) {
                    bl = ((RegressTestResult)testResult).isAccuracyMetricsResult();
                    bl5 = ((RegressTestResult)testResult).isResidualsResult();
                }
            } else if (element instanceof TestCompareNode) {
                testResult = ((TestCompareNode)element).getTestResults().get(0);
                if (testResult instanceof ClassTestResult) {
                    bl = ((TestCompareNode)element).isShowTestMetrics();
                    bl2 = ((TestCompareNode)element).isShowConfusionMatrix();
                    bl3 = ((TestCompareNode)element).isShowLiftProfit();
                    bl4 = ((TestCompareNode)element).isShowROC();
                } else if (testResult instanceof RegressTestResult) {
                    bl = ((RegressTestResult)testResult).isAccuracyMetricsResult();
                    bl5 = ((RegressTestResult)testResult).isResidualsResult();
                }
            }
            switch (this._type) {
                case PERFORMANCE: {
                    if (bl) {
                        return 1.0f;
                    }
                    return Float.NaN;
                }
                case RESIDUAL: {
                    if (bl5) {
                        return 0.9f;
                    }
                    return Float.NaN;
                }
                case MATRIX: {
                    if (bl2) {
                        return 0.9f;
                    }
                    return Float.NaN;
                }
                case LIFT: {
                    if (bl3) {
                        return 0.7f;
                    }
                    return Float.NaN;
                }
                case PROFIT: {
                    if (bl3) {
                        return 0.6f;
                    }
                    return Float.NaN;
                }
                case ROC: {
                    if (bl4) {
                        return 0.8f;
                    }
                    return Float.NaN;
                }
            }
        }
        return Float.NaN;
    }

    public boolean restoreAtStartup() {
        return true;
    }

    public boolean isDuplicable() {
        return false;
    }

    private class MyPreferredLayoutListener
    implements PreferredLayoutListener {
        private MyPreferredLayoutListener() {
        }

        public void onInitializeLayout(PreferredLayoutEvent preferredLayoutEvent) {
        }

        public void onPreferredLayoutActivate(PreferredLayoutEvent preferredLayoutEvent) {
        }
    }

    public static enum MeasureType {
        PERFORMANCE,
        RESIDUAL,
        ROC,
        LIFT,
        PROFIT,
        MATRIX;

    }
}

