/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.repository.Activity;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Series;
import oracle.ide.Context;
import oracle.ide.model.Node;

public class SharedTestEditorState {
    private static final Logger theLogger = Logger.getLogger(SharedTestEditorState.class.getName());
    private List<TestResult> _allTestResults = null;
    private List<TestResult> _testResults = null;
    private String _selectTestResult = null;
    private List<Color> _testResultGraphColors = null;
    private HashMap<String, Color> _allTestResultGraphColors;
    private List<CPerformanceTabState.PerformanceMetric> _performanceMetrics = null;
    private Context _context = null;
    private Activity _parentActivity;
    private long _lastUpdateTime = 0L;
    public static final Color LIFT_IDEAL_LINE = Color.GREEN;
    public static final Color LIFT_RANDOM_LINE = Color.RED;
    public static final Color LIFT_QUANTILE_LINE = Color.BLUE;
    public static final Color PROFIT_BUDGET_LINE = Color.GREEN;
    public static final Color PROFIT_POPULATION_LINE = Color.BLUE;
    private static final List<Color> RESERVED_COLORS = Arrays.asList(Color.GREEN, Color.RED, Color.BLUE);

    /*
     * WARNING - void declaration
     */
    public SharedTestEditorState(Node node) {
        Object object2;
        Object object3;
        if (node instanceof TestResultNode) {
            object3 = (TestResultNode)node;
            object2 = (TestResult)((BaseTreeNode)object3).getRepositoryData();
            assert (object2 != null) : "model cannot be null";
            this._testResults = new ArrayList<TestResult>();
            this._testResults.add((TestResult)object2);
            this._context = ((AbstractHiddenNode)object3).getContext();
        } else if (node instanceof TestCompareNode) {
            object3 = (TestCompareNode)node;
            assert (((TestCompareNode)object3).getTestResults() != null) : "models cannot be null";
            this._testResults = ((TestCompareNode)object3).getTestResults();
            this._context = ((TestCompareNode)object3).getContext();
        } else assert (false) : "Node is not of type TestResultNode or TestCompareNode";
        object3 = new TreeMap();
        for (TestResult object4 : this._testResults) {
            object3.put(object4.toString(), object4);
        }
        this._testResults = new ArrayList(object3.values());
        object2 = null;
        Object var4_5 = null;
        try {
            object2 = Connections.getSharedConnection(this._context);
            String string2 = Connections.getUserAccountName(this._context);
            string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        boolean bl = false;
        for (TestResult testResult : this._testResults) {
            void var4_8;
            String string = testResult.getModelSchema();
            if (string == null || string.compareTo((String)var4_8) == 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (TestResult testResult : this._testResults) {
                testResult.setShowSchema(true);
            }
        }
        this._allTestResults = new ArrayList<TestResult>();
        this._allTestResults.addAll(this._testResults);
        this.assignColors();
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public void updateTime() {
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public List<TestResult> getTestResults() {
        return this._testResults;
    }

    public Activity getParentActivity() {
        return this._parentActivity;
    }

    public List<Color> getTestResultGraphColors() {
        return this._testResultGraphColors;
    }

    public Color getTestResultGraphColor(String string) {
        return this._allTestResultGraphColors.get(string);
    }

    public Context getContext() {
        return this._context;
    }

    public void setTestResults(List<TestResult> list) {
        this._testResults = list;
        this._testResultGraphColors.clear();
        for (TestResult testResult : this._testResults) {
            Color color = this._allTestResultGraphColors.get(testResult.toString());
            this._testResultGraphColors.add(color);
        }
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public void setPerformanceMetrics(List<CPerformanceTabState.PerformanceMetric> list) {
        this._performanceMetrics = list;
    }

    public List<CPerformanceTabState.PerformanceMetric> getPerformanceMetrics() {
        return this._performanceMetrics;
    }

    private void assignColors() {
        Graph graph = new Graph();
        Object[] objectArray = new Object[]{"TempRowLable1", "TempRowLable2"};
        Object[] objectArray2 = new Object[this._testResults.size() + RESERVED_COLORS.size()];
        Object[][] objectArray3 = new Object[2][this._testResults.size() + RESERVED_COLORS.size()];
        int n = 0;
        for (int i = 0; i < RESERVED_COLORS.size(); ++i) {
            objectArray2[n] = "Color-" + n;
            objectArray3[0][n] = 0.5;
            objectArray3[1][n] = 1.0;
            ++n;
        }
        for (TestResult iterator : this._allTestResults) {
            objectArray2[n] = iterator.getName();
            objectArray3[0][n] = 0.5;
            objectArray3[1][n] = 1.0;
            ++n;
        }
        graph.setGridData(objectArray, objectArray2, objectArray3);
        Series series = graph.getSeries();
        n = 0;
        for (Color color : RESERVED_COLORS) {
            try {
                series.setColor(color, n++);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        this._allTestResultGraphColors = new HashMap();
        this._testResultGraphColors = new ArrayList<Color>();
        for (TestResult testResult : this._allTestResults) {
            try {
                Color color = series.getColor(n++);
                this._allTestResultGraphColors.put(testResult.toString(), color);
                this._testResultGraphColors.add(color);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public List<TestResult> getAllTestResults() {
        return this._allTestResults;
    }

    public void setSelectTestResult(String string) {
        this._selectTestResult = string;
    }

    public String getSelectTestResult() {
        return this._selectTestResult;
    }
}

