/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.lift;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.lift.LiftDetailDialog;
import oracle.dmt.dataminer.tviewer.lift.LiftEditor;
import oracle.dmt.dataminer.tviewer.lift.LiftTabState;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class LiftPanel
extends DataMinerViewGUI
implements GraphDataDisplay {
    private GraphPanel _graphPanel;
    private LiftTabState _state;
    private boolean _loading = true;
    private static final String UPDATE_ALL = "UPDATE_ALL";
    private static final String UPDATE_GRAPH = "UPDATE_GRAPH";
    private static final String UPDATE_THRESHOLD = "UPDATE_THRESHOLD";
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;
    private JComboBox jDisplayCombo;
    private JLabel jDisplayLbl;
    private JPanel jGraphControl;
    private JPanel jGraphPanel;
    private JPanel jPanel;
    private JPanel jPanel1;
    private JSlider jQuantileSlider;
    private JSplitPane jSplitPane;
    private JComboBox jTargetComb;
    private JLabel jTargetLbl;
    private JButton jDetailBtn;
    private JButton _jBT_AddOrRemove;

    public LiftPanel(LiftEditor liftEditor, Context context) {
        super(liftEditor, context);
        this._state = new LiftTabState((SharedTestEditorState)liftEditor.getCachedLegendState(), context);
        this.initComponents();
        this.initGraph();
        this.initRes();
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel(this, new DefaultGraphDataModel(null, null, null, null, null));
        this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.jGraphPanel.updateUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, (Component)this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jDisplayLbl, (Component)this.jDisplayCombo, (String)TestViewerLrb.get("DISPLAY_OPTION"));
        this.jDisplayLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("DISPLAY_OPTION"));
        this.jDisplayLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("DISPLAY_OPTION_ADA"));
    }

    @Override
    public void initUI() {
        this._loading = true;
        this.dataMinerTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = LiftPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    String string = (String)LiftPanel.this._state.getLiftTableModel().getValueAt(nArray[0], 0);
                    LiftDetailDialog liftDetailDialog = new LiftDetailDialog(LiftPanel.this.getContext(), string, LiftPanel.this._state.getLiftData().get(string));
                    liftDetailDialog.invoke();
                }
            }
        });
        this.installLiftResultsActions();
        this.dataMinerTablePanel.setTitle(TestViewerLrb.get("MODELS"));
        this.initializeControls();
        this.jSplitPane.setDividerLocation(0.75);
        this.jSplitPane.setResizeWeight(0.75);
        LoadUI loadUI = new LoadUI(UPDATE_ALL);
        loadUI.execute();
    }

    public void reload() {
        this._loading = true;
        this.enableControls(false);
        LiftEditor liftEditor = (LiftEditor)this.getEditor();
        this._state = new LiftTabState((SharedTestEditorState)liftEditor.getCachedLegendState(), this.getContext());
        this._context = liftEditor.getContext();
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        LoadUI loadUI = new LoadUI(UPDATE_ALL);
        loadUI.execute();
    }

    private void enableControls(boolean bl) {
        this.jDisplayCombo.setEnabled(bl);
        this.jTargetComb.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0);
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingLiftTableModel()));
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jDisplayCombo.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES"), TestViewerLrb.get("DISPLAY_OPTION_CUMULATIVE_LIFT")}));
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("LOADING_SHORTENED")}));
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LiftPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this._state.getLiftTableModel().getValueAt(nArray[0], 0);
            this._state.setSelectedTestResult(string);
            this.enableControls(true);
            this.getEditor().updateSelection();
        }
    }

    public LiftTabState.LiftData getLiftData() {
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getLiftTableModel().getValueAt(nArray[0], 0);
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getSelectedQuantileValue();
        LiftTabState.LiftData liftData = this._state.getLiftData().get(string).get(n);
        liftData.setLabel(string);
        return liftData;
    }

    private void initComponents() {
        this.jDisplayLbl = new JLabel();
        this.jDisplayCombo = new JComboBox();
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSplitPane = new JSplitPane();
        this.jPanel = new JPanel();
        this.jGraphPanel = new JPanel();
        this.jGraphControl = new JPanel();
        this.jQuantileSlider = new JSlider();
        this.jPanel1 = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jDisplayLbl.setText("Display:");
        this.jDisplayCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Cumulative Positive Cases", "Cumulative Lift", "Profit"}));
        this.jDisplayCombo.setMinimumSize(new Dimension(0, 0));
        this.jDisplayCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LiftPanel.this.jDisplayComboActionPerformed(actionEvent);
            }
        });
        this.jTargetLbl.setHorizontalAlignment(4);
        this.jTargetLbl.setText("Target Value:");
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTargetComb.setMinimumSize(new Dimension(0, 0));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LiftPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jSplitPane.setDividerLocation(400);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphControl.setLayout(new GridBagLayout());
        this.jQuantileSlider.setName("jQuantileSlider");
        this.jQuantileSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LiftPanel.this.jQuantileSliderStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.jGraphControl.add((Component)this.jQuantileSlider, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGraphControl, -1, 652, Short.MAX_VALUE).addComponent(this.jGraphPanel, -1, 652, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jGraphPanel, -1, 370, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphControl, -2, -1, -2)));
        this.jSplitPane.setTopComponent(this.jPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, GroupLayout.Alignment.TRAILING, -1, 652, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 110, Short.MAX_VALUE));
        this.jSplitPane.setBottomComponent(this.jPanel1);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jDisplayLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDisplayCombo, 0, -1, Short.MAX_VALUE).addGap(300, 300, 300).addComponent(this.jTargetLbl, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, 0, -1, Short.MAX_VALUE)).addComponent(this.jSplitPane)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDisplayLbl).addComponent(this.jTargetComb, -2, -1, -2).addComponent(this.jTargetLbl).addComponent(this.jDisplayCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane).addContainerGap()));
    }

    private void jDisplayComboActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jDisplayCombo.getSelectedItem();
        if (string.equals(TestViewerLrb.get("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES"))) {
            this._state.setSelectedDisplayOption("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES");
        } else {
            this._state.setSelectedDisplayOption("DISPLAY_OPTION_CUMULATIVE_LIFT");
        }
        this._loading = true;
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingLiftTableModel()));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
        loadUI.execute();
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingLiftTableModel()));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
        loadUI.execute();
    }

    private void installLiftResultsActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("LIFT_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LiftPanel.this.jDetailBtnActionPerformed(actionEvent);
            }
        });
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            this._jBT_AddOrRemove = new JButton(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
            this._jBT_AddOrRemove.setDisabledIcon(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LiftPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn, this._jBT_AddOrRemove);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._state.getParentTestViewerState(), this._state.getParentTestViewerState().getContext(), this._state.getParentTestViewerState().getParentActivity(), this._state.getParentTestViewerState().getAllTestResults(), this._state.getParentTestViewerState().getTestResults())) {
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._state.getParentTestViewerState().setTestResults(list);
            this.jGraphPanel.removeAll();
            this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
            this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingLiftTableModel()));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(UPDATE_ALL);
            loadUI.execute();
        }
    }

    private void jDetailBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this._state.getLiftTableModel().getValueAt(nArray[0], 0);
        LiftDetailDialog liftDetailDialog = new LiftDetailDialog(this.getContext(), string, this._state.getLiftData().get(string));
        liftDetailDialog.invoke();
    }

    private void jQuantileSliderStateChanged(ChangeEvent changeEvent) {
        if (this._loading) {
            return;
        }
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            return;
        }
        BoundedRangeModel boundedRangeModel = this.jQuantileSlider.getModel();
        Integer n = boundedRangeModel.getValue();
        n = Math.max(1, n);
        this._state.setSelectedQuantileValue(n);
        this._loading = true;
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_THRESHOLD);
        loadUI.execute();
    }

    public void setCachedPropertyState(Object object) {
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    @Override
    public void showData(Object object) {
        this.jDetailBtnActionPerformed(null);
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        String _updatemode;

        public LoadUI(String string) {
            this._updatemode = string;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._updatemode.equals(LiftPanel.UPDATE_THRESHOLD)) {
                    LiftPanel.this._state.refreshCustomThresholdData();
                    LiftPanel.this._graphPanel.refreshGraph();
                } else if (this._updatemode.equals(LiftPanel.UPDATE_GRAPH)) {
                    LiftPanel.this._state.refreshLiftData();
                    LiftPanel.this._graphPanel.initGraph(LiftPanel.this._state.getLiftGraphModel());
                } else {
                    LiftPanel.this._state.load();
                    LiftPanel.this._graphPanel.initGraph(LiftPanel.this._state.getLiftGraphModel());
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return LiftPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    Object object;
                    LiftPanel.this.jGraphPanel.removeAll();
                    LiftPanel.this.jGraphPanel.add((Component)LiftPanel.this._graphPanel, "Center");
                    LiftPanel.this.jGraphPanel.updateUI();
                    String string = LiftPanel.this._state.getSelectedTestResult();
                    LiftPanel.this.dataMinerTablePanel.getTable().setFixedColumns(n, 165);
                    LiftPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)LiftPanel.this._state.getLiftTableModel()));
                    LiftPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
                    LiftPanel.this.dataMinerTablePanel.getTable().setSorted(true);
                    TableColumnModel tableColumnModel = LiftPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

                        @Override
                        public Color getColorFor(Object object) {
                            String string = (String)object;
                            return LiftPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
                        }
                    });
                    tableColumnModel.getColumn(0).setCellRenderer(colorCellRenderer);
                    tableColumnModel.getColumn(1).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(2).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(3).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(4).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(6).setCellRenderer(new DateCellRenderer2());
                    tableColumnModel.getColumn(1).setPreferredWidth(100);
                    tableColumnModel.getColumn(2).setPreferredWidth(120);
                    tableColumnModel.getColumn(3).setPreferredWidth(140);
                    tableColumnModel.getColumn(4).setPreferredWidth(160);
                    tableColumnModel.getColumn(5).setPreferredWidth(135);
                    tableColumnModel.getColumn(6).setPreferredWidth(135);
                    int n2 = 0;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < LiftPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            d = LiftPanel.this._state.getSelectedDisplayOption().equals("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES") ? ((Double)LiftPanel.this._state.getLiftTableModel().getValueAt(i, 2)).doubleValue() : ((Double)LiftPanel.this._state.getLiftTableModel().getValueAt(i, 1)).doubleValue();
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n2 = i;
                        }
                    } else {
                        for (int i = 0; i < LiftPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            object = LiftPanel.this._state.getLiftTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n2 = i;
                        }
                    }
                    LiftPanel.this.dataMinerTablePanel.getTable().setRowSelectionInterval(n2, n2);
                    if (this._updatemode.equals(LiftPanel.UPDATE_ALL)) {
                        LiftPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(LiftPanel.this._state.getTargetValues()));
                        LiftPanel.this.jTargetComb.setSelectedItem(LiftPanel.this._state.getSelectedTargetValue());
                        Integer n3 = LiftPanel.this._state.getSelectedQuantileValue();
                        object = 0;
                        Integer n4 = LiftPanel.this._state.getMaxQuantileCnt() - 1;
                        LiftPanel.this.jQuantileSlider.setMajorTickSpacing(10);
                        LiftPanel.this.jQuantileSlider.setMinorTickSpacing(1);
                        LiftPanel.this.jQuantileSlider.setPaintTicks(true);
                        LiftPanel.this.jQuantileSlider.setPaintLabels(true);
                        LiftPanel.this.jQuantileSlider.setSnapToTicks(true);
                        LiftPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel(n3, 0, (Integer)object, n4));
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), null);
                }
                LiftPanel.this.enableControls(true);
                LiftPanel.this.getEditor().updateSelection();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                LiftPanel.this._loading = false;
                if (LiftPanel.this.overLayPanel != null) {
                    LiftPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

