/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.performance;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CPerformanceTabState {
    private static final Logger theLogger = Logger.getLogger(CPerformanceTabState.class.getName());
    private SharedTestEditorState _parentTestViewerState;
    private List<TestResult> _testResults;
    private ArrayList<PerformanceMetric> _metricsList;
    private GraphDataModel _graphDataModel;
    private ArrayList<Measure> _selectedGraphPerformanceMesaures = new ArrayList();
    private List<Color> _testResultColors = null;
    private PerformanceTable _performanceTable = null;
    private long _lastUpdateTime = 0L;
    private boolean _hasCost = false;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)_p);
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS = 50;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;

    public CPerformanceTabState(SharedTestEditorState sharedTestEditorState) {
        this(sharedTestEditorState, null);
    }

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public void resetTime() {
        this._lastUpdateTime = 0L;
    }

    public CPerformanceTabState(SharedTestEditorState sharedTestEditorState, ArrayList<Measure> arrayList) {
        this._parentTestViewerState = sharedTestEditorState;
        this._testResults = this._parentTestViewerState.getTestResults();
        this._testResultColors = this._parentTestViewerState.getTestResultGraphColors();
        this._graphDataModel = new DefaultGraphDataModel(null, 17, null, null, null);
        this._graphDataModel.setX1(TestViewerLrb.get("TEST_RESULT"), null);
        this._graphDataModel.setY1(TestViewerLrb.get("VALUE"), 100.0);
        if (this._testResultColors != null) {
            this._graphDataModel.addRowColors(this._testResultColors.toArray(new Color[0]));
        }
        if (arrayList == null || arrayList.size() == 0) {
            this._selectedGraphPerformanceMesaures.add(Measure.PREDICTIVE_CONFIDENCE);
        } else {
            this._selectedGraphPerformanceMesaures = arrayList;
        }
        this._hasCost = false;
        this.styleSelection = this.graphPanelSettings.getGraphStyle();
        this.depthRadius = this.graphPanelSettings.getRadiusDepthValue();
    }

    public synchronized List<PerformanceMetric> sortedResults(Measure measure, SortBy sortBy, SortOrder sortOrder) {
        Collections.sort(this._metricsList, new PerformanceMetricComparator(measure, sortBy, sortOrder));
        return this._metricsList;
    }

    public synchronized GraphDataModel sortedGraphDataModel(Measure measure, SortBy sortBy, SortOrder sortOrder, Object[] objectArray) {
        this.sortedResults(measure, sortBy, sortOrder);
        Object[] objectArray2 = new Object[this._testResults.size()];
        Color[][] colorArray = null;
        Object[] objectArray3 = null;
        Object[] objectArray4 = null;
        Object[][] objectArray5 = null;
        this._graphDataModel.clear();
        this._graphDataModel.setGraphType(17);
        if (measure == Measure.MEAN_PREDICTED_VALUE && this._metricsList.get((int)0)._measureItemValue3 != null) {
            objectArray5 = new Object[this._testResults.size()][2];
            objectArray4 = new Object[this._testResults.size() * 2];
            colorArray = new Color[objectArray2.length][2];
        } else {
            objectArray5 = new Object[this._testResults.size()][1];
            objectArray3 = new Object[1];
            colorArray = new Color[objectArray2.length][1];
        }
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        for (PerformanceMetric performanceMetric : this._metricsList) {
            objectArray2[n] = performanceMetric._testResult.toString();
            switch (measure) {
                case MEAN_ACTUAL_VALUE: {
                    d = 100.0;
                    objectArray3[0] = TestViewerLrb.get("MEAN_ACTUAL_VALUE");
                    objectArray5[n][0] = performanceMetric._measureItemValue4.doubleValue();
                    this._graphDataModel.setTitle(TestViewerLrb.get("MEAN_ACTUAL_VALUE"));
                    colorArray[n][0] = performanceMetric._color;
                    break;
                }
                case PREDICTIVE_CONFIDENCE: {
                    d = 100.0;
                    objectArray3[0] = TestViewerLrb.get("PREDICTIVE_CONFIDENCE");
                    colorArray[n][0] = performanceMetric._color;
                    objectArray5[n][0] = performanceMetric._predConfidence.doubleValue();
                    this._graphDataModel.setTitle(TestViewerLrb.get("PERF_PC_GRAPH_TITLE"));
                    break;
                }
                case AVG_ACCURACY: 
                case ROOT_MEAN_SQRT_ERR: {
                    if (measure == Measure.ROOT_MEAN_SQRT_ERR) {
                        if (performanceMetric._measureItemValue1.doubleValue() > d) {
                            d = performanceMetric._measureItemValue1.doubleValue();
                        }
                        objectArray3[0] = TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR");
                    } else {
                        d = 100.0;
                        objectArray3[0] = TestViewerLrb.get("AVG_ACCURACY");
                    }
                    colorArray[n][0] = performanceMetric._color;
                    objectArray5[n][0] = performanceMetric._measureItemValue1.doubleValue();
                    this._graphDataModel.setTitle(TestViewerLrb.get(measure == Measure.AVG_ACCURACY ? "PERF_AA_GRAPH_TITLE" : "PERF_RMSE_GRAPH_TITLE"));
                    break;
                }
                case OVERALL_ACCURACY: 
                case MEAN_ABS_ERR: {
                    if (measure == Measure.MEAN_ABS_ERR) {
                        if (performanceMetric._measureItemValue2.doubleValue() > d) {
                            d = performanceMetric._measureItemValue2.doubleValue();
                        }
                        objectArray3[0] = TestViewerLrb.get("MEAN_ABSOLUTE_ERROR");
                    } else {
                        d = 100.0;
                        objectArray3[0] = TestViewerLrb.get("OVERALL_ACCURACY");
                    }
                    colorArray[n][0] = performanceMetric._color;
                    objectArray5[n][0] = performanceMetric._measureItemValue2.doubleValue();
                    this._graphDataModel.setTitle(TestViewerLrb.get(measure == Measure.OVERALL_ACCURACY ? "PERF_OA_GRAPH_TITLE" : "PERF_MAE_GRAPH_TITLE"));
                    break;
                }
                case COST: 
                case MEAN_PREDICTED_VALUE: {
                    if (performanceMetric._measureItemValue3 != null) {
                        if (measure == Measure.MEAN_PREDICTED_VALUE) {
                            if (performanceMetric._measureItemValue3.doubleValue() > d) {
                                d = performanceMetric._measureItemValue3.doubleValue();
                            }
                            if (performanceMetric._measureItemValue4.doubleValue() > d) {
                                d = performanceMetric._measureItemValue4.doubleValue();
                            }
                            objectArray3 = new Object[]{TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE")};
                            objectArray4[n2++] = 1;
                            colorArray[n][0] = performanceMetric._color;
                            objectArray5[n][0] = performanceMetric._measureItemValue3.doubleValue();
                            objectArray4[n2++] = 2;
                            objectArray5[n][1] = performanceMetric._measureItemValue4.doubleValue();
                            colorArray[n][1] = Color.RED;
                        } else {
                            double d2 = 0.0;
                            d2 = performanceMetric._measureItemValue3.scale() == 0 ? (double)performanceMetric._measureItemValue3.longValue() : performanceMetric._measureItemValue3.doubleValue();
                            if (d2 > d) {
                                d = d2;
                            }
                            objectArray3[0] = TestViewerLrb.get("COST");
                            colorArray[n][0] = performanceMetric._color;
                            objectArray5[n][0] = performanceMetric._measureItemValue3.doubleValue();
                        }
                    } else {
                        objectArray5[n][0] = null;
                    }
                    this._graphDataModel.setTitle(TestViewerLrb.get(measure == Measure.COST ? "PERF_CO_GRAPH_TITLE" : "PERF_MPV_GRAPH_TITLE"));
                    this._graphDataModel.setY1(TestViewerLrb.get("VALUE"), null);
                }
            }
            ++n;
        }
        this._graphDataModel.addRowLabels(objectArray3);
        this._graphDataModel.addColumnLabels(objectArray2);
        this._graphDataModel.addRowColors2(colorArray);
        if (objectArray4 != null) {
            this._graphDataModel.addRowMarkerTypes(objectArray4);
        }
        this._graphDataModel.addGraphData(objectArray5);
        this._graphDataModel.setY1(TestViewerLrb.get("VALUE"), d);
        this._graphDataModel.setDepthRadius(this.depthRadius);
        this._graphDataModel.setStyleSelection(this.styleSelection);
        return this._graphDataModel;
    }

    public synchronized void load(String[] stringArray, Connection connection) throws Exception {
        this._percentageFormat.setMaximumFractionDigits(this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
        this._testResults = this._parentTestViewerState.getTestResults();
        if (this._parentTestViewerState.getPerformanceMetrics() == null || this._parentTestViewerState.getLastUpdateTime() != this._lastUpdateTime) {
            this._lastUpdateTime = this._parentTestViewerState.getLastUpdateTime();
            this._metricsList = new ArrayList();
            for (TestResult testResult : this._testResults) {
                PerformanceMetric performanceMetric = new PerformanceMetric();
                performanceMetric._testResult = testResult;
                performanceMetric._color = this._parentTestViewerState.getTestResultGraphColor(testResult.toString());
                String string = null;
                String string2 = null;
                if (testResult instanceof ClassTestResult) {
                    string = ((ClassTestResult)testResult).getPerformanceMatrixTable();
                    string2 = "Select metric_name, metric_num_value from " + string + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'AVG_ACCURACY', 'ACCURACY', 'COST')";
                } else if (testResult instanceof RegressTestResult) {
                    string = ((RegressTestResult)testResult).getPerformanceMatrixTable();
                    string2 = "Select metric_name, metric_num_value from " + string + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'MEAN_RMS_ERROR', 'MEAN_ABSOLUTE_ERROR', 'MEAN_PREDICATED_VALUE', 'MEAN_ACTUAL_VALUE')";
                    this._hasCost = true;
                }
                SQLHelper sQLHelper = new SQLHelper();
                try {
                    sQLHelper.pstmt = connection.prepareStatement(string2);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        String string3 = sQLHelper.rs.getString(1);
                        BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(2);
                        if ("PREDICTIVE_CONFIDENCE".equals(string3)) {
                            performanceMetric._predConfidence = bigDecimal;
                            continue;
                        }
                        if ("AVG_ACCURACY".equals(string3) || "MEAN_RMS_ERROR".equals(string3)) {
                            performanceMetric._measureItemValue1 = bigDecimal;
                            continue;
                        }
                        if ("ACCURACY".equals(string3) || "MEAN_ABSOLUTE_ERROR".equals(string3)) {
                            performanceMetric._measureItemValue2 = bigDecimal;
                            continue;
                        }
                        if ("COST".equals(string3) || "MEAN_PREDICATED_VALUE".equals(string3)) {
                            performanceMetric._measureItemValue3 = bigDecimal;
                            if (!(testResult instanceof ClassTestResult) || !(bigDecimal.doubleValue() > 0.0)) continue;
                            this._hasCost = true;
                            continue;
                        }
                        if (!"MEAN_ACTUAL_VALUE".equals(string3)) continue;
                        performanceMetric._measureItemValue4 = bigDecimal;
                    }
                    performanceMetric._algorithm = testResult.getMiningAlgorithm();
                    performanceMetric._creationDate = testResult.getCreationTime();
                    this._metricsList.add(performanceMetric);
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    throw sQLException;
                }
                finally {
                    sQLHelper.close();
                }
            }
            this._performanceTable = new PerformanceTable(stringArray, this._metricsList);
            List list = (List)this._metricsList.clone();
            this._parentTestViewerState.setPerformanceMetrics(list);
        } else {
            ArrayList arrayList;
            ArrayList arrayList2 = (ArrayList)this._parentTestViewerState.getPerformanceMetrics();
            this._metricsList = arrayList = (ArrayList)arrayList2.clone();
        }
    }

    public GenericBaseTableModel getPerformanceTableModel() {
        return this._performanceTable;
    }

    public GraphDataModel getGraphDataModel() {
        return this._graphDataModel;
    }

    public boolean hasCost() {
        return this._hasCost;
    }

    class PerformanceTable
    extends GenericBaseTableModel {
        private final String LOADING = TestViewerLrb.get("LOADING");
        private String[] _columnNames;
        private List<PerformanceMetric> _metricsList;

        public PerformanceTable(String[] stringArray) {
            this(stringArray, null);
        }

        public PerformanceTable(String[] stringArray, List<PerformanceMetric> list) {
            this._columnNames = stringArray;
            this._metricsList = list;
            this.setColumnIdentifiers(stringArray);
            if (this._metricsList != null) {
                this.setRowCount(this._metricsList.size());
            } else {
                this.setRowCount(1);
            }
            if (this._columnNames != null) {
                this.setColumnCount(this._columnNames.length);
            } else {
                this.setColumnCount(1);
            }
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._metricsList == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            PerformanceMetric performanceMetric = this._metricsList.get(n);
            if (this._columnNames[n2].equals(TestViewerLrb.get("NAME"))) {
                return performanceMetric._testResult.toString();
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("ALGORITHM"))) {
                return performanceMetric._algorithm;
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("CREATION_DATE"))) {
                return performanceMetric._creationDate;
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"))) {
                return performanceMetric._predConfidence.doubleValue();
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("OVERALL_ACCURACY_COL"))) {
                return performanceMetric._measureItemValue2.doubleValue();
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("AVG_ACCURACY_COL"))) {
                return performanceMetric._measureItemValue1.doubleValue();
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("COST"))) {
                return performanceMetric._measureItemValue3 != null ? Double.valueOf(performanceMetric._measureItemValue3.doubleValue()) : performanceMetric._measureItemValue3;
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("MEAN_PREDICTED_VALUE"))) {
                return performanceMetric._measureItemValue3.doubleValue();
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("MEAN_ACTUAL_VALUE"))) {
                return performanceMetric._measureItemValue4.doubleValue();
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"))) {
                return performanceMetric._measureItemValue2.doubleValue();
            }
            if (this._columnNames[n2].equals(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"))) {
                return performanceMetric._measureItemValue1.doubleValue();
            }
            return "Undefined";
        }
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    public static enum SortBy {
        MEASURE,
        CREATION_TIME,
        NAME;

    }

    public static enum Measure {
        PREDICTIVE_CONFIDENCE,
        AVG_ACCURACY,
        OVERALL_ACCURACY,
        COST,
        ROOT_MEAN_SQRT_ERR,
        MEAN_ABS_ERR,
        MEAN_ACTUAL_VALUE,
        MEAN_PREDICTED_VALUE,
        MULTIPLE_SELECTION;

    }

    public class PerformanceMetricComparator
    implements Comparator {
        private Measure _primaryCompareMesaure;
        private SortBy _sortBy;
        private SortOrder _sortOrder;

        public PerformanceMetricComparator(Measure measure, SortBy sortBy, SortOrder sortOrder) {
            this._primaryCompareMesaure = measure;
            this._sortBy = sortBy;
            this._sortOrder = sortOrder;
        }

        public int compare(Object object, Object object2) {
            int n = SortOrder.ASCENDING.equals((Object)this._sortOrder) ? 1 : -1;
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null && object2 != null) {
                return -1;
            }
            if (object != null && object2 == null) {
                return 1;
            }
            if (object != null && object2 != null) {
                PerformanceMetric performanceMetric = (PerformanceMetric)object;
                PerformanceMetric performanceMetric2 = (PerformanceMetric)object2;
                switch (this._sortBy) {
                    case MEASURE: {
                        switch (this._primaryCompareMesaure) {
                            case PREDICTIVE_CONFIDENCE: {
                                return performanceMetric._predConfidence.compareTo(performanceMetric2._predConfidence) * n;
                            }
                            case AVG_ACCURACY: 
                            case ROOT_MEAN_SQRT_ERR: {
                                return performanceMetric._measureItemValue1.compareTo(performanceMetric2._measureItemValue1) * n;
                            }
                            case OVERALL_ACCURACY: 
                            case MEAN_ABS_ERR: {
                                return performanceMetric._measureItemValue2.compareTo(performanceMetric2._measureItemValue2) * n;
                            }
                            case COST: 
                            case MEAN_PREDICTED_VALUE: {
                                if (performanceMetric._measureItemValue3 == null && performanceMetric2._measureItemValue3 == null) {
                                    return 0;
                                }
                                if (performanceMetric._measureItemValue3 == null && performanceMetric2._measureItemValue3 != null) {
                                    return -1;
                                }
                                if (performanceMetric._measureItemValue3 != null && performanceMetric2._measureItemValue3 == null) {
                                    return 1;
                                }
                                if (performanceMetric._measureItemValue3 != null && performanceMetric2._measureItemValue3 != null) {
                                    return performanceMetric._measureItemValue3.compareTo(performanceMetric2._measureItemValue3) * n;
                                }
                                return 0;
                            }
                        }
                        break;
                    }
                    case CREATION_TIME: {
                        return performanceMetric._testResult.getCreationTime().compareTo(performanceMetric2._testResult.getCreationTime()) * n;
                    }
                    case NAME: {
                        return performanceMetric._testResult.toString().compareTo(performanceMetric2._testResult.toString()) * n;
                    }
                }
            }
            assert (false);
            return 1;
        }
    }

    public class PerformanceMetric {
        private TestResult _testResult = null;
        private Color _color = null;
        public BigDecimal _predConfidence = null;
        public BigDecimal _measureItemValue1 = null;
        public BigDecimal _measureItemValue2 = null;
        public BigDecimal _measureItemValue3 = null;
        public BigDecimal _measureItemValue4 = null;
        public String _algorithm = null;
        public Date _creationDate = null;

        public Object[] toArray() {
            if (this._measureItemValue4 == null) {
                return new Object[]{this._testResult.toString(), this._predConfidence == null ? null : Double.valueOf(this._predConfidence.doubleValue()), this._measureItemValue2 == null ? null : Double.valueOf(this._measureItemValue2.doubleValue()), this._measureItemValue1 == null ? null : Double.valueOf(this._measureItemValue1.doubleValue()), this._measureItemValue3 == null ? null : Double.valueOf(this._measureItemValue3.doubleValue())};
            }
            return new Object[]{this._testResult.toString(), this._predConfidence == null ? null : Double.valueOf(this._predConfidence.doubleValue()), this._measureItemValue2 == null ? null : Double.valueOf(this._measureItemValue2.doubleValue()), this._measureItemValue1 == null ? null : Double.valueOf(this._measureItemValue1.doubleValue()), this._measureItemValue3 == null ? null : Double.valueOf(this._measureItemValue3.doubleValue()), this._measureItemValue4 == null ? null : Double.valueOf(this._measureItemValue4.doubleValue())};
        }
    }
}

