/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.performance;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.tviewer.performance.PerformanceEditor;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;

public class PerformanceTabPanel
extends DataMinerViewGUI {
    private static final Logger theLogger = Logger.getLogger(PerformanceTabPanel.class.getName());
    CPerformanceTabState _performanceTabState;
    GraphPanel _graphPanel;
    MeasureItem _selectedMeasureItem;
    MeasureItem _predictionConfidenceMeasureItem;
    MeasureItem _measureItem1;
    MeasureItem _measureItem2;
    MeasureItem _measureItem3;
    MeasureItem _measureItem4;
    MeasureItem _allMeasureItem;
    SortByItem _selectedSortByItem;
    SortOrderItem _selectedSortOrderItem;
    Context _context;
    boolean _showClassResults = true;
    private String[] _columnNames = null;
    private ColorCellRenderer.ColorChooser colorChooser;
    int[] columns = new int[0];
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;
    private JComboBox jCBSortOrder;
    private JComboBox jCB_Measure;
    private JComboBox jCB_SortBy;
    private JLabel jLB_Measure;
    private JLabel jLB_SortBy;
    private JPanel jPNL_Graph;
    private JSplitPane jSPLPane;
    private JScrollPane jScrollPane1;
    private JButton _jBT_AddOrRemove;

    public PerformanceTabPanel(PerformanceEditor performanceEditor, Context context) {
        super(performanceEditor, context);
        this._performanceTabState = new CPerformanceTabState((SharedTestEditorState)performanceEditor.getCachedLegendState());
        if (this._performanceTabState.getParentTestViewerState().getTestResults().get(0) instanceof RegressTestResult) {
            this._showClassResults = false;
        }
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLB_Measure = new JLabel();
        this.jCB_Measure = new JComboBox();
        this.jLB_SortBy = new JLabel();
        this.jCB_SortBy = new JComboBox();
        this.jCBSortOrder = new JComboBox();
        this.jSPLPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPNL_Graph = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jLB_Measure.setLabelFor(this.jCB_Measure);
        this.jLB_Measure.setText("Measure:");
        this.jCB_Measure.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLB_SortBy.setLabelFor(this.jCB_SortBy);
        this.jLB_SortBy.setText("Sort By:");
        this.jCB_SortBy.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCB_SortBy.setMinimumSize(new Dimension(53, 20));
        this.jCBSortOrder.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCBSortOrder.setMinimumSize(new Dimension(53, 20));
        this.jCBSortOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this.jCBSortOrderActionPerformed(actionEvent);
            }
        });
        this.jSPLPane.setDividerLocation(400);
        this.jSPLPane.setOrientation(0);
        this.jSPLPane.setOneTouchExpandable(true);
        this.jSPLPane.setPreferredSize(new Dimension(3, 4));
        this.jPNL_Graph.setMinimumSize(new Dimension(100, 100));
        this.jPNL_Graph.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jPNL_Graph);
        this.jSPLPane.setLeftComponent(this.jScrollPane1);
        this.jSPLPane.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSPLPane, GroupLayout.Alignment.LEADING, -1, 577, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLB_Measure, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_Measure, 0, 122, Short.MAX_VALUE).addGap(93, 93, 93).addComponent(this.jLB_SortBy, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_SortBy, 0, 92, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCBSortOrder, 0, 70, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_Measure).addComponent(this.jCBSortOrder, -1, -1, Short.MAX_VALUE).addComponent(this.jCB_SortBy, -1, -1, Short.MAX_VALUE).addComponent(this.jCB_Measure).addComponent(this.jLB_SortBy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSPLPane, -1, 493, Short.MAX_VALUE).addContainerGap()));
    }

    private void jCBSortOrderActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLB_Measure, (Component)this.jCB_Measure, (String)(TestViewerLrb.get("MEASURE") + ":"));
        this.jCB_Measure.removeAllItems();
        this._predictionConfidenceMeasureItem = new MeasureItem(CPerformanceTabState.Measure.PREDICTIVE_CONFIDENCE, TestViewerLrb.get("PREDICTIVE_CONFIDENCE"));
        if (this._showClassResults) {
            this._measureItem1 = new MeasureItem(CPerformanceTabState.Measure.AVG_ACCURACY, TestViewerLrb.get("AVG_ACCURACY"));
            this._measureItem2 = new MeasureItem(CPerformanceTabState.Measure.OVERALL_ACCURACY, TestViewerLrb.get("OVERALL_ACCURACY"));
            this._measureItem3 = new MeasureItem(CPerformanceTabState.Measure.COST, TestViewerLrb.get("COST"));
            this._columnNames = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("OVERALL_ACCURACY_COL"), TestViewerLrb.get("AVG_ACCURACY_COL"), TestViewerLrb.get("COST"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        } else {
            this._measureItem1 = new MeasureItem(CPerformanceTabState.Measure.MEAN_ABS_ERR, TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"));
            this._measureItem2 = new MeasureItem(CPerformanceTabState.Measure.ROOT_MEAN_SQRT_ERR, TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"));
            this._measureItem3 = new MeasureItem(CPerformanceTabState.Measure.MEAN_PREDICTED_VALUE, TestViewerLrb.get("MEAN_PREDICTED_VALUE"));
            this._measureItem4 = new MeasureItem(CPerformanceTabState.Measure.MEAN_ACTUAL_VALUE, TestViewerLrb.get("MEAN_ACTUAL_VALUE"));
            this._columnNames = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"), TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"), TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        }
        this._allMeasureItem = new MeasureItem(CPerformanceTabState.Measure.MULTIPLE_SELECTION, TestViewerLrb.get("MULTIPLE_SELECTION"));
        this.jCB_Measure.addItem(this._predictionConfidenceMeasureItem);
        this.jCB_Measure.addItem(this._measureItem1);
        this.jCB_Measure.addItem(this._measureItem2);
        this.jCB_Measure.addItem(this._measureItem3);
        if (!this._showClassResults) {
            this.jCB_Measure.addItem(this._measureItem4);
        }
        this.jCB_Measure.addItem(this._allMeasureItem);
        this._selectedMeasureItem = this._allMeasureItem;
        ResourceUtils.resLabel((JLabel)this.jLB_SortBy, (Component)this.jCB_SortBy, (String)(TestViewerLrb.get("SORT_BY") + ":"));
        this._selectedSortByItem = new SortByItem(CPerformanceTabState.SortBy.NAME, TestViewerLrb.get("NAME"));
        this.jCB_SortBy.removeAllItems();
        this.jCB_SortBy.addItem(this._selectedSortByItem);
        this.jCB_SortBy.addItem(new SortByItem(CPerformanceTabState.SortBy.CREATION_TIME, TestViewerLrb.get("CREATION_DATE")));
        this.jCB_SortBy.addItem(new SortByItem(CPerformanceTabState.SortBy.MEASURE, TestViewerLrb.get("MEASURE")));
        this._selectedSortOrderItem = new SortOrderItem(CPerformanceTabState.SortOrder.DESCENDING, TestViewerLrb.get("DESCENDING"));
        this.jCBSortOrder.removeAllItems();
        this.jCBSortOrder.addItem(new SortOrderItem(CPerformanceTabState.SortOrder.ASCENDING, TestViewerLrb.get("ASCENDING")));
        this.jCBSortOrder.addItem(this._selectedSortOrderItem);
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.jCB_Measure.setSelectedItem(this._selectedMeasureItem);
        this.jCB_SortBy.setSelectedItem(this._selectedSortByItem);
        this.jCBSortOrder.setSelectedItem(this._selectedSortOrderItem);
        this.jCB_Measure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedMeasureItem = (MeasureItem)PerformanceTabPanel.this.jCB_Measure.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this.jCB_SortBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedSortByItem = (SortByItem)PerformanceTabPanel.this.jCB_SortBy.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this.jCBSortOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedSortOrderItem = (SortOrderItem)PerformanceTabPanel.this.jCBSortOrder.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this.dataMinerTablePanel.setTitle(TestViewerLrb.get("MODELS"));
        this.installPerfSummaryActions();
        this.jSPLPane.setDividerLocation(0.85);
        this.jSPLPane.setResizeWeight(0.85);
        this.colorChooser = new ColorCellRenderer.ColorChooser(){

            @Override
            public Color getColorFor(Object object) {
                String string = (String)object;
                return PerformanceTabPanel.this._performanceTabState.getParentTestViewerState().getTestResultGraphColor(string);
            }
        };
        LoadUI loadUI = new LoadUI();
        this.jPNL_Graph.add(GraphPanel.LOADING_GRAPH);
        loadUI.execute();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void installPerfSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        if (this._performanceTabState.getParentTestViewerState().getAllTestResults().size() > 1) {
            this._jBT_AddOrRemove = new JButton(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
            this._jBT_AddOrRemove.setDisabledIcon(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PerformanceTabPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this._jBT_AddOrRemove);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._performanceTabState.getParentTestViewerState(), this._performanceTabState.getParentTestViewerState().getContext(), this._performanceTabState.getParentTestViewerState().getParentActivity(), this._performanceTabState.getParentTestViewerState().getAllTestResults(), this._performanceTabState.getParentTestViewerState().getTestResults())) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._performanceTabState.getParentTestViewerState().setTestResults(list);
            LoadUI loadUI = new LoadUI();
            loadUI.execute();
        }
    }

    public void reload() {
        PerformanceEditor performanceEditor = (PerformanceEditor)this.getEditor();
        this._performanceTabState = new CPerformanceTabState((SharedTestEditorState)performanceEditor.getCachedLegendState());
        this._context = performanceEditor.getContext();
        if (this._performanceTabState != null && this._performanceTabState.getParentTestViewerState().getTestResults().size() > 0 && this._performanceTabState.getParentTestViewerState().getTestResults().get(0) instanceof RegressTestResult) {
            this._showClassResults = false;
        }
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void reloadGraphPanel() {
        CPerformanceTabState cPerformanceTabState = this._performanceTabState;
        cPerformanceTabState.getClass();
        CPerformanceTabState.PerformanceTable performanceTable = cPerformanceTabState.new CPerformanceTabState.PerformanceTable(this._columnNames, this._performanceTabState.getParentTestViewerState().getPerformanceMetrics());
        this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)performanceTable));
        this.setTableRenderers();
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(145);
        tableColumnModel.getColumn(1).setPreferredWidth(135);
        tableColumnModel.getColumn(2).setPreferredWidth(145);
        tableColumnModel.getColumn(3).setPreferredWidth(135);
        tableColumnModel.getColumn(4).setPreferredWidth(135);
        tableColumnModel.getColumn(5).setPreferredWidth(135);
        if (tableColumnModel.getColumnCount() > 6) {
            tableColumnModel.getColumn(6).setPreferredWidth(135);
        }
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        if (!this._performanceTabState.hasCost()) {
            this.jCB_Measure.removeItem(this._measureItem3);
        }
        if (CPerformanceTabState.Measure.MULTIPLE_SELECTION.equals((Object)this._selectedMeasureItem._measure)) {
            if (!this._performanceTabState.hasCost()) {
                this.dataMinerTablePanel.getTable().setHiddenColumns(new int[]{4});
            } else {
                this.dataMinerTablePanel.getTable().setHiddenColumns(new int[0]);
            }
            CPerformanceTabState.Measure[] measureArray = null;
            String[] stringArray = null;
            if (!this._performanceTabState.hasCost()) {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem._measure, this._measureItem1._measure, this._measureItem2._measure};
                stringArray = new String[]{this._predictionConfidenceMeasureItem._displayName, this._measureItem1._displayName, this._measureItem2._displayName};
            } else if (!this._showClassResults) {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem._measure, this._measureItem1._measure, this._measureItem2._measure, this._measureItem3._measure, this._measureItem4._measure};
                stringArray = new String[]{this._predictionConfidenceMeasureItem._displayName, this._measureItem1._displayName, this._measureItem2._displayName, this._measureItem3._displayName, this._measureItem4._displayName};
            } else {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem._measure, this._measureItem1._measure, this._measureItem2._measure, this._measureItem3._measure};
                stringArray = new String[]{this._predictionConfidenceMeasureItem._displayName, this._measureItem1._displayName, this._measureItem2._displayName, this._measureItem3._displayName};
            }
            GraphPanel[] graphPanelArray = new GraphPanel[measureArray.length];
            GraphDataModel[] graphDataModelArray = new GraphDataModel[measureArray.length];
            this.jPNL_Graph.removeAll();
            this.jPNL_Graph.setLayout(new GridLayout(3, 2));
            for (int i = 0; i < measureArray.length; ++i) {
                graphDataModelArray[i] = this._performanceTabState.sortedGraphDataModel(measureArray[i], this._selectedSortByItem._sortBy, this._selectedSortOrderItem._sortOrder, new Object[]{stringArray[i]});
                graphPanelArray[i] = new GraphPanel(graphDataModelArray[i]);
                graphPanelArray[i].initGraph();
                this.jPNL_Graph.add(graphPanelArray[i]);
            }
            this.jPNL_Graph.updateUI();
        } else {
            GraphDataModel graphDataModel;
            if (!(this.jPNL_Graph.getLayout() instanceof BorderLayout)) {
                this.jPNL_Graph.removeAll();
                this.jPNL_Graph.setLayout(new BorderLayout());
                if (this._graphPanel == null) {
                    graphDataModel = this._performanceTabState.sortedGraphDataModel(this._selectedMeasureItem._measure, this._selectedSortByItem._sortBy, this._selectedSortOrderItem._sortOrder, new Object[]{this._selectedMeasureItem._displayName});
                    this._graphPanel = new GraphPanel(graphDataModel);
                    this._graphPanel.initGraph();
                }
                this.jPNL_Graph.add((Component)this._graphPanel, "Center");
            }
            graphDataModel = this._performanceTabState.sortedGraphDataModel(this._selectedMeasureItem._measure, this._selectedSortByItem._sortBy, this._selectedSortOrderItem._sortOrder, new Object[]{this._selectedMeasureItem._displayName});
            this.columnHiding(this._selectedMeasureItem);
            this._graphPanel.initGraph(graphDataModel);
            this.jPNL_Graph.updateUI();
        }
    }

    private void columnHiding(MeasureItem measureItem) {
        try {
            if (CPerformanceTabState.Measure.PREDICTIVE_CONFIDENCE.equals((Object)measureItem._measure)) {
                int n = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.OVERALL_ACCURACY.equals((Object)measureItem._measure)) {
                int n = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("OVERALL_ACCURACY_COL"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.MEAN_ABS_ERR.equals((Object)measureItem._measure)) {
                int n = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.AVG_ACCURACY.equals((Object)measureItem._measure)) {
                int n = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("AVG_ACCURACY_COL"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.ROOT_MEAN_SQRT_ERR.equals((Object)measureItem._measure)) {
                int n = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.COST.equals((Object)measureItem._measure)) {
                int n = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("COST"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.MEAN_PREDICTED_VALUE.equals((Object)measureItem._measure)) {
                int n = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("MEAN_PREDICTED_VALUE"));
                this.hideColumns(n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            theLogger.log(Level.SEVERE, illegalArgumentException.getLocalizedMessage());
        }
    }

    private void hideColumns(int n) {
        int n2 = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("ALGORITHM"));
        int n3 = this.dataMinerTablePanel.getTable().getColumnModel().getColumnIndex(TestViewerLrb.get("CREATION_DATE"));
        int[] nArray = new int[this.dataMinerTablePanel.getTable().getColumnCount() - 3];
        int n4 = 0;
        for (int i = 0; i < this.dataMinerTablePanel.getTable().getColumnCount(); ++i) {
            if (i == n || i == n2 || i == n3) continue;
            nArray[n4++] = i + 1;
        }
        this.dataMinerTablePanel.getTable().setHiddenColumns(nArray);
    }

    public void setLegendState(LegendEvent legendEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
        this.repaint();
    }

    public void setTableRenderers() {
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
        for (String string : this._columnNames) {
            int n = tableColumnModel.getColumnIndex(string);
            if (string.equals(TestViewerLrb.get("NAME"))) {
                ColorCellRenderer colorCellRenderer = new ColorCellRenderer(this.colorChooser);
                tableColumnModel.getColumn(n).setCellRenderer(colorCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("CREATION_DATE"))) {
                tableColumnModel.getColumn(n).setCellRenderer(new DateCellRenderer2());
                continue;
            }
            if (string.equals(TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"))) {
                tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY_COL"))) {
                tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("AVG_ACCURACY_COL"))) {
                tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("COST"))) {
                tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("MEAN_PREDICTED_VALUE"))) {
                tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("MEAN_ACTUAL_VALUE"))) {
                tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"))) {
                tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
                continue;
            }
            if (!string.equals(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"))) continue;
            tableColumnModel.getColumn(n).setCellRenderer(numberCellRenderer);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(PerformanceTabPanel.this._context);
                PerformanceTabPanel.this._performanceTabState.load(PerformanceTabPanel.this._columnNames, connection);
                this._success = true;
            }
            catch (Exception exception) {
                try {
                    this._ex = exception;
                    this._success = false;
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
            }
            SQLHelper.close(connection);
            return PerformanceTabPanel.this._performanceTabState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    PerformanceTabPanel.this.reloadGraphPanel();
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                PerformanceTabPanel.this.setLoading(false);
                if (PerformanceTabPanel.this.overLayPanel != null) {
                    PerformanceTabPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private class SortOrderItem {
        CPerformanceTabState.SortOrder _sortOrder;
        String _displayName;

        public SortOrderItem(CPerformanceTabState.SortOrder sortOrder, String string) {
            this._sortOrder = sortOrder;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof SortOrderItem) {
                return this._sortOrder.equals((Object)((SortOrderItem)object)._sortOrder);
            }
            return false;
        }

        public int hashCode() {
            int n = 3;
            n = 83 * n + (this._sortOrder != null ? this._sortOrder.hashCode() : 0);
            return n;
        }
    }

    private class SortByItem {
        CPerformanceTabState.SortBy _sortBy;
        String _displayName;

        public SortByItem(CPerformanceTabState.SortBy sortBy, String string) {
            this._sortBy = sortBy;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof SortByItem) {
                return this._sortBy.equals((Object)((SortByItem)object)._sortBy);
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this._sortBy != null ? this._sortBy.hashCode() : 0);
            return n;
        }
    }

    private class MeasureItem {
        CPerformanceTabState.Measure _measure;
        String _displayName;

        public MeasureItem(CPerformanceTabState.Measure measure, String string) {
            this._measure = measure;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof MeasureItem) {
                return this._measure.equals((Object)((MeasureItem)object)._measure);
            }
            return false;
        }
    }
}

