/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitDetailPanel;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Assert;
import oracle.javatools.icons.OracleIcons;

public class ProfitDetailDialog {
    private static final Logger theLogger = Logger.getLogger(ProfitDetailDialog.class.getName());
    private static final String _WIZARD_NAME = TestViewerLrb.get("PROFIT_DETAIL_DIALOG");
    private static final String _DIALOG_TITLE = TestViewerLrb.get("PROFIT_DETAIL_DIALOG");
    protected JEWTDialog _dlg;
    private List<ProfitTabState.ProfitData> _data;
    private ProfitTabState _state;
    private String _testResult;

    public ProfitDetailDialog(String string, ProfitTabState profitTabState, List<ProfitTabState.ProfitData> list) {
        this._testResult = string;
        this._state = profitTabState;
        this._data = list;
    }

    protected JEWTDialog buildDialog() {
        ProfitDetailPanel profitDetailPanel = this.buildPanel();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 5;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, _WIZARD_NAME, n);
        jEWTDialog.setContent((Component)profitDetailPanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        DialogHeader dialogHeader = new DialogHeader();
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        return _DIALOG_TITLE + this._testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke() {
        boolean bl = false;
        if (this._data != null) {
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                this._dlg = jEWTDialog;
                if (jEWTDialog == null) return bl;
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                return bl;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                return bl;
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        } else {
            Assert.println((String)("Failed to create a valid BaliWizardState for wizard " + this));
        }
        return bl;
    }

    protected void cancel() {
    }

    protected ProfitDetailPanel buildPanel() {
        return new ProfitDetailPanel(this._state, this._data);
    }

    protected Image getHeaderImage() {
        return (Image)((Object)OracleIcons.getIcon((String)"warning.png"));
    }
}

