/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitDetailDialog;
import oracle.dmt.dataminer.tviewer.profit.ProfitEditor;
import oracle.dmt.dataminer.tviewer.profit.ProfitInputDialog;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class ProfitPanel
extends DataMinerViewGUI
implements GraphDataDisplay {
    private static final String UPDATE_ALL = "UPDATE_ALL";
    private static final String UPDATE_GRAPH = "UPDATE_GRAPH";
    private static final String UPDATE_THRESHOLD = "UPDATE_THRESHOLD";
    private GraphPanel _graphPanel;
    private ProfitTabState _state;
    private boolean _loading = true;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;
    private JPanel jGraphControl;
    private JPanel jGraphPanel;
    private JPanel jPanel;
    private JSlider jQuantileSlider;
    private JButton jSettingsBtn;
    private JSplitPane jSplitPane;
    private JComboBox jTargetComb;
    private JLabel jTargetLbl;
    private JButton jDetailBtn;
    private JButton _jBT_AddOrRemove;

    public ProfitPanel(ProfitEditor profitEditor, Context context) {
        super(profitEditor, context);
        this._state = new ProfitTabState((SharedTestEditorState)profitEditor.getCachedLegendState(), context);
        this.initComponents();
        this.initGraph();
        this.initRes();
        this.initUI();
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel(this, new DefaultGraphDataModel(null, null, null, null, null));
        this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.jGraphPanel.updateUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, (Component)this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jSettingsBtn, (String)TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PROFIT_SETTINGS_BTN_ADA"));
    }

    @Override
    public void initUI() {
        this._loading = true;
        this.dataMinerTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = ProfitPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    String string = (String)ProfitPanel.this._state.getProfitTableModel().getValueAt(nArray[0], 0);
                    ProfitDetailDialog profitDetailDialog = new ProfitDetailDialog(string, ProfitPanel.this._state, ProfitPanel.this._state.getProfitData().get(string));
                    profitDetailDialog.invoke();
                }
            }
        });
        this.dataMinerTablePanel.setTitle(TestViewerLrb.get("MODELS"));
        this.installProfitResultsActions();
        this.initializeControls();
        this.jSplitPane.setDividerLocation(0.75);
        this.jSplitPane.setResizeWeight(0.75);
        LoadUI loadUI = new LoadUI(UPDATE_ALL);
        loadUI.execute();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public void reload() {
        ProfitEditor profitEditor = (ProfitEditor)this.getEditor();
        this._state = new ProfitTabState((SharedTestEditorState)profitEditor.getCachedLegendState(), this.getContext());
        this._context = profitEditor.getContext();
        LoadUI loadUI = new LoadUI(UPDATE_ALL);
        loadUI.execute();
    }

    private void enableControls(boolean bl) {
        this.jTargetComb.setEnabled(bl);
        this.jSettingsBtn.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0);
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingProfitTableModel()));
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("LOADING_SHORTENED")}));
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProfitPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], 0);
            this._state.setSelectedTestResult(string);
            this.enableControls(true);
            this.fireViewPropertySelectionChange(this, string);
        }
    }

    public ProfitTabState.ProfitData getProfitData() {
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], 0);
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getSelectedQuantileValue();
        ProfitTabState.ProfitData profitData = this._state.getProfitData().get(string).get(n);
        profitData.setLabel(string);
        return profitData;
    }

    private void initComponents() {
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSettingsBtn = new JButton();
        this.jSplitPane = new JSplitPane();
        this.jPanel = new JPanel();
        this.jGraphPanel = new JPanel();
        this.jGraphControl = new JPanel();
        this.jQuantileSlider = new JSlider();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jTargetLbl.setText("Target Value:");
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jSettingsBtn.setText("Settings...");
        this.jSettingsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitPanel.this.jSettingsBtnActionPerformed(actionEvent);
            }
        });
        this.jSplitPane.setDividerLocation(390);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setLastDividerLocation(-1);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphControl.setLayout(new GridBagLayout());
        this.jQuantileSlider.setName("jQuantileSlider");
        this.jQuantileSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProfitPanel.this.jQuantileSliderStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        this.jGraphControl.add((Component)this.jQuantileSlider, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGraphControl, -1, 652, Short.MAX_VALUE).addComponent(this.jGraphPanel, -1, 652, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jGraphPanel, -1, 360, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphControl, -2, -1, -2)));
        this.jSplitPane.setTopComponent(this.jPanel);
        this.jSplitPane.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, 0, -1, Short.MAX_VALUE).addGap(192, 192, 192).addComponent(this.jSettingsBtn, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jSettingsBtn).addComponent(this.jTargetComb, -2, -1, -2)).addGap(14, 14, 14).addComponent(this.jSplitPane, -1, 491, Short.MAX_VALUE).addContainerGap()));
    }

    private void jSettingsBtnActionPerformed(ActionEvent actionEvent) {
        ProfitInputDialog profitInputDialog = new ProfitInputDialog(this._state);
        if (profitInputDialog.invoke()) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            this._loading = true;
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
            loadUI.execute();
        }
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingProfitTableModel()));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
        loadUI.execute();
    }

    private void jQuantileSliderStateChanged(ChangeEvent changeEvent) {
        if (this._loading) {
            return;
        }
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            return;
        }
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        BoundedRangeModel boundedRangeModel = this.jQuantileSlider.getModel();
        Integer n = boundedRangeModel.getValue();
        n = Math.max(1, n);
        this._state.setSelectedQuantileValue(n);
        this._loading = true;
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_THRESHOLD);
        loadUI.execute();
    }

    private void installProfitResultsActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("PROFIT_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitPanel.this.jDetailBtnActionPerformed(actionEvent);
            }
        });
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            this._jBT_AddOrRemove = new JButton(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
            this._jBT_AddOrRemove.setDisabledIcon(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfitPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn, this._jBT_AddOrRemove);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._state.getParentTestViewerState(), this._state.getParentTestViewerState().getContext(), this._state.getParentTestViewerState().getParentActivity(), this._state.getParentTestViewerState().getAllTestResults(), this._state.getParentTestViewerState().getTestResults())) {
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            this._state.getParentTestViewerState().setTestResults(list);
            this.jGraphPanel.removeAll();
            this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
            this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingProfitTableModel()));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(UPDATE_ALL);
            loadUI.execute();
        }
    }

    private void jDetailBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], 0);
        ProfitDetailDialog profitDetailDialog = new ProfitDetailDialog(string, this._state, this._state.getProfitData().get(string));
        profitDetailDialog.invoke();
    }

    public void setCachedPropertyState(Object object) {
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    @Override
    public void showData(Object object) {
        this.jDetailBtnActionPerformed(null);
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        String _updatemode;

        public LoadUI(String string) {
            this._updatemode = string;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._updatemode.equals(ProfitPanel.UPDATE_THRESHOLD)) {
                    ProfitPanel.this._state.refreshCustomThresholdData();
                    ProfitPanel.this._graphPanel.refreshGraph();
                } else if (this._updatemode.equals(ProfitPanel.UPDATE_GRAPH)) {
                    ProfitPanel.this.jGraphPanel.removeAll();
                    ProfitPanel.this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
                    ProfitPanel.this._state.refreshProfitData();
                    ProfitPanel.this._graphPanel.initGraph(ProfitPanel.this._state.getProfitGraphModel());
                } else {
                    ProfitPanel.this.jGraphPanel.removeAll();
                    ProfitPanel.this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
                    ProfitPanel.this._state.load();
                    ProfitPanel.this._graphPanel.initGraph(ProfitPanel.this._state.getProfitGraphModel());
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ProfitPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    Object object;
                    ProfitPanel.this.jGraphPanel.removeAll();
                    ProfitPanel.this.jGraphPanel.add((Component)ProfitPanel.this._graphPanel, "Center");
                    ProfitPanel.this.jGraphPanel.updateUI();
                    String string = ProfitPanel.this._state.getSelectedTestResult();
                    ProfitPanel.this.dataMinerTablePanel.getTable().setFixedColumns(n, 165);
                    ProfitPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)ProfitPanel.this._state.getProfitTableModel()));
                    ProfitPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
                    ProfitPanel.this.dataMinerTablePanel.getTable().setSorted(true);
                    TableColumnModel tableColumnModel = ProfitPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

                        @Override
                        public Color getColorFor(Object object) {
                            String string = (String)object;
                            return ProfitPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
                        }
                    });
                    tableColumnModel.getColumn(0).setCellRenderer(colorCellRenderer);
                    tableColumnModel.getColumn(1).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(2).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(3).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(4).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(5).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(6).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(8).setCellRenderer(new DateCellRenderer2());
                    tableColumnModel.getColumn(1).setPreferredWidth(60);
                    tableColumnModel.getColumn(2).setPreferredWidth(60);
                    tableColumnModel.getColumn(3).setPreferredWidth(140);
                    tableColumnModel.getColumn(4).setPreferredWidth(160);
                    tableColumnModel.getColumn(5).setPreferredWidth(80);
                    tableColumnModel.getColumn(6).setPreferredWidth(150);
                    tableColumnModel.getColumn(7).setPreferredWidth(135);
                    tableColumnModel.getColumn(8).setPreferredWidth(135);
                    int n2 = 0;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < ProfitPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            d = (Double)ProfitPanel.this._state.getProfitTableModel().getValueAt(i, 5);
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n2 = i;
                        }
                    } else {
                        for (int i = 0; i < ProfitPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            object = ProfitPanel.this._state.getProfitTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n2 = i;
                        }
                    }
                    ProfitPanel.this.dataMinerTablePanel.getTable().setRowSelectionInterval(n2, n2);
                    if (this._updatemode.equals(ProfitPanel.UPDATE_ALL)) {
                        ProfitPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ProfitPanel.this._state.getTargetValues()));
                        ProfitPanel.this.jTargetComb.setSelectedItem(ProfitPanel.this._state.getSelectedTargetValue());
                        Integer n3 = ProfitPanel.this._state.getSelectedQuantileValue();
                        object = 0;
                        Integer n4 = ProfitPanel.this._state.getMaxQuantileCnt() - 1;
                        ProfitPanel.this.jQuantileSlider.setMajorTickSpacing(10);
                        ProfitPanel.this.jQuantileSlider.setMinorTickSpacing(1);
                        ProfitPanel.this.jQuantileSlider.setPaintTicks(true);
                        ProfitPanel.this.jQuantileSlider.setPaintLabels(true);
                        ProfitPanel.this.jQuantileSlider.setSnapToTicks(true);
                        ProfitPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel(n3, 0, (Integer)object, n4));
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), null);
                }
                ProfitPanel.this.enableControls(true);
                ProfitPanel.this.getEditor().updateSelection();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ProfitPanel.this._loading = false;
                if (ProfitPanel.this.overLayPanel != null) {
                    ProfitPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

