/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.residual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.charts.axischart.AxisChartInteractive;
import oracle.charts.types.AxisTitleDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.MarkerDesc;
import oracle.charts.types.NumAxisDesc;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel2;
import oracle.dmt.dataminer.controls.GraphPopupClickListener;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.residual.ResidualEditor;
import oracle.dmt.dataminer.tviewer.residual.ResidualTabState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.table.GenericTable;

public class ResidualTabPanel
extends DataMinerViewGUI
implements GraphDataDisplay {
    private static final Logger theLogger = Logger.getLogger(ResidualTabPanel.class.getName());
    private GraphPanel _graphPanel1;
    private GraphPanel _graphPanel2;
    private ResidualTabState _state;
    private boolean _loading = true;
    private Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
    private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private static final int REFRESH_ALL = 0;
    private static final int REFRESH_RESULTS = 1;
    private static final int REFRESH_RESULT1 = 2;
    private static final int REFRESH_RESULT2 = 3;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;
    private JComboBox jCompareModelComboBox;
    private JLabel jCompareToLabel;
    private JPanel jModelPanel1;
    private JPanel jModelPanel2;
    private JButton jQueryButton;
    private ComponentWithTitlebar<JComponent> jResidualComponentWithTitlebar1;
    private ComponentWithTitlebar<JComponent> jResidualComponentWithTitlebar2;
    private TransparentPanel jResidualTransparentPanel1;
    private TransparentPanel jResidualTransparentPanel2;
    private JLabel jSampleLabel;
    private JSpinner jSampleSpinner;
    private JComboBox jShowModelComboBox;
    private JLabel jShowModelLabel;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JComboBox jXAxisComboBox;
    private JLabel jXAxisLabel;
    private JComboBox jYAxisComboBox;
    private JLabel jYAxisLabel;
    private JPanel jGraphPanel1;
    private JPanel jGraphPanel2;
    private GenericTable jPlotTable1;
    private GenericTable jPlotTable2;
    private JScrollPane jResultScroller1;
    private JScrollPane jResultScroller2;
    private static Icon _plotBtnIconEna;
    private static Icon _plotBtnIconDis;
    private JButton jPlotBtn1;
    private JButton jPlotBtn2;
    private JButton jGraphBtn1;
    private JButton jGraphBtn2;
    private JButton jAddRemoveBtn;

    public ResidualTabPanel(ResidualEditor residualEditor, Context context) {
        super(residualEditor, context);
        this._state = new ResidualTabState((SharedTestEditorState)residualEditor.getCachedLegendState(), context);
        this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jYAxisLabel, (Component)this.jYAxisComboBox, (String)TestViewerLrb.get("RESIDUAL_Y_AXIS"));
        this.jYAxisLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("RESIDUAL_Y_AXIS"));
        this.jYAxisLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("RESIDUAL_Y_AXIS_ADA"));
        ResourceUtils.resLabel((JLabel)this.jXAxisLabel, (Component)this.jXAxisComboBox, (String)TestViewerLrb.get("RESIDUAL_X_AXIS"));
        this.jXAxisLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("RESIDUAL_X_AXIS"));
        this.jXAxisLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("RESIDUAL_X_AXIS_ADA"));
        ResourceUtils.resLabel((JLabel)this.jSampleLabel, (Component)this.jSampleSpinner, (String)TestViewerLrb.get("RESIDUAL_SAMPLE_SIZE"));
        this.jSampleLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("RESIDUAL_SAMPLE_SIZE"));
        this.jSampleLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("RESIDUAL_SAMPLE_SIZE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jQueryButton, (String)TestViewerLrb.get("RESIDUAL_QUERY_BTN"));
        this.jQueryButton.getAccessibleContext().setAccessibleName(TestViewerLrb.get("RESIDUAL_QUERY_BTN"));
        this.jQueryButton.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("RESIDUAL_QUERY_BTN_ADA"));
        ResourceUtils.resLabel((JLabel)this.jShowModelLabel, (Component)this.jShowModelComboBox, (String)TestViewerLrb.get("RESIDUAL_RESULT_SHOW"));
        this.jShowModelLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("RESIDUAL_RESULT_SHOW"));
        this.jShowModelLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("RESIDUAL_RESULT_SHOW_ADA"));
        ResourceUtils.resLabel((JLabel)this.jCompareToLabel, (Component)this.jCompareModelComboBox, (String)TestViewerLrb.get("RESIDUAL_RESULT_COMPARE"));
        this.jCompareToLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("RESIDUAL_RESULT_COMPARE"));
        this.jCompareToLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("RESIDUAL_RESULT_COMPARE_ADA"));
        this.dataMinerTablePanel.setTitle(TestViewerLrb.get("RESIDUAL_RESULT_SUMMARY_TABLE"));
    }

    @Override
    public void initUI() {
        this._loading = true;
        this.jQueryButton.setIcon(DataMinerIcons.get(Icons.QUERY));
        _plotBtnIconEna = OracleIcons.getIcon((String)"lov.png");
        _plotBtnIconDis = OracleIcons.getIcon((String)"lov.png");
        this.installSummaryActions();
        this.jSplitPane1.setTopComponent(this.jModelPanel1);
        this.jGraphPanel1 = new JPanel();
        this.jGraphPanel1.setLayout(new BorderLayout());
        this._graphPanel1 = new GraphPanel(this, new DefaultGraphDataModel(null, null, null, null, null), "_graphPanel1");
        this.jPlotTable1 = new DataMinerTable();
        this.jResultScroller1 = this._state.isShowChartForResult1() ? new JScrollPane(this.jGraphPanel1) : new JScrollPane((Component)this.jPlotTable1);
        this.jResidualComponentWithTitlebar1.setComponent((JComponent)this.jResultScroller1);
        ControlBar controlBar = new ControlBar();
        this.installGraphActions1(controlBar);
        this.jResidualComponentWithTitlebar1.setControlBar(controlBar);
        this.jGraphPanel2 = new JPanel();
        this.jGraphPanel2.setLayout(new BorderLayout());
        this._graphPanel2 = new GraphPanel(this, new DefaultGraphDataModel(null, null, null, null, null), "_graphPanel2");
        this.jPlotTable2 = new DataMinerTable();
        this.jResultScroller2 = this._state.isShowChartForResult2() ? new JScrollPane(this.jGraphPanel2) : new JScrollPane((Component)this.jPlotTable2);
        this.jResidualComponentWithTitlebar2.setComponent((JComponent)this.jResultScroller2);
        controlBar = new ControlBar();
        this.installGraphActions2(controlBar);
        this.jResidualComponentWithTitlebar2.setControlBar(controlBar);
        this.initializeControls();
        this.jSplitPane1.setDividerLocation(0.75);
        this.jSplitPane1.setResizeWeight(0.75);
        this.enableControls(false);
        this.prepareLoad(0);
        LoadUI loadUI = new LoadUI(0);
        loadUI.execute();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public void reload() {
        this.enableControls(false);
        this.prepareLoad(0);
        LoadUI loadUI = new LoadUI(0);
        loadUI.execute();
    }

    @Override
    public void showData(Object object) {
        if ("_graphPanel1".equals(((GraphPanel)((AxisChartInteractive)object).getParent()).id)) {
            this.viewData1(null);
        } else {
            this.viewData2(null);
        }
    }

    private void prepareLoad(int n) {
        if (n == 0) {
            this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)new ResidualTabState.ResidualSummaryModel(new ResidualTabState(this._state.getParentTestViewerState(), this.getContext()))));
        }
        if (n == 0 || n == 1 || n == 2) {
            if (this._state.isShowChartForResult1()) {
                this.jGraphPanel1.removeAll();
                this.jGraphPanel1.add((Component)new JTextArea(TestViewerLrb.get("LOADING")), "Center");
            } else {
                this.jPlotTable1.setModel((TableModel)((Object)new ResidualTabState.ResidualPlotModel(new ResidualTabState(this._state.getParentTestViewerState(), this.getContext()))));
            }
        }
        if (n == 0 || n == 1 || n == 3) {
            if (this._state.isShowChartForResult2()) {
                this.jGraphPanel2.removeAll();
                this.jGraphPanel2.add((Component)new JTextArea(TestViewerLrb.get("LOADING")), "Center");
            } else {
                this.jPlotTable2.setModel((TableModel)((Object)new ResidualTabState.ResidualPlotModel(new ResidualTabState(this._state.getParentTestViewerState(), this.getContext()))));
            }
        }
    }

    private void installGraphActions1(ControlBar controlBar) {
        this.jGraphBtn1 = new JButton(DataMinerIcons.get(Icons.CHART));
        this.jGraphBtn1.setToolTipText(TestViewerLrb.get("RESIDUAL_GRAPH_VIEW"));
        this.jGraphBtn1.setDisabledIcon(DataMinerIcons.get(Icons.CHART));
        this.jGraphBtn1.setEnabled(true);
        this.jGraphBtn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResidualTabPanel.this.viewGraph1(actionEvent);
            }
        });
        controlBar.add((Component)this.jGraphBtn1);
        this.jPlotBtn1 = new JButton(_plotBtnIconEna);
        this.jPlotBtn1.setToolTipText(TestViewerLrb.get("RESIDUAL_DATA_VIEW"));
        this.jPlotBtn1.setDisabledIcon(_plotBtnIconDis);
        this.jPlotBtn1.setEnabled(true);
        this.jPlotBtn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResidualTabPanel.this.viewData1(actionEvent);
            }
        });
        controlBar.add((Component)this.jPlotBtn1);
    }

    private void viewGraph1(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.jGraphBtn1.setSelected(true);
        this.jPlotBtn1.setSelected(false);
        this._state.setShowChartForResult1(true);
        this.enableControls(false);
        this.prepareLoad(2);
        LoadUI loadUI = new LoadUI(2);
        loadUI.execute();
    }

    private void viewData1(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.jPlotBtn1.setSelected(true);
        this.jGraphBtn1.setSelected(false);
        this._state.setShowChartForResult1(false);
        this.enableControls(false);
        this.prepareLoad(2);
        LoadUI loadUI = new LoadUI(2);
        loadUI.execute();
    }

    private void installGraphActions2(ControlBar controlBar) {
        this.jGraphBtn2 = new JButton(DataMinerIcons.get(Icons.CHART));
        this.jGraphBtn2.setToolTipText(TestViewerLrb.get("RESIDUAL_GRAPH_VIEW"));
        this.jGraphBtn2.setDisabledIcon(DataMinerIcons.get(Icons.CHART));
        this.jGraphBtn2.setEnabled(true);
        this.jGraphBtn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResidualTabPanel.this.viewGraph2(actionEvent);
            }
        });
        controlBar.add((Component)this.jGraphBtn2);
        this.jPlotBtn2 = new JButton(_plotBtnIconEna);
        this.jPlotBtn2.setToolTipText(TestViewerLrb.get("RESIDUAL_DATA_VIEW"));
        this.jPlotBtn2.setDisabledIcon(_plotBtnIconDis);
        this.jPlotBtn2.setEnabled(true);
        this.jPlotBtn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResidualTabPanel.this.viewData2(actionEvent);
            }
        });
        controlBar.add((Component)this.jPlotBtn2);
    }

    private void viewGraph2(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.jGraphBtn2.setSelected(true);
        this.jPlotBtn2.setSelected(false);
        this._state.setShowChartForResult2(true);
        this.enableControls(false);
        this.prepareLoad(3);
        LoadUI loadUI = new LoadUI(3);
        loadUI.execute();
    }

    private void viewData2(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.jPlotBtn2.setSelected(true);
        this.jGraphBtn2.setSelected(false);
        this._state.setShowChartForResult2(false);
        this.enableControls(false);
        this.prepareLoad(3);
        LoadUI loadUI = new LoadUI(3);
        loadUI.execute();
    }

    private void installSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jAddRemoveBtn = new JButton(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
        this.jAddRemoveBtn.setDisabledIcon(DataMinerIcons.get(Icons.ADD_REMOVE_BTN));
        this.jAddRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResidualTabPanel.this.compare_AddOrRemove_actionPerformed(actionEvent);
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(this.jAddRemoveBtn);
    }

    private void compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._state.getParentTestViewerState(), this._state.getParentTestViewerState().getContext(), this._state.getParentTestViewerState().getParentActivity(), this._state.getParentTestViewerState().getAllTestResults(), this._state.getParentTestViewerState().getTestResults())) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._state.getParentTestViewerState().setTestResults(list);
            this.enableControls(false);
            this.prepareLoad(0);
            LoadUI loadUI = new LoadUI(0);
            loadUI.execute();
        }
    }

    private void enableControls(boolean bl) {
        this.jYAxisComboBox.setEnabled(bl);
        this.jXAxisComboBox.setEnabled(bl);
        this.jQueryButton.setEnabled(bl);
        this.jSampleSpinner.setEnabled(bl);
        this.jShowModelComboBox.setEnabled(bl);
        this.jCompareModelComboBox.setEnabled(bl);
    }

    private void initializeControls() {
        if (this._state.isCaseIdSelectionEnabled()) {
            this.jXAxisComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this._state.getCaseAttr(), TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"), TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"), TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE")}));
            this.jYAxisComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this._state.getCaseAttr(), TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"), TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"), TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE")}));
        } else {
            this.jXAxisComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"), TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"), TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE")}));
            this.jYAxisComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"), TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"), TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE")}));
        }
        if (this._state.getSelectedPlotXValue().equals("PLOT_CASEID")) {
            this.jXAxisComboBox.setSelectedItem(this._state.getCaseAttr());
        } else if (this._state.getSelectedPlotXValue().equals("PLOT_PREDICTION")) {
            this.jXAxisComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"));
        } else if (this._state.getSelectedPlotXValue().equals("PLOT_TARGET")) {
            this.jXAxisComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"));
        } else if (this._state.getSelectedPlotXValue().equals("PLOT_RESIDUAL")) {
            this.jXAxisComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE"));
        }
        if (this._state.getSelectedPlotYValue().equals("PLOT_CASEID")) {
            this.jYAxisComboBox.setSelectedItem(this._state.getCaseAttr());
        } else if (this._state.getSelectedPlotYValue().equals("PLOT_PREDICTION")) {
            this.jYAxisComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"));
        } else if (this._state.getSelectedPlotYValue().equals("PLOT_TARGET")) {
            this.jYAxisComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"));
        } else if (this._state.getSelectedPlotYValue().equals("PLOT_RESIDUAL")) {
            this.jYAxisComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE"));
        }
        Integer n = this._state.getSampleSize();
        Integer n2 = 1;
        Comparable<?> comparable = null;
        Integer n3 = 1000;
        this.jSampleSpinner.setModel(new SpinnerNumberModel(n, n2, comparable, n3));
        this.jShowModelComboBox.setModel(new DefaultComboBoxModel<String>(this._state.getRegressTestResults()));
        this.jShowModelComboBox.setSelectedItem(this._state.getSelectedTestResult1());
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this._state.getRegressTestResults());
        defaultComboBoxModel.insertElementAt(TestViewerLrb.get("RESIDUAL_RESULT_NONE"), 0);
        this.jCompareModelComboBox.setModel(defaultComboBoxModel);
        String string = this._state.getSelectedTestResult2();
        if (string == null) {
            this.jCompareModelComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_RESULT_NONE"));
        } else {
            this.jCompareModelComboBox.setSelectedItem(string);
        }
        this.jGraphBtn1.setSelected(this._state.isShowChartForResult1());
        this.jPlotBtn1.setSelected(!this._state.isShowChartForResult1());
        this.jGraphBtn2.setSelected(this._state.isShowChartForResult2());
        this.jPlotBtn2.setSelected(!this._state.isShowChartForResult2());
    }

    private void initComponents() {
        this.jYAxisLabel = new JLabel();
        this.jYAxisComboBox = new JComboBox();
        this.jXAxisLabel = new JLabel();
        this.jXAxisComboBox = new JComboBox();
        this.jSampleLabel = new JLabel();
        this.jSampleSpinner = new JSpinner();
        this.jQueryButton = new JButton();
        this.jShowModelComboBox = new JComboBox();
        this.jCompareModelComboBox = new JComboBox();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jModelPanel1 = new JPanel();
        this.jResidualTransparentPanel1 = new TransparentPanel();
        this.jResidualComponentWithTitlebar1 = new ComponentWithTitlebar();
        this.jModelPanel2 = new JPanel();
        this.jResidualTransparentPanel2 = new TransparentPanel();
        this.jResidualComponentWithTitlebar2 = new ComponentWithTitlebar();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jShowModelLabel = new JLabel();
        this.jCompareToLabel = new JLabel();
        this.setPreferredSize(new Dimension(800, 564));
        this.jYAxisLabel.setText("Y-axis:");
        this.jYAxisLabel.setToolTipText("Y-axis");
        this.jYAxisLabel.setName("jYAxisLabel");
        this.jYAxisComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Residual"}));
        this.jYAxisComboBox.setName("jYAxisComboBox");
        this.jXAxisLabel.setText("X-axis:");
        this.jXAxisLabel.setToolTipText("Y-axis");
        this.jXAxisLabel.setName("jXAxisLabel");
        this.jXAxisComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Case Id", "Predicted", "Actual"}));
        this.jXAxisComboBox.setName("jXAxisComboBox");
        this.jSampleLabel.setText("Sample Size:");
        this.jSampleLabel.setToolTipText("Y-axis");
        this.jSampleLabel.setName("jSampleLabel");
        this.jSampleSpinner.setName("jSampleSpinner");
        this.jQueryButton.setText("Query");
        this.jQueryButton.setName("jQueryButton");
        this.jQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResidualTabPanel.this.jQueryButtonActionPerformed(actionEvent);
            }
        });
        this.jShowModelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jShowModelComboBox.setName("jShowModelComboBox");
        this.jCompareModelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCompareModelComboBox.setName("jCompareModelComboBox");
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setDividerLocation(450);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jSplitPane2.setPreferredSize(new Dimension(450, 452));
        this.jModelPanel1.setName("jModelPanel1");
        this.jModelPanel1.setPreferredSize(new Dimension(450, 450));
        this.jResidualTransparentPanel1.setName("jResidualTransparentPanel1");
        this.jResidualComponentWithTitlebar1.setName("jResidualComponentWithTitlebar1");
        GroupLayout groupLayout = new GroupLayout((Container)this.jResidualTransparentPanel1);
        this.jResidualTransparentPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualComponentWithTitlebar1, -1, 449, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualComponentWithTitlebar1, -1, 297, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.jModelPanel1);
        this.jModelPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualTransparentPanel1, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualTransparentPanel1, -1, -1, Short.MAX_VALUE));
        this.jSplitPane2.setLeftComponent(this.jModelPanel1);
        this.jModelPanel2.setName("jModelPanel2");
        this.jModelPanel2.setPreferredSize(new Dimension(450, 450));
        this.jResidualTransparentPanel2.setName("jResidualTransparentPanel2");
        this.jResidualComponentWithTitlebar2.setName("jResidualComponentWithTitlebar2");
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jResidualTransparentPanel2);
        this.jResidualTransparentPanel2.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualComponentWithTitlebar2, -1, 322, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualComponentWithTitlebar2, -1, 297, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout(this.jModelPanel2);
        this.jModelPanel2.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualTransparentPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jResidualTransparentPanel2, -1, -1, Short.MAX_VALUE));
        this.jSplitPane2.setRightComponent(this.jModelPanel2);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.dataMinerTablePanel.setName("dataMinerTablePanel");
        this.jSplitPane1.setRightComponent(this.dataMinerTablePanel);
        this.jShowModelLabel.setText("Show:");
        this.jShowModelLabel.setName("jShowModelLabel");
        this.jCompareToLabel.setText("Compare to:");
        this.jCompareToLabel.setName("jCompareToLabel");
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 780, Short.MAX_VALUE).addGroup(groupLayout5.createSequentialGroup().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSampleLabel).addComponent(this.jYAxisLabel).addComponent(this.jShowModelLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.jShowModelComboBox, -2, 215, -2).addGap(18, 18, 18).addComponent(this.jCompareToLabel).addGap(18, 18, 18).addComponent(this.jCompareModelComboBox, -2, 215, -2)).addGroup(groupLayout5.createSequentialGroup().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSampleSpinner).addComponent(this.jYAxisComboBox, 0, 114, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jXAxisLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jXAxisComboBox, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 371, Short.MAX_VALUE).addComponent(this.jQueryButton))))).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jYAxisLabel).addComponent(this.jYAxisComboBox, -2, -1, -2).addComponent(this.jQueryButton).addComponent(this.jXAxisLabel).addComponent(this.jXAxisComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleLabel).addComponent(this.jSampleSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jShowModelLabel).addComponent(this.jShowModelComboBox, -2, -1, -2).addComponent(this.jCompareToLabel).addComponent(this.jCompareModelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 461, Short.MAX_VALUE).addContainerGap()));
    }

    private void jQueryButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        if ((string = (String)this.jXAxisComboBox.getSelectedItem()).equals(this._state.getCaseAttr())) {
            this._state.setSelectedPlotXValue("PLOT_CASEID");
        } else if (string.equals(TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"))) {
            this._state.setSelectedPlotXValue("PLOT_PREDICTION");
        } else if (string.equals(TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"))) {
            this._state.setSelectedPlotXValue("PLOT_TARGET");
        } else if (string.equals(TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE"))) {
            this._state.setSelectedPlotXValue("PLOT_RESIDUAL");
        }
        String string2 = (String)this.jYAxisComboBox.getSelectedItem();
        if (string2.equals(this._state.getCaseAttr())) {
            this._state.setSelectedPlotYValue("PLOT_CASEID");
        } else if (string2.equals(TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"))) {
            this._state.setSelectedPlotYValue("PLOT_PREDICTION");
        } else if (string2.equals(TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE"))) {
            this._state.setSelectedPlotYValue("PLOT_TARGET");
        } else if (string2.equals(TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE"))) {
            this._state.setSelectedPlotYValue("PLOT_RESIDUAL");
        }
        int n = (Integer)this.jSampleSpinner.getValue();
        this._state.setSampleSize(n);
        String string3 = (String)this.jShowModelComboBox.getSelectedItem();
        this._state.setSelectedTestResult1(string3);
        String string4 = (String)this.jCompareModelComboBox.getSelectedItem();
        if (string4.equals(TestViewerLrb.get("RESIDUAL_RESULT_NONE"))) {
            this._state.setSelectedTestResult2(null);
        } else {
            this._state.setSelectedTestResult2(string4);
        }
        this.enableControls(false);
        this.prepareLoad(1);
        LoadUI loadUI = new LoadUI(1);
        loadUI.execute();
    }

    class GraphPanel
    extends GraphPanel2 {
        GraphDataDisplay target;
        public String id;

        public GraphPanel(GraphDataDisplay graphDataDisplay, GraphDataModel graphDataModel, String string) {
            super(graphDataDisplay, graphDataModel);
            this.target = graphDataDisplay;
            this.id = string;
        }

        @Override
        public void initGraph() {
            try {
                this._graph = new AxisChartInteractive();
                this._graph.addMouseListener((MouseListener)new GraphPopupClickListener(this.target, this._graph));
                AxisChartInteractive axisChartInteractive = this._graph;
                axisChartInteractive.setPlotBackground(Color.WHITE);
                axisChartInteractive.setBackground(Color.WHITE);
                axisChartInteractive.setLocale(Locale.getDefault());
                String string = this._dataModel.getTitle();
                if (string != null) {
                    axisChartInteractive.getTitle().setText(this._dataModel.getTitle());
                } else {
                    axisChartInteractive.getTitle().setVisible(false);
                }
                Object[] objectArray = this._dataModel.getRowLabels();
                double d = (Double)this._dataModel.minX1Value();
                double d2 = (Double)this._dataModel.maxX1Value();
                double d3 = (Double)this._dataModel.minY1Value();
                double d4 = (Double)this._dataModel.maxY1Value();
                NumberFormat numberFormat = ResidualTabPanel.this._numericalFormat;
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setParseIntegerOnly(true);
                double d5 = 0.1;
                double d6 = 0.1;
                if (ResidualTabPanel.this._state.getSelectedPlotXValue().equals("PLOT_CASEID")) {
                    d5 = 0.1;
                }
                d -= Math.max(d5, (d2 - d) / 10.0);
                d2 += Math.max(d5, (d2 - d) / 10.0);
                axisChartInteractive.setXSeries(d, d2, numberFormat);
                AxisTitleDesc axisTitleDesc = new AxisTitleDesc();
                axisTitleDesc.setTitle(this._dataModel.getX1Title());
                axisChartInteractive.setChartAttributes(1, axisTitleDesc);
                AxisTitleDesc axisTitleDesc2 = new AxisTitleDesc();
                axisTitleDesc2.setTitle(this._dataModel.getY1Title());
                axisChartInteractive.setChartAttributes(2, axisTitleDesc2);
                NumAxisDesc numAxisDesc = new NumAxisDesc();
                if (ResidualTabPanel.this._state.getSelectedPlotXValue().equals("PLOT_CASEID")) {
                    d6 = 0.1;
                }
                d3 -= Math.max(d6, (d4 - d3) / 10.0);
                d4 += Math.max(d6, (d4 - d3) / 10.0);
                numAxisDesc.setExtentMin(d3);
                numAxisDesc.setExtentMax(d4);
                numAxisDesc.setNumberFormat(numberFormat);
                axisChartInteractive.setChartAttributes(numAxisDesc);
                Object[][] objectArray2 = this._dataModel.getGraphData();
                for (int i = 0; i < objectArray2.length; ++i) {
                    double[] dArray = new double[objectArray2[i].length / 2];
                    double[] dArray2 = new double[objectArray2[i].length / 2];
                    int n = 0;
                    int n2 = 0;
                    for (int j = 0; j < objectArray2[i].length; ++j) {
                        double d7 = (Double)objectArray2[i][j];
                        if (j % 2 == 0) {
                            dArray[n++] = d7;
                            continue;
                        }
                        dArray2[n2++] = d7;
                    }
                    String string2 = (String)objectArray[i];
                    axisChartInteractive.setYSeries(string2, dArray, dArray2);
                    axisChartInteractive.setSeriesGraphType(string2, 0);
                    Object object = this._dataModel.getRowMarkerShapes()[i];
                    MarkerDesc markerDesc = new MarkerDesc();
                    markerDesc.setMarkerType(((Integer)object).intValue());
                    markerDesc.setMarkerScale(0.75);
                    markerDesc.setMarkerColor(this._dataModel.getRowColors()[i]);
                    axisChartInteractive.setSeriesGraphic(string2, markerDesc);
                    axisChartInteractive.setSeriesColor(string2, this._dataModel.getRowColors()[i]);
                    axisChartInteractive.setSeriesInLegend(string2, false);
                }
                this.removeAll();
                this.setLayout(new BorderLayout());
                this.add((Component)this._graph, "Center");
                axisChartInteractive.invalidate();
            }
            catch (ChartException chartException) {
                theLogger.log(Level.FINEST, chartException.getMessage());
            }
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        int _mode;

        public LoadUI(int n) {
            this._mode = n;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._mode == 0) {
                    ResidualTabPanel.this._state.refreshSummary();
                } else if (this._mode == 1) {
                    ResidualTabPanel.this._state.refreshGraph(0);
                } else if (this._mode == 2) {
                    ResidualTabPanel.this._state.refreshGraph(1);
                } else if (this._mode == 3) {
                    ResidualTabPanel.this._state.refreshGraph(2);
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ResidualTabPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                boolean bl = true;
                if (this._success && this._ex == null) {
                    Object object;
                    Object object2;
                    Object object3;
                    if (this._mode == 0) {
                        ResidualTabPanel.this.jShowModelComboBox.setModel(new DefaultComboBoxModel<String>(ResidualTabPanel.this._state.getRegressTestResults()));
                        ResidualTabPanel.this.jShowModelComboBox.setSelectedItem(ResidualTabPanel.this._state.getSelectedTestResult1());
                        object3 = new DefaultComboBoxModel<String>(ResidualTabPanel.this._state.getRegressTestResults());
                        object3.insertElementAt(TestViewerLrb.get("RESIDUAL_RESULT_NONE"), 0);
                        ResidualTabPanel.this.jCompareModelComboBox.setModel(object3);
                        object2 = ResidualTabPanel.this._state.getSelectedTestResult2();
                        if (object2 == null) {
                            ResidualTabPanel.this.jCompareModelComboBox.setSelectedItem(TestViewerLrb.get("RESIDUAL_RESULT_NONE"));
                        } else {
                            ResidualTabPanel.this.jCompareModelComboBox.setSelectedItem(object2);
                        }
                        ResidualTabPanel.this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
                        ResidualTabPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)ResidualTabPanel.this._state.getResidualSummaryModel()));
                        ResidualTabPanel.this.dataMinerTablePanel.getTable().setSorted(true);
                        ResidualTabPanel.this.dataMinerTablePanel.getTable().setSelectionMode(0);
                        ResidualTabPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
                        object = ResidualTabPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
                        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                        ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

                            @Override
                            public Color getColorFor(Object object) {
                                String string = (String)object;
                                return ResidualTabPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
                            }
                        });
                        object.getColumn(0).setCellRenderer(colorCellRenderer);
                        object.getColumn(1).setCellRenderer(numberCellRenderer);
                        object.getColumn(2).setCellRenderer(numberCellRenderer);
                        object.getColumn(3).setCellRenderer(numberCellRenderer);
                        object.getColumn(4).setCellRenderer(numberCellRenderer);
                        object.getColumn(5).setCellRenderer(numberCellRenderer);
                        object.getColumn(7).setCellRenderer(new DateCellRenderer2());
                        object.getColumn(1).setPreferredWidth(145);
                        object.getColumn(2).setPreferredWidth(125);
                        object.getColumn(3).setPreferredWidth(145);
                        object.getColumn(4).setPreferredWidth(130);
                        object.getColumn(5).setPreferredWidth(120);
                        object.getColumn(6).setPreferredWidth(135);
                        object.getColumn(7).setPreferredWidth(135);
                    }
                    if (ResidualTabPanel.this._state.getSelectedTestResult2() == null) {
                        ResidualTabPanel.this.jSplitPane1.setTopComponent(ResidualTabPanel.this.jModelPanel1);
                    } else {
                        ResidualTabPanel.this.jSplitPane1.setTopComponent(ResidualTabPanel.this.jSplitPane2);
                        ResidualTabPanel.this.jSplitPane2.setLeftComponent(ResidualTabPanel.this.jModelPanel1);
                        ResidualTabPanel.this.jSplitPane2.setRightComponent(ResidualTabPanel.this.jModelPanel2);
                        ResidualTabPanel.this.jSplitPane2.setDividerLocation(0.5);
                        ResidualTabPanel.this.jSplitPane2.setResizeWeight(0.5);
                    }
                    if (this._mode == 0 || this._mode == 1 || this._mode == 2) {
                        if (ResidualTabPanel.this._state.isShowChartForResult1()) {
                            ResidualTabPanel.this.jGraphPanel1.removeAll();
                            ResidualTabPanel.this.jGraphPanel1.add((Component)ResidualTabPanel.this._graphPanel1, "Center");
                            ResidualTabPanel.this.jResultScroller1 = new JScrollPane(ResidualTabPanel.this.jGraphPanel1);
                            ResidualTabPanel.this.jResidualComponentWithTitlebar1.setComponent((JComponent)ResidualTabPanel.this.jResultScroller1);
                            ResidualTabPanel.this._graphPanel1.initGraph(ResidualTabPanel.this._state.getGraphDataModel(ResidualTabPanel.this._state.getSelectedTestResult1()));
                            ResidualTabPanel.this.jGraphPanel1.updateUI();
                        } else {
                            object3 = ResidualTabPanel.this._state.getResidualPlotModel(ResidualTabPanel.this._state.getSelectedTestResult1());
                            ResidualTabPanel.this.jPlotTable1.setModel(object3);
                            ResidualTabPanel.this.jPlotTable1.setShowToolTips(true);
                            ResidualTabPanel.this.jPlotTable1.setSorted(true);
                            ResidualTabPanel.this.jPlotTable1.setUpdateSelectionOnSort(true);
                            ResidualTabPanel.this.jPlotTable1.setRowSelectionAllowed(true);
                            ResidualTabPanel.this.jPlotTable1.setColumnSelectionAllowed(false);
                            ResidualTabPanel.this.jPlotTable1.setAutoResizeMode(0);
                            ResidualTabPanel.this.jPlotTable1.autoSizeColumnsToFit();
                            object2 = new NumberCellRenderer();
                            object = null;
                            object = ResidualTabPanel.this.jPlotTable1.getColumnModel().getColumn(1);
                            ((TableColumn)object).setCellRenderer((TableCellRenderer)object2);
                            object = ResidualTabPanel.this.jPlotTable1.getColumnModel().getColumn(2);
                            ((TableColumn)object).setCellRenderer((TableCellRenderer)object2);
                            object = ResidualTabPanel.this.jPlotTable1.getColumnModel().getColumn(3);
                            ((TableColumn)object).setCellRenderer((TableCellRenderer)object2);
                            ResidualTabPanel.this.jResultScroller1 = new JScrollPane((Component)ResidualTabPanel.this.jPlotTable1);
                            ResidualTabPanel.this.jResidualComponentWithTitlebar1.setComponent((JComponent)ResidualTabPanel.this.jResultScroller1);
                            if (ResidualTabPanel.this._state.getCaseAttr() == null) {
                                ResidualTabPanel.this.jPlotTable1.removeColumn(ResidualTabPanel.this.jPlotTable1.getColumnModel().getColumn(0));
                            }
                        }
                        object3 = StringUtils.getReplacedString(TestViewerLrb.get("RESIDUAL_SELECTED_RESULT"), "%2", ResidualTabPanel.this._numericalFormat.format(ResidualTabPanel.this._state.getResidualPlotSize(ResidualTabPanel.this._state.getSelectedTestResult1())));
                        object3 = StringUtils.getReplacedString(object3, "%1", ResidualTabPanel.this._numericalFormat.format(Math.min(ResidualTabPanel.this._state.getSampleSize(), ResidualTabPanel.this._state.getResidualPlotSize(ResidualTabPanel.this._state.getSelectedTestResult1()))));
                        ResidualTabPanel.this.jResidualComponentWithTitlebar1.setLabel(new JLabel((String)object3));
                    }
                    if (this._mode == 0 || this._mode == 1 || this._mode == 3) {
                        if (ResidualTabPanel.this._state.getSelectedTestResult2() == null) {
                            object3 = new JPanel();
                            ResidualTabPanel.this.jResultScroller2 = new JScrollPane((Component)object3);
                            ResidualTabPanel.this.jResidualComponentWithTitlebar2.setComponent((JComponent)ResidualTabPanel.this.jResultScroller2);
                        } else if (ResidualTabPanel.this._state.isShowChartForResult2()) {
                            ResidualTabPanel.this.jGraphPanel2.removeAll();
                            ResidualTabPanel.this.jGraphPanel2.add((Component)ResidualTabPanel.this._graphPanel2, "Center");
                            ResidualTabPanel.this.jResultScroller2 = new JScrollPane(ResidualTabPanel.this.jGraphPanel2);
                            ResidualTabPanel.this.jResidualComponentWithTitlebar2.setComponent((JComponent)ResidualTabPanel.this.jResultScroller2);
                            ResidualTabPanel.this._graphPanel2.initGraph(ResidualTabPanel.this._state.getGraphDataModel(ResidualTabPanel.this._state.getSelectedTestResult2()));
                            ResidualTabPanel.this.jGraphPanel2.updateUI();
                        } else {
                            object3 = ResidualTabPanel.this._state.getResidualPlotModel(ResidualTabPanel.this._state.getSelectedTestResult2());
                            ResidualTabPanel.this.jPlotTable2.setModel(object3);
                            ResidualTabPanel.this.jPlotTable2.setShowToolTips(true);
                            ResidualTabPanel.this.jPlotTable2.setSorted(true);
                            ResidualTabPanel.this.jPlotTable2.setUpdateSelectionOnSort(true);
                            ResidualTabPanel.this.jPlotTable2.setRowSelectionAllowed(true);
                            ResidualTabPanel.this.jPlotTable2.setColumnSelectionAllowed(false);
                            ResidualTabPanel.this.jPlotTable2.setAutoResizeMode(0);
                            ResidualTabPanel.this.jPlotTable2.autoSizeColumnsToFit();
                            object2 = new NumberCellRenderer();
                            object = null;
                            object = ResidualTabPanel.this.jPlotTable2.getColumnModel().getColumn(1);
                            ((TableColumn)object).setCellRenderer((TableCellRenderer)object2);
                            object = ResidualTabPanel.this.jPlotTable2.getColumnModel().getColumn(2);
                            ((TableColumn)object).setCellRenderer((TableCellRenderer)object2);
                            object = ResidualTabPanel.this.jPlotTable2.getColumnModel().getColumn(3);
                            ((TableColumn)object).setCellRenderer((TableCellRenderer)object2);
                            ResidualTabPanel.this.jResultScroller2 = new JScrollPane((Component)ResidualTabPanel.this.jPlotTable2);
                            ResidualTabPanel.this.jResidualComponentWithTitlebar2.setComponent((JComponent)ResidualTabPanel.this.jResultScroller2);
                            if (ResidualTabPanel.this._state.getCaseAttr() == null) {
                                ResidualTabPanel.this.jPlotTable2.removeColumn(ResidualTabPanel.this.jPlotTable2.getColumnModel().getColumn(0));
                            }
                        }
                        object3 = StringUtils.getReplacedString(TestViewerLrb.get("RESIDUAL_SELECTED_RESULT"), "%2", ResidualTabPanel.this._numericalFormat.format(ResidualTabPanel.this._state.getResidualPlotSize(ResidualTabPanel.this._state.getSelectedTestResult2())));
                        object3 = StringUtils.getReplacedString(object3, "%1", ResidualTabPanel.this._numericalFormat.format(Math.min(ResidualTabPanel.this._state.getSampleSize(), ResidualTabPanel.this._state.getResidualPlotSize(ResidualTabPanel.this._state.getSelectedTestResult2()))));
                        ResidualTabPanel.this.jResidualComponentWithTitlebar2.setLabel(new JLabel((String)object3));
                    }
                    ResidualTabPanel.this.enableControls(true);
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ResidualTabPanel.this._loading = false;
                if (ResidualTabPanel.this.overLayPanel != null) {
                    ResidualTabPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

