/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ROCDetailPanel
extends JPanel {
    private Context _context;
    private String _testResult;
    private List<ROCTabPanelState.ROCData> _data;
    private boolean _useCost = false;
    private DataMinerTable ROCDetailTable;
    private JScrollPane jScrollPane1;

    public ROCDetailPanel(Context context, String string, List<ROCTabPanelState.ROCData> list) {
        this._context = context;
        this._testResult = string;
        this._data = list;
        this.initComponents();
        HelpUtils.setHelpID((JComponent)this, (String)"roc_detail_dialog");
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.ROCDetailTable = new DataMinerTable();
        this.setPreferredSize(new Dimension(600, 400));
        this.ROCDetailTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)((Object)this.ROCDetailTable));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 556, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 537, Short.MAX_VALUE).addContainerGap()));
    }

    public class ROCDetailModel
    extends GenericBaseTableModel {
        private static final int COLUMN_COUNT = 9;
        public static final int THRESHOLD = 0;
        public static final int TRUE_POSITIVES = 1;
        public static final int FALSE_NEGATIVES = 2;
        public static final int FALSE_POSITIVES = 3;
        public static final int TRUE_NEGATIVES = 4;
        public static final int TRUE_POSITIVES_FRACTION = 5;
        public static final int FALSE_POSITIVES_FRACTION = 6;
        public static final int OVERALL_ACCURACY = 7;
        public static final int AVERAGE_ACCURACY = 8;
        private boolean _useCost = false;
        private List<ROCTabPanelState.ROCData> _rocdata = null;
        private String[] _columnNames = new String[]{TestViewerLrb.get("PROB_THRESHOLD"), TestViewerLrb.get("TRUE_POSITIVE"), TestViewerLrb.get("FALSE_NEGATIVE"), TestViewerLrb.get("FALSE_POSITIVE"), TestViewerLrb.get("TRUE_NEGATIVE"), TestViewerLrb.get("TRUE_POSITIVE_FRACTION"), TestViewerLrb.get("FALSE_POSITIVE_FRACTION"), TestViewerLrb.get("OVERALL_ACCURACY"), TestViewerLrb.get("AVG_ACCURACY")};

        public ROCDetailModel() {
            this(false, null);
        }

        public ROCDetailModel(boolean bl, List<ROCTabPanelState.ROCData> list) {
            this.setColumnIdentifiers(this._columnNames);
            this._useCost = bl;
            this._rocdata = list;
            this.setRowCount(this._rocdata.size());
            this.setColumnCount(9);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._rocdata == null) {
                return TestViewerLrb.get("LOADING_SHORTENED");
            }
            ROCTabPanelState.ROCData rOCData = this._rocdata.get(n);
            if (n2 == 0) {
                return rOCData.getProb();
            }
            if (n2 == 1) {
                return rOCData.getTruePositives();
            }
            if (n2 == 2) {
                return rOCData.getFalseNegatives();
            }
            if (n2 == 3) {
                return rOCData.getFalsePositives();
            }
            if (n2 == 4) {
                return rOCData.getTrueNegatives();
            }
            if (n2 == 5) {
                return rOCData.getTruePositivesFraction();
            }
            if (n2 == 6) {
                return rOCData.getFalsePositivesFraction();
            }
            if (n2 == 7) {
                return rOCData.getAccuracy();
            }
            if (n2 == 8) {
                return rOCData.getAvgAccuracy();
            }
            return "Undefined";
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            block6: {
                super.done();
                try {
                    if (this._success && this._ex == null) {
                        ROCDetailPanel.this.ROCDetailTable.setModel((TableModel)((Object)new ROCDetailModel(ROCDetailPanel.this._useCost, ROCDetailPanel.this._data)));
                        ROCDetailPanel.this.ROCDetailTable.setShowToolTips(true);
                        ROCDetailPanel.this.ROCDetailTable.setSorted(true);
                        ROCDetailPanel.this.ROCDetailTable.setUpdateSelectionOnSort(true);
                        ROCDetailPanel.this.ROCDetailTable.setRowSelectionAllowed(true);
                        ROCDetailPanel.this.ROCDetailTable.setColumnSelectionAllowed(false);
                        ROCDetailPanel.this.ROCDetailTable.setAutoResizeMode(0);
                        ROCDetailPanel.this.ROCDetailTable.autoSizeColumnsToFit();
                        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                        TableColumn tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(0);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(1);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(2);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(3);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(4);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(5);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(6);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(7);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ROCDetailPanel.this.ROCDetailTable.getColumnModel().getColumn(8);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        break block6;
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                        break block6;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                }
            }
        }
    }
}

