/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.tviewer.roc.ThresholdPanel;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Assert;
import oracle.javatools.icons.OracleIcons;

public class ThresholdDialog {
    private static final Logger theLogger = Logger.getLogger(ThresholdDialog.class.getName());
    private static final String _WIZARD_NAME = TestViewerLrb.get("CUSTOM_THRESHOLD_DIALOG");
    private static final String _DIALOG_TITLE = TestViewerLrb.get("CUSTOM_THRESHOLD_DIALOG");
    private static final String _DIALOG_HEADER = TestViewerLrb.get("CUSTOM_THRESHOLD_DIALOG_HEADER");
    protected JEWTDialog _dlg;
    private ROCTabPanelState _state;

    public ThresholdDialog(ROCTabPanelState rOCTabPanelState) {
        this._state = rOCTabPanelState;
    }

    protected JEWTDialog buildDialog() {
        ThresholdPanel thresholdPanel = this.buildPanel();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, _WIZARD_NAME, n);
        jEWTDialog.setContent((Component)thresholdPanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderDescription(this.getHeaderDescription());
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        return _DIALOG_TITLE;
    }

    protected String getHeaderDescription() {
        return _DIALOG_HEADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke() {
        boolean bl = false;
        if (this._state != null) {
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final ThresholdPanel thresholdPanel = (ThresholdPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !thresholdPanel.validateAndWriteToState(ThresholdDialog.this._state)) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog == null) return bl;
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                return bl;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                return bl;
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        } else {
            Assert.println((String)("Failed to create a valid BaliWizardState for wizard " + this));
        }
        return bl;
    }

    protected void cancel() {
    }

    protected ThresholdPanel buildPanel() {
        return new ThresholdPanel(this._state);
    }

    protected Image getHeaderImage() {
        return (Image)((Object)OracleIcons.getIcon((String)"warning.png"));
    }
}

