/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.ide.util.ResourceUtils;

public class ThresholdPanel
extends JPanel {
    private ThresholdState _state;
    private JRadioButton jFalseAlarmRadioBtn;
    private JRadioButton jFalsePosFalseNegRadioBtn;
    private JTextField jFalsePosFalseNegText;
    private JRadioButton jHitRatioRadioBtn;
    private JSlider jSlider1;
    private ButtonGroup jThresholdOption;

    public ThresholdPanel(ROCTabPanelState rOCTabPanelState) {
        this._state = new ThresholdState(rOCTabPanelState.getCustomThresholdOption(), rOCTabPanelState.getCustomThresholdValue());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jHitRatioRadioBtn, (String)TestViewerLrb.get("HIT_RATE"));
        this.jHitRatioRadioBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("HIT_RATE"));
        this.jHitRatioRadioBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("HIT_RATE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jFalseAlarmRadioBtn, (String)TestViewerLrb.get("FALSE_ALARM"));
        this.jFalseAlarmRadioBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("FALSE_ALARM"));
        this.jFalseAlarmRadioBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("FALSE_ALARM_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jFalsePosFalseNegRadioBtn, (String)TestViewerLrb.get("FALSE_POS_FALSE_NEG"));
        this.jFalsePosFalseNegRadioBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("FALSE_POS_FALSE_NEG"));
        this.jFalsePosFalseNegRadioBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("FALSE_POS_FALSE_NEG_ADA"));
        this.jFalsePosFalseNegText.setToolTipText(TestViewerLrb.get("RATIO_VALID_RANGE"));
    }

    private void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    private void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    private void setSigned(JTextField jTextField, boolean bl) {
        ((NumberTextField)jTextField).setSigned(bl);
    }

    private void setLocale(JTextField jTextField, Locale locale) {
        ((NumberTextField)jTextField).setLocale(locale);
    }

    private Number getNumber(JTextField jTextField) {
        return ((NumberTextField)jTextField).getNumber();
    }

    public void initUI() {
        this.initializeControls();
        HelpUtils.setHelpID((JComponent)this, (String)"class_tune_roc_cust_op");
    }

    private void enableControls() {
        this.jSlider1.setEnabled(this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_HIT_RATIO") || this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_FALSE_ALARM"));
        this.jFalsePosFalseNegText.setEnabled(this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_FALSE_RATIO"));
    }

    private void initializeControls() {
        this.jHitRatioRadioBtn.setSelected(this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_HIT_RATIO"));
        this.jFalseAlarmRadioBtn.setSelected(this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_FALSE_ALARM"));
        this.jFalsePosFalseNegRadioBtn.setSelected(this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_FALSE_RATIO"));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(0, new JLabel("0.00"));
        hashtable.put(10, new JLabel("0.10"));
        hashtable.put(20, new JLabel("0.20"));
        hashtable.put(30, new JLabel("0.30"));
        hashtable.put(40, new JLabel("0.40"));
        hashtable.put(50, new JLabel("0.50"));
        hashtable.put(60, new JLabel("0.60"));
        hashtable.put(70, new JLabel("0.70"));
        hashtable.put(80, new JLabel("0.80"));
        hashtable.put(90, new JLabel("0.90"));
        hashtable.put(100, new JLabel("1.00"));
        this.jSlider1.setLabelTable(hashtable);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setMajorTickSpacing(20);
        this.jSlider1.setMinorTickSpacing(5);
        this.jSlider1.setMinimum(0);
        this.jSlider1.setMaximum(100);
        this.setDataType(this.jFalsePosFalseNegText, Double.class);
        this.setSigned(this.jFalsePosFalseNegText, false);
        this.setLocale(this.jFalsePosFalseNegText, this.getLocale());
        if (this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_HIT_RATIO") || this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_FALSE_ALARM")) {
            this.jSlider1.setValue(Double.valueOf(this._state.getCustomThresholdValue() * 100.0).intValue());
        }
        if (this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_FALSE_RATIO")) {
            this.setNumber(this.jFalsePosFalseNegText, this._state.getCustomThresholdValue());
        }
        this.enableControls();
    }

    private void initComponents() {
        this.jThresholdOption = new ButtonGroup();
        this.jHitRatioRadioBtn = new JRadioButton();
        this.jFalseAlarmRadioBtn = new JRadioButton();
        this.jSlider1 = new JSlider();
        this.jFalsePosFalseNegRadioBtn = new JRadioButton();
        this.jFalsePosFalseNegText = new NumberTextField();
        this.jThresholdOption.add(this.jHitRatioRadioBtn);
        this.jHitRatioRadioBtn.setText("Hit Ratio (True Positive)");
        this.jHitRatioRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jHitRatioRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        this.jHitRatioRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThresholdPanel.this.jHitRatioRadioBtnActionPerformed(actionEvent);
            }
        });
        this.jThresholdOption.add(this.jFalseAlarmRadioBtn);
        this.jFalseAlarmRadioBtn.setText("False Alarm (False Positive)");
        this.jFalseAlarmRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jFalseAlarmRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        this.jFalseAlarmRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThresholdPanel.this.jFalseAlarmRadioBtnActionPerformed(actionEvent);
            }
        });
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ThresholdPanel.this.jSlider1StateChanged(changeEvent);
            }
        });
        this.jThresholdOption.add(this.jFalsePosFalseNegRadioBtn);
        this.jFalsePosFalseNegRadioBtn.setText("False Positive / False Negative");
        this.jFalsePosFalseNegRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jFalsePosFalseNegRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        this.jFalsePosFalseNegRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThresholdPanel.this.jFalsePosFalseNegRadioBtnActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jFalsePosFalseNegRadioBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFalsePosFalseNegText, -1, 117, Short.MAX_VALUE)).addComponent(this.jSlider1, -1, 286, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jHitRatioRadioBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFalseAlarmRadioBtn))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jHitRatioRadioBtn).addComponent(this.jFalseAlarmRadioBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFalsePosFalseNegRadioBtn).addComponent(this.jFalsePosFalseNegText, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
    }

    private void jSlider1StateChanged(ChangeEvent changeEvent) {
        this._state.setCustomThresholdValue((double)this.jSlider1.getValue() / 100.0);
    }

    private void jFalsePosFalseNegRadioBtnActionPerformed(ActionEvent actionEvent) {
        this._state.setCustomThresholdOption("CUSTOM_THRESHOLD_OP_FALSE_RATIO");
        this.enableControls();
    }

    private void jFalseAlarmRadioBtnActionPerformed(ActionEvent actionEvent) {
        this._state.setCustomThresholdOption("CUSTOM_THRESHOLD_OP_FALSE_ALARM");
        this.enableControls();
    }

    private void jHitRatioRadioBtnActionPerformed(ActionEvent actionEvent) {
        this._state.setCustomThresholdOption("CUSTOM_THRESHOLD_OP_HIT_RATIO");
        this.enableControls();
    }

    public boolean validateAndWriteToState(ROCTabPanelState rOCTabPanelState) {
        if (this._state.getCustomThresholdOption().equals("CUSTOM_THRESHOLD_OP_FALSE_RATIO")) {
            Number number = this.getNumber(this.jFalsePosFalseNegText);
            if (null == number || number.doubleValue() <= 0.0) {
                return false;
            }
            rOCTabPanelState.setCustomThresholdValue(number.doubleValue());
        } else {
            rOCTabPanelState.setCustomThresholdValue(this._state.getCustomThresholdValue());
        }
        rOCTabPanelState.setCustomThresholdOption(this._state.getCustomThresholdOption());
        return true;
    }

    public class ThresholdState {
        private String _customThresholdOption;
        private double _customThresholdValue;

        public ThresholdState(String string, double d) {
            this._customThresholdOption = string;
            this._customThresholdValue = d;
        }

        public void setCustomThresholdOption(String string) {
            this._customThresholdOption = string;
        }

        public String getCustomThresholdOption() {
            return this._customThresholdOption;
        }

        public void setCustomThresholdValue(double d) {
            this._customThresholdValue = d;
        }

        public double getCustomThresholdValue() {
            return this._customThresholdValue;
        }
    }
}

