/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.trend;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.Test;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CTrendTabState {
    private static final Logger theLogger = Logger.getLogger(CTrendTabState.class.getName());
    private List<Test> _tests;
    private Map<BigDecimal, PerformanceMetrics> _testIdMetricsList;
    private Map<Measure, GraphDataModel> _graphDataModels;
    private List<Color> _testColors = null;
    private GenericBaseTableModel _perfTrendTable = null;

    public CTrendTabState(List<Test> list, List<Color> list2, Timestamp timestamp, Timestamp timestamp2) {
        this._tests = list;
        this._testColors = list2;
    }

    public synchronized void load(Connection connection) throws Exception {
        Object object;
        Object object2;
        this._perfTrendTable = new PerfTrendTable();
        this._perfTrendTable.setColumnCount(8);
        this._testIdMetricsList = new HashMap<BigDecimal, PerformanceMetrics>();
        this._graphDataModels = new HashMap<Measure, GraphDataModel>();
        Object[] objectArray = new Object[this._tests.size()];
        Date[][] dateArray = new Date[this._tests.size()][];
        Object[][] objectArray2 = new Object[this._tests.size()][];
        Object[][] objectArray3 = new Object[this._tests.size()][];
        Object[][] objectArray4 = new Object[this._tests.size()][];
        Object[][] objectArray5 = new Object[this._tests.size()][];
        Vector<Long> vector = new Vector<Long>();
        int n = 0;
        boolean bl = false;
        for (Test object32 : this._tests) {
            object2 = object32.getTestResultsWithinTimeframe();
            object = new PerformanceMetrics();
            objectArray[n] = object32.getName();
            dateArray[n] = new Date[object2.size()];
            objectArray2[n] = new Object[object2.size()];
            objectArray3[n] = new Object[object2.size()];
            objectArray4[n] = new Object[object2.size()];
            objectArray5[n] = new Object[object2.size()];
            ((PerformanceMetrics)object)._predConfidence = new Double[object2.size()];
            ((PerformanceMetrics)object)._overallAccuracy = new Double[object2.size()];
            ((PerformanceMetrics)object)._avgAccuracy = new Double[object2.size()];
            ((PerformanceMetrics)object)._cost = new Double[object2.size()];
            ((PerformanceMetrics)object)._creationDate = new Date[object2.size()];
            int n2 = 0;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                TestResult testResult = (TestResult)iterator.next();
                String string = ((ClassTestResult)testResult).getPerformanceMatrixTable();
                String string2 = "Select metric_name, metric_num_value from " + string + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'AVG_ACCURACY', 'ACCURACY', 'COST')";
                SQLHelper sQLHelper = new SQLHelper();
                try {
                    sQLHelper.pstmt = connection.prepareStatement(string2);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        ((PerformanceMetrics)object)._creationDate[n2] = testResult.getCreationTimestamp();
                        if (((PerformanceMetrics)object)._creationDate[n2] != null) {
                            vector.add(((PerformanceMetrics)object)._creationDate[n2].getTime());
                        }
                        dateArray[n][n2] = testResult.getCreationTimestamp();
                        String sQLException = sQLHelper.rs.getString(1);
                        Double d = sQLHelper.rs.getDouble(2);
                        if ("PREDICTIVE_CONFIDENCE".equals(sQLException)) {
                            ((PerformanceMetrics)object)._predConfidence[n2] = d / 100.0;
                            objectArray2[n][n2] = ((PerformanceMetrics)object)._predConfidence[n2];
                            continue;
                        }
                        if ("AVG_ACCURACY".equals(sQLException)) {
                            ((PerformanceMetrics)object)._avgAccuracy[n2] = d / 100.0;
                            objectArray4[n][n2] = ((PerformanceMetrics)object)._avgAccuracy[n2];
                            continue;
                        }
                        if ("ACCURACY".equals(sQLException)) {
                            ((PerformanceMetrics)object)._overallAccuracy[n2] = d / 100.0;
                            objectArray3[n][n2] = ((PerformanceMetrics)object)._overallAccuracy[n2];
                            continue;
                        }
                        if (!"COST".equals(sQLException)) continue;
                        ((PerformanceMetrics)object)._cost[n2] = d;
                        objectArray5[n][n2] = ((PerformanceMetrics)object)._cost[n2];
                        bl = true;
                    }
                    this._perfTrendTable.addRow(new Object[]{testResult.getName(), testResult.getCreationTimestamp(), testResult.getModelName(), testResult.getMiningAlgorithm(), ((PerformanceMetrics)object)._predConfidence[n2], ((PerformanceMetrics)object)._overallAccuracy[n2], ((PerformanceMetrics)object)._avgAccuracy[n2], ((PerformanceMetrics)object)._cost[n2]});
                    if (objectArray5[n][n2] == null) {
                        objectArray5[n][n2] = -1.0;
                    }
                    ++n2;
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    throw sQLException;
                }
                finally {
                    sQLHelper.close();
                }
            }
            this._testIdMetricsList.put(object32.getId(), (PerformanceMetrics)object);
            ++n;
        }
        Date date = new Date((Long)Collections.min(vector));
        Date date2 = new Date((Long)Collections.max(vector));
        object2 = 0.0;
        object = 1.0;
        this._graphDataModels.put(Measure.PREDICTIVE_CONFIDENCE, new DefaultGraphDataModel(TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), null, objectArray, this._testColors, dateArray, objectArray2, TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), date, date2, object2, object));
        this._graphDataModels.put(Measure.OVERALL_ACCURACY, new DefaultGraphDataModel(TestViewerLrb.get("OVERALL_ACCURACY"), null, objectArray, this._testColors, dateArray, objectArray3, TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("OVERALL_ACCURACY"), date, date2, object2, object));
        this._graphDataModels.put(Measure.AVG_ACCURACY, new DefaultGraphDataModel(TestViewerLrb.get("AVG_ACCURACY"), null, objectArray, this._testColors, dateArray, objectArray4, TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("AVG_ACCURACY"), date, date2, object2, object));
        if (bl) {
            this._graphDataModels.put(Measure.COST, new DefaultGraphDataModel(TestViewerLrb.get("COST"), null, objectArray, this._testColors, dateArray, objectArray5, TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("COST"), date, date2, object2, null));
        }
    }

    public GenericBaseTableModel getPerformanceTableModel() {
        return this._perfTrendTable;
    }

    public Map<Measure, GraphDataModel> getGraphDataModels() {
        return this._graphDataModels;
    }

    public GraphDataModel getGraphDataModel(Measure measure) {
        return this._graphDataModels.get((Object)measure);
    }

    public static enum Measure {
        PREDICTIVE_CONFIDENCE,
        AVG_ACCURACY,
        OVERALL_ACCURACY,
        COST,
        MULTIPLE_SELECTION;

    }

    public class PerformanceMetrics {
        Double[] _predConfidence;
        Double[] _avgAccuracy;
        Double[] _overallAccuracy;
        Double[] _cost;
        Date[] _creationDate;
        NumberFormat nf = NumericFormat.getInstance(false, 8, 8);
    }

    class PerfTrendTable
    extends GenericBaseTableModel {
    }
}

