/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.trend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.NiceTable2;
import oracle.dmt.dataminer.controls.TimeSeriesGraphPanel;
import oracle.dmt.dataminer.controls.renderers.FormatterCellRenderer;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.legend.LegendListener;
import oracle.dmt.dataminer.legend.LegendManager;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.tviewer.TestTrendNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.trend.CTrendTabState;
import oracle.dmt.dataminer.tviewer.trend.TrendEditor;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class TrendTabPanel
extends DataMinerViewGUI {
    CTrendTabState _perfTrendTabState;
    MeasureItem _selectedMeasureItem;
    MeasureItem _predictionConfidenceMeasureItem;
    MeasureItem _avgAccuracyMeasureItem;
    MeasureItem _overallAccuracyMeasureItem;
    MeasureItem _costMeasureItem;
    Context _context;
    private String[] _columnNames = null;
    private JComboBox jCB_Measure;
    private JLabel jLB_Measure;
    private JPanel jPNL_Graph;
    private GenericTable jPerfTable;
    private JSplitPane jSPLPane;
    private JScrollPane jSP_Table;

    public TrendTabPanel(TrendEditor trendEditor, Context context) {
        TestTrendNode testTrendNode = (TestTrendNode)context.getNode();
        if (testTrendNode.getTests() != null && testTrendNode.getTests().size() > 0) {
            this._perfTrendTabState = new CTrendTabState(testTrendNode.getTests(), testTrendNode.getTestGraphColors(), null, null);
        }
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLB_Measure = new JLabel();
        this.jCB_Measure = new JComboBox();
        this.jSPLPane = new JSplitPane();
        this.jSP_Table = new JScrollPane();
        this.jPerfTable = new NiceTable2();
        this.jPNL_Graph = new JPanel();
        this.jLB_Measure.setText("Measure:");
        this.jCB_Measure.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSPLPane.setDividerLocation(400);
        this.jSPLPane.setOrientation(0);
        this.jSPLPane.setOneTouchExpandable(true);
        this.jSPLPane.setPreferredSize(new Dimension(3, 4));
        this.jPerfTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jSP_Table.setViewportView((Component)this.jPerfTable);
        this.jSPLPane.setRightComponent(this.jSP_Table);
        this.jPNL_Graph.setMinimumSize(new Dimension(100, 100));
        this.jPNL_Graph.setLayout(new BorderLayout());
        this.jSPLPane.setLeftComponent(this.jPNL_Graph);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSPLPane, GroupLayout.Alignment.LEADING, -1, 574, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLB_Measure, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_Measure, -2, 133, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_Measure).addComponent(this.jCB_Measure)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSPLPane, -1, 493, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLB_Measure, (Component)this.jCB_Measure, (String)(TestViewerLrb.get("MEASURE") + ":"));
        this.jCB_Measure.removeAllItems();
        this._predictionConfidenceMeasureItem = new MeasureItem(CTrendTabState.Measure.PREDICTIVE_CONFIDENCE, TestViewerLrb.get("PREDICTIVE_CONFIDENCE"));
        this._avgAccuracyMeasureItem = new MeasureItem(CTrendTabState.Measure.AVG_ACCURACY, TestViewerLrb.get("AVG_ACCURACY"));
        this._overallAccuracyMeasureItem = new MeasureItem(CTrendTabState.Measure.OVERALL_ACCURACY, TestViewerLrb.get("OVERALL_ACCURACY"));
        this._costMeasureItem = new MeasureItem(CTrendTabState.Measure.COST, TestViewerLrb.get("COST"));
        this.jCB_Measure.addItem(this._predictionConfidenceMeasureItem);
        this.jCB_Measure.addItem(this._avgAccuracyMeasureItem);
        this.jCB_Measure.addItem(this._overallAccuracyMeasureItem);
        this.jCB_Measure.addItem(this._costMeasureItem);
        this._columnNames = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("MODEL_NAME"), TestViewerLrb.get("ALGORITHM"), this._predictionConfidenceMeasureItem._displayName, this._overallAccuracyMeasureItem._displayName, this._avgAccuracyMeasureItem._displayName, this._costMeasureItem._displayName};
        this.jCB_Measure.addItem(new MeasureItem(CTrendTabState.Measure.MULTIPLE_SELECTION, TestViewerLrb.get("MULTIPLE_SELECTION")));
        this._selectedMeasureItem = this._predictionConfidenceMeasureItem;
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.jCB_Measure.setSelectedItem(this._selectedMeasureItem);
        this.jSP_Table.setVisible(false);
        this.jCB_Measure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrendTabPanel.this._selectedMeasureItem = (MeasureItem)TrendTabPanel.this.jCB_Measure.getSelectedItem();
                TrendTabPanel.this.reloadGraphPanel();
            }
        });
        this.registerWithLegendDockable();
        LoadUI loadUI = new LoadUI();
        this.jPNL_Graph.add(GraphPanel.LOADING_GRAPH);
        loadUI.execute();
    }

    private void registerWithLegendDockable() {
        LegendManager.getLegendManager().getLegendWindow().addLegendListener(new TestLegendListener(), (View)this._editor);
    }

    private void reloadGraphPanel() {
        this.jPerfTable.setDefaultRenderer(Double.class, (TableCellRenderer)new FormatterCellRenderer());
        this.jPerfTable.setDefaultRenderer(Date.class, (TableCellRenderer)new FormatterCellRenderer());
        if (CTrendTabState.Measure.MULTIPLE_SELECTION.equals((Object)this._selectedMeasureItem._measure)) {
            this.jPerfTable.setHiddenColumns(new int[0]);
            this.jPerfTable.setSortColumn(1, false);
            this.jPNL_Graph.removeAll();
            this.jPNL_Graph.setLayout(new GridLayout(2, 2));
            this.jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.PREDICTIVE_CONFIDENCE)));
            this.jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.OVERALL_ACCURACY)));
            this.jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.AVG_ACCURACY)));
            GraphDataModel graphDataModel = this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.COST);
            if (graphDataModel != null) {
                this.jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.COST)));
            }
            this.jPNL_Graph.updateUI();
            this.jPerfTable.setHiddenColumns(new int[]{2, 3});
            this.jPerfTable.setSortColumn(1, true);
        } else {
            this.jPNL_Graph.removeAll();
            this.jPNL_Graph.setLayout(new BorderLayout());
            this.jPNL_Graph.add((Component)new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(this._selectedMeasureItem._measure)), "Center");
            this.jPNL_Graph.updateUI();
            if (CTrendTabState.Measure.PREDICTIVE_CONFIDENCE.equals((Object)this._selectedMeasureItem._measure)) {
                this.jPerfTable.setHiddenColumns(new int[]{2, 3, 5, 6, 7});
            } else if (CTrendTabState.Measure.OVERALL_ACCURACY.equals((Object)this._selectedMeasureItem._measure)) {
                this.jPerfTable.setHiddenColumns(new int[]{2, 3, 4, 6, 7});
            } else if (CTrendTabState.Measure.AVG_ACCURACY.equals((Object)this._selectedMeasureItem._measure)) {
                this.jPerfTable.setHiddenColumns(new int[]{2, 3, 4, 5, 7});
            } else if (CTrendTabState.Measure.COST.equals((Object)this._selectedMeasureItem._measure)) {
                this.jPerfTable.setHiddenColumns(new int[]{2, 3, 4, 5, 6});
            } else {
                this.jPerfTable.setHiddenColumns(new int[]{2, 3});
            }
            this.jPerfTable.setSortColumn(1, true);
        }
    }

    public void setLegendState(LegendEvent legendEvent) {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
        this.repaint();
    }

    private class TestLegendListener
    implements LegendListener {
        private TestLegendListener() {
        }

        @Override
        public void addEvent(LegendEvent legendEvent) {
            TrendTabPanel.this.setLegendState(legendEvent);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(TrendTabPanel.this._context);
                TrendTabPanel.this._perfTrendTabState.load(connection);
                GenericBaseTableModel genericBaseTableModel = TrendTabPanel.this._perfTrendTabState.getPerformanceTableModel();
                genericBaseTableModel.setColumnIdentifiers((Object[])TrendTabPanel.this._columnNames);
                TrendTabPanel.this.jPerfTable.setModel((TableModel)TrendTabPanel.this._perfTrendTabState.getPerformanceTableModel());
                TrendTabPanel.this.jPerfTable.setSorted(true);
                TrendTabPanel.this.jPerfTable.setSortColumn(1, true);
                TrendTabPanel.this.jPerfTable.getColumnModel().getColumn(1).setCellRenderer(new FormatterCellRenderer());
                TrendTabPanel.this.jPerfTable.getColumnModel().getColumn(4).setCellRenderer(new FormatterCellRenderer());
                TrendTabPanel.this.jPerfTable.getColumnModel().getColumn(5).setCellRenderer(new FormatterCellRenderer());
                TrendTabPanel.this.jPerfTable.getColumnModel().getColumn(6).setCellRenderer(new FormatterCellRenderer());
                TrendTabPanel.this.jPerfTable.getColumnModel().getColumn(7).setCellRenderer(new FormatterCellRenderer());
                TrendTabPanel.this.jPerfTable.setDefaultRenderer(Double.class, (TableCellRenderer)new FormatterCellRenderer());
                TrendTabPanel.this.jPerfTable.setDefaultRenderer(Date.class, (TableCellRenderer)new FormatterCellRenderer());
                TrendTabPanel.this.jPerfTable.setHiddenColumns(new int[]{2, 3, 5, 6, 7});
                this._success = true;
            }
            catch (Exception exception) {
                try {
                    this._ex = exception;
                    this._success = false;
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
            }
            SQLHelper.close(connection);
            return TrendTabPanel.this._perfTrendTabState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    TrendTabPanel.this.jPNL_Graph.removeAll();
                    TrendTabPanel.this.jPNL_Graph.add((Component)new TimeSeriesGraphPanel(TrendTabPanel.this._perfTrendTabState.getGraphDataModel(TrendTabPanel.this._selectedMeasureItem._measure)), "Center");
                    TrendTabPanel.this.jSP_Table.setVisible(true);
                    TrendTabPanel.this.jPNL_Graph.updateUI();
                    TrendTabPanel.this.jSPLPane.setDividerLocation(0.8);
                    TrendTabPanel.this.jSPLPane.setResizeWeight(1.0);
                    TrendTabPanel.this.setLoaded(true);
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                TrendTabPanel.this.setLoading(false);
            }
        }
    }

    private class MeasureItem {
        CTrendTabState.Measure _measure;
        String _displayName;

        public MeasureItem(CTrendTabState.Measure measure, String string) {
            this._measure = measure;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof MeasureItem) {
                return this._measure.equals((Object)((MeasureItem)object)._measure);
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 53 * n + (this._measure != null ? this._measure.hashCode() : 0);
            return n;
        }
    }
}

