/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public class AttributeTypeHelper {
    private static final Logger theLogger = Logger.getLogger(AttributeTypeHelper.class.getName());
    public static final int NAME_MAX_LENGTH = 30;
    private static final String NO_TRANSFORM_DISTINCT_AGG = " /*+ NO_TRANSFORM_DISTINCT_AGG */ ";
    private static final String NOT_NULL = " IS NOT NULL ";
    private static final String WHERE = " WHERE ";
    private static String _maintable_alias = "t0";
    private static String DBMS_SQL_PARSE_AGGREGATE = "DECLARE   curid      NUMBER;\n  ret_value  NUMBER;\n  id_var     NUMBER;\nBEGIN\n  curid := DBMS_SQL.OPEN_CURSOR;\n  DBMS_SQL.PARSE(curid, 'select count (*) from ([SQL_EXPRESSION])', DBMS_SQL.NATIVE);\n  DBMS_SQL.DEFINE_COLUMN (curid, 1, id_var);\n  ret_value := DBMS_SQL.EXECUTE(curid);\n  ret_value := DBMS_SQL.FETCH_ROWS(curid);\n  DBMS_SQL.COLUMN_VALUE(curid, 1, id_var);\n  DBMS_SQL.CLOSE_CURSOR(curid);\n  EXCEPTION WHEN OTHERS THEN\n    DBMS_SQL.CLOSE_CURSOR(curid);\n    RAISE;  \nEND;\n";

    private static String getHint(Context context) {
        String string = NO_TRANSFORM_DISTINCT_AGG;
        try {
            Version version = DatabaseMetadataUtils.getDatabaseVersion(context);
            Version version2 = new Version("11.2.0.1.2");
            if (version2.compareTo((Object)version) <= 0) {
                string = " ";
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        return string;
    }

    public static ExTransformationSourceAttribute[] toExTransformationSourceAttributes(TransformationSourceAttribute[] transformationSourceAttributeArray) {
        ExTransformationSourceAttribute[] exTransformationSourceAttributeArray = new ExTransformationSourceAttribute[transformationSourceAttributeArray.length];
        for (int i = 0; i < transformationSourceAttributeArray.length; ++i) {
            exTransformationSourceAttributeArray[i] = new ExTransformationSourceAttribute(transformationSourceAttributeArray[i]);
        }
        return exTransformationSourceAttributeArray;
    }

    public static void copyAttribute(AttributeType attributeType, AttributeType attributeType2) {
        attributeType.setName(attributeType2.getName());
        attributeType.setAlias(attributeType2.getAlias());
        attributeType.setDataType(attributeType2.getDataType());
        attributeType.setStatus(attributeType2.getStatus());
        attributeType.setAnnotation(attributeType2.getAnnotation());
    }

    public static TransformationNodeColumns getAllColumns(TransformationNodeType transformationNodeType) {
        TransformationNodeColumns transformationNodeColumns = new TransformationNodeColumns(transformationNodeType.getTransformedAttributes(), transformationNodeType.getTransformationSourceAttributes());
        return transformationNodeColumns;
    }

    public static TextTransformationNodeColumns getAllColumns(TextNodeType textNodeType) {
        TextTransformationNodeColumns textTransformationNodeColumns = new TextTransformationNodeColumns(textNodeType.getTransformedAttributes(), textNodeType.getTransformationSourceAttributes());
        return textTransformationNodeColumns;
    }

    public static TextTransformationNodeColumns getAllColumns(TransformedAttributesType transformedAttributesType, TransformationSourceAttributes transformationSourceAttributes) {
        TextTransformationNodeColumns textTransformationNodeColumns = new TextTransformationNodeColumns(transformedAttributesType, transformationSourceAttributes);
        return textTransformationNodeColumns;
    }

    public static TransformedAttributesType cloneTransformedAttributesType(TransformedAttributesType transformedAttributesType) {
        return (TransformedAttributesType)MetaDataHelper.copyMetadataObject(transformedAttributesType);
    }

    public static void copyTransformedAttributesType(TransformedAttributesType transformedAttributesType, TransformedAttributesType transformedAttributesType2) {
        if (null == transformedAttributesType2 || transformedAttributesType == null) {
            return;
        }
        TransformedAttributesType transformedAttributesType3 = AttributeTypeHelper.cloneTransformedAttributesType(transformedAttributesType2);
        transformedAttributesType.getMapTextTransformedSource().clear();
        List list = transformedAttributesType.getMapTextTransformedSource();
        for (MapTextTransformedSourceType mapTextTransformedSourceType : transformedAttributesType3.getMapTextTransformedSource()) {
            list.add(mapTextTransformedSourceType);
        }
    }

    public static void copyMapTextTransformedSource(MapTextTransformedSourceType mapTextTransformedSourceType, MapTextTransformedSourceType mapTextTransformedSourceType2) {
        AttributeTypeHelper.copyTextTransformationOutputAttribute(mapTextTransformedSourceType.getKey(), mapTextTransformedSourceType2.getKey());
    }

    public static void copyTextTransformationOutputAttribute(TextTransformationOutputAttributeType textTransformationOutputAttributeType, TextTransformationOutputAttributeType textTransformationOutputAttributeType2) {
        AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)textTransformationOutputAttributeType, (TransformationSourceAttribute)textTransformationOutputAttributeType2);
        textTransformationOutputAttributeType.setTransformationElement(AttributeTypeHelper.cloneTextTransformationType(textTransformationOutputAttributeType2.getTransformationElement()));
        textTransformationOutputAttributeType.setModified(textTransformationOutputAttributeType2.isModified());
    }

    public static TextTransformationType cloneTextTransformationType(TextTransformationType textTransformationType) {
        return (TextTransformationType)MetaDataHelper.copyMetadataObject(textTransformationType);
    }

    public static UpdateTableNodeType cloneUpdateTableNodeType(UpdateTableNodeType updateTableNodeType) {
        UpdateTableNodeType updateTableNodeType2 = new UpdateTableNodeType();
        updateTableNodeType2.setAutoSpec(updateTableNodeType.getAutoSpec());
        updateTableNodeType2.setDropExisting(updateTableNodeType.isDropExisting());
        updateTableNodeType2.setUpdateTargetTable(updateTableNodeType.getUpdateTargetTable());
        UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        updateTableNodeType2.setUpdateTableAttributes(updateTableAttributes);
        UpdateTableAttributes updateTableAttributes2 = updateTableNodeType.getUpdateTableAttributes();
        UpdateTableNode.copyAttributes(list, updateTableAttributes2.getUpdateTableItemType());
        return updateTableNodeType2;
    }

    public static void copyUpdateTableNodeType(UpdateTableNodeType updateTableNodeType, UpdateTableNodeType updateTableNodeType2) {
        updateTableNodeType2.setAutoSpec(updateTableNodeType.getAutoSpec());
        updateTableNodeType2.setDropExisting(updateTableNodeType.isDropExisting());
        updateTableNodeType2.setUpdateTargetTable(updateTableNodeType.getUpdateTargetTable());
        UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        updateTableNodeType2.setUpdateTableAttributes(updateTableAttributes);
        UpdateTableAttributes updateTableAttributes2 = updateTableNodeType.getUpdateTableAttributes();
        UpdateTableNode.copyAttributes(list, updateTableAttributes2.getUpdateTableItemType());
    }

    public static TransformationNodeType cloneTransformationNodeType(TransformationNodeType transformationNodeType) {
        SampleSettings.Method.Random random;
        TransformationNodeType transformationNodeType2 = new TransformationNodeType();
        TransformedAttributes transformedAttributes = null;
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        if (null != transformationNodeType) {
            transformedAttributes = AttributeTypeHelper.cloneTransformedAttributes(transformationNodeType.getTransformedAttributes());
            if (null != transformationNodeType.getTransformationSourceAttributes()) {
                AttributeTypeHelper.copyTransformationSourceAttributes(transformationSourceAttributes.getTransformationSourceAttributeType(), transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType());
            }
        }
        transformationNodeType2.setTransformationSourceAttributes(transformationSourceAttributes);
        transformationNodeType2.setTransformedAttributes(transformedAttributes);
        ResultType resultType = new ResultType();
        if (null != transformationNodeType.getInputStatisticTable()) {
            resultType.setCreationDate(transformationNodeType.getInputStatisticTable().getCreationDate());
            resultType.setName(transformationNodeType.getInputStatisticTable().getName());
        }
        transformationNodeType2.setInputStatisticTable(resultType);
        ResultType resultType2 = new ResultType();
        if (null != transformationNodeType.getTransformedStatisticTable()) {
            resultType2.setCreationDate(transformationNodeType.getTransformedStatisticTable().getCreationDate());
            resultType2.setName(transformationNodeType.getTransformedStatisticTable().getName());
        }
        transformationNodeType2.setTransformedStatisticTable(resultType2);
        SampleSettings sampleSettings = transformationNodeType.getSampleSettings();
        SampleSettings sampleSettings2 = new SampleSettings();
        sampleSettings2.setNumberOfRows(sampleSettings.getNumberOfRows());
        sampleSettings2.setPercentOfTotal(sampleSettings.getPercentOfTotal());
        SampleSettings.Method method = new SampleSettings.Method();
        if (sampleSettings.getMethod().getRandom() != null) {
            random = new SampleSettings.Method.Random();
            random.setSeed(sampleSettings.getMethod().getRandom().getSeed());
            method.setRandom(random);
        } else if (sampleSettings.getMethod().getStratified() != null) {
            random = new SampleSettings.Method.Stratified();
            random.setTargetAttr(sampleSettings.getMethod().getStratified().getTargetAttr());
            method.setStratified((SampleSettings.Method.Stratified)random);
        } else if (sampleSettings.getMethod().getTopN() != null) {
            random = new SampleSettings.Method.TopN();
            method.setTopN((SampleSettings.Method.TopN)random);
        }
        sampleSettings2.setMethod(method);
        sampleSettings2.setUseFullData(sampleSettings.isUseFullData());
        sampleSettings2.setGenerateCache(Boolean.valueOf(sampleSettings.isGenerateCache()));
        random = new ResultType();
        ResultType resultType3 = sampleSettings.getOutputTable();
        if (resultType3 != null) {
            if (resultType3.getCreationDate() != null) {
                random.setCreationDate(resultType3.getCreationDate());
            }
            if (resultType3.getName() != null) {
                random.setName(resultType3.getName());
            }
        }
        sampleSettings2.setOutputTable((ResultType)random);
        transformationNodeType2.setSampleSettings(sampleSettings2);
        StatsSelection statsSelection = new StatsSelection();
        StatsSelection statsSelection2 = transformationNodeType.getStatsSelection();
        if (statsSelection2 != null) {
            statsSelection.setAvg(Boolean.valueOf(statsSelection2.isAvg()));
            statsSelection.setKurtosis(Boolean.valueOf(statsSelection2.isKurtosis()));
            statsSelection.setMax(Boolean.valueOf(statsSelection2.isMax()));
            statsSelection.setMedian(Boolean.valueOf(statsSelection2.isMedian()));
            statsSelection.setMin(Boolean.valueOf(statsSelection2.isMin()));
            statsSelection.setMode(Boolean.valueOf(statsSelection2.isMode()));
            statsSelection.setModeall(Boolean.valueOf(statsSelection2.isModeall()));
            statsSelection.setModesampled(Boolean.valueOf(statsSelection2.isModesampled()));
            statsSelection.setPercentdistinct(Boolean.valueOf(statsSelection2.isPercentdistinct()));
            statsSelection.setPercentnull(Boolean.valueOf(statsSelection2.isPercentnull()));
            statsSelection.setSkewness(Boolean.valueOf(statsSelection2.isSkewness()));
            statsSelection.setStd(Boolean.valueOf(statsSelection2.isStd()));
            statsSelection.setVar(Boolean.valueOf(statsSelection2.isVar()));
            statsSelection.setHistogram(Boolean.valueOf(statsSelection2.isHistogram()));
        } else {
            statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        transformationNodeType2.setStatsSelection(statsSelection);
        return transformationNodeType2;
    }

    public static TransformedAttributes cloneTransformedAttributes(TransformedAttributes transformedAttributes) {
        TransformedAttributes transformedAttributes2 = new TransformedAttributes();
        if (null == transformedAttributes) {
            return transformedAttributes2;
        }
        List list = transformedAttributes2.getMapTransformedSourceType();
        if (null != transformedAttributes && !transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (MapTransformedSource mapTransformedSource : transformedAttributes.getMapTransformedSourceType()) {
                MapTransformedSource mapTransformedSource2 = new MapTransformedSource();
                TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
                TransformationOutputAttribute transformationOutputAttribute2 = new TransformationOutputAttribute();
                AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute2, (TransformationSourceAttribute)transformationOutputAttribute);
                transformationOutputAttribute2.setTransformationElementType(AttributeTypeHelper.cloneTransformationType(transformationOutputAttribute.getTransformationElementType()));
                transformationOutputAttribute2.setModified(transformationOutputAttribute.isModified());
                mapTransformedSource2.setKey(transformationOutputAttribute2);
                StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
                StringCollection stringCollection2 = new StringCollection();
                if (stringCollection != null) {
                    stringCollection2.getValue().addAll(stringCollection.getValue());
                }
                mapTransformedSource2.setStringCollectionNames(stringCollection2);
                list.add(mapTransformedSource2);
            }
        }
        return transformedAttributes2;
    }

    public static MapTransformedSource cloneMapTransformedSource(MapTransformedSource mapTransformedSource) {
        MapTransformedSource mapTransformedSource2 = new MapTransformedSource();
        TransformationOutputAttribute transformationOutputAttribute = new TransformationOutputAttribute();
        AttributeTypeHelper.copyTransformationOutputAttribute(transformationOutputAttribute, mapTransformedSource.getKey());
        mapTransformedSource2.setKey(transformationOutputAttribute);
        StringCollection stringCollection = new StringCollection();
        stringCollection.getValue().addAll(mapTransformedSource.getStringCollectionNames().getValue());
        mapTransformedSource2.setStringCollectionNames(stringCollection);
        return mapTransformedSource2;
    }

    public static void copyMapTransformedSource(MapTransformedSource mapTransformedSource, MapTransformedSource mapTransformedSource2) {
        AttributeTypeHelper.copyTransformationOutputAttribute(mapTransformedSource.getKey(), mapTransformedSource2.getKey());
        mapTransformedSource.getStringCollectionNames().getValue().clear();
        mapTransformedSource.getStringCollectionNames().getValue().addAll(mapTransformedSource2.getStringCollectionNames().getValue());
    }

    public static MapTransformedSource findMapTransformedSource(TransformedAttributes transformedAttributes, AttributeType attributeType) {
        return AttributeTypeHelper.findMapTransformedSource(transformedAttributes, attributeType.getName());
    }

    public static MapTransformedSource findMapTransformedSource(TransformedAttributes transformedAttributes, String string) {
        MapTransformedSource mapTransformedSource = null;
        List list = transformedAttributes.getMapTransformedSourceType();
        for (MapTransformedSource mapTransformedSource2 : list) {
            if (!mapTransformedSource2.getKey().getName().equals(string)) continue;
            mapTransformedSource = mapTransformedSource2;
            break;
        }
        return mapTransformedSource;
    }

    public static void copyTransformedAttributes(TransformedAttributes transformedAttributes, TransformedAttributes transformedAttributes2) {
        if (null == transformedAttributes2 || transformedAttributes == null) {
            return;
        }
        transformedAttributes.getMapTransformedSourceType().clear();
        List list = transformedAttributes.getMapTransformedSourceType();
        if (null != transformedAttributes2 && !transformedAttributes2.getMapTransformedSourceType().isEmpty()) {
            for (MapTransformedSource mapTransformedSource : transformedAttributes2.getMapTransformedSourceType()) {
                MapTransformedSource mapTransformedSource2 = new MapTransformedSource();
                TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
                TransformationOutputAttribute transformationOutputAttribute2 = new TransformationOutputAttribute();
                AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute2, (TransformationSourceAttribute)transformationOutputAttribute);
                transformationOutputAttribute2.setTransformationElementType(AttributeTypeHelper.cloneTransformationType(transformationOutputAttribute.getTransformationElementType()));
                transformationOutputAttribute2.setModified(transformationOutputAttribute.isModified());
                mapTransformedSource2.setKey(transformationOutputAttribute2);
                StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
                StringCollection stringCollection2 = new StringCollection();
                if (stringCollection != null) {
                    stringCollection2.getValue().addAll(stringCollection.getValue());
                }
                mapTransformedSource2.setStringCollectionNames(stringCollection2);
                list.add(mapTransformedSource2);
            }
        }
    }

    public static Vector<TransformationSourceAttribute> toVector(List<TransformationSourceAttribute> list) {
        Vector<TransformationSourceAttribute> vector = new Vector<TransformationSourceAttribute>(list);
        return vector;
    }

    public static TransformationType cloneTransformationType(TransformationType transformationType) {
        TransformationType transformationType2 = new TransformationType();
        if (null != transformationType.getBinning()) {
            TransformationType.Binning binning = transformationType.getBinning();
            TransformationType.Binning binning2 = new TransformationType.Binning();
            if (null != binning.getQuantile()) {
                TransformationType.Binning.Quantile quantile = new TransformationType.Binning.Quantile();
                quantile.setBinCount(binning.getQuantile().getBinCount());
                quantile.setBinGeneration(binning.getQuantile().getBinGeneration());
                quantile.setBinLabels(binning.getQuantile().getBinLabels());
                binning2.setQuantile(quantile);
            } else if (null != binning.getCustomCategorical() && null != binning.getCustomCategorical().getCategoricalBin()) {
                TransformationType.Binning.CustomCategorical customCategorical = new TransformationType.Binning.CustomCategorical();
                List list = customCategorical.getCategoricalBin();
                for (CategoricalBin categoricalBin : binning.getCustomCategorical().getCategoricalBin()) {
                    CategoricalBin categoricalBin2 = new CategoricalBin();
                    categoricalBin2.setIsOther(categoricalBin.isIsOther());
                    categoricalBin2.setName(categoricalBin.getName());
                    StringCollection stringCollection = categoricalBin.getStringCollectionValues();
                    if (stringCollection != null) {
                        StringCollection stringCollection2 = new StringCollection();
                        stringCollection2.getValue().addAll(stringCollection.getValue());
                        categoricalBin2.setStringCollectionValues(stringCollection2);
                    }
                    list.add(categoricalBin2);
                }
                binning2.setCustomCategorical(customCategorical);
            } else if (null != binning.getCustomNumeric() && null != binning.getCustomNumeric().getNumericBin()) {
                TransformationType.Binning.CustomNumeric customNumeric = new TransformationType.Binning.CustomNumeric();
                List list = customNumeric.getNumericBin();
                for (NumericBin numericBin : binning.getCustomNumeric().getNumericBin()) {
                    NumericBin numericBin2 = new NumericBin();
                    numericBin2.setBinName(numericBin.getBinName());
                    numericBin2.setLowerBound(numericBin.getLowerBound());
                    list.add(numericBin2);
                }
                BinLabels binLabels = new BinLabels();
                if (null != binning.getCustomNumeric().getBinLabels().getNumberSequence()) {
                    binLabels.setNumberSequence(new BinLabels.NumberSequence());
                } else {
                    binLabels.setRange(new BinLabels.Range());
                }
                customNumeric.setBinLabels(binLabels);
                binning2.setCustomNumeric(customNumeric);
            } else if (null != binning.getCustomDate() && null != binning.getCustomDate().getDateBin()) {
                TransformationType.Binning.CustomDate customDate = new TransformationType.Binning.CustomDate();
                List list = customDate.getDateBin();
                for (DateBin dateBin : binning.getCustomDate().getDateBin()) {
                    DateBin dateBin2 = new DateBin();
                    dateBin2.setName(dateBin.getName());
                    dateBin2.setLowerBound(dateBin.getLowerBound());
                    list.add(dateBin2);
                }
                BinLabels binLabels = new BinLabels();
                if (null != binning.getCustomDate().getBinLabels().getNumberSequence()) {
                    binLabels.setNumberSequence(new BinLabels.NumberSequence());
                } else {
                    binLabels.setRange(new BinLabels.Range());
                }
                customDate.setBinLabels(binLabels);
                binning2.setCustomDate(customDate);
            } else if (null != binning.getCustomTimestamp() && null != binning.getCustomTimestamp().getTimestampTimezoneBin()) {
                TransformationType.Binning.CustomTimestamp customTimestamp = new TransformationType.Binning.CustomTimestamp();
                List list = customTimestamp.getTimestampTimezoneBin();
                for (TimestampTimezoneBin timestampTimezoneBin : binning.getCustomTimestamp().getTimestampTimezoneBin()) {
                    TimestampTimezoneBin timestampTimezoneBin2 = new TimestampTimezoneBin();
                    timestampTimezoneBin2.setName(timestampTimezoneBin.getName());
                    timestampTimezoneBin2.setLowerBound(timestampTimezoneBin.getLowerBound());
                    list.add(timestampTimezoneBin2);
                }
                BinLabels binLabels = new BinLabels();
                if (null != binning.getCustomTimestamp().getBinLabels().getNumberSequence()) {
                    binLabels.setNumberSequence(new BinLabels.NumberSequence());
                } else {
                    binLabels.setRange(new BinLabels.Range());
                }
                customTimestamp.setBinLabels(binLabels);
                binning2.setCustomTimestamp(customTimestamp);
            } else if (null != binning.getEqualWidth()) {
                TransformationType.Binning.EqualWidth equalWidth = new TransformationType.Binning.EqualWidth();
                equalWidth.setBinCount(binning.getEqualWidth().getBinCount());
                equalWidth.setBinGeneration(binning.getEqualWidth().getBinGeneration());
                equalWidth.setBinLabels(binning.getEqualWidth().getBinLabels());
                binning2.setEqualWidth(equalWidth);
            } else if (null != binning.getDateEqualWidth()) {
                TransformationType.Binning.DateEqualWidth dateEqualWidth = new TransformationType.Binning.DateEqualWidth();
                dateEqualWidth.setBinCount(binning.getDateEqualWidth().getBinCount());
                dateEqualWidth.setBinGeneration(binning.getDateEqualWidth().getBinGeneration());
                dateEqualWidth.setBinLabels(binning.getDateEqualWidth().getBinLabels());
                binning2.setDateEqualWidth(dateEqualWidth);
            } else if (null != binning.getTimestampEqualWidth()) {
                TransformationType.Binning.TimestampEqualWidth timestampEqualWidth = new TransformationType.Binning.TimestampEqualWidth();
                timestampEqualWidth.setBinCount(binning.getTimestampEqualWidth().getBinCount());
                timestampEqualWidth.setBinGeneration(binning.getTimestampEqualWidth().getBinGeneration());
                timestampEqualWidth.setBinLabels(binning.getTimestampEqualWidth().getBinLabels());
                binning2.setTimestampEqualWidth(timestampEqualWidth);
            } else if (null != binning.getTopN()) {
                TransformationType.Binning.TopN topN = new TransformationType.Binning.TopN();
                topN.setBinCount(binning.getTopN().getBinCount());
                topN.setOther(binning.getTopN().getOther());
                binning2.setTopN(topN);
            }
            transformationType2.setBinning(binning2);
        } else if (null != transformationType.getCustomTransformation()) {
            TransformationType.CustomTransformation customTransformation = transformationType.getCustomTransformation();
            TransformationType.CustomTransformation customTransformation2 = new TransformationType.CustomTransformation();
            customTransformation2.setValue(customTransformation.getValue());
            transformationType2.setCustomTransformation(customTransformation2);
        } else if (null != transformationType.getMissingValuesCategorical()) {
            TransformationType.MissingValuesCategorical missingValuesCategorical = transformationType.getMissingValuesCategorical();
            TransformationType.MissingValuesCategorical missingValuesCategorical2 = new TransformationType.MissingValuesCategorical();
            missingValuesCategorical2.setValue(missingValuesCategorical.getValue());
            missingValuesCategorical2.setCategoricalStatistic(missingValuesCategorical.getCategoricalStatistic());
            transformationType2.setMissingValuesCategorical(missingValuesCategorical2);
        } else if (null != transformationType.getMissingValuesDate()) {
            TransformationType.MissingValuesDate missingValuesDate = transformationType.getMissingValuesDate();
            TransformationType.MissingValuesDate missingValuesDate2 = new TransformationType.MissingValuesDate();
            missingValuesDate2.setValue(missingValuesDate.getValue());
            missingValuesDate2.setDateStatistic(missingValuesDate.getDateStatistic());
            transformationType2.setMissingValuesDate(missingValuesDate2);
        } else if (null != transformationType.getMissingValuesNumeric()) {
            TransformationType.MissingValuesNumeric missingValuesNumeric = transformationType.getMissingValuesNumeric();
            TransformationType.MissingValuesNumeric missingValuesNumeric2 = new TransformationType.MissingValuesNumeric();
            missingValuesNumeric2.setValue(missingValuesNumeric.getValue());
            missingValuesNumeric2.setNumericStatistic(missingValuesNumeric.getNumericStatistic());
            transformationType2.setMissingValuesNumeric(missingValuesNumeric2);
        } else if (null != transformationType.getNormalization()) {
            TransformationType.Normalization normalization = transformationType.getNormalization();
            TransformationType.Normalization normalization2 = new TransformationType.Normalization();
            normalization2.setLinearScale(normalization.getLinearScale());
            normalization2.setMinMax(normalization.getMinMax());
            normalization2.setZScore(normalization.getZScore());
            normalization2.setManual(normalization.getManual());
            transformationType2.setNormalization(normalization2);
        } else if (null != transformationType.getOutlier()) {
            TransformationType.Outlier outlier = transformationType.getOutlier();
            TransformationType.Outlier outlier2 = new TransformationType.Outlier();
            outlier2.setPercent(outlier.getPercent());
            outlier2.setValue(outlier.getValue());
            outlier2.setStandardDeviation(outlier.getStandardDeviation());
            outlier2.setReplaceWith(outlier.getReplaceWith());
            transformationType2.setOutlier(outlier2);
        }
        return transformationType2;
    }

    public static void copyTransformationSourceAttribute(TransformationSourceAttribute transformationSourceAttribute, TransformationSourceAttribute transformationSourceAttribute2) {
        transformationSourceAttribute.setIsOutput(transformationSourceAttribute2.isIsOutput());
        AttributeTypeHelper.copyAttribute((AttributeType)transformationSourceAttribute, (AttributeType)transformationSourceAttribute2);
    }

    public static void copyTransformationOutputAttribute(TransformationOutputAttribute transformationOutputAttribute, TransformationOutputAttribute transformationOutputAttribute2) {
        AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute, (TransformationSourceAttribute)transformationOutputAttribute2);
        transformationOutputAttribute.setTransformationElementType(AttributeTypeHelper.cloneTransformationType(transformationOutputAttribute2.getTransformationElementType()));
        transformationOutputAttribute.setModified(transformationOutputAttribute2.isModified());
    }

    public static TransformationSourceAttribute cloneTransformationAttribute(AttributeType attributeType) {
        TransformationOutputAttribute transformationOutputAttribute = null;
        if (attributeType instanceof TransformationOutputAttribute) {
            transformationOutputAttribute = new TransformationOutputAttribute();
            AttributeTypeHelper.copyTransformationOutputAttribute(transformationOutputAttribute, (TransformationOutputAttribute)attributeType);
        } else if (attributeType instanceof TransformationSourceAttribute) {
            transformationOutputAttribute = new TransformationSourceAttribute();
            AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute, (TransformationSourceAttribute)attributeType);
        }
        return transformationOutputAttribute;
    }

    public static void copyTransformationSourceAttributes(List<TransformationSourceAttribute> list, List<TransformationSourceAttribute> list2) {
        list.clear();
        for (TransformationSourceAttribute transformationSourceAttribute : list2) {
            TransformationSourceAttribute transformationSourceAttribute2 = new TransformationSourceAttribute();
            AttributeTypeHelper.copyTransformationSourceAttribute(transformationSourceAttribute2, transformationSourceAttribute);
            list.add(transformationSourceAttribute2);
        }
    }

    public static String createUniqueTransformationOutputNameWizard(String string, String string2, List<TransformationSourceAttribute> list, List<MapTransformedSource> list2, List<String> list3) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (list3 != null) {
            for (String string3 : list3) {
                hashMap.put(string3, new AttributeType());
            }
        }
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), (AttributeType)transformationSourceAttribute);
        }
        for (MapTransformedSource mapTransformedSource : list2) {
            hashMap.put(mapTransformedSource.getKey().getName(), (AttributeType)mapTransformedSource.getKey());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    public static String createUniqueTransformationOutputName(String string, String string2, List<TransformationSourceAttribute> list, List<MapTransformedSource> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), (AttributeType)transformationSourceAttribute);
        }
        for (MapTransformedSource mapTransformedSource : list2) {
            hashMap.put(mapTransformedSource.getKey().getName(), (AttributeType)mapTransformedSource.getKey());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    public static String createUniqueTextTransformationOutputName(String string, String string2, List<TransformationSourceAttribute> list, List<MapTextTransformedSourceType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), (AttributeType)transformationSourceAttribute);
        }
        for (MapTextTransformedSourceType mapTextTransformedSourceType : list2) {
            hashMap.put(mapTextTransformedSourceType.getKey().getName(), (AttributeType)mapTextTransformedSourceType.getKey());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    public static boolean isUniqueTransformationOutputName(String string, List<TransformationSourceAttribute> list, List<MapTransformedSource> list2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        for (MapTransformedSource mapTransformedSource : list2) {
            hashMap.put(mapTransformedSource.getKey().getName(), mapTransformedSource.getKey());
        }
        return null == hashMap.get(string);
    }

    public static void copyAttributes(List<AggregationElementType> list, List<AggregationElementType> list2, Map<String, AggregationElementType> map) {
        for (AggregationElementType aggregationElementType : list2) {
            if (map != null && !map.isEmpty() && null != map.get(aggregationElementType.getOutput().getName())) continue;
            AggregationElementType aggregationElementType2 = new AggregationElementType();
            aggregationElementType2.setAggregationFunction(aggregationElementType.getAggregationFunction());
            AttributeType attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, aggregationElementType.getOutput());
            aggregationElementType2.setOutput(attributeType);
            GroupingElementType groupingElementType = new GroupingElementType();
            GroupingElementType groupingElementType2 = aggregationElementType.getSource();
            AttributeTypeHelper.copyGroupingElementType(groupingElementType, groupingElementType2);
            aggregationElementType2.setSource(groupingElementType);
            GroupingElementType groupingElementType3 = new GroupingElementType();
            GroupingElementType groupingElementType4 = aggregationElementType.getSubGroupBy();
            if (groupingElementType4 != null) {
                AttributeTypeHelper.copyGroupingElementType(groupingElementType3, groupingElementType4);
            }
            aggregationElementType2.setSubGroupBy(groupingElementType3);
            list.add(aggregationElementType2);
        }
    }

    public static AggregationElementType cloneAggregationElementType(AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType;
        AttributeType attributeType;
        AggregationElementType aggregationElementType2 = new AggregationElementType();
        aggregationElementType2.setAggregationFunction(aggregationElementType.getAggregationFunction());
        if (null != aggregationElementType.getOutput()) {
            attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, aggregationElementType.getOutput());
            aggregationElementType2.setOutput(attributeType);
        }
        if (null != aggregationElementType.getSource()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType.getSource();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType2.setSource((GroupingElementType)attributeType);
        }
        if (null != aggregationElementType.getSubGroupBy()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType.getSubGroupBy();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType2.setSubGroupBy((GroupingElementType)attributeType);
        }
        return aggregationElementType2;
    }

    public static void copyAggregationElementType(AggregationElementType aggregationElementType, AggregationElementType aggregationElementType2) {
        GroupingElementType groupingElementType;
        AttributeType attributeType;
        aggregationElementType.setAggregationFunction(aggregationElementType2.getAggregationFunction());
        if (null != aggregationElementType2.getOutput()) {
            attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, aggregationElementType2.getOutput());
            aggregationElementType.setOutput(attributeType);
        }
        if (null != aggregationElementType2.getSource()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType2.getSource();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType.setSource((GroupingElementType)attributeType);
        }
        if (null != aggregationElementType2.getSubGroupBy()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType2.getSubGroupBy();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType.setSubGroupBy((GroupingElementType)attributeType);
        }
    }

    public static void copyAttributes(List<AggregationElementType> list, List<AggregationElementType> list2) {
        AttributeTypeHelper.copyAttributes(list, list2, null);
    }

    public static void copyGroupingElementType(GroupingElementType groupingElementType, GroupingElementType groupingElementType2) {
        if (null != groupingElementType2.getExpression()) {
            groupingElementType.setExpression(groupingElementType2.getExpression());
        } else if (null != groupingElementType2.getAttributes() && null != groupingElementType2.getAttributes().getAttribute()) {
            Attributes attributes = new Attributes();
            List list = attributes.getAttribute();
            for (AttributeType attributeType : groupingElementType2.getAttributes().getAttribute()) {
                AttributeType attributeType2 = new AttributeType();
                AttributeTypeHelper.copyAttribute(attributeType2, attributeType);
                list.add(attributeType2);
            }
            groupingElementType.setAttributes(attributes);
        }
    }

    public static String convertGroupingElementTypetoString(GroupingElementType groupingElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getExpression()) {
            stringBuffer.append(groupingElementType.getExpression());
        } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(attributeType.getName());
            }
        }
        return stringBuffer.toString();
    }

    public static String generateSQLExpression(Context context, AggregationElements aggregationElements, GroupingElementType groupingElementType, String string, boolean bl) {
        String string222;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        Object object422;
        if (aggregationElements == null || null == aggregationElements.getAggregationElement()) {
            return null;
        }
        boolean bl3 = null == groupingElementType.getExpression() && (null == groupingElementType.getAttributes() || groupingElementType.getAttributes().getAttribute().isEmpty());
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        if (version == null) {
            return null;
        }
        String string3 = AttributeTypeHelper.getHint(context);
        List list = aggregationElements.getAggregationElement();
        String string4 = AttributeTypeHelper.mainGroupBytoString(groupingElementType);
        String string5 = groupingElementType.getExpression() != null ? AttributeTypeHelper.createAlias(string4) : string4;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<AggregationElementType> arrayList2 = new ArrayList<AggregationElementType>();
        int n = 0;
        for (Object object422 : list) {
            object3 = object422.getSubGroupBy();
            object2 = null;
            if (AttributeTypeHelper.isSubGropByPresent((GroupingElementType)object3)) {
                object = AttributeTypeHelper.convertGroupingElementTypetoSQL((GroupingElementType)object3);
                object2 = (AggregationSQLElement)hashMap.get(object);
                if (null == object2) {
                    object2 = new AggregationSQLElement((AggregationElementType)object422);
                    hashMap.put((String)object, object2);
                    arrayList.add(object2);
                    ((AggregationSQLElement)object2).sqlSubGroupBy = (String)object;
                    ((AggregationSQLElement)object2).idString = "ID" + ++n;
                    ((AggregationSQLElement)object2).tableAlias = " t" + String.valueOf(n - 1);
                    ((AggregationSQLElement)object2).sb.append("  (SELECT ");
                    if (null != groupingElementType.getExpression()) {
                        ((AggregationSQLElement)object2).sb.append(string5);
                    } else {
                        ((AggregationSQLElement)object2).sb.append(string4);
                    }
                } else {
                    ((AggregationSQLElement)object2).addSourceAttr((AggregationElementType)object422);
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl4 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MODE.toString());
                boolean bl5 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MAX.toString());
                bl2 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MIN.toString());
                boolean bl6 = null != object422.getAggregationFunction() && (object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT.toString()) || object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT_DISTINCT.toString()));
                string222 = null;
                String string6 = null;
                if (bl4 || bl5 || bl2) {
                    if (null != object422.getSource().getAttributes() && null != object422.getSource().getAttributes().getAttribute() && !object422.getSource().getAttributes().getAttribute().isEmpty()) {
                        AttributeType attributeType = (AttributeType)object422.getSource().getAttributes().getAttribute().get(0);
                        if (attributeType.getDataType().equals("VARCHAR2") || attributeType.getDataType().equals("CHAR") || attributeType.getDataType().equals("NVARCHAR2") || attributeType.getDataType().equals("NCHAR")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_CATEGORICAL(";
                            string6 = ")) AS DM_NESTED_CATEGORICALS) ";
                        } else if (attributeType.getDataType().equals("NUMBER") || attributeType.getDataType().equals("FLOAT") || attributeType.getDataType().equals("BINARY_DOUBLE") || attributeType.getDataType().equals("BINARY_FLOAT")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                            string6 = ")) AS DM_NESTED_NUMERICALS) ";
                        }
                    }
                } else if (bl6) {
                    string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                    string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                } else if (null != object422.getSource().getExpression()) {
                    String string7 = object422.getSource().getExpression();
                } else if (version.toCanonicalString().startsWith("11")) {
                    String string8 = ((AttributeType)object3.getAttributes().getAttribute().get(0)).getDataType();
                    if (string8.equals("VARCHAR2")) {
                        string222 = "\n\tCAST(COLLECT(DM_NESTED_CATEGORICAL(";
                        string6 = ")) AS DM_NESTED_CATEGORICALS) ";
                    } else {
                        string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                        string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                    }
                } else {
                    boolean bl7;
                    boolean bl8 = bl7 = object3.getAttributes() != null && object3.getAttributes().getAttribute() != null && !object3.getAttributes().getAttribute().isEmpty();
                    if (bl7) {
                        String string9 = ((AttributeType)object3.getAttributes().getAttribute().get(0)).getDataType();
                        if (string9.equals("BINARY_FLOAT")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_FLOAT(";
                            string6 = ")) AS DM_NESTED_BINARY_FLOATS  ) ";
                        } else if (string9.equals("BINARY_DOUBLE")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_DOUBLE(";
                            string6 = ")) AS DM_NESTED_BINARY_DOUBLES  ) ";
                        } else {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                            string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                        }
                    } else {
                        string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                        string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                    }
                }
                if (string222 != null) {
                    stringBuilder.append(string222);
                }
                stringBuilder.append(((AggregationSQLElement)object2).idString);
                stringBuilder.append(", ");
                stringBuilder.append(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                if (string6 != null) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(" " + AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                ((AggregationSQLElement)object2).nestedElement.add(stringBuilder.toString());
                ((AggregationSQLElement)object2).internalResultColumns.add(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, (AggregationElementType)object422));
                ((AggregationSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                continue;
            }
            if (!bl) {
                arrayList2.add((AggregationElementType)object422);
                continue;
            }
            object2 = new AggregationSQLElement((AggregationElementType)object422);
            arrayList.add(object2);
            ((AggregationSQLElement)object2).tableAlias = " t" + String.valueOf(++n - 1);
            ((AggregationSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
            ((AggregationSQLElement)object2).sb.append("  (SELECT ");
            ((AggregationSQLElement)object2).sb.append(string3);
            if (null != groupingElementType.getExpression()) {
                ((AggregationSQLElement)object2).sb.append(string4);
                ((AggregationSQLElement)object2).sb.append(" ");
                ((AggregationSQLElement)object2).sb.append(string5);
            } else {
                ((AggregationSQLElement)object2).sb.append(string4);
            }
            if (!bl3) {
                ((AggregationSQLElement)object2).sb.append(", ");
            }
            ((AggregationSQLElement)object2).sb.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, (AggregationElementType)object422));
            if (bl) {
                ((AggregationSQLElement)object2).sb.append("\n\tFROM (");
                ((AggregationSQLElement)object2).sb.append(string);
                ((AggregationSQLElement)object2).sb.append(") ");
            } else {
                ((AggregationSQLElement)object2).sb.append("\n\tFROM {INPUT_SOURCE} ");
            }
            if (!bl3) {
                ((AggregationSQLElement)object2).sb.append("\n\tGROUP BY ");
                ((AggregationSQLElement)object2).sb.append(string4);
            }
            ((AggregationSQLElement)object2).sb.append(")");
            ((AggregationSQLElement)object2).sb.append(((AggregationSQLElement)object2).tableAlias);
        }
        AggregationSQLElement aggregationSQLElement = AttributeTypeHelper.aggregateWithoutSubGroupBy(context, arrayList2, n, groupingElementType, string4, string5, bl3, string3);
        if (null != aggregationSQLElement) {
            arrayList.add(aggregationSQLElement);
        }
        object422 = new StringBuilder("SELECT ");
        object3 = new StringBuilder();
        Object object4 = object2 = arrayList.isEmpty() ? _maintable_alias : ((AggregationSQLElement)arrayList.get(0)).tableAlias;
        if (!arrayList.isEmpty()) {
            ((StringBuilder)object422).append(AttributeTypeHelper.convertGroupingElementTypetoSQL(groupingElementType, (String)object2));
        } else {
            ((StringBuilder)object422).append(AttributeTypeHelper.mainGroupBytoString(groupingElementType));
            if (null != groupingElementType.getExpression()) {
                ((StringBuilder)object422).append(" AS ");
                ((StringBuilder)object422).append(string5);
            }
        }
        object = new ArrayList();
        boolean bl9 = !bl3 && !arrayList.isEmpty();
        for (AggregationSQLElement aggregationSQLElement2 : arrayList) {
            for (Iterator iterator : aggregationSQLElement2.resultColumns) {
                if (bl9) {
                    ((StringBuilder)object422).append(", ");
                }
                ((StringBuilder)object422).append("\n");
                ((StringBuilder)object422).append(aggregationSQLElement2.tableAlias);
                ((StringBuilder)object422).append(".");
                ((StringBuilder)object422).append((String)((Object)iterator));
                if (bl9) continue;
                bl9 = true;
            }
            if (((StringBuilder)object3).length() > 0) {
                ((StringBuilder)object3).append(",\n");
            }
            ((StringBuilder)object3).append((CharSequence)aggregationSQLElement2.sb);
            boolean bl10 = bl2 = !bl3 && !aggregationSQLElement2.nestedElement.isEmpty();
            if (!aggregationSQLElement2.nestedElement.isEmpty()) {
                Iterator iterator;
                for (String string222 : aggregationSQLElement2.nestedElement) {
                    if (bl2) {
                        ((StringBuilder)object3).append(", ");
                    }
                    ((StringBuilder)object3).append(string222);
                    if (bl2) continue;
                    bl2 = true;
                }
                ((StringBuilder)object3).append("\n\tFROM\n");
                ((StringBuilder)object3).append("\t\t(SELECT ");
                ((StringBuilder)object3).append(string3);
                ((StringBuilder)object3).append(" ");
                if (null != groupingElementType.getExpression()) {
                    ((StringBuilder)object3).append("(");
                    ((StringBuilder)object3).append(string4);
                    ((StringBuilder)object3).append(") AS ");
                    ((StringBuilder)object3).append(string5);
                } else {
                    ((StringBuilder)object3).append(string4);
                }
                if (!bl3) {
                    ((StringBuilder)object3).append(",");
                }
                ((StringBuilder)object3).append("\n\t\t");
                ((StringBuilder)object3).append(aggregationSQLElement2.sqlSubGroupBy + " ");
                ((StringBuilder)object3).append(aggregationSQLElement2.idString);
                iterator = aggregationSQLElement2.internalResultColumns.iterator();
                while (iterator.hasNext()) {
                    string222 = (String)iterator.next();
                    ((StringBuilder)object3).append(",\n\t\t");
                    ((StringBuilder)object3).append(string222);
                }
                if (bl) {
                    ((StringBuilder)object3).append("\n\t\tFROM (");
                    ((StringBuilder)object3).append(string);
                    ((StringBuilder)object3).append(") ");
                } else {
                    ((StringBuilder)object3).append("\n\t\tFROM {INPUT_SOURCE} ");
                }
                ((StringBuilder)object3).append("\n\t\tGROUP BY ");
                if (null != groupingElementType.getExpression()) {
                    ((StringBuilder)object3).append("(");
                    ((StringBuilder)object3).append(string4);
                    ((StringBuilder)object3).append(") ");
                } else {
                    ((StringBuilder)object3).append(string4);
                }
                if (!bl3) {
                    ((StringBuilder)object3).append(", ");
                }
                ((StringBuilder)object3).append("(");
                ((StringBuilder)object3).append(aggregationSQLElement2.sqlSubGroupBy);
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(")");
                ((StringBuilder)object3).append("\n\t ");
                if (!bl3) {
                    ((StringBuilder)object3).append("GROUP BY ");
                }
                if (null != groupingElementType.getExpression()) {
                    ((StringBuilder)object3).append(string5);
                } else {
                    ((StringBuilder)object3).append(string4);
                }
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(aggregationSQLElement2.tableAlias);
            }
            object.add(aggregationSQLElement2.tableAlias);
        }
        if (arrayList.isEmpty()) {
            if (bl) {
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(string);
                ((StringBuilder)object3).append(") ");
            } else {
                ((StringBuilder)object3).append("{INPUT_SOURCE} ");
            }
            ((StringBuilder)object3).append("\nGROUP BY ");
            ((StringBuilder)object3).append(string4);
        }
        ((StringBuilder)object422).append("\nFROM\n");
        ((StringBuilder)object422).append((CharSequence)object3);
        ((StringBuilder)object422).append("\n");
        String string10 = object.isEmpty() ? _maintable_alias : (String)object.get(0);
        ((StringBuilder)object422).append(AttributeTypeHelper.convertGroupingElementTypetoWhereClause(groupingElementType, string10, (List<String>)object));
        return ((StringBuilder)object422).toString();
    }

    private static String convertAggregationElementSourcetoSQL(Context context, AggregationElementType aggregationElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != aggregationElementType.getSource().getExpression()) {
            stringBuffer.append(aggregationElementType.getSource().getExpression());
        } else if (null != aggregationElementType.getSource().getAttributes() && null != aggregationElementType.getSource().getAttributes().getAttribute() && 1 == aggregationElementType.getSource().getAttributes().getAttribute().size()) {
            boolean bl = aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
            List list = aggregationElementType.getSource().getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                String string = aggregationElementType.getAggregationFunction();
                int n = string.indexOf("()");
                StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
                stringBuilder.append("(");
                stringBuilder.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                if (bl) {
                    String string2 = AttributeTypeHelper.getNestedCategoricalType(context, attributeType);
                    stringBuilder.append(") AS " + string2);
                    stringBuilder.append(string.substring(n + 2, string.length()));
                } else {
                    stringBuilder.append(string.substring(n + 1, string.length()));
                }
                stringBuffer.append((CharSequence)stringBuilder);
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(aggregationElementType.getOutput()));
        return stringBuffer.toString();
    }

    public static String mainGroupBytoString(GroupingElementType groupingElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getExpression()) {
            stringBuffer.append(groupingElementType.getExpression());
        } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
            }
        }
        return stringBuffer.toString();
    }

    public static String processDoubleQuotedName(AttributeType attributeType) {
        String string = null;
        string = !StringUtils.isDoubleQuotedString(attributeType.getName()) ? "\"" + attributeType.getName() + "\"" : attributeType.getName();
        return string;
    }

    private static String convertGroupingElementTypetoSQL(GroupingElementType groupingElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" || ");
                    stringBuffer.append("'");
                    stringBuffer.append(" - ");
                    stringBuffer.append("'");
                    stringBuffer.append(" || ");
                } else {
                    stringBuffer.append("(");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
            }
            stringBuffer.append(")");
        } else if (null != groupingElementType.getExpression()) {
            stringBuffer.append(groupingElementType.getExpression());
        }
        return stringBuffer.toString();
    }

    private static String convertGroupingElementTypetoSQL(GroupingElementType groupingElementType, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                stringBuffer.append(".");
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
            }
        } else if (null != groupingElementType.getExpression()) {
            stringBuffer.append(string);
            stringBuffer.append(".");
            stringBuffer.append(AttributeTypeHelper.createAlias(groupingElementType.getExpression()));
        }
        return stringBuffer.toString();
    }

    public static String createAlias(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() && i < 28; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') continue;
            stringBuilder.append(c);
        }
        return "\"" + stringBuilder.toString() + "\"";
    }

    public static String createNonQuotedAlias(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() && i < 28; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String convertGroupingElementTypetoWhereClause(GroupingElementType groupingElementType, String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list2 = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list2) {
                StringBuilder stringBuilder2 = new StringBuilder();
                for (String string2 : list) {
                    if (string2.equals(string)) continue;
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(" AND ");
                    }
                    stringBuilder2.append(string);
                    stringBuilder2.append(".");
                    stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                    stringBuilder2.append(" = ");
                    stringBuilder2.append(string2);
                    stringBuilder2.append(".");
                    stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                    stringBuilder2.append("(+)\n");
                }
                if (stringBuilder2.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" AND ");
                } else {
                    stringBuilder.append(WHERE);
                }
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        }
        return stringBuilder.toString();
    }

    public static boolean isUniqueAggregationOutputName(String string, List<AggregationElementType> list, Map<String, AttributeType> map) {
        if (null != map.get(string)) {
            return false;
        }
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AggregationElementType aggregationElementType : list) {
            hashMap.put(aggregationElementType.getOutput().getName(), aggregationElementType.getOutput());
        }
        return null == hashMap.get(string);
    }

    public static String createUniqueAggregationOutputName(String string, String string2, List<AggregationElementType> list) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AggregationElementType aggregationElementType : list) {
            hashMap.put(aggregationElementType.getOutput().getName(), aggregationElementType.getOutput());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    private static String createUniqueCustomName(Map<String, AttributeType> map) {
        String string;
        int n;
        int n2 = 25;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION();
        stringBuilder.append(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION());
        int n3 = 0;
        while (null != map.get(stringBuilder.toString()) && (n = n2 - (1 + (string = String.valueOf(++n3)).length())) > 0) {
            stringBuilder = new StringBuilder();
            if (string2.length() > n) {
                stringBuilder.append(string2.substring(0, n - 1));
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append("_");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String createUniqueOutputName(String string, String string2, Map<String, AttributeType> map) {
        int n;
        if (string2.equals(TransformationTypes.getCUSTOM_ABBREVIATION())) {
            return AttributeTypeHelper.createUniqueCustomName(map);
        }
        int n2 = 25;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length() + string2.length() + 1;
        if (n3 <= n2) {
            stringBuilder.append(string);
        } else {
            n = n2 - (string2.length() + 1);
            stringBuilder.append(string.substring(0, n - 1));
        }
        stringBuilder.append("_");
        stringBuilder.append(string2);
        n = 0;
        while (null != map.get(stringBuilder.toString())) {
            String string3 = String.valueOf(++n);
            int n4 = n2 - (string2.length() + 2 + string3.length());
            if (n4 <= 0) break;
            stringBuilder = new StringBuilder();
            if (string.length() > n4) {
                stringBuilder.append(string.substring(0, n4 - 1));
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append("_");
            stringBuilder.append(string2);
            stringBuilder.append("_");
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static String getValidationSQLForGroupByExpression(Context context, GroupingElementType groupingElementType, AggregationElementType aggregationElementType, String string, String string2, String string3) {
        String string4 = AttributeTypeHelper.mainGroupBytoString(groupingElementType);
        String string5 = string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t\t(SELECT ");
        if (string4 != null && !string4.isEmpty()) {
            if (null != groupingElementType.getExpression()) {
                stringBuilder.append("(");
                stringBuilder.append(string4);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string4);
            }
            stringBuilder.append(",\n");
        }
        stringBuilder.append("\t\t(");
        stringBuilder.append(string5);
        stringBuilder.append(") ");
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, aggregationElementType));
        stringBuilder.append("\n\t\tFROM (");
        stringBuilder.append(string3);
        stringBuilder.append(")\n\t\tGROUP BY ");
        if (string4 != null && !string4.isEmpty()) {
            if (null != groupingElementType.getExpression()) {
                stringBuilder.append("(");
                stringBuilder.append(string4);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string4);
            }
            stringBuilder.append(", ");
        }
        stringBuilder.append("(");
        stringBuilder.append(string5);
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    public static String getAggregationElementValidationSQL(Context context, GroupingElementType groupingElementType, AggregationElementType aggregationElementType, String string) {
        String string2 = StringUtils.escapeSingleQuotesForSQL(AttributeTypeHelper.mainGroupBytoString(groupingElementType));
        String string3 = null;
        if (AttributeTypeHelper.isSubGropByPresent(aggregationElementType.getSubGroupBy())) {
            string3 = AttributeTypeHelper.convertGroupingElementTypetoSQL(aggregationElementType.getSubGroupBy());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(SELECT ");
        stringBuilder.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, aggregationElementType));
        stringBuilder.append("\nFROM (");
        stringBuilder.append(string);
        stringBuilder.append(")\n");
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append("GROUP BY ");
            stringBuilder.append(string2);
            if (string3 != null && !string3.trim().isEmpty()) {
                stringBuilder.append(",\n");
                stringBuilder.append(string3);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getMainGroupByElementValidationSQL(GroupingElementType groupingElementType, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT (");
        String string2 = StringUtils.escapeSingleQuotesForSQL(AttributeTypeHelper.mainGroupBytoString(groupingElementType));
        stringBuilder.append(string2);
        stringBuilder.append(") \nFROM (");
        stringBuilder.append(string);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static boolean isSubGropByPresent(GroupingElementType groupingElementType) {
        return groupingElementType != null && (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty() || null != groupingElementType.getExpression());
    }

    public static void setOutputAttributeType(Context context, String string, AggregationElementType aggregationElementType) {
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        if (version == null) {
            return;
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setStatus(AttributeStatus.VALID);
        attributeType.setName(string);
        boolean bl = null != aggregationElementType.getAggregationFunction() && aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MAX.toString());
        boolean bl2 = null != aggregationElementType.getAggregationFunction() && aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MIN.toString());
        boolean bl3 = aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MODE.toString());
        boolean bl4 = null != aggregationElementType.getAggregationFunction() && (aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT.toString()) || aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT_DISTINCT.toString()));
        boolean bl5 = aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
        GroupingElementType groupingElementType = aggregationElementType.getSource();
        if (AttributeTypeHelper.isSubGropByPresent(aggregationElementType.getSubGroupBy())) {
            String string2 = null;
            if (bl3 || bl || bl2) {
                if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
                    AttributeType attributeType2 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                    if (attributeType2.getDataType().equals("VARCHAR2") || attributeType2.getDataType().equals("CHAR") || attributeType2.getDataType().equals("NVARCHAR2") || attributeType2.getDataType().equals("NCHAR")) {
                        string2 = "DM_NESTED_CATEGORICALS";
                    } else if (attributeType2.getDataType().equals("NUMBER")) {
                        string2 = "DM_NESTED_NUMERICALS";
                    }
                }
            } else if (bl4) {
                string2 = "DM_NESTED_NUMERICALS";
            } else if (null != aggregationElementType.getSource().getExpression()) {
                string2 = "DM_NESTED_CATEGORICALS";
            } else if (version.toCanonicalString().startsWith("11")) {
                String string3 = ((AttributeType)aggregationElementType.getSubGroupBy().getAttributes().getAttribute().get(0)).getDataType();
                string2 = string3.equals("VARCHAR2") ? "DM_NESTED_CATEGORICALS" : "DM_NESTED_NUMERICALS";
            } else {
                String string4;
                boolean bl6;
                boolean bl7 = bl6 = aggregationElementType.getSubGroupBy().getAttributes() != null && aggregationElementType.getSubGroupBy().getAttributes().getAttribute() != null && !aggregationElementType.getSubGroupBy().getAttributes().getAttribute().isEmpty();
                string2 = bl6 ? ((string4 = ((AttributeType)aggregationElementType.getSubGroupBy().getAttributes().getAttribute().get(0)).getDataType()).equals("BINARY_FLOAT") ? "DM_NESTED_BINARY_FLOATS" : (string4.equals("BINARY_DOUBLE") ? "DM_NESTED_BINARY_DOUBLES" : "DM_NESTED_NUMERICALS")) : "DM_NESTED_NUMERICALS";
            }
            attributeType.setDataType(string2);
        } else {
            AttributeType attributeType3;
            String string5 = "NUMBER";
            if (bl3) {
                if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
                    attributeType3 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                    if (attributeType3.getDataType().equals("VARCHAR2") || attributeType3.getDataType().equals("CHAR")) {
                        string5 = "VARCHAR2";
                    } else if (attributeType3.getDataType().equals("NVARCHAR2") || attributeType3.getDataType().equals("NCHAR")) {
                        string5 = "NVARCHAR2";
                    }
                } else if (null != groupingElementType.getExpression()) {
                    string5 = "VARCHAR2";
                }
            } else if (bl5) {
                if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
                    attributeType3 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                    string5 = AttributeTypeHelper.getNestedCategoricalType(context, attributeType3);
                } else if (null != groupingElementType.getExpression()) {
                    string5 = "VARCHAR2";
                }
            }
            if (DatabaseMetadataUtils.AggregateFunctions.isTypeTransparentFunction(aggregationElementType.getAggregationFunction())) {
                attributeType3 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                attributeType.setDataType(attributeType3.getDataType());
            } else {
                attributeType.setDataType(string5);
            }
        }
        aggregationElementType.setOutput(attributeType);
    }

    public static boolean isValidSubGroupBy(Map<String, AttributeType> map, GroupingElementType groupingElementType) {
        if (null != groupingElementType.getExpression()) {
            return true;
        }
        if (groupingElementType == null || groupingElementType.getAttributes() == null) {
            return false;
        }
        List list = groupingElementType.getAttributes().getAttribute();
        boolean bl = true;
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (null == attributeType2) {
                bl = false;
            }
            if (attributeType2 != null && !attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) {
                bl = false;
            }
            if (bl) continue;
            attributeType.setStatus(AttributeStatus.INVALID);
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Context context, UpdateTableNode updateTableNode) {
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)updateTableNode.getData();
        boolean bl = false;
        String string = updateTableNodeType.getUpdateTargetTable().getName();
        String string2 = updateTableNodeType.getUpdateTargetTable().getSchema();
        if (string != null && !string.isEmpty()) {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(context);
                bl = DatabaseMetadataUtils.datasourceExists(connection, string2, string);
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getMessage());
            }
            finally {
                SQLHelper.close(connection);
            }
        }
        return bl;
    }

    public static boolean areCompatibleTypes(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return DatabaseMetadataUtils.isANumberOracleDataType(string) && DatabaseMetadataUtils.isANumberOracleDataType(string2);
    }

    public static String getNestedCategoricalType(Context context, AttributeType attributeType) {
        String string = null;
        boolean bl = SQLHelper.isExtendedTypeEnabled(context);
        if (attributeType.getDataType().equals("VARCHAR2")) {
            string = bl ? "ODMR_NESTED_VARCHAR2_EX" : "ODMR_NESTED_VARCHAR2";
        } else if (attributeType.getDataType().equals("CHAR")) {
            string = "ODMR_NESTED_CHAR";
        } else if (attributeType.getDataType().equals("NVARCHAR2")) {
            string = bl ? "ODMR_NESTED_NVARCHAR2_EX" : "ODMR_NESTED_NVARCHAR2";
        } else if (attributeType.getDataType().equals("NCHAR")) {
            string = "ODMR_NESTED_NCHAR";
        } else assert (false);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeSQLAggregate(Context context, String string) throws Exception {
        Connection connection = null;
        boolean bl = false;
        try {
            String string2 = StringUtils.escapeSingleQuotesForSQL(string);
            String string3 = StringUtils.getReplacedString(DBMS_SQL_PARSE_AGGREGATE, "[SQL_EXPRESSION]", string2);
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            CallableStatement callableStatement = connection.prepareCall(string3);
            callableStatement.execute();
            bl = true;
        }
        catch (Throwable throwable) {
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return bl;
    }

    private static AggregationSQLElement aggregateWithoutSubGroupBy(Context context, List<AggregationElementType> list, int n, GroupingElementType groupingElementType, String string, String string2, boolean bl, String string3) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        AggregationSQLElement aggregationSQLElement = new AggregationSQLElement();
        aggregationSQLElement.tableAlias = " t" + String.valueOf(n);
        aggregationSQLElement.sb = new StringBuilder("  (SELECT ");
        aggregationSQLElement.sb.append(string3);
        if (null != groupingElementType.getExpression()) {
            aggregationSQLElement.sb.append(string);
            aggregationSQLElement.sb.append(" ");
            aggregationSQLElement.sb.append(string2);
        } else {
            aggregationSQLElement.sb.append(string);
        }
        if (!bl) {
            aggregationSQLElement.sb.append(", ");
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        for (AggregationElementType aggregationElementType : list) {
            AggregationSQLElement aggregationSQLElement2 = new AggregationSQLElement(aggregationElementType);
            aggregationSQLElement.sb.append("\n    ");
            if (n2 > 0) {
                aggregationSQLElement.sb.append(",");
            }
            aggregationSQLElement.resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(aggregationElementType.getOutput()));
            aggregationSQLElement.sb.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, aggregationElementType));
            ++n2;
        }
        Object object = "";
        if (stringBuilder != null) {
            object = stringBuilder.toString();
        }
        aggregationSQLElement.sb.append("\n  FROM {INPUT_SOURCE}\n  " + (String)object + " ");
        if (!bl) {
            aggregationSQLElement.sb.append("\n  GROUP BY ");
            aggregationSQLElement.sb.append(string);
        }
        aggregationSQLElement.sb.append(")");
        aggregationSQLElement.sb.append(aggregationSQLElement.tableAlias);
        return aggregationSQLElement;
    }

    private static class AggregationSQLElement {
        private List<AttributeType> sourceAttrs;
        private String sqlSubGroupBy;
        private StringBuilder sb = new StringBuilder();
        private List<String> nestedElement = new ArrayList<String>();
        private String tableAlias;
        private List<String> resultColumns = new ArrayList<String>();
        private List<String> internalResultColumns = new ArrayList<String>();
        private String idString;

        AggregationSQLElement() {
        }

        AggregationSQLElement(AggregationElementType aggregationElementType) {
            if (null != aggregationElementType.getSource().getAttributes() && null != aggregationElementType.getSource().getAttributes().getAttribute() && !aggregationElementType.getSource().getAttributes().getAttribute().isEmpty()) {
                this.sourceAttrs = new ArrayList<AttributeType>();
                this.sourceAttrs.add((AttributeType)aggregationElementType.getSource().getAttributes().getAttribute().get(0));
            }
        }

        void addSourceAttr(AggregationElementType aggregationElementType) {
            if (this.sourceAttrs == null) {
                this.sourceAttrs = new ArrayList<AttributeType>();
            }
            if (null != aggregationElementType.getSource().getAttributes() && null != aggregationElementType.getSource().getAttributes().getAttribute() && !aggregationElementType.getSource().getAttributes().getAttribute().isEmpty()) {
                this.sourceAttrs.add((AttributeType)aggregationElementType.getSource().getAttributes().getAttribute().get(0));
            }
        }
    }

    public static class TextTransformationNodeColumns {
        private TransformedAttributesType _xformedAttributes;
        private TransformationSourceAttributes _xformSourceAttributes;

        private TextTransformationNodeColumns(TransformedAttributesType transformedAttributesType, TransformationSourceAttributes transformationSourceAttributes) {
            if (null != transformedAttributesType) {
                this._xformedAttributes = AttributeTypeHelper.cloneTransformedAttributesType(transformedAttributesType);
            }
            if (null != transformationSourceAttributes) {
                this._xformSourceAttributes = new TransformationSourceAttributes();
                AttributeTypeHelper.copyTransformationSourceAttributes(this._xformSourceAttributes.getTransformationSourceAttributeType(), transformationSourceAttributes.getTransformationSourceAttributeType());
            }
        }

        public TransformedAttributesType getXformedAttributes() {
            return this._xformedAttributes;
        }

        public TransformationSourceAttributes getXformSourceAttributes() {
            return this._xformSourceAttributes;
        }
    }

    public static class TransformationNodeColumns {
        private TransformedAttributes _xformedAttributes;
        private TransformationSourceAttributes _xformSourceAttributes;

        private TransformationNodeColumns(TransformedAttributes transformedAttributes, TransformationSourceAttributes transformationSourceAttributes) {
            if (null != transformedAttributes) {
                this._xformedAttributes = AttributeTypeHelper.cloneTransformedAttributes(transformedAttributes);
            }
            if (null != transformationSourceAttributes) {
                this._xformSourceAttributes = new TransformationSourceAttributes();
                AttributeTypeHelper.copyTransformationSourceAttributes(this._xformSourceAttributes.getTransformationSourceAttributeType(), transformationSourceAttributes.getTransformationSourceAttributeType());
            }
        }

        public TransformedAttributes getXformedAttributes() {
            return this._xformedAttributes;
        }

        public TransformationSourceAttributes getXformSourceAttributes() {
            return this._xformSourceAttributes;
        }
    }

    public static class ExTransformationSourceAttribute {
        private TransformationSourceAttribute _src;

        public ExTransformationSourceAttribute(TransformationSourceAttribute transformationSourceAttribute) {
            this._src = transformationSourceAttribute;
        }

        public String toString() {
            if (this._src != null) {
                return this._src.getName();
            }
            return "";
        }

        public TransformationSourceAttribute getTransformationSourceAttribute() {
            return this._src;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof ExTransformationSourceAttribute) {
                if (null != ((ExTransformationSourceAttribute)object)._src && this._src != null) {
                    return ((ExTransformationSourceAttribute)object)._src.getName().equals(this._src.getName());
                }
                if (null == ((ExTransformationSourceAttribute)object)._src && this._src == null) {
                    return true;
                }
            }
            return false;
        }
    }
}

