/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class ConfigurationSettingsDialog {
    private JEWTDialog dlg;
    private Connection conn;
    private Context context;
    private String defaultTablespace;
    private String defaultTempTablespace;
    private boolean requireASM = false;
    private SettingOption settingOption = null;
    public static final String TABLESPACE_NAME = "TABLESPACE_NAME";
    public static final String CONTENTS = "CONTENTS";
    public static final String SEGMENT_SPACE_MANAGEMENT = "SEGMENT_SPACE_MANAGEMENT";

    public ConfigurationSettingsDialog(Connection connection, Context context, SettingOption settingOption, boolean bl) {
        this.context = context;
        this.defaultTablespace = null;
        this.defaultTempTablespace = null;
        this.settingOption = settingOption;
        this.requireASM = bl;
        this.conn = connection;
    }

    protected JEWTDialog buildDialog() {
        ConfigurationSettingsPanel configurationSettingsPanel = new ConfigurationSettingsPanel();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, "configSettings", n);
        jEWTDialog.setContent((Component)configurationSettingsPanel);
        jEWTDialog.setTitle(this.settingOption == SettingOption.INSTALL_SETTINGS ? UtilsLrb.get("CONFIG_SETTINGS_TITLE") : UtilsLrb.get("TABLE_SPACE_MIGRATION_SETTINGS_TITLE"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "dm_install_odmrsys");
        jEWTDialog.setPreferredSize(new Dimension(500, 250));
        return jEWTDialog;
    }

    public boolean invoke() {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog();
            jEWTDialog.setResizable(true);
            final ConfigurationSettingsPanel configurationSettingsPanel = (ConfigurationSettingsPanel)jEWTDialog.getContent();
            configurationSettingsPanel.initUI();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !configurationSettingsPanel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this.dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        return bl;
    }

    public final String getDefaultTablespaceName() {
        return this.defaultTablespace;
    }

    public final String getDefaultTempTablespaceName() {
        return this.defaultTempTablespace;
    }

    public Connection getConnection() {
        return this.conn;
    }

    private TableSpace getDefaultTempTableSpace(List<TableSpace> list) {
        for (TableSpace tableSpace : list) {
            if (!tableSpace.isTemporary()) continue;
            return tableSpace;
        }
        return null;
    }

    private TableSpace getDefaultTableSpace(List<TableSpace> list) {
        ArrayList<TableSpace> arrayList = new ArrayList<TableSpace>();
        for (TableSpace tableSpace : list) {
            if (!tableSpace.isDefault()) continue;
            if (tableSpace.isDMUSER()) {
                return tableSpace;
            }
            arrayList.add(tableSpace);
        }
        if (!arrayList.isEmpty()) {
            return (TableSpace)arrayList.get(0);
        }
        return null;
    }

    private List<TableSpace> getTempSpaces(List<TableSpace> list) {
        ArrayList<TableSpace> arrayList = new ArrayList<TableSpace>();
        for (TableSpace tableSpace : list) {
            if (!tableSpace.getType().equals("TEMPORARY")) continue;
            arrayList.add(tableSpace);
        }
        return arrayList;
    }

    private List<TableSpace> getPermanentSpaces(List<TableSpace> list) throws Exception {
        ArrayList<TableSpace> arrayList = new ArrayList<TableSpace>();
        for (TableSpace tableSpace : list) {
            if (this.requireASM) {
                if (!tableSpace.getType().equals("PERMANENT") || !tableSpace.getMgmt().equals("AUTO")) continue;
                arrayList.add(tableSpace);
                continue;
            }
            if (!tableSpace.getType().equals("PERMANENT")) continue;
            arrayList.add(tableSpace);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableSpace> getNameSpaces(Connection connection) throws SQLException {
        ArrayList<TableSpace> arrayList = new ArrayList<TableSpace>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement("select TABLESPACE_NAME, CONTENTS, SEGMENT_SPACE_MANAGEMENT from DBA_TABLESPACES where TABLESPACE_NAME not in ('SYSTEM', 'SYSAUX') and CONTENTS not in ('UNDO')");
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string = sQLHelper.rs.getString(TABLESPACE_NAME);
                String string2 = sQLHelper.rs.getString(CONTENTS);
                String string3 = sQLHelper.rs.getString(SEGMENT_SPACE_MANAGEMENT);
                arrayList.add(new TableSpace(string, string2, string3));
            }
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    class TableSpace {
        private String name;
        private String type;
        private String mgmt;
        public static final String DMUSER = "DMUSER";
        public static final String TBS_1 = "TBS_1";
        public static final String USERS = "USERS";
        public static final String TYPE_TEMPORARY = "TEMPORARY";
        public static final String TYPE_PERMANENT = "PERMANENT";
        public static final String MGMT_AUTO = "AUTO";

        TableSpace(String string, String string2, String string3) {
            this.name = string;
            this.type = string2;
            this.mgmt = string3;
        }

        public final String getName() {
            return this.name;
        }

        public final String getType() {
            return this.type;
        }

        public final String getMgmt() {
            return this.mgmt;
        }

        public boolean isTemporary() {
            return this.type.equals(TYPE_TEMPORARY);
        }

        public boolean isDMUSER() {
            return this.name.equals(DMUSER) || this.name.equals(TBS_1);
        }

        public boolean isDefault() {
            if (this.name.equals(DMUSER) || this.name.equals(TBS_1)) {
                return true;
            }
            return this.name.equals(USERS);
        }

        public final String toString() {
            return this.name;
        }
    }

    class ConfigurationSettingsPanel
    extends JPanel {
        JLabel accountLabel;
        JLabel accountValueLabel;
        JLabel defaultTsLabel;
        JComboBox defaultValueCombo;
        JLabel introLabel;
        JLabel tempTsLabel;
        JComboBox tempValueCombo;

        public ConfigurationSettingsPanel() {
            this.initComponents();
            this.initRes();
        }

        private void initComponents() {
            this.defaultTsLabel = new JLabel();
            this.accountLabel = new JLabel();
            this.accountValueLabel = new JLabel();
            this.introLabel = new JLabel();
            this.tempValueCombo = new JComboBox();
            this.defaultValueCombo = new JComboBox();
            this.tempTsLabel = new JLabel();
            this.defaultTsLabel.setText("Default Tablespace:");
            this.accountLabel.setText("Repository Account:");
            this.accountValueLabel.setText("ODMRSYS");
            this.introLabel.setText("The repository installer will create an account using these settings:");
            this.tempValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
            this.defaultValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
            this.tempTsLabel.setText("Temporary Tablespace:");
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultTsLabel, -2, 140, -2).addComponent(this.accountLabel, -2, 140, -2).addComponent(this.tempTsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tempValueCombo, 0, 279, Short.MAX_VALUE).addComponent(this.defaultValueCombo, 0, 279, Short.MAX_VALUE).addComponent(this.accountValueLabel, -1, 279, Short.MAX_VALUE))).addComponent(this.introLabel, -1, 400, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 113, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.introLabel).addGap(22, 22, 22).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accountLabel).addComponent(this.accountValueLabel, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultTsLabel).addComponent(this.defaultValueCombo, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tempTsLabel).addComponent(this.tempValueCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        }

        public void initRes() {
            HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
            hashMap.put(ConfigurationSettingsDialog.this.settingOption == SettingOption.INSTALL_SETTINGS ? UtilsLrb.get("INTRO") : UtilsLrb.get("TABLE_SPACE_MIGRATION_INTRO"), this.introLabel);
            hashMap.put(UtilsLrb.get("ACCOUNT"), this.accountLabel);
            hashMap.put(ConfigurationSettingsDialog.this.settingOption == SettingOption.INSTALL_SETTINGS ? UtilsLrb.get("DEFAULT_TS") : UtilsLrb.get("TABLE_SPACE_MIGRATION"), this.defaultTsLabel);
            hashMap.put(UtilsLrb.get("DEFAULT_TEMP_TS"), this.tempTsLabel);
            hashMap.put("ODMRSYS", this.tempTsLabel);
            UIResourceHelper.setComponentText(hashMap);
            HelpUtils.setHelpID((JComponent)this, (String)(ConfigurationSettingsDialog.this.settingOption == SettingOption.INSTALL_SETTINGS ? "repositoryAccountSettings" : "migrationAccountSettings"));
        }

        public void initUI() {
            TableSpace tableSpace;
            List list = null;
            List list2 = null;
            List list3 = null;
            try {
                list = ConfigurationSettingsDialog.this.getNameSpaces(ConfigurationSettingsDialog.this.conn);
                list2 = ConfigurationSettingsDialog.this.getPermanentSpaces(list);
                list3 = ConfigurationSettingsDialog.this.getTempSpaces(list);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                ConfigurationSettingsDialog.this.dlg.closeDialog(true);
                return;
            }
            TableSpace tableSpace2 = ConfigurationSettingsDialog.this.getDefaultTableSpace(list2);
            if (tableSpace2 == null) {
                list2.add(0, new TableSpace(UtilsLrb.get("TS_DIRECTIVE"), null, null));
            }
            if ((tableSpace = ConfigurationSettingsDialog.this.getDefaultTempTableSpace(list3)) == null) {
                list3.add(0, new TableSpace(UtilsLrb.get("TS_DIRECTIVE"), null, null));
            }
            TableSpace[] tableSpaceArray = list2.toArray(new TableSpace[0]);
            this.defaultValueCombo.setModel(new DefaultComboBoxModel<TableSpace>(tableSpaceArray));
            if (tableSpace2 != null) {
                this.defaultValueCombo.setSelectedItem(tableSpace2);
                ConfigurationSettingsDialog.this.defaultTablespace = tableSpace2.getName();
            }
            this.defaultValueCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    TableSpace tableSpace = (TableSpace)jComboBox.getSelectedItem();
                    if (tableSpace.getName().equals(UtilsLrb.get("TS_DIRECTIVE"))) {
                        ((DefaultComboBoxModel)jComboBox.getModel()).removeElementAt(0);
                    }
                    ConfigurationSettingsDialog.this.defaultTablespace = tableSpace.getName();
                }
            });
            TableSpace[] tableSpaceArray2 = list3.toArray(new TableSpace[0]);
            this.tempValueCombo.setModel(new DefaultComboBoxModel<TableSpace>(tableSpaceArray2));
            if (tableSpace != null) {
                this.tempValueCombo.setSelectedItem(tableSpace);
                ConfigurationSettingsDialog.this.defaultTempTablespace = tableSpace.getName();
            }
            this.tempValueCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    TableSpace tableSpace = (TableSpace)jComboBox.getSelectedItem();
                    if (tableSpace.getName().equals(UtilsLrb.get("TS_DIRECTIVE"))) {
                        ((DefaultComboBoxModel)jComboBox.getModel()).removeElementAt(0);
                    }
                    ConfigurationSettingsDialog.this.defaultTempTablespace = tableSpace.getName();
                }
            });
            if (ConfigurationSettingsDialog.this.settingOption != SettingOption.INSTALL_SETTINGS) {
                this.tempValueCombo.setVisible(false);
                this.tempTsLabel.setVisible(false);
            }
        }

        public boolean doWork() {
            if (ConfigurationSettingsDialog.this.defaultTablespace == null) {
                MessageDialog.error((Component)this, (Object)UtilsLrb.get("SELECT_DEFAULT_TABLE_SPACE"), (String)UtilsLrb.get("SELECT_DEFAULT_TABLE_SPACE_TITLE"), null);
                this.defaultValueCombo.requestFocus(true);
            } else if (ConfigurationSettingsDialog.this.defaultTempTablespace == null && ConfigurationSettingsDialog.this.settingOption == SettingOption.INSTALL_SETTINGS) {
                MessageDialog.error((Component)this, (Object)UtilsLrb.get("SELECT_TEMP_TABLE_SPACE"), (String)UtilsLrb.get("SELECT_TEMP_TABLE_SPACE_TITLE"), null);
                this.tempValueCombo.requestFocus(true);
            }
            if (ConfigurationSettingsDialog.this.requireASM && !ConfigUtils.isExtentSizeCorrect(ConfigurationSettingsDialog.this.conn, ConfigurationSettingsDialog.this.defaultTablespace)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("EXTENT_SIZE_ERROR_MESSAGE"), (String)UtilsLrb.get("EXTENT_SIZE_ERROR_TITLE"), null);
                this.tempValueCombo.requestFocus(true);
                return false;
            }
            if (ConfigurationSettingsDialog.this.defaultTablespace == null) {
                return false;
            }
            return ConfigurationSettingsDialog.this.defaultTempTablespace != null || ConfigurationSettingsDialog.this.settingOption != SettingOption.INSTALL_SETTINGS;
        }
    }

    public static enum SettingOption {
        INSTALL_SETTINGS,
        MIGRATION_SETTINGS;

    }
}

