/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class DataMinerConnections {
    private static final Logger theLogger = Logger.getLogger(DataMinerConnections.class.getName());
    private static DataMinerConnections instance = null;
    private static ConnectionDisconnectListener disconnectListener = null;
    private static Map<String, String> privateConnectionsMap = new HashMap<String, String>();

    public static DataMinerConnections getInstance() {
        if (instance == null) {
            instance = new DataMinerConnections();
        }
        return instance;
    }

    private DataMinerConnections() {
    }

    public String getPrivateConnectionName(String string) throws ConnectionException {
        String string2 = null;
        String string3 = DataMinerConnections.getQualifiedName(string);
        if (privateConnectionsMap.containsKey(string3)) {
            string2 = privateConnectionsMap.get(string3);
        } else {
            string2 = Connections.getInstance().createPrivateConnection(string3);
            privateConnectionsMap.put(string3, string2);
        }
        return string2;
    }

    public static String getUnqualifiedName(String string) {
        String string2 = null;
        try {
            String string3 = URLDecoder.decode(string, "utf-8");
            int n = string3.indexOf(35);
            string2 = n != -1 ? string3.substring(n + 1) : string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            theLogger.log(Level.SEVERE, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        return string2;
    }

    public static String getQualifiedName(String string) {
        String string2 = DatabaseConnections.getInstance().getStoreName();
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string2, (String)string);
        return connectionKey.getQualifiedName();
    }

    public Connection createPrivateConnection(String string) throws ConnectionException {
        Connection connection = null;
        String string2 = this.getPrivateConnectionName(string);
        Connections connections = Connections.getInstance();
        connection = connections.getUniqueConnection(string2);
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new ConnectionException("Error setting auto commit for connection: " + string, (Throwable)sQLException);
        }
        if (disconnectListener == null) {
            disconnectListener = this.addDisconnectListener();
        }
        return connection;
    }

    public void closePrivateConnection(String string) throws ConnectionException {
        String string2 = this.getPrivateConnectionName(string);
        Connections.getInstance().closeConnection(string2, true);
    }

    private ConnectionDisconnectListener addDisconnectListener() {
        ConnectionDisconnectListener connectionDisconnectListener = new ConnectionDisconnectListener(){

            public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                try {
                    Properties properties = connectionDetails.getConnectionProperties();
                    String string = DatabaseConnections.getInstance().getStoreName();
                    Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string, (String)((String)properties.get("UnsharedWorksheetOriginalConnectionName")));
                    String string2 = connectionKey.getConnectionName();
                    if (privateConnectionsMap.containsKey(string2)) {
                        connectionDetails.getConnection().commit();
                    }
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }

            public void connectionDisconnected(ConnectionDetails connectionDetails) {
            }
        };
        Connections.getInstance().addConnectionDisconnectListener(connectionDisconnectListener);
        return connectionDisconnectListener;
    }
}

