/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class OverLayPanel
extends LayerUI
implements AWTEventListener {
    private JComponent parentPanel = null;
    private int x;
    private int y;
    private int width;
    private int height;
    private String text = "Loading...";
    private Font textFont = UIManager.getFont("Label.font");
    private Color bgColor = new Color(209, 218, 237, 200);
    private Color borderLineColor = new Color(136, 142, 154, 200);
    private Color borderInteriorColor = new Color(255, 255, 255, 200);
    private Color textColor = new Color(10, 10, 60);
    private Color bgEndColor = new Color(100, 109, 237, 200);
    private int gradientSteps = 50;
    private boolean enabled = true;

    public OverLayPanel(JComponent jComponent, int n, int n2) {
        this.parentPanel = jComponent;
        this.width = n;
        this.height = n2;
        this.x = jComponent.getLocation().x + jComponent.getSize().width / 2 - n / 2;
        this.y = jComponent.getLocation().y + jComponent.getSize().height / 2 - n2 / 2;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (this.enabled) {
            int n;
            this.x = this.parentPanel.getLocation().x + this.parentPanel.getSize().width / 2 - this.width / 2;
            this.y = this.parentPanel.getLocation().y + this.parentPanel.getSize().height / 2 - this.height / 2;
            int n2 = this.width / this.gradientSteps;
            for (n = 0; n < this.gradientSteps; ++n) {
                float f = (float)n / (float)this.gradientSteps;
                int n3 = (int)((float)this.bgEndColor.getRed() * f + (float)this.bgColor.getRed() * (1.0f - f));
                int n4 = (int)((float)this.bgEndColor.getGreen() * f + (float)this.bgColor.getGreen() * (1.0f - f));
                int n5 = (int)((float)this.bgEndColor.getBlue() * f + (float)this.bgColor.getBlue() * (1.0f - f));
                Color color = new Color(n3, n4, n5, 150);
                graphics.setColor(color);
                graphics.fillRect(this.x + n2 * n, this.y, n2, this.height);
            }
            graphics.setColor(this.borderLineColor);
            graphics.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
            graphics.setColor(this.borderInteriorColor);
            graphics.drawRect(this.x + 2, this.y + 2, this.width - 4, this.height - 4);
            graphics.setColor(this.textColor);
            graphics.setFont(this.textFont);
            n = graphics.getFontMetrics(this.textFont).stringWidth(this.text);
            int n6 = graphics.getFontMetrics(this.textFont).getHeight();
            graphics.drawString(this.text, this.x + this.width / 2 - n / 2, this.y + this.height / 2 + n6 / 2);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        ((JXLayer)jComponent).setLayerEventMask(16L);
        this.getParentPanel().setEnabled(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        ((JXLayer)jComponent).setLayerEventMask(0L);
    }

    public void eventDispatched(AWTEvent aWTEvent, JXLayer jXLayer) {
        super.eventDispatched(aWTEvent, jXLayer);
        switch (aWTEvent.getID()) {
            case 500: 
            case 501: 
            case 502: {
                if (!this.enabled) break;
                ((MouseEvent)aWTEvent).consume();
            }
        }
    }

    public JXLayer<JComponent> createLayer() {
        this.enabled = true;
        return new JXLayer((Component)this.parentPanel, (LayerUI)this);
    }

    public void setParentPanel(JComponent jComponent) {
        this.parentPanel = jComponent;
    }

    public JComponent getParentPanel() {
        return this.parentPanel;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getY() {
        return this.y;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBorderLineColor(Color color) {
        this.borderLineColor = color;
    }

    public Color getBorderLineColor() {
        return this.borderLineColor;
    }

    public void setBorderInteriorColor(Color color) {
        this.borderInteriorColor = color;
    }

    public Color getBorderInteriorColor() {
        return this.borderInteriorColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Color getBgEndColor() {
        return this.bgEndColor;
    }

    public void setBgEndColor(Color color) {
        this.bgEndColor = color;
    }

    public int getGradientSteps() {
        return this.gradientSteps;
    }

    public void setGradientSteps(int n) {
        this.gradientSteps = n;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
    }
}

