/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.inspector.PropertyInspector;

public class PIAncestorListener
implements AncestorListener {
    private static final int MAX_HEIGHT = 220;
    private static final double RATIO = 2.85;
    private static final int PADDING = 28;
    protected Dimension defaultSize;
    private Container propertyInspector;
    private JPanel piComponentPanel;
    private ComponentListener listener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            PIAncestorListener.this.resizeComponent(componentEvent.getComponent());
            PIAncestorListener.this.piComponentPanel.invalidate();
        }
    };

    public PIAncestorListener(JPanel jPanel) {
        this.piComponentPanel = jPanel;
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (this.propertyInspector == null) {
            this.propertyInspector = SwingUtilities.getAncestorOfClass(PropertyInspector.class, this.piComponentPanel);
            this.defaultSize = this.piComponentPanel.getPreferredSize();
            this.resizeComponent(this.propertyInspector);
            this.propertyInspector.addComponentListener(this.listener);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        if (ancestorEvent.getAncestor().getClass().equals(this.piComponentPanel.getClass())) {
            this.propertyInspector.removeComponentListener(this.listener);
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private void resizeComponent(Component component) {
        int n = component.getHeight() - 28;
        Dimension dimension = component.getSize();
        double d = dimension.getWidth() / dimension.getHeight();
        if (d < 2.85) {
            n = Math.min(220, this.defaultSize.height);
        } else if (n < 220) {
            n = Math.min(220, this.defaultSize.height);
        }
        Dimension dimension2 = new Dimension(this.piComponentPanel.getWidth(), n);
        this.piComponentPanel.setPreferredSize(dimension2);
    }
}

