/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTargetSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.ide.Context;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class SQLHelper {
    private static final Logger theLogger = Logger.getLogger(SQLHelper.class.getName());
    private static final String INDENTATION = "    ";
    public static final String CREATE_STATEMENT = "CREATE_STATEMENT";
    public static final String CREATE_INDEX = "CREATE_INDEX";
    public static final String INSERT_STATEMENT = "INSERT_STATEMENT";
    public static final String PURGE_TABLE = "PURGE_TABLE";
    public static final String CREATE_SERVER_CALL = "CREATE_SERVER_CALL";
    public static final String CREATE_TEMP_INPUT_VIEW = "CREATE_TEMP_INPUT_VIEW";
    public static final String HISTOGRAM_API = "HISTOGRAM_API";
    public static final String HISTOGRAM_SAMPLE = "HISTOGRAM_SAMPLE";
    public static final String TEMP_INPUT_VIEW_NAME = "TEMP_INPUT_VIEW_NAME";
    public static final String TEMP_SAMPLED_HISTOGRAM_TABLE_NAME = "TEMP_SAMPLED_HISTOGRAM_TABLE_NAME";
    public static final String TEMP_SAMPLED_TABLE_NAME = "TEMP_SAMPLED_TABLE_NAME";
    public static final String DROP_EXPLORE_NODE_TABLE_NAME = "DROP_EXPLORE_NODE_TABLE_NAME";
    public static final String CREATE_SAMPLE_DATA = "CREATE_SAMPLE_DATA";
    public PreparedStatement pstmt;
    public OraclePreparedStatement opstmt;
    public CallableStatement cstmt;
    public Statement stmt;
    public ResultSet rs;
    public OracleResultSet ors;
    public String message;
    public boolean success;
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public String owner;
    public static final StringBuilder _empty = new StringBuilder("");
    private static String _timestamp_no_tz = "DD.MM.YYYY HH24:MI:SS";
    private static String _update_DATE_sql = "update <stats_table_name> set AVG_DATE = \n  (select TO_DATE(TO_CHAR(AVG_DATE, ''" + _timestamp_no_tz + "''), ''" + _timestamp_no_tz + "'') AVG_DATE from (\n" + "  WITH\n" + "  CASTED_VIEW  AS (SELECT CAST(<column_name> AS DATE) <column_name> FROM <input_table>),\n" + "  MIN_MAX_VIEW AS (SELECT MIN (<column_name>)  min_date,  MAX (<column_name>) max_date FROM CASTED_VIEW ),\n" + "  TRUNC_VIEW AS (SELECT\n" + "      TO_CHAR(<column_name>, ''" + _timestamp_no_tz + "'') <column_name>,\n" + "      trunc(86400*(<column_name>-min_date))-60*(trunc((86400*(<column_name>-min_date))/60)) SECONDS,\n" + "      trunc((86400*(<column_name>-min_date))/60)-60*(trunc(((86400*(<column_name>-min_date))/60)/60)) MINUTES,\n" + "      trunc(((86400*(<column_name>-min_date))/60)/60)-24*(trunc((((86400*(<column_name>-min_date))/60)/60)/24)) HOURS,\n" + "      trunc((((86400*(<column_name>-min_date))/60)/60)/24) DAYS\n" + "  FROM MIN_MAX_VIEW, CASTED_VIEW) ,\n" + "  AVG_SECONDS_VIEW AS (\n" + "  SELECT AVG((SECONDS+MINUTES*60+HOURS*60*60+DAYS*86400)) TOTAL_SEC_AVG from TRUNC_VIEW)\n" + "  select (min_date + TOTAL_SEC_AVG/86400) AVG_DATE\n" + "  from AVG_SECONDS_VIEW, MIN_MAX_VIEW ) ) where ATTR=''<column_name>''";
    private static String _update_MEDIAN_DATE_sql = "update <stats_table_name> set MEDIAN_DATE = \n  (select TO_DATE(TO_CHAR(MEDIAN_DATE, ''" + _timestamp_no_tz + "''), ''" + _timestamp_no_tz + "'') MEDIAN_DATE from ( \n" + "  WITH \n" + "  CASTED_VIEW  AS (SELECT CAST(<column_name> AS DATE) <column_name> FROM <input_table>), \n" + "  MIN_MAX_VIEW AS (SELECT MIN (<column_name>)  min_date,  MAX (<column_name>) max_date FROM CASTED_VIEW ), \n" + "  TRUNC_VIEW AS (SELECT \n" + "      TO_CHAR(<column_name>, ''" + _timestamp_no_tz + "'') <column_name>, \n" + "      trunc(86400*(<column_name>-min_date))-60*(trunc((86400*(<column_name>-min_date))/60)) SECONDS, \n" + "      trunc((86400*(<column_name>-min_date))/60)-60*(trunc(((86400*(<column_name>-min_date))/60)/60)) MINUTES, \n" + "      trunc(((86400*(<column_name>-min_date))/60)/60)-24*(trunc((((86400*(<column_name>-min_date))/60)/60)/24)) HOURS, \n" + "      trunc((((86400*(<column_name>-min_date))/60)/60)/24) DAYS \n" + "  FROM MIN_MAX_VIEW, CASTED_VIEW) , \n" + "  MEDIAN_SECONDS_VIEW AS ( \n" + "  SELECT MEDIAN((SECONDS+MINUTES*60+HOURS*60*60+DAYS*86400)) TOTAL_SEC_MEDIAN from TRUNC_VIEW) \n" + "  select (min_date + TOTAL_SEC_MEDIAN/86400) MEDIAN_DATE \n" + "  from MEDIAN_SECONDS_VIEW, MIN_MAX_VIEW ) ) where ATTR=''<column_name>''";
    private static String _timestamp_ts_tz = "DD.MM.YYYY HH24:MI:SS TZH:TZM";
    private static String _update_TS_TZ_sql = "update <stats_table_name> set AVG_TS_TZ = \n  (SELECT TO_TIMESTAMP_TZ(TO_CHAR(AVG_DATE,''" + _timestamp_ts_tz + "''), ''" + _timestamp_ts_tz + "'') AVG_DATE FROM (\n" + "  WITH\n" + "  MIN_MAX_VIEW   AS (SELECT MIN(<column_name>) MIN_DATE, MAX(<column_name>) MAX_DATE FROM <input_table> ),\n\n" + "  DIFF_VIEW      AS (SELECT (<column_name>-MIN_DATE) date_interval FROM MIN_MAX_VIEW, <input_table>),\n\n" + "  DIFF_VIEW_SECS AS (SELECT (to_number(EXTRACT(SECOND FROM date_interval)) +\n\n" + "                  to_number(EXTRACT(minute from date_interval)) * 60 +\n\n" + "                  to_number(EXTRACT(hour from date_interval)) * 60 * 60 +\n\n" + "                  to_number(EXTRACT(day from date_interval)) * 60 * 60 * 24) AS SECONDS_DIF FROM DIFF_VIEW),\n\n" + "  AVG_SECONDS_VIEW  AS (SELECT AVG(SECONDS_DIF) TOTAL_SEC_AVG FROM DIFF_VIEW_SECS)\n\n" + "  SELECT CAST ((MIN_DATE + TOTAL_SEC_AVG/86400) AS TIMESTAMP WITH TIME ZONE) AVG_DATE\n\n" + "  FROM AVG_SECONDS_VIEW, MIN_MAX_VIEW ) ) where ATTR=''<column_name>''";
    private static String _update_MEDIAN_TS_TZ_sql = "update <stats_table_name> set MEDIAN_TS_TZ = \n  (SELECT TO_TIMESTAMP_TZ(TO_CHAR(MEDIAN_DATE,'" + _timestamp_ts_tz + "'), '" + _timestamp_ts_tz + "') MEDIAN_DATE FROM (\n" + "  WITH\n" + "  MIN_MAX_VIEW   AS (SELECT MIN(<column_name>) MIN_DATE, MAX(<column_name>) MAX_DATE FROM <input_table> ),\n" + "  DIFF_VIEW      AS (SELECT (<column_name>-MIN_DATE) date_interval FROM MIN_MAX_VIEW, <input_table>),\n" + "  DIFF_VIEW_SECS AS (SELECT (to_number(EXTRACT(SECOND FROM date_interval)) +\n" + "                  to_number(EXTRACT(minute from date_interval)) * 60 +\n" + "                  to_number(EXTRACT(hour from date_interval)) * 60 * 60 +\n" + "                  to_number(EXTRACT(day from date_interval)) * 60 * 60 * 24) AS SECONDS_DIF FROM DIFF_VIEW),\n" + "  MEDIAN_SECONDS_VIEW  AS (SELECT MEDIAN(SECONDS_DIF) TOTAL_SEC_MEDIAN FROM DIFF_VIEW_SECS)\n" + "  SELECT CAST ((MIN_DATE + TOTAL_SEC_MEDIAN/86400) AS TIMESTAMP WITH TIME ZONE) MEDIAN_DATE\n" + "  FROM MEDIAN_SECONDS_VIEW, MIN_MAX_VIEW ) ) where ATTR=''<column_name>''";
    private static String _sqlCalcHistograms = "  ODMR_UTIL.CLIENT_CALCULATE_HISTOGRAMS (\n     <p_input_table>,\n      '<stats_table_name>',\n     <p_num_bins>,\n     <p_cat_bins>,\n     <p_date_bins>,\n     <p_grouping_column>,\n     <p_grouping_column_type>,\n     v_attributes,\n     v_attrDataTypes,\n     <p_sampled_mode>,\n     <p_parallel_query_hint>,\n     <p_parallel_insert_hint>,\n     <p_parallel_table_hint>);\n";
    private static String _sqlNonSampleData = "  v_histogram_sampled_data := v_explore_sampled_data;\n";
    private static String _sqlSampleData = "  v_explore_sampled_data := ODMR_UTIL.CREATE_SAMPLE_DATA (\n     v_data_view_name,\n     <p_useNumberOfRows>,\n     <p_numberOfRows>,\n     <p_usePercentOfTotal>,\n     <p_percentOfTotal>,\n     <p_useRandom>,\n     <p_seed>,\n     <p_useStratified>,\n     <p_useTopN>,\n     <p_parallel_query_hint>,\n     <p_parallel_insert_hint>,\n     <p_parallel_table_hint>);\n";
    private static String _sqlSampleHistograms = "  v_histogram_sampled_data := ODMR_UTIL.CREATE_HISTOGRAM_SAMPLE_DATA(v_data_view_name);\n";
    private static String _odmrEngineCall_all_data = "\n  ODMR_UTIL.CREATE_EXPLORE_NODE_STATISTICS(\n    p_input_view              => v_data_view_name,\n    p_statistics_table_name   => '<stats_table_name>',\n    p_attributes              => v_attributes,\n    p_attrDataTypes           => v_attrDataTypes,\n    p_calc_percent_distinct   => <PERCENT_DISTINCT>,\n    p_calc_percent_null       => <PERCENT_NULL>,\n    p_calc_max                => <MAX_VALUE>,\n    p_calc_min                => <MIN_VALUE>,\n    p_calc_avg                => <AVG_VALUE>,\n    p_calc_stddev             => <STDDEV_VALUE>,\n    p_calc_variance           => <VAR_VALUE>, \n    p_calc_kurtosis           => <KURT_VALUE>,\n    p_calc_median             => <MEDIAN_VALUE>, \n    p_calc_skewness           => <SKEW_VALUE>,\n    p_calc_mode               => <MODE_VALUE>, \n    p_calc_mode_sampled       => <MODE_SAMPLED>, \n    p_calc_mode_all           => <MODE_ALL>,\n    p_parallel_query_hint     => <p_parallel_query_hint>,\n    p_parallel_insert_hint    => <p_parallel_insert_hint>,\n    p_parallel_table_hint     => <p_parallel_table_hint>);\n";
    private static String _odmrEngineCall_sampled_data = "\n  ODMR_UTIL.CREATE_EXPLORE_NODE_STATISTICS(\n    p_input_view              => v_explore_sampled_data,\n    p_statistics_table_name   => '<stats_table_name>',\n    p_attributes              => v_attributes,\n    p_attrDataTypes           => v_attrDataTypes,\n    p_calc_percent_distinct   => <PERCENT_DISTINCT>,\n    p_calc_percent_null       => <PERCENT_NULL>,\n    p_calc_max                => <MAX_VALUE>,\n    p_calc_min                => <MIN_VALUE>,\n    p_calc_avg                => <AVG_VALUE>,\n    p_calc_stddev             => <STDDEV_VALUE>,\n    p_calc_variance           => <VAR_VALUE>, \n    p_calc_kurtosis           => <KURT_VALUE>,\n    p_calc_median             => <MEDIAN_VALUE>, \n    p_calc_skewness           => <SKEW_VALUE>,\n    p_calc_mode               => <MODE_VALUE>, \n    p_calc_mode_sampled       => <MODE_SAMPLED>, \n    p_calc_mode_all           => <MODE_ALL>,\n    p_parallel_query_hint     => <p_parallel_query_hint>,\n    p_parallel_insert_hint    => <p_parallel_insert_hint>,\n    p_parallel_table_hint     => <p_parallel_table_hint>);\n";
    private static String _columns_LOOP = "  FOR j IN 1..v_columns.COUNT LOOP\n    v_attributes.EXTEND(1);\n    IF ( v_aliases(j) IS NOT NULL ) THEN\n      v_attributes(v_attributes.COUNT) := v_aliases(j);\n    ELSE \n      v_attributes(v_attributes.COUNT) := v_columns(j);\n    END IF;\n  END LOOP;\n\n";
    private static String _dropHistDataViewSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_data_view_name, 'VIEW', NULL, 'Input Data');";
    private static String _dropHistSampledTableSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_histogram_sampled_data, 'TABLE', NULL, 'Sampled Histogram Data');";
    private static String _dropSampledTableSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_explore_sampled_data, 'TABLE', NULL, 'Sampled Data');";
    private static String _dropExploreTableSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, '<stats_table_name>', 'TABLE', NULL, 'Output Data');";
    public static final String INPUT_SQL = "<INPUT_SQL>";
    private static String _purgeStatsTableSQL = "DROP TABLE <stats_table_name> PURGE";
    public static final String PERCENT_DISTINCT = "<PERCENT_DISTINCT>";
    public static final String PERCENT_NULL = "<PERCENT_NULL>";
    public static final String MAX_VALUE = "<MAX_VALUE>";
    public static final String MIN_VALUE = "<MIN_VALUE>";
    public static final String AVG_VALUE = "<AVG_VALUE>";
    public static final String STDDEV_VALUE = "<STDDEV_VALUE>";
    public static final String VAR_VALUE = "<VAR_VALUE>";
    public static final String KURT_VALUE = "<KURT_VALUE>";
    public static final String MEDIAN_VALUE = "<MEDIAN_VALUE>";
    public static final String SKEW_VALUE = "<SKEW_VALUE>";
    public static final String MODE_VALUE = "<MODE_VALUE>";
    public static final String MODE_ALL = "<MODE_ALL>";
    public static final String MODE_SAMPLED = "<MODE_SAMPLED>";
    public static final String p_parallel_query_hint = "<p_parallel_query_hint>";
    public static final String p_parallel_insert_hint = "<p_parallel_insert_hint>";
    public static final String p_parallel_table_hint = "<p_parallel_table_hint>";
    public static final String JOIN_LEFT_OUTER = " LEFT OUTER JOIN ";
    public static final String JOIN_RIGHT_OUTER = " RIGHT OUTER JOIN ";
    public static final String JOIN = " JOIN ";

    public void close() {
        if (null != this.rs) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getMessage(), exception);
            }
        }
        if (null != this.ors) {
            try {
                this.ors.close();
                this.ors = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getMessage(), exception);
            }
        }
        if (null != this.stmt) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getMessage(), exception);
            }
        }
        if (null != this.pstmt) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getMessage(), exception);
            }
        }
        if (null != this.opstmt) {
            try {
                this.opstmt.close();
                this.opstmt = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getMessage(), exception);
            }
        }
        if (null != this.cstmt) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getMessage(), exception);
            }
        }
    }

    public static String buildSimpleQuery(String[] stringArray, String[] stringArray2, String string) {
        assert (stringArray != null && stringArray.length >= 0) : "Columns array cannot be null";
        assert (stringArray2 != null && stringArray2.length >= 0) : "Tables array cannot be null";
        if (string != null) assert (string.length() > 0) : "Where clause cannot be empty";
        StringBuffer stringBuffer = SQLHelper.formatSelectClause(stringArray);
        stringBuffer.append(SQLHelper.formatFromClause(stringArray2));
        if (string != null) {
            stringBuffer.append("\nwhere " + string);
        }
        return stringBuffer.toString();
    }

    public static String buildSimpleAliasQuery(String[] stringArray, String[] stringArray2, String[] stringArray3, String string) {
        assert (stringArray != null && stringArray.length >= 0) : "Columns array cannot be null";
        assert (stringArray3 != null && stringArray3.length >= 0) : "Tables array cannot be null";
        if (string != null) assert (string.length() > 0) : "Where clause cannot be empty";
        StringBuffer stringBuffer = SQLHelper.formatSelectClauseAlias(stringArray, stringArray2);
        stringBuffer.append(SQLHelper.formatFromClause(stringArray3));
        if (string != null) {
            stringBuffer.append("\nwhere " + string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, StringBuilder> buildCreateTableSQL(Context context, List<DatabaseMetadataUtils.ColumnInfo> list, String string, String string2) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("CREATE TABLE " + string + " (\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        Connection connection = null;
        try {
            Object object2;
            connection = Connections.getUniqueConnection(context);
            object = null;
            StringBuilder stringBuilder3 = new StringBuilder();
            StringBuilder stringBuilder4 = new StringBuilder();
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DatabaseMetadataUtils.ColumnInfo object3 : list) {
                String string3 = object3.getColumnAlias() != null ? object3.getColumnAlias() : object3.getColumnName();
                String string4 = "\"" + string3 + "\"";
                StringBuilder stringBuilder5 = new StringBuilder();
                for (int i = 0; i < 30 - string3.length(); ++i) {
                    stringBuilder5.append(" ");
                }
                object = object3.getDataType();
                if (n > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append(INDENTATION + string4 + stringBuilder5.toString() + object3.getDataType());
                if (((String)object).equals("VARCHAR2") || ((String)object).equals("CHAR") || ((String)object).equals("NVARCHAR2") || ((String)object).equals("NCHAR")) {
                    stringBuilder.append("(" + object3.getDataLength() + ")");
                }
                ++n;
                if (object3.getPrimaryKey().equals("Yes")) {
                    if (stringBuilder3.length() > 0) {
                        stringBuilder3.append(COMMA);
                    }
                    stringBuilder3.append(string4);
                }
                if (object3.getIndex().equals("Yes") && object3.getPrimaryKey().equals("No")) {
                    if (stringBuilder4.length() > 0) {
                        stringBuilder4.append(COMMA);
                    }
                    stringBuilder4.append(string4);
                }
                if (0 == ((String)object).compareToIgnoreCase("CLOB") || 0 == ((String)object).compareToIgnoreCase("NCLOB")) {
                    arrayList.add(String.format("LOB(%s) STORE AS BASICFILE", string4));
                    continue;
                }
                if (0 == ((String)object).compareToIgnoreCase("XMLTYPE")) {
                    arrayList.add(String.format("XMLTYPE COLUMN %s STORE AS BASICFILE CLOB", string4));
                    continue;
                }
                if (object3.getColType() == null || 0 != object3.getColType().compareToIgnoreCase("TABLE")) continue;
                String string5 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connection);
                arrayList.add(String.format("NESTED TABLE %s STORE AS %s", string4, string5));
            }
            if (stringBuilder3.length() > 0) {
                object2 = null;
                object2 = DatabaseMetadataUtils.createUniquePKConstraintName("ODMR$", connection);
                stringBuilder.append(",\n    CONSTRAINT ");
                stringBuilder.append((String)object2);
                stringBuilder.append(" PRIMARY KEY (");
                stringBuilder.append((CharSequence)stringBuilder3);
                stringBuilder.append(")");
            }
            stringBuilder.append(")\n");
            n = 0;
            for (String string6 : arrayList) {
                if (n > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append(INDENTATION + string6);
                ++n;
            }
            stringBuilder.append(INDENTATION + string2);
            if (stringBuilder4.length() > 0) {
                object2 = DatabaseMetadataUtils.createUniqueConstraintNameUsinRandom("ODMR$", connection);
                stringBuilder2.append("v_sql := 'CREATE INDEX ");
                stringBuilder2.append((String)object2);
                stringBuilder2.append(" ON ");
                stringBuilder2.append(string);
                stringBuilder2.append(" (");
                stringBuilder2.append((CharSequence)stringBuilder4);
                stringBuilder2.append(") " + string2 + " ';");
                stringBuilder2.append("\n");
                stringBuilder2.append("  execSQL(v_sql);");
            }
        }
        catch (Exception exception) {
            stringBuilder = new StringBuilder(String.format(UtilsLrb.get("FAILURE_CREATE_TABLE_SWL"), exception.getMessage()));
        }
        finally {
            SQLHelper.close(connection);
        }
        object = new HashMap<String, StringBuilder>();
        object.put(CREATE_STATEMENT, stringBuilder);
        object.put(CREATE_INDEX, stringBuilder2);
        return object;
    }

    public static String populateCreatedTableSQL(List<DatabaseMetadataUtils.ColumnInfo> list, String string, String string2, AbstractNode abstractNode, String string3, String string4) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("INSERT " + string3 + " INTO " + string + "\n");
        boolean bl = AbstractDataNode.generateSQLInlineHint();
        String string5 = bl ? "/*+ inline " + string4 + " */ " : "/*+ " + string4 + " */ ";
        stringBuilder.append("    SELECT " + string5);
        stringBuilder.append("\n");
        for (DatabaseMetadataUtils.ColumnInfo columnInfo : list) {
            String string6 = columnInfo.getColumnName();
            String string7 = "\"" + string6 + "\"";
            if (n > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append(INDENTATION + string7);
            ++n;
        }
        if (abstractNode instanceof DataProfileNode) {
            DatabaseMetadataUtils.ColumnInfo columnInfo;
            DataProfileNode dataProfileNode = (DataProfileNode)abstractNode;
            columnInfo = (DataProfileNodeType)dataProfileNode.getData();
            stringBuilder.append("\n    FROM " + columnInfo.getStatisticTable().getName());
        } else {
            stringBuilder.append("\n    FROM (");
            stringBuilder.append(string2);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static String buildCreateViewSQL(List<DatabaseMetadataUtils.ColumnInfo> list, String string, String string2, String string3) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("CREATE VIEW " + string + " AS \n");
        boolean bl = AbstractDataNode.generateSQLInlineHint();
        String string4 = bl ? "/*+ inline " + string3 + " */ " : "/*+ " + string3 + " */ ";
        stringBuilder.append("    SELECT " + string4);
        stringBuilder.append("\n");
        for (DatabaseMetadataUtils.ColumnInfo columnInfo : list) {
            String string5;
            String string6 = columnInfo.getColumnName();
            String string7 = "\"" + string6 + "\"";
            String string8 = columnInfo.getColumnAlias();
            String string9 = string5 = string8 != null ? "\"" + string8 + "\"" : null;
            if (n > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append(INDENTATION + string7);
            if (string5 != null) {
                stringBuilder.append(" " + string5);
            }
            ++n;
        }
        stringBuilder.append("\n    FROM (");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Map<String, StringBuilder> buildUpdateTableSQL(List<MapTargetSourceType> list, String string, String string2, String string3, String string4, boolean bl, String string5, String string6) {
        CharSequence charSequence;
        String string7;
        Object object2;
        String string8 = string;
        StringBuilder stringBuilder = new StringBuilder("INSERT " + string5 + " INTO " + string8 + " (\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (Object object2 : list) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",\n");
            }
            string7 = object2.getKey().getName();
            stringBuilder2.append("              ");
            stringBuilder2.append(StringUtils.isDoubleQuotedString(string7) ? string7 : StringUtils.addDoubleQuotes(string7));
            if (stringBuilder3.length() > 0) {
                stringBuilder3.append(",\n");
            }
            charSequence = object2.getValue().getName();
            stringBuilder3.append("              ");
            stringBuilder3.append((String)(StringUtils.isDoubleQuotedString((String)charSequence) ? charSequence : StringUtils.addDoubleQuotes((String)charSequence)));
        }
        StringBuilder stringBuilder4 = new StringBuilder("\n              WITH ");
        stringBuilder4.append(string2);
        stringBuilder4.append(",\n");
        object2 = StringUtils.addDoubleQuotes("N$" + string4);
        string7 = StringUtils.addDoubleQuotes("N$" + string3);
        stringBuilder4.append((String)object2);
        stringBuilder4.append(" AS ( SELECT /*+ inline */ ");
        stringBuilder4.append((CharSequence)stringBuilder3);
        stringBuilder4.append(" FROM " + string7);
        stringBuilder4.append(")\n");
        stringBuilder4.append("SELECT * FROM " + (String)object2);
        stringBuilder4.append("\n");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(")\n");
        stringBuilder.append("            SELECT ");
        stringBuilder.append(string6);
        stringBuilder.append("\n");
        stringBuilder.append((CharSequence)stringBuilder3);
        stringBuilder.append("\n            FROM (");
        stringBuilder.append((CharSequence)stringBuilder4);
        stringBuilder.append(")\n");
        charSequence = new StringBuilder();
        if (bl) {
            ((StringBuilder)charSequence).append("v_sql := 'DELETE FROM ");
            ((StringBuilder)charSequence).append(string8);
            ((StringBuilder)charSequence).append("';");
            ((StringBuilder)charSequence).append("\n");
            ((StringBuilder)charSequence).append("  execSQL(v_sql);");
        }
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
        hashMap.put(INSERT_STATEMENT, stringBuilder);
        hashMap.put(PURGE_TABLE, (StringBuilder)charSequence);
        return hashMap;
    }

    public static StringBuffer formatSelectClauseAlias(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("select " + (AbstractDataNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (stringArray2[i] != null && stringArray2[i].trim().length() > 0) {
                stringBuffer.append(" AS ");
                stringBuffer.append(stringArray2[i]);
            }
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatQuery(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        stringBuffer.insert(0, "select " + (AbstractDataNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        stringBuffer2.insert(0, "\n from ");
        return stringBuffer.append(stringBuffer2.append(string != null ? "\n where " + string.toString() : ""));
    }

    public static StringBuffer formatSelectClause(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("select " + (AbstractDataNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatFromClause(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("\nfrom ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatJoinFromClause(String string, String string2, String string3, String string4) {
        return new StringBuffer("\n from " + string + string3 + string2).append(" ON " + string4);
    }

    public static String buildSimpleQuery(String[] stringArray, String[] stringArray2) {
        return SQLHelper.buildSimpleQuery(stringArray, stringArray2, null);
    }

    public static String[] delimit(String[] stringArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(SQLHelper.delimit(stringArray[i], string));
        }
        String[] stringArray2 = new String[]{};
        return vector.toArray(stringArray2);
    }

    public static String delimit(String string, String string2) {
        return "\"" + string2 + "\"" + DOT + "\"" + string + "\"";
    }

    public static String delimitTable(String string, String string2) {
        return "\"" + string + "\".\"" + string2 + "\"";
    }

    public static String[] combine(String[] stringArray, String[] stringArray2) {
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            vector.add(string);
        }
        for (String string : stringArray2) {
            vector.add(string);
        }
        String[] stringArray3 = new String[]{};
        return vector.toArray(stringArray3);
    }

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
        }
    }

    public static Map<String, StringBuilder> buildStatsTableSQL2(List<AttributeType> list, String string, String string2, String string3, SampleSettings sampleSettings, boolean bl, String string4, String string5, String string6) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        CharSequence charSequence;
        boolean bl2;
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
        String string7 = StringUtils.getReplacedString(_purgeStatsTableSQL, "<stats_table_name>", string);
        StringBuilder stringBuilder3 = new StringBuilder(string7);
        hashMap.put(PURGE_TABLE, stringBuilder3);
        StringBuilder stringBuilder4 = new StringBuilder(32000);
        StringBuilder stringBuilder5 = new StringBuilder("  v_sql := 'CREATE VIEW ");
        stringBuilder5.append("'||v_data_view_name||'");
        stringBuilder5.append(" AS SELECT ");
        stringBuilder5.append(string5);
        stringBuilder5.append(" * FROM (\n  WITH <INPUT_SQL>\n");
        stringBuilder5.append("SELECT * FROM INPUT_DATA_VIEW)';");
        stringBuilder5.append("\n");
        stringBuilder5.append("  execSQL(v_sql);\n");
        hashMap.put(CREATE_TEMP_INPUT_VIEW, stringBuilder5);
        for (AttributeType attributeType : list) {
            String string8 = attributeType.getName();
            String string9 = attributeType.getAlias();
            String string10 = attributeType.getDataType();
            stringBuilder4.append("  v_columns.EXTEND(1);\n  v_columns(v_columns.COUNT) := '" + string8 + "';\n" + "  v_aliases.EXTEND(1);\n");
            if (string9 != null) {
                stringBuilder4.append("  v_aliases(v_aliases.COUNT) := '" + string9 + "';\n");
            } else {
                stringBuilder4.append("  v_aliases(v_aliases.COUNT) := null;\n");
            }
            stringBuilder4.append("  v_attrDataTypes.EXTEND(1);\n  v_attrDataTypes(v_attrDataTypes.COUNT) := '" + string10 + "';\n\n");
        }
        stringBuilder4.append(_columns_LOOP);
        int n = 0;
        int n2 = 0;
        boolean bl3 = bl2 = null != sampleSettings && !sampleSettings.isUseFullData();
        if (bl2) {
            int n3;
            int n4;
            int n5;
            if (null != sampleSettings.getNumberOfRows()) {
                n = 1;
                n2 = 0;
            } else if (null != sampleSettings.getPercentOfTotal()) {
                n2 = 1;
                n = 0;
            } else {
                n2 = 0;
                n = 0;
            }
            int n6 = 12345;
            if (null != sampleSettings.getMethod() && null != sampleSettings.getMethod().getRandom() && null != sampleSettings.getMethod().getRandom().getSeed()) {
                n5 = 1;
                n4 = 0;
                n3 = 0;
                n6 = sampleSettings.getMethod().getRandom().getSeed().intValue();
            } else {
                n3 = 1;
                n4 = 0;
                n5 = 0;
            }
            charSequence = StringUtils.getReplacedString(_sqlSampleData, "<p_useNumberOfRows>", String.valueOf(n));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_numberOfRows>", String.valueOf(sampleSettings.getNumberOfRows()));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_usePercentOfTotal>", String.valueOf(n2));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_percentOfTotal>", String.valueOf(sampleSettings.getPercentOfTotal()));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_useRandom>", String.valueOf(n5));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_seed>", String.valueOf(n6));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_useStratified>", String.valueOf(n4));
            charSequence = StringUtils.getReplacedString(charSequence, p_parallel_query_hint, StringUtils.addSingleQuotes(String.valueOf(string5)));
            charSequence = StringUtils.getReplacedString(charSequence, p_parallel_insert_hint, StringUtils.addSingleQuotes(String.valueOf(string6)));
            charSequence = StringUtils.getReplacedString(charSequence, p_parallel_table_hint, StringUtils.addSingleQuotes(String.valueOf(string4)));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_useTopN>", String.valueOf(n3));
            stringBuilder2 = new StringBuilder(_dropSampledTableSQL);
            hashMap.put(TEMP_SAMPLED_TABLE_NAME, stringBuilder2);
            stringBuilder = new StringBuilder((String)charSequence);
            hashMap.put(CREATE_SAMPLE_DATA, stringBuilder);
        } else {
            hashMap.put(CREATE_SAMPLE_DATA, _empty);
            hashMap.put(TEMP_SAMPLED_TABLE_NAME, _empty);
        }
        String string11 = StringUtils.getReplacedString(_dropExploreTableSQL, "<stats_table_name>", string);
        StringBuilder stringBuilder6 = new StringBuilder(string11);
        hashMap.put(DROP_EXPLORE_NODE_TABLE_NAME, stringBuilder6);
        StringBuilder stringBuilder7 = new StringBuilder(stringBuilder4);
        String string12 = StringUtils.getReplacedString(bl2 ? _odmrEngineCall_sampled_data : _odmrEngineCall_all_data, "<stats_table_name>", string);
        stringBuilder7.append(string12);
        hashMap.put(CREATE_SERVER_CALL, stringBuilder7);
        if (1 == n && sampleSettings.getNumberOfRows() <= 2000L) {
            charSequence = new StringBuilder(_sqlNonSampleData);
            hashMap.put(HISTOGRAM_SAMPLE, (StringBuilder)charSequence);
            hashMap.put(TEMP_SAMPLED_HISTOGRAM_TABLE_NAME, _empty);
        } else {
            charSequence = new StringBuilder(_sqlSampleHistograms);
            hashMap.put(HISTOGRAM_SAMPLE, (StringBuilder)charSequence);
            stringBuilder2 = new StringBuilder(_dropHistSampledTableSQL);
            hashMap.put(TEMP_SAMPLED_HISTOGRAM_TABLE_NAME, stringBuilder2);
        }
        charSequence = StringUtils.getReplacedString(_sqlCalcHistograms, "<p_input_table>", "v_histogram_sampled_data");
        charSequence = StringUtils.getReplacedString(charSequence, "<stats_table_name>", string);
        charSequence = StringUtils.getReplacedString(charSequence, "<p_sampled_mode>", String.valueOf(bl));
        if (string2 != null) {
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column>", "'" + string2 + "'");
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column_type>", "'" + string3 + "'");
        } else {
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column>", "NULL");
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column_type>", "NULL");
        }
        stringBuilder2 = new StringBuilder((String)charSequence);
        stringBuilder2.append("\n");
        hashMap.put(HISTOGRAM_API, stringBuilder2);
        stringBuilder = new StringBuilder(_dropHistDataViewSQL);
        hashMap.put(TEMP_INPUT_VIEW_NAME, stringBuilder);
        return hashMap;
    }

    public static boolean isExtendedTypeEnabled(Context context) {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        boolean bl = false;
        try {
            bl = connectionFolder.isExtendedTypeEnabled();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage(), exception);
        }
        return bl;
    }
}

