/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class SingleColumnRowSorter
extends TableRowSorter<TableModel> {
    private int searchColumnIndex;

    public SingleColumnRowSorter(TableModel tableModel, String string, int n) {
        this(tableModel, string, n, n);
    }

    public SingleColumnRowSorter(TableModel tableModel, String string, int n, int n2) {
        super(tableModel);
        this.searchColumnIndex = n;
        this.setRowFilter(new SingleCategoryRowFilter(string));
        this.configureSorting(n2, tableModel);
    }

    public SingleColumnRowSorter(TableModel tableModel, RowFilter rowFilter) {
        this(tableModel, rowFilter, -1);
    }

    public SingleColumnRowSorter(TableModel tableModel, RowFilter rowFilter, int n) {
        super(tableModel);
        this.setRowFilter(rowFilter);
        this.configureSorting(n, tableModel);
    }

    private void configureSorting(int n, TableModel tableModel) {
        Object object;
        Comparator comparator;
        if (n == -1) {
            n = this.searchColumnIndex;
        }
        if (tableModel instanceof GenericBaseTableModel && (comparator = (object = (GenericBaseTableModel)tableModel).getColumnSortComparator(n)) != null) {
            this.setComparator(n, comparator);
        }
        object = new ArrayList();
        object.add(new RowSorter.SortKey(n, SortOrder.ASCENDING));
        this.setSortKeys((List<RowSorter.SortKey>)object);
    }

    private class SingleCategoryRowFilter
    extends RowFilter<TableModel, Integer> {
        private SearchMatcher matcher;

        public SingleCategoryRowFilter(String string) {
            this.matcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            TableModel tableModel = entry.getModel();
            Object object = tableModel.getValueAt(entry.getIdentifier(), SingleColumnRowSorter.this.searchColumnIndex);
            if (object == null) {
                return false;
            }
            return this.matcher.matches((CharSequence)object.toString());
        }
    }
}

