/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.project;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ConnectionFolderFilter;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.wizard.project.ProjectLrb;
import oracle.dmt.dataminer.wizard.project.ProjectModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;

public class ProjectPanel
extends JPanel
implements DataminerGUIPanel {
    private Context _context;
    private ProjectModel _state;
    private boolean _editMode = false;
    private JTextArea _jComment;
    private JLabel _jCommentLabel;
    private JTextField _jName;
    private JLabel _jNameLabel;
    private JScrollPane jScrollPane1;

    public ProjectPanel(Context context, ProjectModel projectModel) {
        this.initComponents();
        this._context = context;
        this._state = projectModel;
        this._editMode = projectModel.isProjectModelEditMode();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jNameLabel = new JLabel();
        this._jName = new JTextField();
        this._jCommentLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this._jComment = new JTextArea();
        this.setMinimumSize(new Dimension(100, 100));
        this._jNameLabel.setDisplayedMnemonic('N');
        this._jNameLabel.setLabelFor(this._jName);
        this._jNameLabel.setText("Name:");
        this._jCommentLabel.setDisplayedMnemonic('C');
        this._jCommentLabel.setLabelFor(this._jComment);
        this._jCommentLabel.setText("Comment:");
        this._jComment.setColumns(20);
        this._jComment.setRows(3);
        this._jComment.setLineWrap(true);
        this.jScrollPane1.setViewportView(this._jComment);
        this._jComment.getAccessibleContext().setAccessibleDescription("Project comment");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jCommentLabel).addComponent(this._jNameLabel, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 347, Short.MAX_VALUE).addComponent(this._jName, -1, 347, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jNameLabel).addComponent(this._jName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jCommentLabel).addContainerGap(60, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 74, Short.MAX_VALUE))));
        this._jName.getAccessibleContext().setAccessibleDescription("Project name");
    }

    @Override
    public void initUI() {
        this._jNameLabel.setVisible(!this._editMode);
        this._jName.setVisible(!this._editMode);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jNameLabel, (Component)this._jName, (String)ProjectLrb.get("CREATE_PROJECT_NAME"));
        this._jNameLabel.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_NAME_ADA"));
        this._jNameLabel.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_NAME"));
        this._jName.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_NAME_ADA"));
        this._jName.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_NAME"));
        this._jName.setDocument(new TextFieldLimit(30));
        ResourceUtils.resLabel((JLabel)this._jCommentLabel, (Component)this._jComment, (String)ProjectLrb.get("CREATE_PROJECT_COMMENT"));
        this._jCommentLabel.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_COMMENT_ADA"));
        this._jCommentLabel.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_COMMENT"));
        this._jComment.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_COMMENT_ADA"));
        this._jComment.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_COMMENT"));
        this._jComment.setDocument(new TextFieldLimit(4000));
    }

    public boolean validateAndWriteToState(ProjectModel projectModel) {
        final ProjectModel projectModel2 = projectModel;
        boolean bl = false;
        try {
            class ValidateWriteThread
            extends ProgressRunnable {
                boolean validated = true;
                private WorkflowProject _projectObj = null;
                private String projectName;
                private String projectComment;

                ValidateWriteThread() {
                }

                public boolean getValidation() {
                    return this.validated;
                }

                public WorkflowProject getProjectObj() {
                    return this._projectObj;
                }

                protected Object doWork() throws Exception {
                    Connection connection = null;
                    boolean bl = false;
                    boolean bl2 = false;
                    try {
                        connection = Connections.getSharedConnection(ProjectPanel.this._context);
                        this.projectName = ProjectPanel.this._jName.getText();
                        this.projectName = this.projectName.trim();
                        this.projectComment = ProjectPanel.this._jComment.getText().trim();
                        if (ProjectPanel.this._editMode) {
                            bl = true;
                            if (ProjectPanel.this._state.getComment().equals(this.projectComment)) {
                                bl2 = true;
                            }
                        }
                        if (!bl && !ProjectModel.validateProjectName(connection, this.projectName)) {
                            this.validated = false;
                        }
                        if (!this.validated) {
                            return this.validated;
                        }
                        if (!bl2 && !ProjectModel.validateProjectComment(connection, this.projectComment)) {
                            this.validated = false;
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_TITLE"), (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_MESG"), null);
                    }
                    try {
                        if (this.validated) {
                            projectModel2.setName(this.getProjectName());
                            projectModel2.setComment(this.projectComment);
                            this._projectObj = projectModel2.finish();
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_TITLE"), (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_MESG"), null);
                    }
                    return this.validated;
                }

                public String getProjectName() {
                    return this.projectName;
                }
            }
            ValidateWriteThread validateWriteThread = new ValidateWriteThread();
            if (!this._editMode) {
                validateWriteThread.setTitle(ProjectLrb.get("WIZARD_CREATING_PROJECT_TITLE"));
                validateWriteThread.setMessage(ProjectLrb.get("WIZARD_CREATING_PROJECT_MESG"));
            } else {
                validateWriteThread.setTitle(ProjectLrb.get("WIZARD_EDITING_PROJECT_TITLE"));
                validateWriteThread.setMessage(ProjectLrb.get("WIZARD_EDITING_PROJECT_MESG"));
            }
            validateWriteThread.setCancelable(false);
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
            if (!bl) {
                return bl;
            }
            WorkflowProject workflowProject = validateWriteThread.getProjectObj();
            if (!this._editMode) {
                if (workflowProject == null) {
                    return false;
                }
                BaseTreeNode baseTreeNode = (BaseTreeNode)this._context.getElement();
                TreeExplorer treeExplorer = ((NavigatorWindow)this._context.getView()).getTreeExplorer();
                TNode tNode = this.findConnectionFolder(treeExplorer, baseTreeNode, this._context);
                ProjectFolder projectFolder = this.createProjectNode(tNode, workflowProject);
                this.addProjectNode(this._context, tNode, projectFolder);
            }
        }
        catch (Exception exception) {
            if (this._editMode) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ProjectLrb.get("EDIT_PROJECT_FAILURE_TITLE"), (String)ProjectLrb.get("EDIT_PROJECT_FAILURE_MESG"), null);
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_TITLE"), (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_MESG"), null);
        }
        return bl;
    }

    public void initializeFromState(ProjectModel projectModel) {
        this._jName.setText(projectModel.getName());
        if (projectModel.getComment() == null) {
            this._jComment.setText("");
        } else {
            this._jComment.setText(projectModel.getComment());
        }
    }

    private ProjectFolder createProjectNode(TNode tNode, WorkflowProject workflowProject) {
        ConnectionFolder connectionFolder = (ConnectionFolder)tNode.getData();
        ProjectFolder projectFolder = ConnectionFolderFilter.getProjectFolder(connectionFolder.getURL().getPath() + "/" + workflowProject.getName(), true);
        projectFolder.setRepositoryData(workflowProject);
        projectFolder.setId(workflowProject.getId());
        projectFolder.setParent(tNode);
        return projectFolder;
    }

    private TNode findConnectionFolder(TreeExplorer treeExplorer, BaseTreeNode baseTreeNode, Context context) {
        TNode tNode = null;
        TNode tNode2 = null;
        if (!(baseTreeNode instanceof ConnectionFolder)) {
            if (baseTreeNode instanceof ProjectFolder) {
                tNode = treeExplorer.searchTNode((Element)baseTreeNode, treeExplorer.getRoot(), context);
                tNode2 = tNode.getAncestorTNode(ConnectionFolder.class, false);
                assert (tNode2 != null) : "Did not find TNode for ConnectionFolder!";
            } else {
                tNode2 = baseTreeNode.getParent().getAncestorTNode(ConnectionFolder.class, false);
            }
        } else {
            tNode2 = treeExplorer.searchTNode((Element)baseTreeNode, baseTreeNode.getParent(), context);
        }
        BaseDeferredFilter.getChildTreeNodes(tNode2);
        return tNode2;
    }

    private void addProjectNode(Context context, TNode tNode, ProjectFolder projectFolder) {
        ConnectionFolder connectionFolder = (ConnectionFolder)tNode.getData();
        connectionFolder.add((Element)projectFolder, true);
        connectionFolder.markDirty(false);
        projectFolder.selectInTree(context);
    }
}

