/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.workflow;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;

public class WorkflowDialogState {
    private Context _context;
    private String _name;
    private boolean _editMode = false;
    private Workflow _workflowState = null;
    private static final Logger theLogger = Logger.getLogger(WorkflowDialogState.class.getName());

    public WorkflowDialogState(Context context) {
        this._context = context;
        this._editMode = false;
        this.loadDefaults();
    }

    public WorkflowDialogState(Context context, Workflow workflow) throws Exception {
        this._context = context;
        this._editMode = true;
        this._workflowState = workflow;
        this.loadWorkflow();
    }

    private void loadWorkflow() throws Exception {
        if (!this._workflowState.isLoaded()) {
            this.loadWorkflowStateFromDB();
        }
        this._name = this._workflowState.getName();
    }

    private void loadWorkflowStateFromDB() throws Exception {
        final Connection connection = Connections.getSharedConnection(this._context);
        class Loader
        extends ProgressRunnable {
            Loader() {
            }

            protected Object doWork() throws Exception {
                WorkflowDialogState.this._workflowState.load(connection);
                return WorkflowDialogState.this._workflowState;
            }
        }
        Loader loader = new Loader();
        loader.setTitle(WorkflowLrb.get("RETRIEVING_WORKFLOW"));
        loader.setMessage(WorkflowLrb.get("RETRIEVING_WORKFLOW_DETAILS"));
        loader.setCancelable(false);
        try {
            loader.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
            throw progressException;
        }
    }

    public boolean isWorkflowModelEditMode() {
        return this._editMode;
    }

    private Workflow finishCreate() throws Exception {
        Connection connection = null;
        BigDecimal bigDecimal = null;
        Workflow workflow = null;
        connection = Connections.getSharedConnection(this._context);
        ProjectFolder projectFolder = ProjectFolder.getProjectFolder(this._context);
        Timestamp[] timestampArray = new Timestamp[]{new Timestamp(0L)};
        bigDecimal = Workflow.create(connection, projectFolder.getId(), this.getName(), "", timestampArray);
        if (bigDecimal != null) {
            workflow = new Workflow(this.getName(), bigDecimal, null);
        }
        return workflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workflow finishEdit() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getSharedConnection(this._context);
        }
        finally {
            try {
                if (this._workflowState != null) {
                    this._workflowState.unload();
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return this._workflowState;
    }

    public Workflow finish() throws Exception {
        if (!this._editMode) {
            return this.finishCreate();
        }
        return this.finishEdit();
    }

    private void loadDefaults() {
        this._name = this.loadDefaultName();
    }

    private String loadDefaultName() {
        Connection connection = null;
        String string = WorkflowLrb.get("DEFAULT_NAME");
        String string2 = "";
        try {
            connection = Connections.getSharedConnection(this._context);
            ProjectFolder projectFolder = ProjectFolder.getProjectFolder(this._context);
            string2 = Workflow.createUniqueName(connection, projectFolder.getId(), string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string2;
    }

    public String getName() {
        return this._name.toString();
    }

    public void setName(String string) {
        this._name = string;
    }

    public Context getContext() {
        return this._context;
    }
}

