/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.link.IlvLinkLayout;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMModelEvent;
import ilog.views.sdm.event.SDMModelListener;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.model.IlvSDMNode;
import ilog.views.sdm.renderer.graphlayout.IlvGraphLayoutRenderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.readonly.DefaultDiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.DiagramReadOnlyPlugin;
import oracle.diagram.framework.toolbar.DefaultDiagramToolbarPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.RefreshInterface;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.EventLog;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.runner.EventLogDialog;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.ApplyChainGenerator;
import oracle.dmt.dataminer.workflow.WorkflowContextMenu;
import oracle.dmt.dataminer.workflow.WorkflowDiagram;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.ShowMessagesDialog;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.model.WorkflowRunStateAdapter;
import oracle.dmt.dataminer.workflow.parallelquery.WorkflowParallelQueryDialog;
import oracle.dmt.dataminer.workflow.preferences.WorkflowPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.view.View;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.HyperlinkButton;

public class WorkflowEditor
extends DataMinerDiagramEditor
implements RunManagerListener,
RefreshInterface {
    private static final Logger theLogger = Logger.getLogger(WorkflowEditor.class.getName());
    private boolean connectionLossDetected = false;
    private boolean jobsListenerInitialized = false;
    private HyperlinkButton parallelLinkButton = new HyperlinkButton();
    int layoutStyle;
    int layoutMode;
    private BlockingComponent overLayPanel;
    private ModelListener propertyChangeListener = null;
    private WorkflowJob monitoredJob = null;
    private Boolean lockOwner = false;
    private static int STOP_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.stop");
    private static int RUN_CMDID = Ide.findOrCreateCmdID((String)"RunNodeAction");
    private static int UNLOCK_CMDID = Ide.findOrCreateCmdID((String)"unlockDocument");
    private static int REFRESH_CMDID = Ide.findOrCreateCmdID((String)"refreshDocument");

    public BlockingComponent getOverLayPanel() {
        return this.overLayPanel;
    }

    public void setOverLayPanel(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public WorkflowEditor() {
        super((Diagram)new WorkflowDiagram());
        this.setPreferredLayoutBaseName("Workflow Editor");
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return WorkflowContextMenu.getInstance();
    }

    @Override
    public void refresh() {
        try {
            super.refresh();
            if (!this.isActivated()) {
                return;
            }
            WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
            if (workflowNode.isDirty()) {
                String string = MessageFormat.format(WorkflowEditorLrb.get("WORKFLOW_REFRESH_MSG"), workflowNode.getShortLabel());
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)WorkflowEditorLrb.get("WORKFLOW_REFRESH_TITLE"), null)) {
                    this.reload(workflowNode, workflowNode.getWorkflowModel(), false);
                } else {
                    this.setCancelRefresh(true);
                }
            } else if (workflowNode.isReadOnly()) {
                this.reload(workflowNode, workflowNode.getWorkflowModel(), false);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    public HelpInfo getHelpInfo() {
        IlvManagerView ilvManagerView = this.getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        String string = "workflow_diagram_editor";
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof AbstractNode)) continue;
                arrayList.add((AbstractNode)e);
            }
            if (arrayList.size() == 1) {
                string = ((AbstractNode)arrayList.get(0)).getHelpTopic();
            }
        }
        return new HelpInfo(string);
    }

    public void startJobMonitoring() {
        this.updateJobMonitoringState(true);
    }

    public void stopJobMonitoring() {
        this.updateJobMonitoringState(false);
    }

    public WorkflowJob getJob(boolean bl) {
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        Workflow workflow = (Workflow)workflowNode.getRepositoryData();
        WorkflowJob workflowJob = runManager.getJob(connectionFolder.getConnectionName(), workflow.getId(), bl);
        return workflowJob;
    }

    private String getJobStateString(WorkflowJob workflowJob) {
        if (workflowJob != null) {
            String string = workflowJob.getState();
            if (string.equals("ACTIVE")) {
                return WorkflowEditorLrb.get("RUNNING");
            }
            if (string.equals("QUEUED")) {
                return WorkflowEditorLrb.get("QUEUED");
            }
            return "";
        }
        return "";
    }

    public boolean isRunningOrQueued() {
        boolean bl = false;
        WorkflowJob workflowJob = this.getJob(false);
        if (workflowJob != null) {
            bl = this.isRunningOrQueued(workflowJob);
        }
        return bl;
    }

    public boolean isRunningOrQueued(WorkflowJob workflowJob) {
        if (workflowJob == null) {
            return false;
        }
        String string = workflowJob.getState();
        return string.equals("ACTIVE") || string.equals("QUEUED");
    }

    private void updateJobMonitoringState(boolean bl) {
        WorkflowModel workflowModel = null;
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        Workflow workflow = (Workflow)workflowNode.getRepositoryData();
        try {
            workflowModel = workflowNode.getWorkflowModel();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (bl) {
            workflowModel.setRunStateAdapter(new WorkflowRunStateAdapter());
            runManager.addListener(this, connectionFolder.getConnectionName(), workflow.getId());
        } else {
            workflowModel.unsetRunStateAdapter();
            runManager.removeListener(this, connectionFolder.getConnectionName());
            this.jobsListenerInitialized = false;
        }
    }

    protected void installEditorPlugins(Diagram diagram) {
        super.installEditorPlugins(diagram);
        DiagramContext diagramContext = diagram.getDiagramContext();
        diagramContext.addPlugin(DiagramMainMenuPlugin.class, (Plugin)DefaultDiagramMainMenuPlugin.getInstance());
        diagramContext.addPlugin(ToolbarPlugin.class, (Plugin)new OdmrToolbarPlugin(diagramContext));
        diagramContext.addPlugin(DiagramReadOnlyPlugin.class, (Plugin)new OdmrReadOnlyPlugin(diagramContext));
    }

    public Workflow getWorkflow() {
        return (Workflow)((WorkflowNode)this.getContext().getNode()).getRepositoryData();
    }

    @Override
    public void closeImpl(boolean bl) {
        super.closeImpl(bl);
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        workflowNode.closeSessionConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openImpl(boolean bl) throws OpenAbortedException {
        super.openImpl(bl);
        if (!bl) {
            return;
        }
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        try {
            final IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
            this.load();
            final WorkflowPreferencesPanelSettings workflowPreferencesPanelSettings = WorkflowPreferencesPanelSettings.getInstance();
            this.layoutStyle = workflowPreferencesPanelSettings.getLinkLayoutStyle();
            this.layoutMode = workflowPreferencesPanelSettings.getLinkLayoutMode();
            this.doLayout(ilvSDMEngine);
            workflowPreferencesPanelSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                    boolean bl = false;
                    for (int i = 0; i < changeInfoArray.length; ++i) {
                        ChangeInfo changeInfo = changeInfoArray[i];
                        if (changeInfo.getPropertyName().equals(WorkflowPreferencesPanelSettings.LINK_LAYOUT_STYLE)) {
                            WorkflowEditor.this.layoutStyle = changeInfo.getNewValueAsInt();
                            bl = true;
                            continue;
                        }
                        if (!changeInfo.getPropertyName().equals(WorkflowPreferencesPanelSettings.LINK_LAYOUT_MODE)) continue;
                        WorkflowEditor.this.layoutMode = workflowPreferencesPanelSettings.getLinkLayoutMode();
                        bl = true;
                    }
                    if (bl) {
                        WorkflowEditor.this.doLayout(ilvSDMEngine);
                    }
                }
            });
            this.setLockOwner(!workflowNode.isReadOnly());
        }
        catch (Exception exception) {
            try {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("FAILED_ERROR_TITLE"), (String)WorkflowEditorLrb.get("FAILED_OPEN_WORKFLOW"), null);
                this.abortOpen((oracle.ide.model.Node)workflowNode, exception);
                this.setLockOwner(!workflowNode.isReadOnly());
            }
            catch (Throwable throwable) {
                this.setLockOwner(!workflowNode.isReadOnly());
                throw throwable;
            }
        }
    }

    private void doLayout(IlvSDMEngine ilvSDMEngine) {
        IlvLinkLayout ilvLinkLayout = new IlvLinkLayout();
        ilvLinkLayout.setLayoutMode(this.layoutMode);
        ilvLinkLayout.setGlobalLinkStyle(this.layoutStyle);
        ilvLinkLayout.setAutoLayout(true);
        ilvLinkLayout.setSplineRoutingEnabled(false);
        try {
            IlvGraphLayoutRenderer ilvGraphLayoutRenderer = ilvSDMEngine.getLinkLayoutRenderer();
            ilvGraphLayoutRenderer.setGraphLayout((IlvGraphLayout)ilvLinkLayout);
            ilvLinkLayout.performLayout();
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)ilvGraphLayoutException), (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    public void updateParallelToolBarLink() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        Enumeration enumeration = workflowNode.getWorkflowModel().getObjects();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractNode)) continue;
            ++n;
            AbstractNode abstractNode = (AbstractNode)e;
            if (abstractNode.getData().getParallelism() == null || !abstractNode.getData().getParallelism().isEnable()) continue;
            ++n2;
        }
        if (n2 == 0) {
            this.setParallelLinkText(WorkflowEditorLrb.get("PARALLEL_QUERY_OFF"));
        } else if (n2 == n) {
            this.setParallelLinkText(WorkflowEditorLrb.get("PARALLEL_QUERY_ON_ALL"));
        } else {
            this.setParallelLinkText(WorkflowEditorLrb.get("PARALLEL_QUERY_ON_SELECTED"));
        }
    }

    @Override
    public void closeEditor() {
        WorkflowEditor workflowEditor = this;
        SwingUtilities.invokeLater(new Runnable((Editor)workflowEditor){
            final /* synthetic */ Editor val$thisEditor;
            {
                this.val$thisEditor = editor;
            }

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this.val$thisEditor));
            }
        });
    }

    private void setPropertyChangeListener(IlvSDMEngine ilvSDMEngine, WorkflowModel workflowModel) {
        Enumeration enumeration = workflowModel.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractNode)) continue;
            AbstractNode abstractNode = (AbstractNode)e;
            abstractNode.addPropertyChangeListener(ilvSDMEngine);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new ModelListener();
            workflowModel.addSDMPropertyChangeListener(this.propertyChangeListener);
            workflowModel.addSDMModelListener(new SDMModelListener(){

                public void objectAdded(SDMModelEvent sDMModelEvent) {
                    WorkflowEditor.this.updateParallelToolBarLink();
                }

                public void objectRemoved(SDMModelEvent sDMModelEvent) {
                    WorkflowEditor.this.updateParallelToolBarLink();
                }

                public void linkSourceChanged(SDMModelEvent sDMModelEvent) {
                }

                public void linkDestinationChanged(SDMModelEvent sDMModelEvent) {
                }

                public void dataChanged(SDMModelEvent sDMModelEvent) {
                }

                public void adjustmentFinished(SDMModelEvent sDMModelEvent) {
                }
            });
        }
    }

    private void unsetPropertyChangeListener(IlvSDMEngine ilvSDMEngine, WorkflowModel workflowModel) {
        Enumeration enumeration = workflowModel.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractNode)) continue;
            AbstractNode abstractNode = (AbstractNode)e;
            abstractNode.removePropertyChangeListener(ilvSDMEngine);
        }
    }

    public void displayValidations(Node node) throws Exception {
        NodeType nodeType = node.getData();
        if (nodeType.getStatus().equals((Object)NodeStatusType.INVALID)) {
            ShowMessagesDialog showMessagesDialog = new ShowMessagesDialog(node);
            showMessagesDialog.invoke();
        }
    }

    public void displayEventLogForNode(Context context, Node node) {
        EventLog.EntryInfo entryInfo;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        WorkflowProject workflowProject = ProjectFolder.getWorkflowProject(context);
        EventLogDialog eventLogDialog = new EventLogDialog();
        String string = Connections.getConnectionName(context);
        if (node != null) {
            EventLog.Entry entry = new EventLog.Entry();
            entry.setNodeName(node.getData().getName());
            entryInfo = new EventLog.EntryInfo(entry);
            entryInfo.setNodeId(node.getData().getId());
        } else {
            entryInfo = new EventLog.EntryInfo(null);
        }
        entryInfo.setProjectId(workflowProject.getId());
        entryInfo.setProjectName(workflowProject.getName());
        entryInfo.setWorkflowId(workflowNode.getId());
        entryInfo.setWorkflowName(workflowNode.getLabel());
        eventLogDialog.invoke(string, workflowProject.getId(), workflowNode.getId(), entryInfo, true);
    }

    private void load() throws Exception {
        class Loader
        extends ProgressRunnable {
            private boolean _canceled;
            private WorkflowJob wfJob;

            Loader() {
            }

            public WorkflowJob getWorkflowJob() {
                return this.wfJob;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                WorkflowNode workflowNode = (WorkflowNode)WorkflowEditor.this.getContext().getNode();
                try {
                    Object object;
                    final IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
                    ilvSDMEngine.setMetadataEnabled(false);
                    SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
                    final WorkflowModel workflowModel = WorkflowUtils.getFilteredModel(sDMUndoFilter);
                    Workflow workflow = (Workflow)workflowNode.getRepositoryData();
                    if (workflowNode.getSessionConnection() == null) {
                        object = Connections.getUniqueConnection(WorkflowEditor.this.getContext());
                        workflowNode.setSessionConnection((Connection)object);
                    }
                    object = workflow.load(workflowNode.getSessionConnection(), workflowNode.getLastSavedOn(), true);
                    workflowNode.setLastSavedOn((Timestamp)object);
                    workflowModel.load(workflow.getWorkflowProcess(), WorkflowEditor.this.getContext());
                    ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                    workflowNode.setWorkflowModel(workflowModel);
                    workflowNode.setReadOnly(workflow.isReadOnly());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WorkflowEditor.this.setPropertyChangeListener(ilvSDMEngine, workflowModel);
                        }
                    });
                    this.wfJob = WorkflowEditor.this.getJob(true);
                }
                finally {
                    workflowNode.setLoading(false);
                }
                return Boolean.TRUE;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }
        }
        Loader loader = new Loader();
        loader.setTitle(WorkflowEditorLrb.get("LOAD_WORKFLOW"));
        loader.setMessage(WorkflowEditorLrb.get("LOAD_WORKFLOW_DESCR"));
        loader.setCancelable(false);
        loader.start(true);
        WorkflowJob workflowJob = loader.getWorkflowJob();
        boolean bl = this.isRunningOrQueued(workflowJob);
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        if (workflowNode.isReadOnly()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("WORKFLOW_OPEN_READ_ONLY_MSG"), (String)WorkflowEditorLrb.get("WORKFLOW_OPEN_READ_ONLY_TITLE"), null);
            if (bl || workflowNode.isReadOnly()) {
                this.startJobMonitoring();
            }
        }
    }

    private void reload(final WorkflowNode workflowNode, final WorkflowModel workflowModel, final boolean bl) throws Exception {
        final Map<String, String> map = this.getSelectedDiagramObjectIds();
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        class Loader
        extends SwingWorker {
            private boolean _canceled;
            private final Workflow wf;
            private WorkflowJob wfJob;

            Loader() {
                this.wf = (Workflow)workflowNode.getRepositoryData();
            }

            public WorkflowJob getWorkflowJob() {
                return this.wfJob;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                Object object = workflowNode.getRepositoryDataReadLock();
                synchronized (object) {
                    if (bl) {
                        Timestamp timestamp = this.wf.load(workflowNode.getSessionConnection(), workflowNode.getLastSavedOn(), WorkflowEditor.this.isLockOwner() != false || bl);
                        workflowNode.setLastSavedOn(timestamp);
                    }
                    workflowNode.setReadOnly(this.wf.isReadOnly());
                    this.wfJob = WorkflowEditor.this.getJob(true);
                    WorkflowEditor.this.setLockOwner(!workflowNode.isReadOnly());
                }
                return Boolean.TRUE;
            }

            @Override
            protected void done() {
                OdmrToolbarPlugin odmrToolbarPlugin;
                try {
                    IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
                    WorkflowEditor.this.unsetPropertyChangeListener(ilvSDMEngine, workflowModel);
                    workflowModel.fireDataChanged(null);
                    workflowNode.markDirty(false);
                    UpdateMessage.fireStructureChanged((Subject)WorkflowEditor.this.getContext().getNode());
                    WorkflowEditor.this.setPropertyChangeListener(ilvSDMEngine, workflowModel);
                    WorkflowEditor.this.setSelectedDiagramObjectIds(map);
                    if (WorkflowEditor.this != EditorManager.getEditorManager().getCurrentEditor()) {
                        EditorManager.getEditorManager().requestAttention((Editor)WorkflowEditor.this, true);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                WorkflowJob workflowJob = this.getWorkflowJob();
                boolean bl2 = WorkflowEditor.this.isRunningOrQueued(workflowJob);
                if (workflowNode.isReadOnly()) {
                    if (bl) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("WORKFLOW_UNABLE_TO_UNLOCK"), (String)WorkflowEditorLrb.get("WORKFLOW_OPEN_READ_ONLY_TITLE"), null);
                    }
                    if (bl2 || workflowNode.isReadOnly()) {
                        WorkflowEditor.this.startJobMonitoring();
                    }
                } else {
                    WorkflowEditor.this.setLockOwner(true);
                }
                if ((odmrToolbarPlugin = (OdmrToolbarPlugin)WorkflowEditor.this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class)) != null) {
                    odmrToolbarPlugin.updateEditorToolbar(false, workflowJob);
                }
                if (WorkflowEditor.this.overLayPanel != null) {
                    WorkflowEditor.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
        Loader loader = new Loader();
        loader.execute();
    }

    private void unlock(WorkflowNode workflowNode, String string) throws Exception {
        class UnlockWorkflow
        extends ProgressRunnable {
            String _connectionName;
            WorkflowNode wfNode;

            public UnlockWorkflow(WorkflowNode workflowNode, String string) {
                this.wfNode = workflowNode;
                this._connectionName = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                Connection connection = null;
                boolean bl = false;
                Exception exception = null;
                try {
                    connection = Connections.getUniqueConnection(this._connectionName);
                    try {
                        Workflow workflow = (Workflow)this.wfNode.getRepositoryData();
                        workflow.unlock(connection);
                    }
                    catch (SQLException sQLException) {
                        exception = sQLException;
                    }
                    if (exception == null) {
                        bl = Boolean.TRUE;
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                    bl = Boolean.FALSE;
                }
                finally {
                    SQLHelper.close(connection);
                }
                return bl;
            }
        }
        UnlockWorkflow unlockWorkflow = new UnlockWorkflow(workflowNode, string);
        unlockWorkflow.setTitle(WorkflowEditorLrb.get("LOCKING_WORKFLOW"));
        unlockWorkflow.setMessage(WorkflowEditorLrb.get("LOCKING_WORKFLOW_DESCR"));
        unlockWorkflow.setCancelable(false);
        unlockWorkflow.start(true);
    }

    public void setLockOwner(boolean bl) {
        this.lockOwner = bl;
    }

    public Boolean isLockOwner() {
        return this.lockOwner;
    }

    public static WorkflowEditor findWorkflowEditor(Context context) {
        WorkflowEditor workflowEditor = null;
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager.findEditors(context);
        if (list.size() == 1 && list.get(0) instanceof WorkflowEditor) {
            workflowEditor = (WorkflowEditor)list.get(0);
        }
        return workflowEditor;
    }

    public WorkflowJob getMonitoredJob() {
        return this.monitoredJob;
    }

    @Override
    public void jobsListenerInitialized() {
        this.jobsListenerInitialized = true;
    }

    public boolean isJobsListenerInitialized() {
        return this.jobsListenerInitialized;
    }

    @Override
    public void jobAdded(RunManagerEvent runManagerEvent) {
        this.handleRunManagerEvent(runManagerEvent);
        this.monitoredJob = runManagerEvent.getJob();
    }

    @Override
    public void jobChanged(RunManagerEvent runManagerEvent) {
        this.handleRunManagerEvent(runManagerEvent);
        this.monitoredJob = runManagerEvent.getJob();
    }

    @Override
    public void jobRemoved(RunManagerEvent runManagerEvent) {
        this.handleRunManagerEvent(runManagerEvent);
        this.monitoredJob = null;
    }

    @Override
    public void connectionLost(RunManagerEvent runManagerEvent) {
        WorkflowJob workflowJob = this.getJob(false);
        if (this.isRunningOrQueued(workflowJob)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (WorkflowEditor.this.connectionLossDetected) {
                        return;
                    }
                    WorkflowEditor.this.connectionLossDetected = true;
                    URL uRL = WorkflowEditor.this.getWorkflowNode().getURL();
                    Object[] objectArray = new Object[]{uRL.getPath()};
                    String string = MessageFormat.format(WorkflowEditorLrb.get("CONNECTION_LOST"), objectArray);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)WorkflowEditorLrb.get("CONNECTION_LOST_TITLE"), null);
                }
            });
        }
    }

    @Override
    public void connectionReestablished(RunManagerEvent runManagerEvent) {
        this.connectionLossDetected = false;
    }

    @Override
    public void jobFinished(RunManagerEvent runManagerEvent) {
        this.monitoredJob = null;
        if (this.getContext() == null) {
            return;
        }
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        try {
            this.stopJobMonitoring();
            WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
            if (this.overLayPanel == null) {
                workflowNode.createOverLayPanel(this.getContext().getView());
            } else {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
                this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
            }
            this.reload(workflowNode, workflowModel, false);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)"Application Error", (String)"Inconsistent state - finished job detected, but unable to reload the editor.", null);
        }
    }

    private void handleRunManagerEvent(RunManagerEvent runManagerEvent) {
        try {
            WorkflowRunStateAdapter workflowRunStateAdapter;
            WorkflowJob workflowJob = runManagerEvent.getJob();
            Context context = this.getContext();
            if (context == null) {
                return;
            }
            Collection<IlvSDMNode> collection = this.getSelectedDiagramObjects();
            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
            WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
            if (!workflowJob.getWorkflowId().equals(workflowNode.getId())) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)new Exception("Inconsistent state - handleRunManagerEvent should not be notified of job that are not relevant to other workflows."), (String)"Application Error", (String)"Inconsistent state - handleRunManagerEvent should not be notified of job that are not relevant to other workflows.", null);
            }
            if ((workflowRunStateAdapter = workflowModel.getRunStateAdapter()) != null) {
                workflowRunStateAdapter.setWorkflowJob(workflowJob);
            }
            workflowModel.fireDataChanged(null);
            workflowNode.markDirty(false);
            this.setSelectedDiagramObjects(collection);
            OdmrToolbarPlugin odmrToolbarPlugin = (OdmrToolbarPlugin)this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
            odmrToolbarPlugin.updateEditorToolbar(false, workflowJob);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public Node getSelectedDiagramNode() throws Exception {
        List<Node> list = this.getSelectedDiagramNodes();
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public List<Node> getSelectedDiagramNodes() throws Exception {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return arrayList;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractNode)) continue;
            arrayList.add((AbstractNode)e);
        }
        return arrayList;
    }

    public Collection<IlvSDMNode> getSelectedDiagramObjects() throws Exception {
        ArrayList<IlvSDMNode> arrayList = new ArrayList<IlvSDMNode>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return arrayList;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof IlvSDMNode)) continue;
            arrayList.add((IlvSDMNode)e);
        }
        return arrayList;
    }

    public Map<String, String> getSelectedDiagramObjectIds() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return hashMap;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return hashMap;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractNode)) continue;
            AbstractNode abstractNode = (AbstractNode)e;
            String string = abstractNode.getData().getId();
            hashMap.put(string, string);
        }
        return hashMap;
    }

    public void setSelectedDiagramObjects(Collection<IlvSDMNode> collection) throws Exception {
        this.setSelectedDiagramObjects(collection, true);
    }

    public void setSelectedDiagramObjects(Collection<IlvSDMNode> collection, boolean bl) {
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ilvSDMEngine.setSelected(e, false);
        }
        ilvSDMEngine.setSelected(collection.toArray(), bl);
    }

    public void setSelectedDiagramObjectIds(Map<String, String> map) throws Exception {
        Object object;
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ilvSDMEngine.setSelected(object, false);
        }
        object = new ArrayList();
        Enumeration enumeration2 = ilvSDMEngine.getAllObjects();
        while (enumeration2.hasMoreElements()) {
            AbstractNode abstractNode;
            IlvSDMNode ilvSDMNode = (IlvSDMNode)enumeration2.nextElement();
            if (!(ilvSDMNode instanceof AbstractNode) || !map.containsKey((abstractNode = (AbstractNode)ilvSDMNode).getData().getId())) continue;
            object.add(ilvSDMNode);
        }
        ilvSDMEngine.setSelected(object.toArray(), true);
    }

    public GeneralLink getSelectedDiagramLink() throws Exception {
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return null;
        }
        IlvManager ilvManager = ilvManagerView.getManager();
        WorkflowNode workflowNode = (WorkflowNode)diagram.getContext().getNode();
        IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getSelectedObjects();
        if (ilvManager.getSelectedObjectsCount() > 1 || ilvManager.getSelectedObjectsCount() == 0) {
            return null;
        }
        IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object instanceof GeneralLink) {
            return (GeneralLink)object;
        }
        return null;
    }

    public void setSelected(IlvSDMEngine ilvSDMEngine, Node node) throws IOException {
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ilvSDMEngine.setSelected(e, false);
        }
        ilvSDMEngine.setSelected((Object)node, true);
    }

    public WorkflowNode getWorkflowNode() {
        return (WorkflowNode)this.getDiagram().getContext().getNode();
    }

    public static TestResultNode createClassTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, ClassificationBuildNodeType classificationBuildNodeType, ClassificationResultType classificationResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new ClassTestResult(context, (BuildNodeType)classificationBuildNodeType, (MiningResultType)classificationResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
        }
        return testResultNode;
    }

    public static TestCompareNode createClassTestCompareNode(Context context, WorkflowNode workflowNode, ClassificationBuildNodeType classificationBuildNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + classificationBuildNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new ClassTestResult(context, (BuildNodeType)classificationBuildNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
        }
        return testCompareNode;
    }

    public static TestCompareNode createClassTestCompareNode(Context context, WorkflowNode workflowNode, TestNodeType testNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + testNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new ClassTestResult(context, testNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
        }
        return testCompareNode;
    }

    public static TestResultNode createRegressTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, RegressionBuildNodeType regressionBuildNodeType, RegressionResultType regressionResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new RegressTestResult(context, (BuildNodeType)regressionBuildNodeType, (MiningResultType)regressionResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
        }
        return testResultNode;
    }

    public static TestCompareNode createRegressTestCompareNode(Context context, WorkflowNode workflowNode, RegressionBuildNodeType regressionBuildNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + regressionBuildNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new RegressTestResult(context, (BuildNodeType)regressionBuildNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
        }
        return testCompareNode;
    }

    public static TestCompareNode createRegressTestCompareNode(Context context, WorkflowNode workflowNode, TestNodeType testNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + testNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new RegressTestResult(context, testNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
        }
        return testCompareNode;
    }

    public boolean doesNodeNameAlreadyExist(String string) {
        WorkflowModel workflowModel = null;
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        try {
            workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return workflowModel.doesNodeNameAlreadyExist(string);
    }

    private void setParallelLinkText(String string) {
        if (this.parallelLinkButton != null) {
            this.parallelLinkButton.setText(string);
        }
    }

    public void handleGenerateApplyChain() throws Exception {
        ApplyChainGenerator applyChainGenerator = new ApplyChainGenerator(this, this.getDiagram());
        applyChainGenerator.generateApplyChain();
    }

    public class OdmrToolbarPlugin
    extends DefaultDiagramToolbarPlugin {
        private IdeAction openEventLogAction;
        private IdeAction doStopAction;
        private IdeAction doRunAction;
        private IdeAction doForceSelected;
        private IdeAction doForceChildren;
        private IdeAction doForceSelectedChildren;
        private IdeAction doForceParents;
        private IdeAction unlockAction;
        private IdeAction refreshAction;
        private Toolbar toolbar;
        private ToolButton doStop;
        private JButton lock;
        private ToolButton refresh;
        private JLabel running;
        private ActionMenuToolButton runMenu;

        public OdmrToolbarPlugin(DiagramContext diagramContext) {
            super(diagramContext);
            this.openEventLogAction = IdeAction.get((int)WorkflowContextMenu.VIEW_ERROR_STATUS_ID);
            this.doStopAction = IdeAction.get((int)STOP_CMDID);
            this.doRunAction = IdeAction.get((int)RUN_CMDID);
            this.doForceSelected = IdeAction.get((int)WorkflowContextMenu.RUN_FORCE_SELECTED_ACTION_ID);
            this.doForceChildren = IdeAction.get((int)WorkflowContextMenu.RUN_FORCE_CHILDREN_ACTION_ID);
            this.doForceSelectedChildren = IdeAction.get((int)WorkflowContextMenu.RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID);
            this.doForceParents = IdeAction.get((int)WorkflowContextMenu.RUN_FORCE_PARENTS_ACTION_ID);
            this.unlockAction = IdeAction.get((int)UNLOCK_CMDID);
            this.refreshAction = IdeAction.get((int)REFRESH_CMDID);
            this.toolbar = null;
        }

        public void updateEditorToolbar(boolean bl, WorkflowJob workflowJob) {
            WorkflowNode workflowNode = (WorkflowNode)WorkflowEditor.this.getContext().getNode();
            boolean bl2 = workflowNode.isReadOnly();
            boolean bl3 = WorkflowEditor.this.isRunningOrQueued(workflowJob);
            boolean bl4 = true;
            try {
                for (Node node : WorkflowEditor.this.getSelectedDiagramNodes()) {
                    bl = true;
                    if (node.validateRunChain(false)) continue;
                    bl4 = false;
                    break;
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
            this.runMenu.setEnabled(!bl2 && bl && !bl3 && WorkflowEditor.this.isLockOwner() != false && bl4);
            this.doStop.setEnabled(bl3);
            this.doStop.setVisible(bl3);
            this.running.setVisible(bl3);
            if (bl3) {
                this.running.setText(WorkflowEditor.this.getJobStateString(workflowJob));
                if (workflowJob != null) {
                    String string = workflowJob.getState();
                    if (string.equals("ACTIVE")) {
                        this.running.setIcon(DataMinerIcons.get(Icons.RUNNING));
                    } else if (string.equals("QUEUED")) {
                        this.running.setIcon(DataMinerIcons.get(Icons.QUEUED));
                    }
                }
            }
            this.lock.setVisible(bl2 && !bl3);
            this.refresh.setVisible(bl2 && !bl3);
        }

        protected Toolbar createToolbarImpl(final View view) {
            WorkflowNode workflowNode;
            try {
                workflowNode = (WorkflowNode)WorkflowEditor.this.getDiagram().getContext().getNode();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            final WorkflowNode workflowNode2 = workflowNode;
            this.toolbar = super.createToolbarImpl(view);
            JButton jButton = new JButton();
            jButton.setIcon(OracleIcons.getIcon((String)"log.png"));
            jButton.setToolTipText(WorkflowEditorLrb.get("SHOW_EVENT_LOG"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Node node = WorkflowEditor.this.getSelectedDiagramNode();
                        WorkflowEditor.this.displayEventLogForNode(WorkflowEditor.this.getContext(), node);
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            });
            this.doStop = new ToolButton((Action)this.doStopAction);
            this.doStop.setIcon(OracleIcons.getIcon((String)"terminate.png"));
            this.doStop.setToolTipText(WorkflowEditorLrb.get("STOP_WORKFLOW"));
            this.doStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("WORKFLOW_WILL_BE_CANCELED"), (String)RunManagerLrb.get("WORKFLOW_CANCEL_WARNING_TITLE"), null)) {
                            WorkflowJob workflowJob = ((WorkflowEditor)view).getMonitoredJob();
                            ArrayList<WorkflowJob> arrayList = new ArrayList<WorkflowJob>();
                            if (workflowJob != null) {
                                arrayList.add(workflowJob);
                                RunManager.stopWorkflow(arrayList, Connections.getConnectionName(WorkflowEditor.this.getContext()));
                            } else {
                                WorkflowJob workflowJob2 = new WorkflowJob();
                                workflowJob2.setId(((WorkflowEditor)view).getWorkflow().getId());
                                arrayList.add(workflowJob2);
                                RunManager.stopWorkflow(arrayList, Connections.getConnectionName(WorkflowEditor.this.getContext()));
                            }
                        }
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            });
            this.doStop.setEnabled(false);
            this.runMenu = new ActionMenuToolButton((Action)this.doRunAction);
            this.runMenu.setMenuActions(new Action[]{this.doRunAction});
            this.runMenu.setIcon(OracleIcons.getIcon((String)"run.png"));
            this.runMenu.setToolTipText(WorkflowEditorLrb.get("RUN_SELECTED"));
            JMenu jMenu = new JMenu(WorkflowEditorLrb.get("RUN_FORCE_RUN"));
            jMenu.add((Action)this.doForceSelected);
            jMenu.add((Action)this.doForceSelectedChildren);
            jMenu.add((Action)this.doForceParents);
            jMenu.add((Action)this.doForceChildren);
            this.runMenu.getPopup().add(jMenu);
            this.refresh = new ToolButton((Action)this.refreshAction);
            this.refresh.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            this.running = new JLabel(DataMinerIcons.get(Icons.RUNNING));
            this.running.setText(WorkflowEditorLrb.get("RUNNING"));
            this.lock = new JButton();
            this.lock.setIcon(OracleIcons.getIcon((String)"listLockIcon.png"));
            this.lock.setText(WorkflowEditorLrb.get("LOCKED"));
            if (!workflowNode2.isReadOnly()) {
                this.lock.setVisible(false);
                this.refresh.setVisible(false);
            }
            boolean bl = workflowNode2.getWorkflowModel().getRunStateAdapter() != null;
            this.running.setVisible(bl);
            this.refresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        WorkflowEditor.this.reload(workflowNode2, workflowNode2.getWorkflowModel(), false);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                    }
                }
            });
            this.lock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        WorkflowEditor.this.unlock(workflowNode2, Connections.getConnectionName(WorkflowEditor.this.getContext()));
                        WorkflowEditor.this.reload(workflowNode2, workflowNode2.getWorkflowModel(), true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                    }
                }
            });
            WorkflowEditor.this.parallelLinkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WorkflowParallelQueryDialog workflowParallelQueryDialog = new WorkflowParallelQueryDialog(WorkflowEditor.this.getContext(), null);
                    workflowParallelQueryDialog.invoke(null);
                }
            });
            this.toolbar.addFiller();
            this.toolbar.addFiller();
            this.toolbar.add((Component)jButton);
            this.toolbar.addFiller();
            this.toolbar.add((Component)this.runMenu);
            this.toolbar.add((Component)this.doStop);
            this.toolbar.addFiller();
            this.toolbar.addFiller();
            this.toolbar.addFiller();
            this.toolbar.addFiller();
            this.toolbar.addFiller();
            this.toolbar.addFiller();
            this.toolbar.addFiller();
            this.toolbar.add((Component)this.refresh);
            this.toolbar.add((Component)this.lock);
            this.toolbar.add((Component)this.running);
            this.toolbar.add(Box.createHorizontalGlue());
            this.toolbar.add((Component)WorkflowEditor.this.parallelLinkButton);
            WorkflowEditor.this.updateParallelToolBarLink();
            return this.toolbar;
        }
    }

    class OdmrReadOnlyPlugin
    extends DefaultDiagramReadOnlyPlugin {
        public OdmrReadOnlyPlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        protected boolean checkWritableDiagram() {
            WorkflowNode workflowNode = (WorkflowNode)WorkflowEditor.this.getDiagram().getContext().getNode();
            Workflow workflow = (Workflow)workflowNode.getRepositoryData();
            boolean bl = !workflow.isReadOnly();
            return bl;
        }
    }

    public class ModelListener
    implements SDMPropertyChangeListener {
        public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
            String string = sDMPropertyChangeEvent.getPropertyName();
            Object object = sDMPropertyChangeEvent.getObject();
            if ("show_errors".equals(string)) {
                try {
                    if (object instanceof AbstractNode) {
                        NodeType nodeType = ((Node)object).getData();
                        if (nodeType.getStatus().equals((Object)NodeStatusType.FAILURE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING)) {
                            WorkflowEditor.this.displayEventLogForNode(WorkflowEditor.this.getContext(), (Node)object);
                        } else {
                            WorkflowEditor.this.displayValidations((Node)object);
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                }
            }
        }
    }
}

