/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import ilog.views.IlvManagerView;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.publish.AbstractPublishPlugin;
import oracle.diagram.framework.publish.PublishPlugin;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.GenerateSQLScriptWizard;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinition;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractObject;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class CodeGenerator {
    private static final Logger theLogger = Logger.getLogger(CodeGenerator.class.getName());
    private Context _context;
    private WorkflowEditor _editor;
    private ArrayList<Node> _nodes;
    private int _pos = 1;
    private int _pos2 = 1000000000;
    private String _scriptDirectory;
    private Version _tgtDbVersion;
    private HashMap<String, NodeInfo> _nodeLookup = new HashMap();
    private CODE_GENERATION_OPTION _option;
    private Exception _exception = null;
    private ParameterizedSourceDefinitions _parmSourceDefinitions = new ParameterizedSourceDefinitions();
    private static final int MAX_NUM_PRIMARY_PLACEMENT = 1000000000;
    private static final String SQL_SUFFIX = ".sql";
    private static final String PNG_SUFFIX = ".png";
    private static final String DEFINE_COMMAND_HEADER = "-- From Node: \"<NODE_NAME>\"\n";
    private static final String DEFINE_COMMAND = "DEFINE <PARM_NAME> = '\"<USER_NAME>\".\"<OBJECT_NAME>\"'\n";
    private static final String DEFINE_COMMAND_NO_USER = "DEFINE <PARM_NAME> = '\"<OBJECT_NAME>\"'\n";
    public static final String SOURCE_REPOSITORY_VERSION = "SOURCE_REPOSITORY_VERSION";
    public static final String SOURCE_DATABASE_VERSION = "SOURCE_DATABASE_VERSION";
    public static final String TARGET_DATABASE_VERSION = "TARGET_DATABASE_VERSION";
    public static final String PARALLEL_QUERY_ON_ALLOWED = "PARALLEL_QUERY_ON_ALLOWED";
    public static final String PARALLEL_QUERY_OFF_ALLOWED = "PARALLEL_QUERY_OFF_ALLOWED";
    public static final String EXTENDED_TYPE_STATUS = "EXTENDED_TYPE_STATUS";

    public CodeGenerator(Context context, List<Node> list, WorkflowEditor workflowEditor, CODE_GENERATION_OPTION cODE_GENERATION_OPTION) {
        this._context = context;
        this._nodes = new ArrayList<Node>(list);
        this._editor = workflowEditor;
        this._option = cODE_GENERATION_OPTION;
        Version version = new Version(ConfigUtils.getCurrentRepositoryVersion());
        this._context.setProperty(SOURCE_REPOSITORY_VERSION, (Object)version);
        Version version2 = null;
        try {
            version2 = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        this._context.setProperty(SOURCE_DATABASE_VERSION, (Object)version2);
    }

    private void findParents(Node node) {
        if (!this._nodeLookup.containsKey(node.getMetadataId())) {
            this._nodeLookup.put(node.getMetadataId(), new NodeInfo(node));
        }
        NodeInfo nodeInfo = this._nodeLookup.get(node.getMetadataId());
        List<AbstractNode> list = node.findParentNodes();
        if (!list.isEmpty()) {
            for (AbstractNode abstractNode : list) {
                if (!nodeInfo.addParent(abstractNode)) continue;
                this.findParents(abstractNode);
            }
        } else if (nodeInfo.getPos() == null) {
            if (node instanceof ModelNode || node instanceof BuildTextNodeRef) {
                nodeInfo.setPos(this._pos2++);
            } else {
                nodeInfo.setPos(this._pos++);
            }
        }
    }

    private void findChildrenHelper(Node node, ArrayList<Node> arrayList) {
        List<AbstractNode> list = node.findChildNodes();
        if (list.isEmpty()) {
            if (!arrayList.contains(node)) {
                arrayList.add(node);
            }
        } else {
            for (AbstractNode abstractNode : list) {
                this.findChildrenHelper(abstractNode, arrayList);
            }
        }
    }

    private ArrayList<Node> findChildren(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.findChildrenHelper(node, arrayList);
        return arrayList;
    }

    private void findConnected(Node node) {
        if (!this._nodeLookup.containsKey(node.getMetadataId())) {
            this._nodeLookup.put(node.getMetadataId(), new NodeInfo(node));
        }
        NodeInfo nodeInfo = this._nodeLookup.get(node.getMetadataId());
        List<AbstractNode> list = node.findParentNodes();
        if (!list.isEmpty()) {
            for (AbstractNode object2 : list) {
                if (!this._nodeLookup.containsKey(object2.getMetadataId())) {
                    this._nodeLookup.put(object2.getMetadataId(), new NodeInfo(object2));
                }
                if (!nodeInfo.addParent(object2)) continue;
                this.findConnected(object2);
            }
        } else if (nodeInfo.getPos() == null) {
            if (node instanceof ModelNode || node instanceof BuildTextNodeRef) {
                nodeInfo.setPos(this._pos2++);
            } else {
                nodeInfo.setPos(this._pos++);
            }
        }
        List<AbstractNode> list2 = node.findChildNodes();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            AbstractNode abstractNode = (AbstractNode)iterator.next();
            if (!this._nodeLookup.containsKey(abstractNode.getMetadataId())) {
                this._nodeLookup.put(abstractNode.getMetadataId(), new NodeInfo(abstractNode));
            }
            if (!(nodeInfo = this._nodeLookup.get(abstractNode.getMetadataId())).addParent(node)) continue;
            this.findConnected(abstractNode);
        }
    }

    private Integer getPlacement(NodeInfo nodeInfo) {
        if (nodeInfo.getPos() != null) {
            return nodeInfo.getPos();
        }
        ArrayList<Node> arrayList = nodeInfo.getParent();
        int n = 0;
        for (Node node : arrayList) {
            NodeInfo nodeInfo2 = this._nodeLookup.get(node.getMetadataId());
            Integer n2 = nodeInfo2.getPos();
            if (n2 == null) {
                n2 = this.getPlacement(nodeInfo2);
            }
            if (n2 <= n) continue;
            n = n2;
        }
        if (n >= 1000000000) {
            n = Math.max(this._pos2, n);
            this._pos2 = ++n;
        } else {
            n = Math.max(this._pos, n);
            this._pos = ++n;
        }
        nodeInfo.setPos(n);
        return n;
    }

    private String getDefineParameters(TreeMap<Integer, NodeInfo> treeMap) {
        StringBuffer stringBuffer = new StringBuffer();
        for (NodeInfo nodeInfo : treeMap.values()) {
            String string = nodeInfo.getNode().getData().getName();
            String string2 = null;
            for (ParameterizedSourceDefinition parameterizedSourceDefinition : this._parmSourceDefinitions.getParameterizedSourceDefinitions()) {
                if (!parameterizedSourceDefinition.getNodeName().equals(string)) continue;
                if (string2 == null) {
                    string2 = StringUtils.getReplacedString(DEFINE_COMMAND_HEADER, "<NODE_NAME>", parameterizedSourceDefinition.getNodeName());
                    stringBuffer.append(string2);
                }
                if (parameterizedSourceDefinition.getUserName() == null || parameterizedSourceDefinition.getUserName().isEmpty()) {
                    string2 = StringUtils.getReplacedString(DEFINE_COMMAND_NO_USER, "<PARM_NAME>", parameterizedSourceDefinition.getParmName());
                } else {
                    string2 = StringUtils.getReplacedString(DEFINE_COMMAND, "<PARM_NAME>", parameterizedSourceDefinition.getParmName());
                    string2 = StringUtils.getReplacedString(string2, "<USER_NAME>", parameterizedSourceDefinition.getUserName());
                }
                string2 = StringUtils.getReplacedString(string2, "<OBJECT_NAME>", parameterizedSourceDefinition.getObjectName());
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    private String checkSQLSize(String string) {
        int n = 32000;
        String string2 = "_START_CHECK_SQL_SIZE_";
        String string3 = "_END_CHECK_SQL_SIZE_";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = 0;
            int n3 = 0;
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((n3 = string.indexOf(string2, n2)) >= 0) {
                stringBuffer2.append(string.substring(n2, n3));
                int n4 = string.indexOf("'", n3 + string2.length()) + 1;
                int n5 = string.indexOf(string3, n3 + string2.length());
                int n6 = string.lastIndexOf("'", n5) - 1;
                String string4 = string.substring(n4, n6);
                stringBuffer.setLength(0);
                if (string4.length() > n) {
                    ArrayList<String> arrayList = StringUtils.chopString(string4, n);
                    StringBuffer stringBuffer3 = new StringBuffer();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (i == 0) {
                            stringBuffer.append("v_sql := \n");
                            stringBuffer3.append("v_sql");
                        } else {
                            stringBuffer.append("v_sql" + (i + 1) + " := \n");
                            stringBuffer3.append("||v_sql" + (i + 1));
                        }
                        stringBuffer.append("'" + arrayList.get(i) + "';\n");
                    }
                    stringBuffer.append("execSQL(" + stringBuffer3.toString() + ");\n");
                } else {
                    int n7 = n3 + string2.length();
                    stringBuffer.append(string.substring(n7, n5));
                }
                stringBuffer2.append(stringBuffer);
                n2 = n5 + string3.length();
            }
            stringBuffer2.append(string.substring(n2));
            return stringBuffer2.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void populateInternalWorkflowStructure() {
        block5: {
            block6: {
                block4: {
                    if (!this._option.equals((Object)CODE_GENERATION_OPTION.NODE_PARENT)) break block4;
                    for (Node node : this._nodes) {
                        this.findParents(node);
                    }
                    break block5;
                }
                if (!this._option.equals((Object)CODE_GENERATION_OPTION.NODE_PARENT_CHILDREN)) break block6;
                for (Node node : this._nodes) {
                    ArrayList<Node> arrayList = this.findChildren(node);
                    for (Node node2 : arrayList) {
                        this.findParents(node2);
                    }
                }
                break block5;
            }
            if (!this._option.equals((Object)CODE_GENERATION_OPTION.NODE_ALL_CONNECTED)) break block5;
            for (Node node : this._nodes) {
                this.findConnected(node);
            }
        }
    }

    public boolean validateLineageChain() {
        this.populateInternalWorkflowStructure();
        boolean bl = true;
        for (NodeInfo nodeInfo : this._nodeLookup.values()) {
            NodeType nodeType = nodeInfo.getNode().getData();
            WorkflowModel workflowModel = this._editor.getWorkflowNode().getWorkflowModel();
            AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(nodeType.getId());
            if (abstractNode.getState().equals((Object)NodeStatusType.COMPLETE) || abstractNode.getState().equals((Object)NodeStatusType.WARNING) || abstractNode.getState().equals((Object)NodeStatusType.FAILURE)) continue;
            bl = false;
        }
        return bl;
    }

    public ArrayList<UnsupportedNode> getUnsupportedNodesForDBVersion(Version version) {
        ArrayList<UnsupportedNode> arrayList = new ArrayList<UnsupportedNode>();
        this.populateInternalWorkflowStructure();
        this._context.setProperty(TARGET_DATABASE_VERSION, (Object)version);
        for (NodeInfo nodeInfo : this._nodeLookup.values()) {
            StringBuffer stringBuffer;
            NodeType nodeType = nodeInfo.getNode().getData();
            WorkflowModel workflowModel = this._editor.getWorkflowNode().getWorkflowModel();
            AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(nodeType.getId());
            if (abstractNode.isVersionSupported(this._context, stringBuffer = new StringBuffer())) continue;
            arrayList.add(new UnsupportedNode(abstractNode, stringBuffer.toString()));
        }
        this._context.setProperty(TARGET_DATABASE_VERSION, (Object)this._tgtDbVersion);
        return arrayList;
    }

    public Boolean publish(WorkflowEditor workflowEditor, File file) throws Exception {
        IlvManagerView ilvManagerView = workflowEditor.getActiveManagerView();
        DiagramContext diagramContext = DiagramContext.getDiagramContext((IlvManagerView)ilvManagerView);
        AbstractPublishPlugin abstractPublishPlugin = (AbstractPublishPlugin)diagramContext.getPlugin(PublishPlugin.class);
        URL uRL = file.toURI().toURL();
        String string = PNG_SUFFIX;
        uRL = URLFileSystem.convertSuffix((URL)uRL, (String)URLFileSystem.getSuffix((URL)uRL), (String)string);
        abstractPublishPlugin.publishDiagram(uRL, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generate() {
        boolean bl = false;
        Writer writer = null;
        Connection connection = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object422;
            Object object5;
            Object object6;
            this._context.setProperty(TARGET_DATABASE_VERSION, (Object)this._tgtDbVersion);
            boolean bl2 = SQLHelper.isExtendedTypeEnabled(this._context);
            this._context.setProperty(EXTENDED_TYPE_STATUS, (Object)bl2);
            connection = Connections.getUniqueConnection(this._context);
            boolean bl3 = ConfigUtils.isPARALLEL_QUERY_ON_ALLOWED(connection);
            boolean bl4 = ConfigUtils.isPARALLEL_QUERY_OFF_ALLOWED(connection);
            this._context.setProperty(PARALLEL_QUERY_ON_ALLOWED, (Object)bl3);
            this._context.setProperty(PARALLEL_QUERY_OFF_ALLOWED, (Object)bl4);
            Iterator<NodeInfo> iterator = this._nodeLookup.values().iterator();
            TreeMap<Integer, NodeInfo> treeMap = new TreeMap<Integer, NodeInfo>();
            while (iterator.hasNext()) {
                object6 = iterator.next();
                object5 = this.getPlacement((NodeInfo)object6);
                treeMap.put((Integer)object5, (NodeInfo)object6);
            }
            object6 = CodeTemplate.getInstance();
            object5 = ((CodeTemplate)object6).getTemplate("workflow_run.sql");
            Version version = new Version(ConfigUtils.getCurrentRepositoryVersion());
            object5 = CodeTemplate.updateBodyTemplate((String)object5, "<TARGET_REPOS_VERSION>", version.toCanonicalString());
            object5 = CodeTemplate.updateBodyTemplate((String)object5, "<TARGET_DB_VERSION>", this._tgtDbVersion.toCanonicalString());
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object422 : treeMap.values()) {
                object3 = ((CodeTemplate)object6).getTemplate(((NodeInfo)object422).getNode());
                object2 = ((NodeInfo)object422).getNode().getData();
                object = this._editor.getWorkflowNode().getWorkflowModel();
                AbstractNode object7 = (AbstractNode)object.findNodeByMetadataId(object2.getId());
                object3 = object7.generateCode(this._context, this._parmSourceDefinitions, (String)object3);
                object3 = CodeTemplate.updateBodyTemplate((String)object3, "<WORKFLOW_NODE_ID>", ((NodeInfo)object422).getNode().getMetadataId());
                object3 = CodeTemplate.updateBodyTemplate((String)object3, "<WORKFLOW_NODE_NAME>", ((NodeInfo)object422).getNode().getData().getName());
                object3 = CodeTemplate.updateBodyTemplate((String)object3, "<WORKFLOW_NODE_TYPE>", ((AbstractObject)((Object)((NodeInfo)object422).getNode())).getTag());
                ((NodeInfo)object422).setCode(this.checkSQLSize((String)object3));
                String string = StringUtils.addDoubleQuotes(((NodeInfo)object422).getNode().getData().getName() + SQL_SUFFIX);
                stringBuffer.append("@@" + string + ";\n");
                stringBuffer.append("\n");
            }
            object5 = CodeTemplate.updateBodyTemplate((String)object5, "<DROP_EXISTING_OBJECTS>", "TRUE");
            object5 = CodeTemplate.updateBodyTemplate((String)object5, "<WORKFLOW_OUTPUT>", this._editor.getWorkflow().getName());
            object5 = CodeTemplate.updateBodyTemplate((String)object5, "<PARAMETER_LIST>", this.getDefineParameters(treeMap));
            object5 = CodeTemplate.updateBodyTemplate((String)object5, "<WORKFLOW_SCRIPTS>", stringBuffer.toString());
            object422 = ((CodeTemplate)object6).getTemplate("workflow_drop.sql");
            object422 = CodeTemplate.updateBodyTemplate((String)object422, "<WORKFLOW_OUTPUT>", this._editor.getWorkflow().getName());
            object3 = new File(this._scriptDirectory);
            if (((File)object3).mkdir()) {
                object2 = new File(this._scriptDirectory + File.separator + this._editor.getWorkflow().getName() + PNG_SUFFIX);
                this.publish(this._editor, (File)object2);
                object = new File(this._scriptDirectory + File.separator + this._editor.getWorkflow().getName() + "_Run" + SQL_SUFFIX);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8"));
                writer.write((String)object5);
                writer.close();
                object = new File(this._scriptDirectory + File.separator + this._editor.getWorkflow().getName() + "_Drop" + SQL_SUFFIX);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8"));
                writer.write((String)object422);
                writer.close();
                for (NodeInfo nodeInfo : treeMap.values()) {
                    object = new File(this._scriptDirectory + File.separator + nodeInfo.getNode().getData().getName() + SQL_SUFFIX);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8"));
                    if (nodeInfo.getCode() != null) {
                        writer.write(nodeInfo.getCode().toString());
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "No code generated for: " + nodeInfo.getNode().getData().getName(), (Throwable)null);
                    }
                    writer.close();
                }
            } else {
                if (((File)object3).exists()) {
                    throw new Exception(CodeGenLrb.get("GENERATE_SCRIPT_DIR_EXIST"));
                }
                if (!((File)object3).canWrite()) {
                    throw new Exception(CodeGenLrb.get("GENERATE_SCRIPT_DIRECTORY_CREATE_FAILED_NO_WRITE"));
                }
                throw new Exception(CodeGenLrb.get("GENERATE_SCRIPT_DIRECTORY_CREATE_FAILED_UNKNOWN"));
            }
            bl = true;
        }
        catch (Exception exception) {
            this._exception = exception;
            bl = false;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
        }
        return bl;
    }

    public boolean run() {
        boolean bl = false;
        GenerateSQLScriptWizard generateSQLScriptWizard = new GenerateSQLScriptWizard();
        if (generateSQLScriptWizard.runWizard(null, this._context, this)) {
            String string = generateSQLScriptWizard.getModel().getWorkingDirectory();
            String string2 = generateSQLScriptWizard.getModel().getScriptDirectory();
            this._scriptDirectory = string + File.separator + string2;
            this._tgtDbVersion = generateSQLScriptWizard.getModel().getDbVersion();
            class GenCodeProcess
            extends ProgressRunnable {
                CodeGenerator _codeGen;
                Boolean _success = false;

                GenCodeProcess(CodeGenerator codeGenerator2) {
                    this._codeGen = codeGenerator2;
                }

                protected Object doWork() throws Exception {
                    this._success = this._codeGen.generate();
                    return this._success;
                }

                public boolean isSuccessful() {
                    return this._success;
                }
            }
            GenCodeProcess genCodeProcess = new GenCodeProcess(this);
            genCodeProcess.setTitle(WorkflowEditorLrb.get("GENERATING_CODE"));
            genCodeProcess.setMessage(WorkflowEditorLrb.get("GENERATING_CODE_DESCR"));
            genCodeProcess.setCancelable(false);
            try {
                genCodeProcess.start(true);
            }
            catch (ProgressException progressException) {
                theLogger.log(Level.SEVERE, progressException.getLocalizedMessage(), progressException);
            }
            bl = genCodeProcess.isSuccessful();
            if (bl) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)CodeGenLrb.get("GENERATE_SCRIPT_COMPLETE"), (String)CodeGenLrb.get("GENERATE_CODE_TITLE"), null);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public Workflow getWorkflow() {
        return this._editor.getWorkflow();
    }

    public Exception getException() {
        return this._exception;
    }

    class NodeInfo {
        HashMap<String, Node> _parents = new HashMap();
        Node _node = null;
        String _code = null;
        Integer _pos = null;

        public NodeInfo(Node node) {
            this._node = node;
        }

        public ArrayList<Node> getParent() {
            ArrayList<Node> arrayList = new ArrayList<Node>(this._parents.values());
            return arrayList;
        }

        public boolean addParent(Node node) {
            boolean bl = false;
            if (!this._parents.containsKey(node.getMetadataId())) {
                this._parents.put(node.getMetadataId(), node);
                bl = true;
            }
            return bl;
        }

        public Node getNode() {
            return this._node;
        }

        public void setCode(String string) {
            this._code = string;
        }

        public String getCode() {
            return this._code;
        }

        public void setPos(Integer n) {
            this._pos = n;
        }

        public Integer getPos() {
            return this._pos;
        }
    }

    public class UnsupportedNode {
        Node _node = null;
        String _reason = null;

        public UnsupportedNode(Node node, String string) {
            this._node = node;
            this._reason = string;
        }

        public Node getNode() {
            return this._node;
        }

        public String getReason() {
            return this._reason;
        }
    }

    public static enum CODE_GENERATION_OPTION {
        NODE_PARENT,
        NODE_PARENT_CHILDREN,
        NODE_ALL_CONNECTED;

    }
}

