/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.wizard.AbstractWizardPage;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenerator;
import oracle.dmt.dataminer.workflow.codegen.GenerateSQLScriptWizardModel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class GenerateSQLScriptTargetDBPage
extends AbstractWizardPage
implements DataminerGUIPanel {
    private GenerateSQLScriptWizardModel _wizModel;
    private Version _dbVersion;
    private static final Version[] DATABASE_RELEASES = new Version[]{new Version("11.2.0.1.0"), new Version("11.2.0.2.0"), new Version("11.2.0.3.0"), new Version("11.2.0.4.0"), new Version("12.1.0.1.0")};
    private JScrollPane jScrollPaneMessage;
    private JComboBox jTargetDBVerComboBox;
    private JLabel jTargetDBVerLabel;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public GenerateSQLScriptTargetDBPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetDBVerLabel, (Component)this.jTargetDBVerComboBox, (String)CodeGenLrb.get("TARGET_DB_PAGE_VER"));
    }

    @Override
    public void initUI() {
        int n;
        this._wizModel = (GenerateSQLScriptWizardModel)this.getTraversableContext().get("wizardModel");
        this.jTargetDBVerComboBox.setModel(new DefaultComboBoxModel<Version>(DATABASE_RELEASES));
        this._dbVersion = this._wizModel.getDbVersion();
        for (n = DATABASE_RELEASES.length - 1; n >= 0 && this._dbVersion.compareTo((Object)DATABASE_RELEASES[n]) < 0; --n) {
        }
        this.jTargetDBVerComboBox.setSelectedItem(DATABASE_RELEASES[n]);
        this.updateWizardButtons();
    }

    @Override
    public String getPageDirtyKey() {
        return "TargetDBDirty";
    }

    private boolean validate(Version version) {
        this._wizModel = (GenerateSQLScriptWizardModel)this.getTraversableContext().get("wizardModel");
        ArrayList<CodeGenerator.UnsupportedNode> arrayList = this._wizModel.getCodeGen().getUnsupportedNodesForDBVersion(version);
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("\n\n");
            for (CodeGenerator.UnsupportedNode unsupportedNode : arrayList) {
                String string = unsupportedNode.getNode().getDefaultName() + ": " + unsupportedNode.getNode().getData().getName() + " (" + unsupportedNode.getReason() + ")";
                stringBuilder.append(string).append("\n");
            }
            String string = MessageFormat.format(CodeGenLrb.get("TARGET_DB_PAGE_UNSUPPORTED_NODES"), stringBuilder.toString());
            this._jDescription.setText(string);
            this.jScrollPaneMessage.getViewport().add((Component)this._jDescription);
            return false;
        }
        this._jDescription.setText("");
        this.jScrollPaneMessage.getViewport().add((Component)this._jDescription);
        return true;
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        this._dbVersion = (Version)this.jTargetDBVerComboBox.getSelectedItem();
        if (!this.validate(this._dbVersion)) {
            return false;
        }
        this._wizModel.setDbVersion(this._dbVersion);
        return true;
    }

    private void initComponents() {
        this.jTargetDBVerLabel = new JLabel();
        this.jTargetDBVerComboBox = new JComboBox();
        this.jScrollPaneMessage = new JScrollPane();
        this.jTargetDBVerLabel.setText("Target Database Version:");
        this.jTargetDBVerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"11.2.0.1.0", "11.2.0.2.0", "11.2.0.3.0", "11.2.0.4.0", "12.1.0.0.0"}));
        this.jTargetDBVerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateSQLScriptTargetDBPage.this.jTargetDBVerComboBoxActionPerformed(actionEvent);
            }
        });
        this.jScrollPaneMessage.setBorder(null);
        this.jScrollPaneMessage.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneMessage.setVerticalScrollBarPolicy(21);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetDBVerLabel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jTargetDBVerComboBox, 0, -1, Short.MAX_VALUE).addGap(162, 162, 162)).addComponent(this.jScrollPaneMessage, -1, 498, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetDBVerLabel).addComponent(this.jTargetDBVerComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jScrollPaneMessage, -1, 240, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTargetDBVerComboBoxActionPerformed(ActionEvent actionEvent) {
        this._dbVersion = (Version)this.jTargetDBVerComboBox.getSelectedItem();
        this.validate(this._dbVersion);
    }
}

