/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenPreferences;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class GenerateScriptsPanel
extends AbstractDialogPanel {
    private Workflow _wf;
    private String _working_dir;
    private String _wf_script_dir;
    private CodeGenPreferences _codeGenPrefences;
    private JButton jBrowseButton;
    private JTextField jGeneratedScriptDirectoryField;
    private JLabel jGeneratedScriptDirectoryLabel;
    private JLabel jScriptDirectoryLabel;
    private JLabel jScriptDirectoryValue;

    public GenerateScriptsPanel(Context context, Workflow workflow) {
        super(context, null);
        this._wf = workflow;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jScriptDirectoryLabel, (Component)this.jScriptDirectoryValue, (String)CodeGenLrb.get("GENERATE_SCRIPT_DIRECTORY"));
        ResourceUtils.resLabel((JLabel)this.jGeneratedScriptDirectoryLabel, (Component)this.jGeneratedScriptDirectoryField, (String)CodeGenLrb.get("GENERATE_SCRIPT_GEN_DIRECTORY"));
        ResourceUtils.resButton((AbstractButton)this.jBrowseButton, (String)CodeGenLrb.get("GENERATE_SCRIPT_BROWSE_DIRECTORY"));
    }

    @Override
    public void initUI() {
        String string;
        HelpUtils.setHelpID((JComponent)this, (String)"generateScriptChooseDir");
        Preferences preferences = Preferences.getPreferences();
        this._codeGenPrefences = CodeGenPreferences.getInstance((PropertyStorage)preferences);
        this._working_dir = this._codeGenPrefences.getCodeLocation();
        if (this._working_dir == null || this._working_dir.isEmpty()) {
            this._working_dir = System.getProperty("user.dir");
        }
        this.jScriptDirectoryValue.setText(this._working_dir);
        this.jScriptDirectoryValue.setToolTipText(this._working_dir);
        this._wf_script_dir = string = this._wf.getName();
        File file = new File(this._working_dir + File.separator + this._wf_script_dir);
        int n = 1;
        while (file.exists()) {
            this._wf_script_dir = string + "_" + n;
            file = new File(this._working_dir + File.separator + this._wf_script_dir);
            ++n;
        }
        this.jGeneratedScriptDirectoryField.setText(this._wf_script_dir);
    }

    public boolean doWork() {
        boolean bl = true;
        this._wf_script_dir = this.jGeneratedScriptDirectoryField.getText();
        File file = new File(this._working_dir + File.separator + this._wf_script_dir);
        if (file.exists()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CodeGenLrb.get("GENERATE_SCRIPT_DIR_EXIST"), (String)CodeGenLrb.get("GENERATE_SCRIPT_CHOOSE_DIR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    public String getScriptDirectory() {
        return this._working_dir + File.separator + this._wf_script_dir;
    }

    private void initComponents() {
        this.jScriptDirectoryLabel = new JLabel();
        this.jScriptDirectoryValue = new JLabel();
        this.jBrowseButton = new JButton();
        this.jGeneratedScriptDirectoryLabel = new JLabel();
        this.jGeneratedScriptDirectoryField = new JTextField();
        this.jScriptDirectoryLabel.setText("Script Directory:");
        this.jScriptDirectoryValue.setText("jLabel1");
        this.jBrowseButton.setText("Browse...");
        this.jBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateScriptsPanel.this.jBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.jGeneratedScriptDirectoryLabel.setText("Generated Script Directory:");
        this.jGeneratedScriptDirectoryField.setText("jTextField1");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScriptDirectoryLabel, -2, 175, -2).addComponent(this.jGeneratedScriptDirectoryLabel, -2, 175, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScriptDirectoryValue, GroupLayout.Alignment.TRAILING, -1, 208, Short.MAX_VALUE).addComponent(this.jGeneratedScriptDirectoryField, GroupLayout.Alignment.TRAILING, -1, 208, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jBrowseButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jScriptDirectoryValue).addComponent(this.jScriptDirectoryLabel).addComponent(this.jBrowseButton)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jGeneratedScriptDirectoryLabel).addComponent(this.jGeneratedScriptDirectoryField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jBrowseButtonActionPerformed(ActionEvent actionEvent) {
        try {
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.setCurrentDirectory(new File(this._working_dir));
            uRLFileChooser.setSelectionScope(1);
            if (uRLFileChooser.showOpenDialog((Component)this) == 0) {
                File file = uRLFileChooser.getSelectedFile();
                this._working_dir = file.getAbsolutePath();
                this._codeGenPrefences.setCodeLocation(this._working_dir);
                this.jScriptDirectoryValue.setText(this._working_dir);
                this.jScriptDirectoryValue.setToolTipText(this._working_dir);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }
}

