/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.expressionbuilder.AggregateMainGroupBy;
import oracle.dmt.dataminer.expressionbuilder.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderDialog;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditExpressionPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateValidation;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateValidationProgress;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class AddAggregationExpressionPanel
extends AbstractDialogPanel
implements DataConsumerPanel,
AggregateValidation {
    protected AggregationElementType thisAggregationElement;
    protected GroupingElementType mainGroupBy;
    protected List<AggregationElementType> allAggregationColumns;
    protected Map<String, AttributeType> dataProviderAttributes = new HashMap<String, AttributeType>();
    protected JButton jBtnEdit;
    protected JButton jBtnValidate;
    protected ComponentWithTitlebar<JComponent> jExpressionComponent;
    protected JLabel jLblOutput;
    public JLabel jLblSubGroupBy;
    public JTextField jTxtOutput;
    protected JTextField jtxtSubGroupBy;
    protected JTextArea jtxtSqlExpression = new JTextArea();
    protected JButton _editBtn;

    public AddAggregationExpressionPanel(Context context, AbstractNode abstractNode) {
        super(context, abstractNode);
    }

    public AddAggregationExpressionPanel(Context context, AbstractNode abstractNode, GroupingElementType groupingElementType, List<AggregationElementType> list, List<AttributeType> list2) {
        super(context, abstractNode);
        assert (list2 != null) : "Available attribute collection must not be null";
        this.allAggregationColumns = list;
        this.mainGroupBy = groupingElementType;
        if (list2 != null) {
            for (AttributeType attributeType : list2) {
                this.dataProviderAttributes.put(attributeType.getName(), attributeType);
            }
        }
        this.thisAggregationElement = new AggregationElementType();
        this.thisAggregationElement.setSource(new GroupingElementType());
        GroupingElementType groupingElementType2 = new GroupingElementType();
        groupingElementType2.setAttributes(new Attributes());
        this.thisAggregationElement.setSubGroupBy(groupingElementType2);
        this.initUIComponents();
    }

    protected void initUIComponents() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblOutput = new JLabel();
        this.jExpressionComponent = new ComponentWithTitlebar();
        this.jLblSubGroupBy = new JLabel();
        this.jtxtSubGroupBy = new JTextField();
        this.jBtnEdit = new JButton();
        this.jBtnValidate = new JButton();
        this.jTxtOutput = new JTextField();
        this.jLblOutput.setText("Output:");
        this.jLblSubGroupBy.setText("Sub Group By");
        this.jBtnEdit.setText("Edit");
        this.jBtnValidate.setText("Validate");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jtxtSubGroupBy, -2, 216, -2).addGap(26, 26, 26).addComponent(this.jBtnEdit).addGap(52, 52, 52)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jBtnValidate).addContainerGap(276, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblSubGroupBy, -2, 153, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblOutput, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtOutput, -1, 263, Short.MAX_VALUE))).addGap(22, 22, 22)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jExpressionComponent, -1, 341, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblOutput).addComponent(this.jTxtOutput, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jExpressionComponent, -1, 127, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLblSubGroupBy, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtxtSubGroupBy, -2, -1, -2).addComponent(this.jBtnEdit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnValidate).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblOutput, (Component)this.jTxtOutput, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_OUTPUT"));
        ResourceUtils.resLabel((JLabel)this.jLblSubGroupBy, (Component)this.jtxtSubGroupBy, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_SUB_GROUP_BY"));
        ResourceUtils.resButton((AbstractButton)this.jBtnEdit, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_EDIT_SUB_GROUP_BY"));
        ResourceUtils.resButton((AbstractButton)this.jBtnValidate, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_ADD_GROUP_BY_DLG_TYPE_EXPRESSION_VALIDATE"));
        this.jLblSubGroupBy.setHorizontalTextPosition(2);
    }

    protected void initControlBar() {
        JScrollPane jScrollPane = new JScrollPane(this.jtxtSqlExpression);
        this.jExpressionComponent.setComponent((JComponent)jScrollPane);
        this.jExpressionComponent.setLabel(new JLabel(AggregateDialogsLrb.get("ADD_AGGREGATION_ADD_GROUP_BY_DLG_TYPE_EXPRESSION")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        controlBar.add((Component)this._editBtn);
        this.jExpressionComponent.setControlBar(controlBar);
    }

    @Override
    public void initUI() {
        this.jtxtSqlExpression.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = AddAggregationExpressionPanel.this.jtxtSqlExpression.getText().trim();
                boolean bl = StringUtils.isDoubleQuotedString(string) || StringUtils.isSingleQuotedString(string) || StringUtils.containsDoubleQuote(string);
                string = bl ? string : string.toUpperCase();
                AddAggregationExpressionPanel.this.jBtnEdit.setEnabled(string != null && !string.trim().isEmpty());
            }
        });
        this.initControlBar();
        this.jtxtSubGroupBy.setEditable(false);
        this.jBtnEdit.setEnabled(false);
        this.jBtnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)AddAggregationExpressionPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                String string = AddAggregationExpressionPanel.this.jTxtOutput.getText().trim();
                if (string == null || string.length() == 0 || string.length() > 30) {
                    MessageDialog.error((Component)AddAggregationExpressionPanel.this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
                    return;
                }
                AttributeType attributeType = new AttributeType();
                attributeType.setName(string);
                AddAggregationExpressionPanel.this.thisAggregationElement.setOutput(attributeType);
                AggregateEditMainDialog aggregateEditMainDialog = new AggregateEditMainDialog(AddAggregationExpressionPanel.this.constructTempAggregationElementType(), AddAggregationExpressionPanel.this.mainGroupBy);
                if (aggregateEditMainDialog.invoke(AddAggregationExpressionPanel.this._context, aggregationNode, (AbstractDataNode)abstractNode)) {
                    GroupingElementType groupingElementType = aggregateEditMainDialog.getGroupByElement();
                    AddAggregationExpressionPanel.this.thisAggregationElement.setSubGroupBy(groupingElementType);
                    AddAggregationExpressionPanel.this.jtxtSubGroupBy.setText(AttributeTypeHelper.convertGroupingElementTypetoString(AddAggregationExpressionPanel.this.thisAggregationElement.getSubGroupBy()));
                }
            }
        });
        this.jBtnValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = AddAggregationExpressionPanel.this.jTxtOutput.getText().trim();
                if (string == null || string.length() == 0 || string.length() > 30) {
                    MessageDialog.error((Component)AddAggregationExpressionPanel.this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
                    return;
                }
                AggregateValidationProgress.startLongRunningOperation(AddAggregationExpressionPanel.this, true);
            }
        });
    }

    protected void installItemFilterActions(ControlBar controlBar) {
        this._editBtn = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this._editBtn.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_EXPRESSION_BUILDER"));
        this._editBtn.setEnabled(true);
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)AddAggregationExpressionPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                String string = AddAggregationExpressionPanel.this.jtxtSqlExpression.getText();
                AggregateMainGroupBy aggregateMainGroupBy = new AggregateMainGroupBy(((DataProvider)((Object)abstractNode)).getInputSQL(), abstractNode, string);
                ExpressionBuilderDialog expressionBuilderDialog = new ExpressionBuilderDialog();
                if (expressionBuilderDialog.invoke(AddAggregationExpressionPanel.this._context, aggregateMainGroupBy)) {
                    string = expressionBuilderDialog.getExpression();
                    AddAggregationExpressionPanel.this.jtxtSqlExpression.setText(string != null ? string : "");
                    AddAggregationExpressionPanel.this.jBtnEdit.setEnabled(string != null && !string.trim().isEmpty());
                }
            }
        });
    }

    @Override
    public boolean doWork() {
        String string = this.jTxtOutput.getText().trim();
        if (string == null || string.length() == 0 || string.length() > 30) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        String string2 = StringUtils.trimDoubleQuotes(string);
        if (!Character.isLetter(string2.charAt(0))) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_INVALID"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        String string3 = this.jtxtSqlExpression.getText().trim();
        if (string3 == null || string3.length() == 0) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("SQL_EXPRESSION_IS_EMPTY"), (String)AggregateDialogsLrb.get("SQL_EXPRESSION_IS_EMPTY_TITLE"), null);
            return false;
        }
        if (!StringUtils.isDoubleQuotedString(string)) {
            string = string.toUpperCase();
        }
        boolean bl = true;
        if (this.thisAggregationElement != null && this.thisAggregationElement.getOutput() != null && this.thisAggregationElement.getOutput().getName() != null && string.equals(this.thisAggregationElement.getOutput().getName())) {
            bl = false;
        }
        if (bl && !AttributeTypeHelper.isUniqueAggregationOutputName(string, this.allAggregationColumns, this.dataProviderAttributes)) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_DUPLICATE"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setName(string);
        attributeType.setAlias(string);
        if (AttributeTypeHelper.isSubGropByPresent(this.thisAggregationElement.getSubGroupBy())) {
            attributeType.setDataType("DM_NESTED_CATEGORICALS");
        }
        attributeType.setStatus(AttributeStatus.VALID);
        this.thisAggregationElement.setOutput(attributeType);
        Boolean bl2 = AggregateValidationProgress.startLongRunningOperation(this, false);
        if (bl2.booleanValue()) {
            GroupingElementType groupingElementType = new GroupingElementType();
            boolean bl3 = StringUtils.isDoubleQuotedString(string3) || StringUtils.isSingleQuotedString(string3) || StringUtils.containsDoubleQuote(string3);
            string3 = bl3 ? string3 : string3.toUpperCase();
            groupingElementType.setExpression(string3);
            this.thisAggregationElement.setSource(groupingElementType);
        }
        return bl2;
    }

    @Override
    public boolean isValidExpression(boolean bl) throws Exception {
        CharSequence charSequence;
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AbstractNode abstractNode = aggregationNode.findParentNode();
        assert (abstractNode instanceof AbstractDataNode);
        AggregationElementType aggregationElementType = this.constructTempAggregationElementType();
        if (null == aggregationElementType) {
            return false;
        }
        boolean bl2 = true;
        String string = ((DataProvider)((Object)abstractNode)).getInputSQL();
        boolean bl3 = false;
        try {
            AggregateEditExpressionPanel.executeSQL(this._context, string);
        }
        catch (Exception exception) {
            boolean bl4 = abstractNode.validateCompleteChain(true);
            if (bl4) {
                charSequence = new StringBuilder(AggregateDialogsLrb.get("ADD_AGGREGATE_SUB_GROUP_BY_EXPRESSION_INVALID"));
                ((StringBuilder)charSequence).append(exception.getMessage());
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)((StringBuilder)charSequence).toString(), (String)AggregateDialogsLrb.get("ADD_AGGREGATE_EXPRESSION_DIALOG_TITLE"), null);
                bl2 = false;
            }
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("EXPBLDR_PANEL_VALIDATE_RUN_PARENT_CONFIRM"), (String)AggregateDialogsLrb.get("ADD_AGGREGATE_EXPRESSION_DIALOG_TITLE"), null)) {
                bl2 = false;
                bl3 = true;
            }
            bl2 = false;
        }
        if (!bl2) {
            return bl3;
        }
        String string2 = AttributeTypeHelper.getAggregationElementValidationSQL(this._context, this.mainGroupBy, aggregationElementType, string);
        String string3 = DatabaseMetadataUtils.getColumnType(this._context, string2);
        if (!(this.thisAggregationElement.getOutput() == null || (charSequence = this.thisAggregationElement.getOutput().getDataType()) != null && ((String)charSequence).equals("DM_NESTED_CATEGORICALS"))) {
            this.thisAggregationElement.getOutput().setDataType(string3);
        }
        return string3 != null;
    }

    public AggregationElementType getNewAggregationElement() {
        return this.thisAggregationElement;
    }

    protected AggregationElementType constructTempAggregationElementType() {
        String string;
        String string2;
        String string3;
        String string4 = this.jtxtSqlExpression.getText().trim();
        if (string4 == null || string4.isEmpty()) {
            return null;
        }
        boolean bl = StringUtils.isDoubleQuotedString(string4) || StringUtils.isSingleQuotedString(string4) || StringUtils.containsDoubleQuote(string4);
        String string5 = string4 = !bl ? string4.toUpperCase() : string4;
        if (StringUtils.isSingleQuotedString(string4)) {
            string3 = StringUtils.trimSingleQuotes(string4);
            string2 = "'" + StringUtils.escapeSingleQuotesForSQL(string3) + "'";
        } else {
            string2 = string4;
        }
        string3 = new AggregationElementType();
        GroupingElementType groupingElementType = new GroupingElementType();
        groupingElementType.setExpression(string2);
        string3.setSource(groupingElementType);
        AttributeType attributeType = new AttributeType();
        if (this.thisAggregationElement.getOutput() != null) {
            attributeType.setName(this.thisAggregationElement.getOutput().getName());
            attributeType.setAlias(this.thisAggregationElement.getOutput().getName());
        } else {
            string = this.jTxtOutput.getText().trim();
            String string6 = StringUtils.trimDoubleQuotes(string);
            if (!Character.isLetter(string6.charAt(0))) {
                MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_INVALID"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
                return null;
            }
            if (!StringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            attributeType.setName(string);
            attributeType.setAlias(string);
        }
        if (AttributeTypeHelper.isSubGropByPresent(this.thisAggregationElement.getSubGroupBy())) {
            attributeType.setDataType("DM_NESTED_CATEGORICALS");
        }
        attributeType.setStatus(AttributeStatus.VALID);
        string3.setOutput(attributeType);
        string = new GroupingElementType();
        if (null != this.thisAggregationElement.getSubGroupBy()) {
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)string, this.thisAggregationElement.getSubGroupBy());
        }
        string3.setSubGroupBy((GroupingElementType)string);
        return string3;
    }

    public JLabel getLabelSubGroupBy() {
        return this.jLblSubGroupBy;
    }
}

