/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplySettingsPage;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ApplyTopNPanel
extends AbstractDialogPanel {
    private ApplyNode.DefaultPredictionSet _predictionSet;
    private ApplySettingsPage _parent;
    private static final String TOPN_ALL = DialogsLrb.get("APPLY_OPTION_ALL");
    private static final BigInteger TOPN_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private JCheckBox jBestNCheckBox;
    private JComboBox jBestNComboBox;
    private JCheckBox jCutOffCheckBox;
    private JLabel jCutOffLabel;
    private NumberTextField jCutOffTextField;
    private JLabel jNValueLabel;

    public ApplyTopNPanel(Context context, ApplySettingsPage applySettingsPage, ApplyNode.DefaultPredictionSet defaultPredictionSet) {
        super(context, null);
        this._parent = applySettingsPage;
        this._predictionSet = defaultPredictionSet;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
        ResourceUtils.resLabel((JLabel)this.jNValueLabel, (Component)this.jBestNComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
        ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"apply_topn");
        BigInteger bigInteger = this._predictionSet.getTopN();
        this.jBestNCheckBox.setSelected(bigInteger != null);
        int n2 = this._predictionSet.getMaxN();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(TOPN_ALL);
        for (int i = 1; i <= n2; ++i) {
            defaultComboBoxModel.addElement(i + "");
        }
        this.jBestNComboBox.setModel(defaultComboBoxModel);
        this.jBestNComboBox.setEnabled(this.jBestNCheckBox.isSelected());
        this.jBestNComboBox.setSelectedItem(bigInteger.equals(TOPN_VALUE) ? TOPN_ALL : bigInteger.toString());
        Double d = null;
        String string = null;
        String string2 = null;
        boolean bl = true;
        if (this._predictionSet instanceof ApplyNode.PredictionSet) {
            void var8_10;
            boolean n = false;
            for (RefModelType refModelType : this._parent.getWizModel().getSelectedModels()) {
                boolean bl2 = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getWizModel().getParent().getData(), refModelType);
                if (bl2) continue;
                ++var8_10;
            }
            if (this._parent.getWizModel().getSelectedModels().size() > 1 && this._parent.getWizModel().getSelectedModels().size() > var8_10) {
                this.jCutOffCheckBox.setVisible(false);
                this.jCutOffTextField.setVisible(false);
                bl = false;
            } else if (((ApplyNode.PredictionSet)this._predictionSet).getUseCostType().compareTo("Model") == 0) {
                d = ((ApplyNode.PredictionSet)this._predictionSet).getCostCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE_TIP");
            } else {
                d = this._predictionSet.getCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE_TIP");
            }
        } else {
            d = this._predictionSet.getCutOff();
            string = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE");
            string2 = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE_TIP");
        }
        if (bl) {
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)string);
            this.jCutOffLabel.getAccessibleContext().setAccessibleName(string);
            boolean bl3 = d != null && d > 0.0;
            this.jCutOffCheckBox.setSelected(bl3);
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(string2);
        }
    }

    public boolean doWork() {
        boolean bl = true;
        try {
            String string = null;
            boolean bl2 = this.jBestNCheckBox.isSelected();
            if (bl2) {
                string = (String)this.jBestNComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl3 = this.jCutOffCheckBox.isSelected();
            if (bl3) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            this._predictionSet.setUseTopN(bl2);
            this._predictionSet.setTopN(bl2 ? (string.equals(TOPN_ALL) ? TOPN_VALUE : new BigInteger(string)) : null);
            if (this._predictionSet instanceof ApplyNode.PredictionSet) {
                if (((ApplyNode.PredictionSet)this._predictionSet).getUseCostType().compareTo("None") == 0) {
                    this._predictionSet.setUseCutOff(bl3);
                    this._predictionSet.setCutOff(bl3 ? d : null);
                } else {
                    ((ApplyNode.PredictionSet)this._predictionSet).setUseCostCutOff(bl3);
                    ((ApplyNode.PredictionSet)this._predictionSet).setCostCutOff(bl3 ? d : null);
                }
            } else {
                this._predictionSet.setUseCutOff(bl3);
                this._predictionSet.setCutOff(bl3 ? d : null);
            }
            this._predictionSet.validate();
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void initComponents() {
        this.jBestNCheckBox = new JCheckBox();
        this.jNValueLabel = new JLabel();
        this.jBestNComboBox = new JComboBox();
        this.jCutOffCheckBox = new JCheckBox();
        this.jCutOffLabel = new JLabel();
        this.jCutOffTextField = new NumberTextField();
        this.jBestNCheckBox.setText("Use Best N:");
        this.jBestNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyTopNPanel.this.jBestNCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNValueLabel.setLabelFor(this.jBestNComboBox);
        this.jNValueLabel.setText("N Value:");
        this.jBestNComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1"}));
        this.jCutOffCheckBox.setText("Use CutOff:");
        this.jCutOffCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyTopNPanel.this.jCutOffCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jCutOffLabel.setLabelFor((Component)this.jCutOffTextField);
        this.jCutOffLabel.setText("Prob Value:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jCutOffLabel, -2, 65, -2)).addComponent(this.jBestNCheckBox).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jNValueLabel, -2, 65, -2)).addComponent(this.jCutOffCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCutOffTextField, -1, 157, Short.MAX_VALUE).addComponent(this.jBestNComboBox, 0, 157, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.linkSize(0, this.jCutOffLabel, this.jNValueLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jBestNCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNValueLabel).addComponent(this.jBestNComboBox, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jCutOffCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCutOffLabel).addComponent((Component)this.jCutOffTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jBestNCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jBestNComboBox.setEnabled(this.jBestNCheckBox.isSelected());
    }

    private void jCutOffCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
    }
}

