/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyDataPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class SuppAttrsPanel
extends AbstractDialogPanel {
    private List<AttributeType> availAttrsCache = new ArrayList<AttributeType>();
    private List<AttributeType> selectedAttrsCache;
    private boolean _dirty = false;
    private DataMinerTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JLabel jSelectedLabel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;

    public SuppAttrsPanel(Context context, ApplyDataPanel applyDataPanel, DataProvider dataProvider, SupplementalAttributesType supplementalAttributesType) {
        super(context, applyDataPanel.getData());
        List list = dataProvider.getAttributes().getAttribute();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            this.availAttrsCache.add(attributeType2);
        }
        SupplementalAttributesType supplementalAttributesType2 = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(supplementalAttributesType);
        this.selectedAttrsCache = supplementalAttributesType2.getAttribute();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public SuppAttrsPanel(Context context, AbstractNode abstractNode, DataProvider dataProvider, SupplementalAttributesType supplementalAttributesType) {
        super(context, abstractNode);
        List list = dataProvider.getAttributes().getAttribute();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            this.availAttrsCache.add(attributeType2);
        }
        SupplementalAttributesType supplementalAttributesType2 = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(supplementalAttributesType);
        this.selectedAttrsCache = supplementalAttributesType2.getAttribute();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new DataMinerTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new DataMinerTable();
        this.jSelectedAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrsScrollPane.setViewportView((Component)((Object)this.jSelectedAttrs));
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jAvailableLabel.setLabelFor(this.jAvailAttrsScrollPane);
        this.jAvailableLabel.setText("Available Attributes");
        this.jSelectedLabel.setLabelFor(this.jSelectedAttrsScrollPane);
        this.jSelectedLabel.setText("Selected Attributes");
        this.jAvailAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrsScrollPane.setViewportView((Component)((Object)this.jAvailAttrs));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, 277, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 289, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, 289, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 210, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 210, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAvailableLabel, (Component)((Object)this.jAvailAttrs), (String)DataDialogsLrb.get("AVAILABLE_LABEL"));
        ResourceUtils.resLabel((JLabel)this.jSelectedLabel, (Component)((Object)this.jSelectedAttrs), (String)DataDialogsLrb.get("SELECTED_LABEL"));
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHT));
        this.jSelectAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHTALL));
        this.jRemoveBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFT));
        this.jRemoveAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFTALL));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"apply_supplemental");
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        String[] stringArray = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        AttrTableModel attrTableModel = new AttrTableModel(this.availAttrsCache, stringArray);
        this.jAvailAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer((Icon)DataMinerIcons.get(Icons.ATTRIBUTE), DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        AttrTableModel attrTableModel2 = new AttrTableModel(this.selectedAttrsCache, stringArray);
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        attributeNameCellRenderer = new AttributeNameCellRenderer((Icon)DataMinerIcons.get(Icons.ATTRIBUTE), DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        this.jAvailAttrs.getRowSorter().toggleSortOrder(0);
        this.jSelectedAttrs.getRowSorter().toggleSortOrder(0);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jAvailAttrs, SuppAttrsPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jAvailAttrs, SuppAttrsPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jSelectedAttrs, SuppAttrsPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jSelectedAttrs, SuppAttrsPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<AttributeType> list = ((AttrTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((AttributeType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<AttributeType> list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (AttributeType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    public List<AttributeType> getSelectedAttrsCache() {
        return this.selectedAttrsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    class AttrTableModel
    extends GenericBaseTableModel {
        private List<AttributeType> _data;
        private final int NAME = 0;
        private final int DATA_TYPE = 1;

        public AttrTableModel(List<AttributeType> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.getRowCount());
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            AttributeType attributeType = this._data.get(n);
            if (0 == n2) {
                object = attributeType;
            } else if (1 == n2) {
                assert (n2 > 0 && n2 < this.getColumnCount()) : "Column out of bounds";
                object = attributeType.getDataType();
            }
            return object;
        }

        public List<AttributeType> getDataList() {
            return this._data;
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 0: {
                    return AttributeTypeComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }
    }
}

