/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.CheckBoxTableListener;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.LabeledCheckBoxRenderer;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class AddStopwordsFromFeaturesPanel
extends AbstractDialogPanel
implements SearchListener {
    private static final int SHOW_STOPWORDS = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.build.showWords");
    private static final int SHOW_STOPTHEMES = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.build.showThemes");
    private BuildNodeType buildNodeType = null;
    private JPanel parent;
    private StoplistType stoplist;
    private boolean dirty;
    private StopwordTableModel stopwordModels;
    private GenericTable stopwordTable = new DataMinerTable();
    private SearchField searchField;
    private String searchText;
    private transient SearchCategory searchCategory;
    private ToggleToolButton showWords;
    private ToggleToolButton showThemes;
    private boolean bShowWords;
    private boolean bShowThemes;
    private LabeledCheckBoxRenderer tableCellRenderer = new LabeledCheckBoxRenderer();
    private CheckListener tableListener = new CheckListener(this.tableCellRenderer);
    private transient RowFilter<StopwordTableModel, Integer> tokenFilter;
    private HashMap<String, Boolean> allTokens = new HashMap();
    private ComponentWithTitlebar<JComponent> StopwordComponentWithTitlebar;
    private JLabel jLanguageLabel;
    private JLabel jLanguageValueLabel;
    private JLabel jStoplistLabel;
    private JTextField jStoplistTextField;
    private String[] _stopwordColumnNames = new String[]{DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_ATTR"), DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_NAME"), DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_TYPE"), DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_FREQ")};
    private static final int STOPWORD_ATTR = 0;
    private static final int STOPWORD_NAME = 1;
    private static final int STOPWORD_TYPE = 2;
    private static final int STOPWORD_FREQUENCY = 3;
    private static final int STOPWORD_COLUMN_COUNT = 4;
    private static final int SELECT_COLUMN = -1;

    public AddStopwordsFromFeaturesPanel(Context context, JPanel jPanel, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, StoplistType stoplistType) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "AbstractBuildNode node must not be null.";
        assert (abstractBuildNode instanceof AbstractBuildNode) : "Must be an instance of AbstractBuildNode node.";
        this.init(jPanel, buildNodeType, stoplistType);
    }

    private void init(JPanel jPanel, BuildNodeType buildNodeType, StoplistType stoplistType) {
        this.buildNodeType = buildNodeType;
        this.parent = jPanel;
        this.bShowWords = true;
        this.bShowThemes = true;
        this.stoplist = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
        for (StoplistType.StopTokens.Token token : this.stoplist.getStopTokens().getToken()) {
            String string = token.getLanguage();
            String string2 = token.getItem();
            String string3 = token.getType();
            String string4 = string + ":" + string3 + ":" + string2;
            this.allTokens.put(string4, Boolean.TRUE);
        }
        this.dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, (Component)this.jStoplistTextField, (String)DialogsLrb.get("ADD_STOPWORD_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jLanguageValueLabel, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGES"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"add_stopwords_from_features");
        this.jStoplistTextField.setText(this.stoplist.getName());
        this.jStoplistTextField.setEditable(false);
        String string = null;
        string = this.stoplist.getType().equals("Basic") ? ServerConstants.StoplistLanguage.toHuman(this.stoplist.getLanguage()) : ServerConstants.StoplistLanguage.toHuman("Multi");
        this.jLanguageValueLabel.setText(string);
        JScrollPane jScrollPane = new JScrollPane((Component)this.stopwordTable);
        this.StopwordComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.StopwordComponentWithTitlebar.setControlBar(controlBar);
        this.installStopwordItemFilterActions(controlBar);
        LoadUI loadUI = new LoadUI(this.buildNodeType);
        loadUI.execute();
    }

    private void installStopwordItemFilterActions(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        IdeAction ideAction = IdeAction.get((int)SHOW_STOPWORDS);
        this.showWords = new ToggleToolButton((ToggleAction)ideAction);
        this.showWords.setIcon(OracleIcons.getIcon((String)"text.png"));
        this.showWords.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPWORDS_TIP"));
        controlBar.add((Component)this.showWords);
        this.showWords.setSelected(this.bShowWords);
        this.showWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                AddStopwordsFromFeaturesPanel.this.bShowWords = toggleToolButton.isSelected();
                AddStopwordsFromFeaturesPanel.this.configureSorting();
            }
        });
        IdeAction ideAction2 = IdeAction.get((int)SHOW_STOPTHEMES);
        this.showThemes = new ToggleToolButton((ToggleAction)ideAction2);
        this.showThemes.setIcon(OracleIcons.getIcon((String)"catalog.png"));
        this.showThemes.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPTHEMES_TIP"));
        controlBar.add((Component)this.showThemes);
        controlBar.addSeparator();
        this.showThemes.setSelected(this.bShowThemes);
        this.showThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                AddStopwordsFromFeaturesPanel.this.bShowThemes = toggleToolButton.isSelected();
                AddStopwordsFromFeaturesPanel.this.configureSorting();
            }
        });
        this.searchField = new SearchField(SearchField.Style.FILTER);
        this.searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_ATTR")), new SearchCategory(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_NAME")), new SearchCategory(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_TYPE")), new SearchCategory(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_FREQ"))}) {
            this.searchField.addCategory(searchCategory);
        }
        controlBar.add((Component)this.searchField);
        this.searchField.addSearchListener((SearchListener)this);
    }

    public void configureSorting() {
        TableRowSorter<StopwordTableModel> tableRowSorter = (TableRowSorter<StopwordTableModel>)this.stopwordTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<StopwordTableModel>(this.stopwordModels);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(3, SortOrder.DESCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this.tokenFilter);
        this.stopwordTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this.searchCategory = searchEvent.getSearchCategory();
        this.searchText = searchEvent.getSearchText();
        this.configureSorting();
        this.stopwordTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this.searchCategory = searchEvent.getSearchCategory();
        this.searchText = searchEvent.getSearchText();
        this.configureSorting();
        this.stopwordTable.scrollToSelection();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean doWork() {
        boolean bl = true;
        List<ColumnData> list = this.stopwordModels.getData();
        for (ColumnData columnData : list) {
            if (!((Entry)columnData.getData()).getSelected().booleanValue()) continue;
            AbstractBuildNode.TextFeature textFeature = (AbstractBuildNode.TextFeature)((Entry)columnData.getData()).getUserObject();
            String string = this.stoplist.getLanguage();
            string = "Multi".equals(string) ? "All" : string;
            String string2 = textFeature.getType();
            String string3 = textFeature.getName();
            String string4 = string + ":" + string2 + ":" + string3;
            if (this.allTokens.containsKey(string4)) continue;
            StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
            token.setLanguage(string);
            token.setType(string2);
            token.setItem(string3);
            this.stoplist.getStopTokens().getToken().add(token);
            this.allTokens.put(string4, Boolean.TRUE);
            this.dirty = true;
        }
        return bl;
    }

    private void initComponents() {
        this.jStoplistLabel = new JLabel();
        this.jStoplistTextField = new JTextField();
        this.jLanguageLabel = new JLabel();
        this.jLanguageValueLabel = new JLabel();
        this.StopwordComponentWithTitlebar = new ComponentWithTitlebar();
        this.jStoplistLabel.setText("Stoplist:");
        this.jStoplistTextField.setText("jTextField1");
        this.jLanguageLabel.setText("Language:");
        this.jLanguageValueLabel.setText("jLabel3");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 464, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jStoplistLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLanguageLabel, -1, 73, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLanguageValueLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jStoplistTextField, -1, 213, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStoplistLabel).addComponent(this.jStoplistTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jLanguageValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 300, Short.MAX_VALUE).addContainerGap()));
    }

    public StoplistType getStoplist() {
        return this.stoplist;
    }

    private class StopwordTableModel
    extends GenericBaseTableModel {
        private List<ColumnData> data = new ArrayList<ColumnData>();

        private void determineState(List<Entry> list) {
            for (Entry entry : list) {
                ColumnData columnData = new ColumnData(entry);
                if (entry.getSelected().booleanValue()) {
                    columnData.setCheckBoxState(TriStateBoolean.TRUE);
                }
                this.data.add(columnData);
            }
        }

        public StopwordTableModel(List<AbstractBuildNode.TextFeature> list) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            for (AbstractBuildNode.TextFeature textFeature : list) {
                Entry entry = new Entry();
                entry.setUserObject(textFeature);
                arrayList.add(entry);
            }
            this.determineState(arrayList);
            this.setColumnIdentifiers(AddStopwordsFromFeaturesPanel.this._stopwordColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return Integer.class;
            }
            if (n == 0) {
                return ColumnData.class;
            }
            return String.class;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == -1) {
                ColumnData columnData = this.data.get(n);
                Entry entry = (Entry)columnData.getData();
                entry.setSelected((Boolean)object);
            }
        }

        public Object getValueAt(int n, int n2) {
            if (this.data == null) {
                return "Loading...";
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ColumnData columnData = this.data.get(n);
            Object object = null;
            Entry entry = (Entry)columnData.getData();
            AbstractBuildNode.TextFeature textFeature = (AbstractBuildNode.TextFeature)entry.getUserObject();
            switch (n2) {
                case -1: {
                    object = entry.getSelected();
                    break;
                }
                case 0: {
                    object = columnData;
                    break;
                }
                case 1: {
                    object = textFeature.getName();
                    break;
                }
                case 2: {
                    object = ServerConstants.StopTokenType.toHuman(textFeature.getType());
                    break;
                }
                case 3: {
                    object = textFeature.getFrequency();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public List<ColumnData> getData() {
            return this.data;
        }
    }

    static class Entry {
        private Boolean selected = Boolean.FALSE;
        private Object userObject;

        public void setSelected(Boolean bl) {
            this.selected = bl;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public Object getUserObject() {
            return this.userObject;
        }
    }

    private class CheckListener
    extends CheckBoxTableListener {
        public CheckListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
            super(labeledCheckBoxRenderer);
        }

        @Override
        protected void itemChecked(int n) {
            StopwordTableModel stopwordTableModel = (StopwordTableModel)((Object)AddStopwordsFromFeaturesPanel.this.stopwordTable.getModel());
            ColumnData columnData = (ColumnData)stopwordTableModel.getValueAt(AddStopwordsFromFeaturesPanel.this.stopwordTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.TRUE);
            Entry entry = (Entry)columnData.getData();
            entry.setSelected(Boolean.TRUE);
        }

        @Override
        public void itemUnchecked(int n) {
            StopwordTableModel stopwordTableModel = (StopwordTableModel)((Object)AddStopwordsFromFeaturesPanel.this.stopwordTable.getModel());
            ColumnData columnData = (ColumnData)stopwordTableModel.getValueAt(AddStopwordsFromFeaturesPanel.this.stopwordTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.FALSE);
            Entry entry = (Entry)columnData.getData();
            entry.setSelected(Boolean.FALSE);
        }
    }

    static class ColumnData
    extends CheckedItemData {
        public ColumnData(Entry entry) {
            super(entry);
        }

        @Override
        public String toString() {
            AbstractBuildNode.TextFeature textFeature = (AbstractBuildNode.TextFeature)((Entry)this.getData()).getUserObject();
            return textFeature.getColumn();
        }
    }

    private class LoadUI
    extends SwingWorker {
        private BuildNodeType buildNode;
        private List<AbstractBuildNode.TextFeature> textFeatures = new ArrayList<AbstractBuildNode.TextFeature>();
        private Exception ex = null;
        private boolean success = false;

        public LoadUI(BuildNodeType buildNodeType) {
            this.buildNode = buildNodeType;
        }

        protected Object doInBackground() throws Exception {
            try {
                List<AbstractBuildNode.TextFeature> list = AbstractBuildNode.getDefaultTextFeatures(AddStopwordsFromFeaturesPanel.this._context, this.buildNode);
                for (AbstractBuildNode.TextFeature textFeature : list) {
                    String string = AddStopwordsFromFeaturesPanel.this.stoplist.getLanguage();
                    string = "Multi".equals(string) ? "All" : string;
                    String string2 = textFeature.getType();
                    String string3 = textFeature.getName();
                    String string4 = string + ":" + string2 + ":" + string3;
                    if (AddStopwordsFromFeaturesPanel.this.allTokens.containsKey(string4)) continue;
                    this.textFeatures.add(textFeature);
                }
                this.success = true;
            }
            catch (Exception exception) {
                this.ex = exception;
                this.success = false;
            }
            return this.textFeatures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            block5: {
                super.done();
                try {
                    if (this.success && this.ex == null) {
                        AddStopwordsFromFeaturesPanel.this.stopwordModels = new StopwordTableModel(this.textFeatures);
                        AddStopwordsFromFeaturesPanel.this.stopwordTable.setModel((TableModel)((Object)AddStopwordsFromFeaturesPanel.this.stopwordModels));
                        AddStopwordsFromFeaturesPanel.this.stopwordTable.setResizeColumnOnDoubleClick(true);
                        AddStopwordsFromFeaturesPanel.this.stopwordTable.getSelectionModel().setSelectionMode(2);
                        AddStopwordsFromFeaturesPanel.this.stopwordTable.addMouseListener((MouseListener)AddStopwordsFromFeaturesPanel.this.tableListener);
                        AddStopwordsFromFeaturesPanel.this.stopwordTable.addKeyListener((KeyListener)AddStopwordsFromFeaturesPanel.this.tableListener);
                        TableColumn tableColumn = AddStopwordsFromFeaturesPanel.this.stopwordTable.getColumnModel().getColumn(0);
                        tableColumn.setCellRenderer(AddStopwordsFromFeaturesPanel.this.tableCellRenderer);
                        AddStopwordsFromFeaturesPanel.this.tokenFilter = new RowFilter<StopwordTableModel, Integer>(){

                            @Override
                            public boolean include(RowFilter.Entry<? extends StopwordTableModel, ? extends Integer> entry) {
                                String string;
                                boolean bl = false;
                                boolean bl2 = false;
                                boolean bl3 = AddStopwordsFromFeaturesPanel.this.searchText != null && AddStopwordsFromFeaturesPanel.this.searchCategory != null;
                                Integer n = entry.getIdentifier();
                                StopwordTableModel stopwordTableModel = entry.getModel();
                                String string2 = (String)stopwordTableModel.getValueAt(n, 2);
                                if (AddStopwordsFromFeaturesPanel.this.bShowWords && ServerConstants.StopTokenType.isWord(string2) || AddStopwordsFromFeaturesPanel.this.bShowThemes && ServerConstants.StopTokenType.isTheme(string2)) {
                                    bl2 = true;
                                }
                                String string3 = string = AddStopwordsFromFeaturesPanel.this.searchText != null ? AddStopwordsFromFeaturesPanel.this.searchText.toLowerCase() : null;
                                if (bl2 && bl3 && AddStopwordsFromFeaturesPanel.this.searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_ATTR"))) {
                                    ColumnData columnData = (ColumnData)stopwordTableModel.getValueAt(n, 0);
                                    Entry entry2 = (Entry)columnData.getData();
                                    AbstractBuildNode.TextFeature textFeature = (AbstractBuildNode.TextFeature)entry2.getUserObject();
                                    if (textFeature.getColumn().toLowerCase().startsWith(string)) {
                                        bl = true;
                                    }
                                } else if (bl2 && bl3 && AddStopwordsFromFeaturesPanel.this.searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_NAME"))) {
                                    String string4 = (String)stopwordTableModel.getValueAt(n, 1);
                                    if (string4.toLowerCase().startsWith(string)) {
                                        bl = true;
                                    }
                                } else if (bl2 && bl3 && AddStopwordsFromFeaturesPanel.this.searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_TYPE"))) {
                                    String string5 = (String)stopwordTableModel.getValueAt(n, 2);
                                    if (string5.toLowerCase().startsWith(string)) {
                                        bl = true;
                                    }
                                } else if (bl2 && bl3 && AddStopwordsFromFeaturesPanel.this.searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_FREQ"))) {
                                    Integer n2 = (Integer)stopwordTableModel.getValueAt(n, 3);
                                    if (n2.toString().startsWith(string)) {
                                        bl = true;
                                    }
                                } else if (bl2) {
                                    bl = true;
                                }
                                return bl;
                            }
                        };
                        AddStopwordsFromFeaturesPanel.this.configureSorting();
                        break block5;
                    }
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this.ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILD_TEXT_NODE_EDIT_ERROR_MESG"), null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILD_TEXT_NODE_EDIT_ERROR_MESG"), null);
                }
            }
        }
    }
}

