/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AlgorithmSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.DataUsagePanel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelDataUsageCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.build.ModelEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameChangeValidator;
import oracle.dmt.dataminer.workflow.dialog.build.ModelsTable;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelDialog;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.dialog.build.PerformanceSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.JTabbedPane2;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class AdvancedSettingsPanel
extends JPanel
implements ModelNameChangeValidator {
    private static final Logger LOGGER = Logger.getLogger(AdvancedSettingsPanel.class.getName());
    protected Context context;
    protected BuildNodeType metadataCopy;
    private boolean isStandalone = false;
    protected AbstractBuildNode workflowNode;
    private Map<String, AbstractSettingsPanel> panels;
    private boolean isTextDirty = false;
    private DataUsagePanel dataUsagePanelRef;
    private final HashMap<String, ModelEditRecord> modelEdits = new HashMap();
    private Version dbVersion;
    private Map<String, Object> auxMetadata = new HashMap<String, Object>();
    private JEWTDialog parentDialogRef;
    private Map<String, ModelHeuristicRules> modelRules;
    private TransparentPanel _jDetailPanel;
    private TransparentPanel _jModelsTablePanel;
    private ComponentWithTitlebar<JComponent> _jModelsToolbar;
    private JSplitPane jSplitter;
    private ControlledSelectionGenericTable jModelsTable = new ControlledSelectionGenericTable(this.metadataCopy, 3);
    private ModelsTableModel modelsTblModel;
    private JTabbedPane tabs = new CustomTab();
    private JButton removeBtn;
    private JButton addBtn;

    public Map<String, ModelHeuristicRules> getCopyOfModelRules() {
        if (this.modelRules == null) {
            this.modelRules = MetaDataHelper.getHeuristicsRulesModels(this.context, this.metadataCopy);
        }
        return new HashMap<String, ModelHeuristicRules>(this.modelRules);
    }

    public AdvancedSettingsPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, List<String> list) {
        try {
            this.panels = new LinkedHashMap<String, AbstractSettingsPanel>();
            this.context = context;
            this.workflowNode = abstractBuildNode;
            this.metadataCopy = buildNodeType;
            this.dbVersion = ConfigUtils.getDatabaseVersion(context);
            if (buildNodeType != null) {
                this.metadataCopy = buildNodeType;
            } else {
                this.metadataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(abstractBuildNode.getData());
                this.isStandalone = true;
            }
            this.initComponents();
            this.initRes();
            this.initUI(list);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage());
        }
    }

    public boolean isDirty() {
        return this.modelEdits.size() != 0 || this.isTextDirty;
    }

    private void initComponents() {
        this.jSplitter = new JSplitPane();
        this._jModelsTablePanel = new TransparentPanel();
        this._jModelsToolbar = new ComponentWithTitlebar();
        this._jDetailPanel = new TransparentPanel();
        this.jSplitter.setBorder(null);
        this.jSplitter.setDividerLocation(180);
        this.jSplitter.setDividerSize(3);
        this.jSplitter.setOrientation(0);
        this.jSplitter.setMinimumSize(new Dimension(550, 450));
        this._jModelsToolbar.setPreferredSize(new Dimension(0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this._jModelsTablePanel);
        this._jModelsTablePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsToolbar, -1, 840, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsToolbar, -1, 180, Short.MAX_VALUE));
        this.jSplitter.setLeftComponent((Component)this._jModelsTablePanel);
        GroupLayout groupLayout2 = new GroupLayout((Container)this._jDetailPanel);
        this._jDetailPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 840, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 347, Short.MAX_VALUE));
        this.jSplitter.setRightComponent((Component)this._jDetailPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitter, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitter, -1, -1, Short.MAX_VALUE));
    }

    protected void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        UIResourceHelper.setComponentText(hashMap);
        this.initHelp();
        this.jSplitter.setDividerLocation(120);
    }

    protected void initHelp() {
        if (this.workflowNode instanceof AssociationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"association_node_edit_adv");
        } else if (this.workflowNode instanceof ClassificationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"classification_node_edit_adv");
        } else if (this.workflowNode instanceof ClusteringBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"clustering_node_edit_adv");
        } else if (this.workflowNode instanceof RegressionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"regression_node_edit_adv");
        } else if (this.workflowNode instanceof AnomalyDetectionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"anomaly_node_edit_adv");
        } else if (this.workflowNode instanceof FeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"feature_node_edit_adv");
        }
    }

    protected void initIconResources() {
    }

    public void setParentDialogRef(JEWTDialog jEWTDialog) {
        this.parentDialogRef = jEWTDialog;
        this.parentDialogRef.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (AdvancedSettingsPanel.this.dataUsagePanelRef != null) {
                    AdvancedSettingsPanel.this.dataUsagePanelRef.resizeTable(AdvancedSettingsPanel.this.getSize());
                }
            }
        });
    }

    protected void initUI(List<String> list) {
        DefaultTableModel defaultTableModel;
        this.initIconResources();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.jModelsTable));
        this._jModelsToolbar.setComponent((JComponent)jScrollPane);
        this._jModelsToolbar.setLabel(new JLabel(BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL")));
        this.installModelActions();
        List<ModelType> list2 = MetaDataHelper.getModelsCollection(this.metadataCopy);
        String[] stringArray = null;
        stringArray = this.metadataCopy instanceof AssociationBuildNodeType ? new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT")} : new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT"), BuildEditorLrb.get("BUILD_MODEL_USAGE"), BuildEditorLrb.get("BUILD_MODEL_EXCLUDED")};
        this.modelsTblModel = new ModelsTableModel(list2, stringArray);
        this.jModelsTable.setModelEditCache(this.modelEdits);
        this.jModelsTable.setModel((TableModel)((Object)this.modelsTblModel));
        this.jModelsTable.setSorted(true);
        this.jModelsTable.setUpdateSelectionOnSort(true);
        this.jModelsTable.getTableHeader().setReorderingAllowed(false);
        this.jModelsTable.setAutoResizeMode(2);
        this.jModelsTable.getColumnModel().getColumn(0).setCellEditor(new ModelNameCellEditor(this.context, this.getWorkflowModel(), this.metadataCopy, this));
        if (stringArray.length > 3) {
            this.jModelsTable.getColumnModel().getColumn(3).setCellRenderer(new ModelDataUsageCellRenderer(false, true, true));
        }
        this.jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AdvancedSettingsPanel.this.handleModelSelectionChanged(listSelectionModel);
            }
        });
        this._jDetailPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        if (!(this.metadataCopy instanceof AssociationBuildNodeType)) {
            this.dataUsagePanelRef = new DataUsagePanel(this, this.context, this.workflowNode, this.metadataCopy, this.modelEdits);
            this.panels.put(BuildEditorLrb.get("DATA_USAGE"), this.dataUsagePanelRef);
        }
        this.panels.put(BuildEditorLrb.get("ALGO_SETTINGS"), new AlgorithmSettingsPanel(this, this.context, this.workflowNode, this.metadataCopy, this.modelEdits));
        if (this.metadataCopy instanceof ClassificationBuildNodeType) {
            this.panels.put(BuildEditorLrb.get("PERF_SETTINGS"), new PerformanceSettingsPanel(this, this.context, this.workflowNode, this.metadataCopy, this.modelEdits));
        }
        for (String string : this.panels.keySet()) {
            this.tabs.addTab(string, this.panels.get(string));
        }
        this._jDetailPanel.add((Component)this.tabs, (Object)"Center");
        Object object = new int[]{0};
        if (list != null && list.size() > 0) {
            object = new int[list.size()];
            int n = 0;
            for (int i = 0; i < this.modelsTblModel.getDataList().size(); ++i) {
                ModelType modelType = this.modelsTblModel.getDataList().get(i);
                if (!list.contains(modelType.getId())) continue;
                object[n++] = i;
            }
        }
        if (!(defaultTableModel = (DefaultTableModel)this.jModelsTable.getModel()).getDataVector().isEmpty()) {
            this.jModelsTable.setSelectedRowsInModel((int[])object);
        }
    }

    private WorkflowModel getWorkflowModel() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return workflowModel;
    }

    public void refreshTable() {
        int[] nArray = this.jModelsTable.getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.jModelsTable.getModel());
        modelsTableModel.fireTableDataChanged();
        this.jModelsTable.setSelectedRowsInModel(nArray);
    }

    public boolean canProceed() {
        boolean bl = true;
        ListSelectionModel listSelectionModel = this.jModelsTable.getSelectionModel();
        String string = BuildEditorLrb.get("PERF_SETTINGS");
        AbstractSettingsPanel abstractSettingsPanel = this.panels.get(string);
        if (abstractSettingsPanel != null && !abstractSettingsPanel.canProceed(listSelectionModel)) {
            return false;
        }
        for (String string2 : this.panels.keySet()) {
            AbstractSettingsPanel abstractSettingsPanel2 = this.panels.get(string2);
            if (abstractSettingsPanel != null && string2.equals(string) || abstractSettingsPanel2.canProceed(listSelectionModel)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void initMiningAttributeInputs(MiningAttributes miningAttributes, ModelType modelType) {
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
            for (MiningAttributeType miningAttributeType : miningAttributes.getMiningAttribute()) {
                if (AbstractBuildNode.isInputAllowed(miningAttributeType, modelType, version).booleanValue()) continue;
                miningAttributeType.setInput("No");
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void installModelActions() {
        ControlBar controlBar = new ControlBar();
        this.removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(BuildEditorLrb.get("MODELS_DELETE_TOOLTIP"));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n;
                String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)AdvancedSettingsPanel.this.jModelsTable));
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = AdvancedSettingsPanel.this.jModelsTable.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray2[n] = AdvancedSettingsPanel.this.jModelsTable.convertRowIndexToModel(nArray[n]);
                    object = AdvancedSettingsPanel.this.modelsTblModel.getDataList().get(nArray2[n]);
                    AdvancedSettingsPanel.this.addEditedModelRecord((ModelType)object, 2);
                }
                AdvancedSettingsPanel.this.modelsTblModel.removeRows(nArray2);
                if (AdvancedSettingsPanel.this.modelsTblModel.getDataList().size() != 0) {
                    n = nArray[0] - 1 < 0 ? 0 : nArray[0] - 1;
                    n = AdvancedSettingsPanel.this.jModelsTable.convertRowIndexToModel(n);
                    object = new int[]{n};
                    AdvancedSettingsPanel.this.jModelsTable.setSelectedRowsInModel((int[])object);
                }
            }
        });
        controlBar.add((Component)this.removeBtn);
        this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(BuildEditorLrb.get("MODELS_ADD_TOOLTIP"));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = AdvancedSettingsPanel.this.getPendingNewModels();
                Collection collection2 = AdvancedSettingsPanel.this.getPendingRenamedModels();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(collection);
                arrayList.addAll(collection2);
                ModelType modelType = NewModelDialog.addNewModel(AdvancedSettingsPanel.this.metadataCopy, AdvancedSettingsPanel.this.getContext(), AdvancedSettingsPanel.this.workflowNode, arrayList);
                if (modelType != null) {
                    AdvancedSettingsPanel.this.initMiningAttributeInputs(modelType.getInputMiningData().getMiningAttributes(), modelType);
                    MetaDataHelper.addModel(AdvancedSettingsPanel.this.metadataCopy, modelType);
                    if (AdvancedSettingsPanel.this.dataUsagePanelRef != null) {
                        AdvancedSettingsPanel.this.dataUsagePanelRef.generateUIRulesMessages();
                    }
                    AdvancedSettingsPanel.this.addEditedModelRecord(modelType, 0);
                    int[] nArray = new int[]{AdvancedSettingsPanel.this.modelsTblModel.addModel(modelType)};
                    AdvancedSettingsPanel.this.jModelsTable.setSelectedRowsInModel(nArray);
                }
            }
        });
        controlBar.add((Component)this.addBtn);
        ListSelectionModel listSelectionModel = this.jModelsTable.getSelectionModel();
        this.removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._jModelsToolbar.setControlBar(controlBar);
    }

    protected List<ModelType> getSelectedModels() {
        ModelsTableModel modelsTableModel = this.getTableModel();
        List<ModelType> list = modelsTableModel.getDataList();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        ModelsTableModel modelsTableModel2 = this.getTableModel();
        if (!modelsTableModel2.getDataVector().isEmpty()) {
            int[] nArray;
            for (int n : nArray = this.jModelsTable.getSelectedRowsInModel()) {
                ModelType modelType = list.get(n);
                arrayList.add(modelType);
            }
        }
        return arrayList;
    }

    public boolean isMultpleSelection() {
        return this.jModelsTable.getSelectedRowCount() > 1;
    }

    public boolean doWork() {
        TableCellEditor tableCellEditor;
        if (this.jModelsTable.isEditing() && !(tableCellEditor = this.jModelsTable.getCellEditor()).stopCellEditing()) {
            return false;
        }
        boolean bl = this.canProceed();
        if (!bl) {
            return bl;
        }
        if (!this.isDirty()) {
            return true;
        }
        HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)this.workflowNode.getData());
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (ModelType modelType : list) {
            ModelType modelType2 = MetaDataHelper.findModelById(this.metadataCopy, modelType.getId());
            if (modelType2 == null || modelType2.getName().equals(modelType.getName())) continue;
            hashMap.put(modelType2.getName(), modelType);
            arrayList.add(modelType2);
        }
        if (bl && (this.modelEdits.size() != 0 || this.isTextDirty)) {
            Object object;
            Object object2;
            Iterator<Object> iterator = this.modelEdits.entrySet().iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator.hasNext()) {
                object2 = (Map.Entry)iterator.next();
                object = (ModelEditRecord)object2.getValue();
                if (((ModelEditRecord)object).isNew()) {
                    bl = MetaDataHelper.addModel(this.metadataCopy, ((ModelEditRecord)object).getModel());
                    bl3 = true;
                } else if (((ModelEditRecord)object).getEditType() == 1) {
                    bl = MetaDataHelper.replaceModel(this.metadataCopy, ((ModelEditRecord)object).getModel(), ((ModelEditRecord)object).getOrigName());
                    bl2 = true;
                } else if (((ModelEditRecord)object).getEditType() == 2) {
                    bl = MetaDataHelper.removeModel(this.metadataCopy, ((ModelEditRecord)object).getModel());
                }
                if (bl) continue;
                break;
            }
            if (bl && this.isStandalone) {
                try {
                    CommandProcessor.getInstance().beginTrans("Edit Data Usage");
                    object2 = (OdmrSDMUndoFilter)this.workflowNode.getUndoFilter();
                    ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this.workflowNode, this.context, "nodetype", this.metadataCopy);
                    if (hashMap.size() > 0) {
                        object = MetaDataHelper.getModelsCollection(this.metadataCopy, this.context);
                        HashMap<String, RefModelType> hashMap2 = new HashMap<String, RefModelType>();
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            RefModelType refModelType = (RefModelType)iterator2.next();
                            if (!hashMap.containsKey(refModelType.getName())) continue;
                            hashMap2.put(((ModelType)hashMap.get(refModelType.getName())).getName(), refModelType);
                        }
                        this.workflowNode.refactorChildModelReferences(hashMap2, false);
                    }
                    this.workflowNode.validateAfterEdit();
                    CommandProcessor.getInstance().endTrans();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                    bl = false;
                    CommandProcessor.getInstance().abortTrans();
                }
            }
        }
        return bl;
    }

    public ModelType findEditedModel(ModelType modelType) {
        ModelEditRecord modelEditRecord = this.modelEdits.get(modelType.getName());
        ModelType modelType2 = null;
        if (modelEditRecord != null) {
            modelType2 = modelEditRecord.getModel();
        }
        return modelType2;
    }

    public ModelEditRecord findEditedModelRecord(ModelType modelType) {
        ModelEditRecord modelEditRecord = this.modelEdits.get(modelType.getName());
        return modelEditRecord;
    }

    protected ModelEditRecord addEditedModelRecord(ModelType modelType, int n) {
        ModelEditRecord modelEditRecord = this.modelEdits.get(modelType.getName());
        if (modelEditRecord != null && modelEditRecord.isNew() && 2 == n) {
            return this.modelEdits.remove(modelType.getName());
        }
        if (modelEditRecord != null && modelEditRecord.getEditType() == 2) {
            return modelEditRecord;
        }
        if (modelEditRecord != null && modelEditRecord.getEditType() == 1 && 2 == n) {
            this.modelEdits.remove(modelType.getName());
        } else if (modelEditRecord != null) {
            throw new RuntimeException("Contract violation.  ModelEditRecord being added more than once.  Use findEditedModel()");
        }
        ModelEditRecord modelEditRecord2 = new ModelEditRecord(n, modelType);
        if (0 == n || modelEditRecord != null && modelEditRecord.isNew()) {
            modelEditRecord2.setIsNew();
        }
        this.modelEdits.put(modelType.getName(), modelEditRecord2);
        return modelEditRecord2;
    }

    private Collection<ModelEditRecord> getNewModelsRecords() {
        ArrayList<ModelEditRecord> arrayList = new ArrayList<ModelEditRecord>();
        for (Map.Entry<String, ModelEditRecord> entry : this.modelEdits.entrySet()) {
            ModelEditRecord modelEditRecord = entry.getValue();
            if (!modelEditRecord.isNew()) continue;
            arrayList.add(modelEditRecord);
        }
        return arrayList;
    }

    private Collection<String> getPendingNewModels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<ModelEditRecord> collection = this.getNewModelsRecords();
        for (ModelEditRecord modelEditRecord : collection) {
            arrayList.add(modelEditRecord.getModel().getName());
        }
        return arrayList;
    }

    private Collection<String> getPendingRenamedModels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, ModelEditRecord> entry : this.modelEdits.entrySet()) {
            ModelEditRecord modelEditRecord = entry.getValue();
            String string = modelEditRecord.getModel().getName();
            if (string.equals(modelEditRecord.getOrigName())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public boolean validateModelNameChange(String string, String string2) {
        boolean bl = true;
        Collection<String> collection = this.getPendingNewModels();
        Collection<String> collection2 = WorkflowUtils.getInMemoryModelNames(this.getWorkflowModel(), this.metadataCopy);
        collection2.addAll(collection);
        if (!NewModelPanel.validateName(string, this.context, this, collection2, string2)) {
            bl = false;
        }
        return bl;
    }

    protected boolean canHandleModelSelectionChange() {
        boolean bl;
        block1: {
            String string;
            bl = true;
            ListSelectionModel listSelectionModel = this.jModelsTable.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) break block1;
            Iterator<String> iterator = this.panels.keySet().iterator();
            while (iterator.hasNext() && (bl = this.panels.get(string = iterator.next()).canHandleModelSelectionChange(this.jModelsTable.getSelectionModel()))) {
            }
        }
        return bl;
    }

    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.getValueIsAdjusting()) {
            return false;
        }
        this.removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        if (listSelectionModel.isSelectionEmpty()) {
            for (String string : this.panels.keySet()) {
                this.panels.get(string).loadEmptySelectionUI();
            }
        } else {
            for (String string : this.panels.keySet()) {
                this.panels.get(string).handleModelSelectionChanged(this.jModelsTable.getSelectionModel());
            }
        }
        if (this.dataUsagePanelRef != null) {
            this.dataUsagePanelRef.resizeTable(this.getSize());
        }
        return true;
    }

    protected ModelsTableModel getTableModel() {
        return (ModelsTableModel)((Object)this.jModelsTable.getModel());
    }

    protected GenericTable getModelsTable() {
        return this.jModelsTable;
    }

    public AbstractBuildNode getWorkflowNode() {
        return this.workflowNode;
    }

    public Context getContext() {
        return this.context;
    }

    public BuildNodeType getMetadataCopy() {
        return this.metadataCopy;
    }

    public Object getAuxMetadata(String string) {
        return this.auxMetadata.get(string);
    }

    public void putAuxMetadata(String string, Object object) {
        this.auxMetadata.put(string, object);
    }

    class TableHeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;

        public TableHeaderRenderer(JTable jTable) {
            this.renderer = jTable.getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 3) {
                jLabel.setHorizontalAlignment(0);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
            return jLabel;
        }
    }

    class ModelsTableModel
    extends GenericBaseTableModel
    implements BuildNodeTableModel {
        private List<ModelType> data;
        public static final int NAME = 0;
        public static final int ALGORITHM = 1;
        public static final int MODEL_CREATED_ON = 2;
        public static final int USAGE = 3;
        public static final int COLUMNS_EXCLUDED = 4;

        public ModelsTableModel(List<ModelType> list, String[] stringArray) {
            this.data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.data.size());
        }

        public int[] getIndexesOf(List<String> list) {
            Vector<Integer> vector = new Vector<Integer>();
            for (String string : list) {
                for (int i = 0; i < this.data.size(); ++i) {
                    ModelType modelType = this.data.get(i);
                    if (!modelType.getName().equals(string)) continue;
                    vector.add(i);
                }
            }
            if (vector.size() == 0) {
                return new int[0];
            }
            Object object = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Integer)vector.get(i);
            }
            return object;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return String.class;
            }
            if (n == 2) {
                return XMLGregorianCalendar.class;
            }
            return String.class;
        }

        public void reload(List<ModelType> list) {
            this.data = list;
            this.setRowCount(this.data.size());
            this.fireTableDataChanged();
        }

        public int addModel(ModelType modelType) {
            this.data.add(modelType);
            int n = this.data.size() - 1;
            this.setRowCount(this.data.size());
            this.fireTableRowsInserted(n, n);
            return this.data.size() - 1;
        }

        public void removeRows(int[] nArray) {
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this.data.get(nArray[i]));
            }
            for (ModelType modelType : arrayList) {
                int n = this.data.indexOf(modelType);
                this.fireTableRowsDeleted(n, n);
                this.removeModel(n);
            }
        }

        public void removeModel(int n) {
            this.data.remove(n);
            this.setRowCount(this.data.size());
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this.data.get(n);
            Object object = null;
            ModelType modelType2 = AdvancedSettingsPanel.this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            switch (n2) {
                case 0: {
                    object = modelType2.getName();
                    break;
                }
                case 1: {
                    object = MetaDataHelper.getAlgorithmName(modelType2);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType2.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = null;
                    break;
                }
                case 3: {
                    object = modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.AUTO) ? "Auto" : "Custom";
                    break;
                }
                case 4: {
                    object = AdvancedSettingsPanel.this.dataUsagePanelRef.getModelRulesCount(modelType2);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelType modelType = this.data.get(n);
            ModelType modelType2 = null;
            ModelEditRecord modelEditRecord = AdvancedSettingsPanel.this.findEditedModelRecord(modelType);
            if (modelEditRecord == null) {
                modelEditRecord = AdvancedSettingsPanel.this.addEditedModelRecord(modelType, 1);
            }
            modelType2 = modelEditRecord.getModel();
            if (n2 == 0) {
                modelType2.setName((String)object);
                if (modelEditRecord.isNew()) {
                    ModelEditRecord modelEditRecord2 = (ModelEditRecord)AdvancedSettingsPanel.this.modelEdits.remove(modelType.getName());
                    AdvancedSettingsPanel.this.modelEdits.put((String)object, modelEditRecord2);
                    modelType.setName((String)object);
                }
            }
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = this.data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById((BuildNodeType)AdvancedSettingsPanel.this.workflowNode.getData(), modelType.getId());
            if (modelType2 != null) {
                string = modelType2.getName();
            }
            return string;
        }

        @Override
        public List<ModelType> getDataList() {
            return this.data;
        }
    }

    public class MenuAction
    extends AbstractAction {
        public MenuAction(String string, String string2) {
            super(string);
            this.putValue("ActionCommandKey", string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class CustomTab
    extends JTabbedPane2 {
        CustomTab() {
        }

        public void setSelectedIndex(int n) {
            if (AdvancedSettingsPanel.this.canHandleModelSelectionChange()) {
                super.setSelectedIndex(n);
                return;
            }
        }
    }

    class ControlledSelectionGenericTable
    extends ModelsTable {
        public ControlledSelectionGenericTable(BuildNodeType buildNodeType, int n) {
            super(buildNodeType, n);
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            if (AdvancedSettingsPanel.this.canHandleModelSelectionChange()) {
                super.changeSelection(n, n2, bl, bl2);
            }
        }
    }
}

