/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractEditPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.EditChangeListener;
import oracle.dmt.dataminer.workflow.dialog.build.ModelDataUsageCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.ModelsTable;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelDialog;
import oracle.dmt.dataminer.workflow.inspect.EditCaseAttributesDialog;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class BuildEditModelsPanel
extends AbstractEditPanel {
    private static final Logger LOGGER = Logger.getLogger(BuildEditModelsPanel.class.getName());
    private static final String[] COLUMNS = new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT"), BuildEditorLrb.get("BUILD_MODEL_USAGE")};
    private BuildNodeType nodeData;
    private BuildNodeType nodeDataCopy;
    private boolean dirty = false;
    private List<String> selectedModels;
    private JButton jBtnCaseIds;
    private JComboBox jCaseCombo;
    private JLabel jCaseLabel;
    private JComboBox jItemIDCombo;
    private JComboBox jItemValueCombo;
    private JLabel jLblCaseIds;
    private JLabel jLblItemID;
    private JLabel jLblItemValue;
    private TransparentPanel jModelsTablePanel;
    private ComponentWithTitlebar<JComponent> jModelsToolbar;
    private JComboBox jTargetChoice;
    private JLabel jTargetLabel;
    private JTextField jTextCaseIds;
    private JLabel statusIconCase;
    private JLabel statusIconCaseIDs;
    private JLabel statusIconTarget;
    private JLabel statusItemId;
    private JLabel statusItemValue;
    private ModelsTable jModelsTable = new ModelsTable(this.nodeDataCopy, 3);
    private ModelsTableModel modelsTblModel;
    private JButton editBtn;
    private JButton removeBtn;
    private JButton addBtn;
    private JButton duplicateBtn;

    public BuildEditModelsPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, List<String> list) {
        super(context, abstractBuildNode);
        this.selectedModels = list;
        this.nodeData = (BuildNodeType)abstractBuildNode.getData();
        this.nodeDataCopy = buildNodeType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jModelsTablePanel = new TransparentPanel();
        this.jModelsToolbar = new ComponentWithTitlebar();
        this.jTargetLabel = new JLabel();
        this.jTargetChoice = new JComboBox();
        this.jCaseLabel = new JLabel();
        this.jCaseCombo = new JComboBox();
        this.jLblCaseIds = new JLabel();
        this.jTextCaseIds = new JTextField();
        this.jBtnCaseIds = new JButton();
        this.jItemIDCombo = new JComboBox();
        this.jLblItemID = new JLabel();
        this.jLblItemValue = new JLabel();
        this.jItemValueCombo = new JComboBox();
        this.statusIconTarget = new JLabel();
        this.statusIconCase = new JLabel();
        this.statusItemId = new JLabel();
        this.statusItemValue = new JLabel();
        this.statusIconCaseIDs = new JLabel();
        this.jModelsToolbar.setPreferredSize(new Dimension(0, 0));
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setHorizontalTextPosition(2);
        this.jTargetChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCaseLabel.setText("Case ID:");
        this.jCaseLabel.setHorizontalTextPosition(2);
        this.jCaseCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLblCaseIds.setText("Case IDs:");
        this.jTextCaseIds.setEditable(false);
        this.jTextCaseIds.setMargin(new Insets(2, 2, 2, 0));
        this.jBtnCaseIds.setAlignmentY(0.0f);
        this.jBtnCaseIds.setMaximumSize(new Dimension(0, 0));
        this.jBtnCaseIds.setMinimumSize(new Dimension(0, 0));
        this.jBtnCaseIds.setPreferredSize(new Dimension(5, 5));
        this.jItemIDCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLblItemID.setText("Item ID:");
        this.jLblItemValue.setText("Item Value:");
        this.jItemValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.statusIconTarget.setText("warnIcon");
        this.statusIconTarget.setHorizontalTextPosition(4);
        this.statusIconCase.setText("warnIcon");
        this.statusIconCase.setHorizontalTextPosition(4);
        this.statusItemId.setText("warnIcon");
        this.statusItemValue.setText("warnIcon");
        this.statusIconCaseIDs.setText("warnIcon");
        GroupLayout groupLayout = new GroupLayout((Container)this.jModelsTablePanel);
        this.jModelsTablePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCaseLabel).addComponent(this.jLblItemValue, -2, 55, -2).addComponent(this.jLblCaseIds, -1, 72, Short.MAX_VALUE).addComponent(this.jTargetLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLblItemID, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextCaseIds, -2, 215, -2).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.jTargetChoice, -2, 212, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusIconTarget).addComponent(this.statusIconCase).addGroup(groupLayout.createSequentialGroup().addComponent(this.statusIconCaseIDs).addGap(2, 2, 2).addComponent(this.jBtnCaseIds, -2, 23, -2)))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jItemValueCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusItemValue)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jItemIDCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusItemId))).addContainerGap(455, Short.MAX_VALUE)).addComponent((Component)this.jModelsToolbar, -1, -1, Short.MAX_VALUE));
        groupLayout.linkSize(0, this.jCaseCombo, this.jItemIDCombo, this.jItemValueCombo, this.jTargetChoice, this.jTextCaseIds);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetChoice, -2, -1, -2).addComponent(this.statusIconTarget)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseLabel).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.statusIconCase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblCaseIds).addComponent(this.jTextCaseIds, -2, -1, -2).addComponent(this.statusIconCaseIDs)).addComponent(this.jBtnCaseIds, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblItemID, -2, 14, -2).addComponent(this.jItemIDCombo, -2, -1, -2).addComponent(this.statusItemId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblItemValue, -2, 14, -2).addComponent(this.jItemValueCombo, -2, -1, -2).addComponent(this.statusItemValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jModelsToolbar, -1, 253, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLblCaseIds, this.jTextCaseIds);
        groupLayout.linkSize(1, this.jTargetChoice, this.jTargetLabel);
        groupLayout.linkSize(1, this.jItemIDCombo, this.jLblItemID);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.jModelsTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.jModelsTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, (Component)this.jTargetChoice, (String)BuildEditorLrb.get("BUILD_NODE_TARGET"));
        ResourceUtils.resLabel((JLabel)this.jCaseLabel, (Component)this.jCaseCombo, (String)BuildEditorLrb.get("BUILD_NODE_CASEID"));
        ResourceUtils.resLabel((JLabel)this.jLblCaseIds, (Component)this.jTextCaseIds, (String)BuildEditorLrb.get("BUILD_NODE_TXN_ID"));
        ResourceUtils.resLabel((JLabel)this.jLblItemID, (Component)this.jItemIDCombo, (String)BuildEditorLrb.get("BUILD_NODE_ITEM_ID"));
        ResourceUtils.resLabel((JLabel)this.jLblItemValue, (Component)this.jItemValueCombo, (String)BuildEditorLrb.get("BUILD_NODE_ITEM_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jBtnCaseIds, (String)"");
        this.jBtnCaseIds.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this.jBtnCaseIds.setBorder(null);
        this.jBtnCaseIds.setRolloverEnabled(true);
        this.jBtnCaseIds.setToolTipText(BuildEditorLrb.get("BUILD_NODE_CASEIDS_SELECT"));
        this.statusIconTarget.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconTarget.setToolTipText(BuildEditorLrb.get("BUILD_NODE_TARGET_INVALID_TIP"));
        this.statusIconTarget.setText("");
        this.statusIconCase.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconCase.setToolTipText(BuildEditorLrb.get("BUILD_NODE_CASEID_INVALID_TIP"));
        this.statusIconCase.setText("");
        this.statusIconCaseIDs.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconCaseIDs.setToolTipText(BuildEditorLrb.get("BUILD_NODE_CASEIDS_INVALID_TIP"));
        this.statusIconCaseIDs.setText("");
        this.statusItemId.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemId.setText("");
        this.statusItemValue.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemValue.setText("");
        this.initHelp();
    }

    private void initHelp() {
        if (this.getData() instanceof AssociationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"association_node_edit");
        } else if (this.getData() instanceof ClassificationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"classification_node_edit");
        } else if (this.getData() instanceof ClusteringBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"clustering_node_edit");
        } else if (this.getData() instanceof RegressionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"regression_node_edit");
        } else if (this.getData() instanceof AnomalyDetectionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"anomaly_node_edit");
        } else if (this.getData() instanceof FeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"feature_node_edit");
        }
    }

    @Override
    public void initUI() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List list = this.nodeData.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        if (this.nodeData instanceof AssociationBuildNodeType) {
            this.jTargetLabel.setVisible(false);
            this.remove(this.jTargetLabel);
            this.jTargetChoice.setVisible(false);
            this.remove(this.jTargetChoice);
            this.statusIconTarget.setVisible(false);
            this.remove(this.statusIconTarget);
            this.jCaseLabel.setVisible(false);
            this.remove(this.jCaseLabel);
            this.jCaseCombo.setVisible(false);
            this.remove(this.jCaseCombo);
            this.statusIconCase.setVisible(false);
            this.remove(this.statusIconCase);
            this.initMultiCaseIdUI();
            object4 = null;
            try {
                object4 = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
            object3 = ((AbstractBuildNode)this.getData()).findBuildDataNode((WorkflowModel)((Object)object4));
            object2 = object3;
            object = new ArrayList();
            if (object2 != null) {
                object = object2.getAttributes().getAttribute();
            }
            this.initItemIDUI((AssociationBuildNodeType)this.nodeData, (List<AttributeType>)object);
            this.initItemValueUI((AssociationBuildNodeType)this.nodeData, (List<AttributeType>)object);
        } else {
            this.jLblCaseIds.setVisible(false);
            this.remove(this.jLblCaseIds);
            this.jTextCaseIds.setVisible(false);
            this.remove(this.jTextCaseIds);
            this.jBtnCaseIds.setVisible(false);
            this.remove(this.jBtnCaseIds);
            this.jLblItemID.setVisible(false);
            this.remove(this.jLblItemID);
            this.statusItemId.setVisible(false);
            this.remove(this.statusItemId);
            this.statusIconCaseIDs.setVisible(false);
            this.remove(this.statusIconCaseIDs);
            this.jItemIDCombo.setVisible(false);
            this.remove(this.jItemIDCombo);
            this.jLblItemValue.setVisible(false);
            this.remove(this.jLblItemValue);
            this.statusItemValue.setVisible(false);
            this.remove(this.statusItemValue);
            this.jItemValueCombo.setVisible(false);
            this.remove(this.jItemValueCombo);
            if (this.nodeData instanceof SuperviseBuildNodeType) {
                this.initTargetAttrUI((SuperviseBuildNodeType)this.nodeData, list);
            } else {
                this.jTargetLabel.setVisible(false);
                this.jTargetChoice.setVisible(false);
                this.remove(this.jTargetChoice);
                this.remove(this.jTargetLabel);
                this.statusIconTarget.setVisible(false);
                this.remove(this.statusIconTarget);
            }
            this.initCaseIdUI(list);
        }
        object4 = new JScrollPane((Component)((Object)this.jModelsTable));
        this.jModelsToolbar.setComponent((JComponent)object4);
        this.jModelsToolbar.setLabel(new JLabel(BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL")));
        this.installModelActions();
        object3 = MetaDataHelper.getModelsCollection((BuildNodeType)this.getData().getData());
        this.modelsTblModel = new ModelsTableModel((List<ModelType>)object3, COLUMNS);
        this.jModelsTable.setModel((TableModel)((Object)this.modelsTblModel));
        this.jModelsTable.setSorted(true);
        this.jModelsTable.setUpdateSelectionOnSort(true);
        this.jModelsTable.getTableHeader().setReorderingAllowed(false);
        object2 = null;
        try {
            object2 = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.jModelsTable.getColumnModel().getColumn(0).setCellEditor(new ModelNameCellEditor(this._context, (WorkflowModel)((Object)object2), this.nodeDataCopy));
        this.jModelsTable.getColumnModel().getColumn(3).setCellRenderer(new ModelDataUsageCellRenderer(false, true, true));
        if (this.nodeData instanceof AssociationBuildNodeType) {
            this.jModelsTable.removeColumn(this.jModelsTable.getColumnModel().getColumn(3));
        }
        this.jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                BuildEditModelsPanel.this.handleModelSelectionChanged(listSelectionModel);
            }
        });
        this.jModelsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BuildEditModelsPanel.this.launchAdvancedDialog();
                }
            }
        });
        if (object3.size() > 0 && this.selectedModels != null && ((Object)(object = (Object)this.modelsTblModel.getIndexesOf(this.selectedModels))).length != 0) {
            this.jModelsTable.setSelectedRowsInModel((int[])object);
        }
        this.jCaseCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                Object object3;
                JComboBox jComboBox;
                Object object4;
                AttributeType attributeType = MetaDataHelper.getCaseId(BuildEditModelsPanel.this.nodeDataCopy);
                if (attributeType != null) {
                    MetaDataHelper.setModelsAttributeProperties(BuildEditModelsPanel.this.nodeDataCopy, attributeType, true, true);
                }
                if ((object4 = (jComboBox = (JComboBox)actionEvent.getSource()).getSelectedItem()) instanceof CaseIdItem) {
                    object3 = (CaseIdItem)object4;
                    object2 = ((CaseIdItem)object3).item;
                    if (object2.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditModelsPanel.this.statusIconCase.setVisible(true);
                    } else {
                        BuildEditModelsPanel.this.statusIconCase.setVisible(false);
                    }
                    object = new CaseAttributes();
                    object.getAttribute().add(object2);
                    BuildEditModelsPanel.this.nodeDataCopy.setCaseAttributes((CaseAttributes)object);
                    BuildEditModelsPanel.this.setIsDirty(true);
                    MetaDataHelper.setModelsAttributeProperties(BuildEditModelsPanel.this.nodeDataCopy, (AttributeType)object2, false, true);
                } else {
                    object3 = new CaseAttributes();
                    object3.getAttribute().clear();
                    BuildEditModelsPanel.this.nodeDataCopy.setCaseAttributes((CaseAttributes)object3);
                    BuildEditModelsPanel.this.checkEmptyCaseID();
                    BuildEditModelsPanel.this.setIsDirty(true);
                }
                object3 = BuildEditModelsPanel.this.nodeDataCopy.getCaseAttributes().getAttribute();
                object2 = new HashMap();
                object = object3.iterator();
                while (object.hasNext()) {
                    AttributeType object5 = (AttributeType)object.next();
                    object2.put(object5.getName(), object5);
                }
                for (EditChangeListener editChangeListener : BuildEditModelsPanel.this.getChangeListeners()) {
                    editChangeListener.caseIdsChanged((Map<String, AttributeType>)object2);
                }
            }
        });
        this.jTargetChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
                AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof TargetItem) {
                    TargetItem targetItem = (TargetItem)object;
                    AttributeType attributeType2 = targetItem.item;
                    AttributeType attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType2);
                    if (attributeType != null) {
                        MetaDataHelper.setModelsAttributeProperties((BuildNodeType)superviseBuildNodeType, attributeType, true, true);
                    }
                    MetaDataHelper.setModelsTargetPropertiesWithDefaults((BuildNodeType)superviseBuildNodeType, attributeType3);
                    superviseBuildNodeType.setTargetAttribute(attributeType3);
                    BuildEditModelsPanel.this.setIsDirty(true);
                    if (attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditModelsPanel.this.statusIconTarget.setVisible(true);
                    } else {
                        BuildEditModelsPanel.this.statusIconTarget.setVisible(false);
                    }
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                    HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
                    hashMap.put(attributeType2.getName(), attributeType2);
                    for (EditChangeListener editChangeListener : BuildEditModelsPanel.this.getChangeListeners()) {
                        editChangeListener.targetsChanged(hashMap);
                    }
                }
            }
        });
        this.jItemIDCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemID((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    BuildEditModelsPanel.this.setIsDirty(true);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditModelsPanel.this.statusItemId.setVisible(true);
                    } else {
                        BuildEditModelsPanel.this.statusItemId.setVisible(false);
                    }
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        this.jItemValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemValue((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    BuildEditModelsPanel.this.setIsDirty(true);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditModelsPanel.this.statusItemValue.setVisible(true);
                    } else {
                        BuildEditModelsPanel.this.statusItemValue.setVisible(false);
                    }
                } else {
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemValue(null);
                    BuildEditModelsPanel.this.setIsDirty(true);
                    BuildEditModelsPanel.this.statusItemValue.setVisible(false);
                }
            }
        });
        this.jBtnCaseIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                CaseEditRecord caseEditRecord = new CaseEditRecord(new CaseAttributes());
                List list = BuildEditModelsPanel.this.nodeDataCopy.getCaseAttributes().getAttribute();
                for (Object object2 : list) {
                    object = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
                    caseEditRecord.getCaseAttributes().getAttribute().add(object);
                }
                WorkflowNode workflowNode = (WorkflowNode)BuildEditModelsPanel.this.getContext().getNode();
                try {
                    Object object2;
                    object2 = WorkflowUtils.getWorkflowModel(workflowNode);
                    object = new EditCaseAttributesDialog(caseEditRecord);
                    AbstractBuildNode abstractBuildNode = (AbstractBuildNode)BuildEditModelsPanel.this.getData();
                    boolean bl = ((EditCaseAttributesDialog)object).invoke(BuildEditModelsPanel.this.getContext(), abstractBuildNode.findBuildDataNode((WorkflowModel)((Object)object2)));
                    if (bl) {
                        CaseAttributes caseAttributes = caseEditRecord.getCaseAttributes();
                        BuildEditModelsPanel.this.nodeDataCopy.setCaseAttributes(caseAttributes);
                        BuildEditModelsPanel.this.initMultiCaseIdUI();
                        BuildEditModelsPanel.this.setIsDirty(true);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
    }

    private void launchAdvancedDialog() {
        Object object;
        int[] nArray = this.jModelsTable.getSelectedRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.jModelsTable.convertRowIndexToModel(nArray[i]);
            object = this.modelsTblModel.getDataList().get(n);
            arrayList.add(object.getId());
        }
        AdvancedSettingsDialog advancedSettingsDialog = new AdvancedSettingsDialog();
        if (advancedSettingsDialog.invoke(this.getContext(), (AbstractBuildNode)this.getData(), this.nodeDataCopy, arrayList)) {
            boolean bl;
            if (!advancedSettingsDialog.isDirty()) {
                return;
            }
            this.setIsDirty(true);
            List<ModelType> list = MetaDataHelper.getModelsCollection(this.nodeDataCopy);
            object = this.modelsTblModel.getDataList();
            boolean bl2 = bl = list.size() != object.size();
            if (!bl) {
                for (int i = 0; i < list.size(); ++i) {
                    ModelType object22 = list.get(i);
                    ModelType modelType = (ModelType)object.get(i);
                    if (object22.getId().equals(modelType.getId())) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                ModelType modelType;
                int n;
                int[] nArray2 = this.jModelsTable.getSelectedRows();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < nArray2.length; ++i) {
                    n = this.jModelsTable.convertRowIndexToModel(nArray2[i]);
                    modelType = this.modelsTblModel.getDataList().get(n);
                    arrayList2.add(modelType.getId());
                }
                this.modelsTblModel = new ModelsTableModel(list, COLUMNS);
                this.jModelsTable.setModel((TableModel)((Object)this.modelsTblModel));
                this.jModelsTable.setSorted(true);
                this.jModelsTable.setUpdateSelectionOnSort(true);
                if (this.nodeData instanceof AssociationBuildNodeType) {
                    this.jModelsTable.removeColumn(this.jModelsTable.getColumnModel().getColumn(3));
                }
                if (arrayList2.size() > 0) {
                    Vector<Integer> vector = new Vector<Integer>();
                    for (n = 0; n < this.modelsTblModel.getDataList().size(); ++n) {
                        modelType = this.modelsTblModel.getDataList().get(n);
                        if (!arrayList2.contains(modelType.getId())) continue;
                        vector.add(n);
                    }
                    if (vector.size() > 0) {
                        int[] nArray3 = new int[vector.size()];
                        for (int i = 0; i < vector.size(); ++i) {
                            nArray3[i] = (Integer)vector.get(i);
                        }
                        this.jModelsTable.setSelectedRowsInModel(nArray3);
                    }
                }
            } else {
                this.jModelsTable.repaint();
            }
            if (this.isDirty()) {
                for (EditChangeListener editChangeListener : this.getChangeListeners()) {
                    editChangeListener.modelsDataUsageChanged();
                }
            }
        }
    }

    private void installModelActions() {
        ControlBar controlBar = new ControlBar();
        this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(BuildEditorLrb.get("MODELS_ADD_TOOLTIP"));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractBuildNode abstractBuildNode = (AbstractBuildNode)BuildEditModelsPanel.this.getData();
                ModelType modelType = NewModelDialog.addNewModel(BuildEditModelsPanel.this.nodeDataCopy, BuildEditModelsPanel.this.getContext(), abstractBuildNode);
                if (modelType != null) {
                    MetaDataHelper.addModel(BuildEditModelsPanel.this.nodeDataCopy, modelType);
                    int[] nArray = new int[]{BuildEditModelsPanel.this.modelsTblModel.addModel(modelType)};
                    BuildEditModelsPanel.this.jModelsTable.setSelectedRowsInModel(nArray);
                    BuildEditModelsPanel.this.setIsDirty(true);
                }
            }
        });
        controlBar.add((Component)this.addBtn);
        this.editBtn = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.editBtn.setToolTipText(BuildEditorLrb.get("MODELS_EDIT_TOOLTIP"));
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildEditModelsPanel.this.launchAdvancedDialog();
            }
        });
        controlBar.add((Component)this.editBtn);
        this.removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(BuildEditorLrb.get("MODELS_DELETE_TOOLTIP"));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n;
                String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)BuildEditModelsPanel.this.jModelsTable));
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = BuildEditModelsPanel.this.jModelsTable.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                List<ModelType> list = BuildEditModelsPanel.this.modelsTblModel.getDataList();
                for (n = 0; n < nArray.length; ++n) {
                    nArray2[n] = BuildEditModelsPanel.this.jModelsTable.convertRowIndexToModel(nArray[n]);
                    object = list.get(nArray2[n]);
                    MetaDataHelper.removeModel(BuildEditModelsPanel.this.nodeDataCopy, object);
                }
                BuildEditModelsPanel.this.modelsTblModel.removeRows(nArray2);
                if (BuildEditModelsPanel.this.modelsTblModel.getDataList().size() != 0) {
                    n = nArray[0] - 1 < 0 ? 0 : nArray[0] - 1;
                    n = BuildEditModelsPanel.this.jModelsTable.convertRowIndexToModel(n);
                    object = new int[]{n};
                    BuildEditModelsPanel.this.jModelsTable.setSelectedRowsInModel((int[])object);
                }
                BuildEditModelsPanel.this.setIsDirty(true);
            }
        });
        controlBar.add((Component)this.removeBtn);
        this.duplicateBtn = new JButton(OracleIcons.getIcon((String)"duplicate.png"));
        this.duplicateBtn.setToolTipText(BuildEditorLrb.get("MODELS_DUPLICATE_TOOLTIP"));
        this.duplicateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)BuildEditModelsPanel.this._context.getNode());
                    int[] nArray = BuildEditModelsPanel.this.jModelsTable.getSelectedRows();
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        object3 = BuildEditModelsPanel.this.modelsTblModel.getDataList().get(BuildEditModelsPanel.this.jModelsTable.convertRowIndexToModel(nArray[i]));
                        object2 = MetaDataHelper.findModelById(BuildEditModelsPanel.this.nodeDataCopy, object3.getId());
                        object = (ModelType)MetaDataHelper.copyMetadataObject(object2);
                        object.setUseForOutput(true);
                        arrayList.add((ModelType)object);
                    }
                    List<RefModelType> list = MetaDataHelper.getModelsCollection(BuildEditModelsPanel.this.nodeDataCopy, arrayList, BuildEditModelsPanel.this._context);
                    object3 = MetaDataHelper.getModelsCollection(BuildEditModelsPanel.this.nodeDataCopy);
                    object2 = WorkflowUtils.refactorModels(BuildEditModelsPanel.this._context, list, (List<ModelType>)object3, workflowModel, false);
                    AbstractBuildNode.applyRefactoredModels((Map<String, RefModelType>)object2, arrayList);
                    for (ModelType modelType : arrayList) {
                        MetaDataHelper.addModel(BuildEditModelsPanel.this.nodeDataCopy, modelType);
                    }
                    object = new int[arrayList.size()];
                    int n = 0;
                    for (ModelType modelType : arrayList) {
                        object[n++] = (ModelType)BuildEditModelsPanel.this.modelsTblModel.addModel(modelType);
                    }
                    BuildEditModelsPanel.this.jModelsTable.setSelectedRowsInModel((int[])object);
                    BuildEditModelsPanel.this.setIsDirty(true);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        controlBar.add((Component)this.duplicateBtn);
        ListSelectionModel listSelectionModel = this.jModelsTable.getSelectionModel();
        this.editBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.duplicateBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.jModelsToolbar.setControlBar(controlBar);
    }

    private void initCaseIdUI(List<MiningAttributeType> list) {
        List list2 = this.nodeDataCopy.getCaseAttributes().getAttribute();
        AttributeType attributeType = null;
        if (list2.size() != 0) {
            attributeType = (AttributeType)list2.get(0);
        }
        boolean bl = false;
        this.jCaseCombo.removeAllItems();
        this.jCaseCombo.addItem(BuildEditorLrb.get("BUILD_NODE_CASEID_HINT"));
        for (Object object : list) {
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(this.getContext(), object.getDataType())) continue;
            this.jCaseCombo.addItem(new CaseIdItem((AttributeType)object));
            if (attributeType == null || !object.getName().equals(attributeType.getName()) || !object.getDataType().equals(attributeType.getDataType())) continue;
            bl = true;
        }
        if (attributeType != null && !bl) {
            this.jCaseCombo.setEditable(true);
            this.jCaseCombo.setSelectedItem(new CaseIdItem(attributeType));
            this.jCaseCombo.setEditable(false);
        }
        if (list2.size() == 0) {
            this.jCaseCombo.setSelectedIndex(0);
        }
        if (attributeType != null && bl) {
            for (int i = 0; i < this.jCaseCombo.getItemCount(); ++i) {
                Object object;
                if (!(this.jCaseCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                object = (CaseIdItem)this.jCaseCombo.getItemAt(i);
                if (!attributeType.getName().equals(object.item.getName()) || !attributeType.getDataType().equals(object.item.getDataType())) continue;
                this.jCaseCombo.setSelectedIndex(i);
            }
        }
        if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            this.statusIconCase.setVisible(false);
        } else if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.statusIconCase.setText("");
            this.statusIconCase.setVisible(true);
        } else if (attributeType == null) {
            this.checkEmptyCaseID();
        }
    }

    public void checkEmptyCaseID() {
        if (this.nodeData instanceof RegressionBuildNodeType || this.nodeData instanceof ClassificationBuildNodeType) {
            this.statusIconCase.setVisible(true);
            this.statusIconCase.setText(BuildEditorLrb.get("BUILD_NODE_CASE_ID_WARN"));
        } else {
            this.statusIconCase.setVisible(false);
        }
    }

    private void initMultiCaseIdUI() {
        List list = null;
        boolean bl = false;
        list = this.nodeDataCopy.getCaseAttributes().getAttribute();
        if (list.size() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (AttributeType attributeType : list) {
                stringBuilder.append(attributeType.getName());
                stringBuilder.append(", ");
                if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                bl = true;
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            this.jTextCaseIds.setText(stringBuilder.toString());
        } else {
            this.jTextCaseIds.setText(BuildEditorLrb.get("BUILD_NODE_MULTICASEID_HINT"));
            bl = true;
        }
        this.statusIconCaseIDs.setVisible(bl);
    }

    private void initTargetAttrUI(SuperviseBuildNodeType superviseBuildNodeType, List<MiningAttributeType> list) {
        this.jTargetChoice.removeAllItems();
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.getData();
        for (MiningAttributeType miningAttributeType : list) {
            try {
                if (abstractBuildNode instanceof ClassificationBuildNode && DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, miningAttributeType.getDataType())) {
                    this.jTargetChoice.addItem(new TargetItem(miningAttributeType));
                    continue;
                }
                if (!(abstractBuildNode instanceof RegressionBuildNode) || !DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, miningAttributeType.getDataType())) continue;
                this.jTargetChoice.addItem(new TargetItem(miningAttributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
        if (attributeType == null) {
            this.jTargetChoice.insertItemAt(BuildEditorLrb.get("BUILD_NODE_TARGET_HINT"), 0);
            this.jTargetChoice.setSelectedIndex(0);
        }
        if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            boolean bl = false;
            for (int i = 0; i < this.jTargetChoice.getItemCount(); ++i) {
                if (!(this.jTargetChoice.getItemAt(i) instanceof TargetItem)) continue;
                TargetItem targetItem = (TargetItem)this.jTargetChoice.getItemAt(i);
                if (!attributeType.getName().equals(targetItem.item.getName()) || !attributeType.getDataType().equals(targetItem.item.getDataType())) continue;
                this.jTargetChoice.setSelectedIndex(i);
                bl = true;
            }
            if (!bl) {
                LOGGER.log(Level.SEVERE, "Could not find the target value even though it is valid");
            } else {
                this.statusIconTarget.setVisible(false);
            }
        } else if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            MiningAttributeType miningAttributeType;
            miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
            TargetItem targetItem = new TargetItem(miningAttributeType);
            this.jTargetChoice.setEditable(true);
            this.jTargetChoice.setSelectedItem(targetItem);
            this.jTargetChoice.setEditable(false);
            this.statusIconTarget.setVisible(true);
        } else if (attributeType == null) {
            this.statusIconTarget.setVisible(true);
        }
    }

    private void initItemIDUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        AttributeType attributeType = associationBuildNodeType.getItemID();
        this.jItemIDCombo.removeAllItems();
        this.jItemIDCombo.addItem(BuildEditorLrb.get("BUILD_NODE_ITEMID_HINT"));
        try {
            for (AttributeType attributeType2 : list) {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, attributeType2.getDataType())) continue;
                this.jItemIDCombo.addItem(new CaseIdItem(attributeType2));
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (attributeType == null) {
            this.jItemIDCombo.setSelectedIndex(0);
            this.statusItemId.setVisible(true);
        } else {
            CaseIdItem caseIdItem;
            boolean bl = false;
            for (int i = 0; i < this.jItemIDCombo.getItemCount(); ++i) {
                if (!(this.jItemIDCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                caseIdItem = (CaseIdItem)this.jItemIDCombo.getItemAt(i);
                if (!attributeType.getName().equals(caseIdItem.item.getName()) || !attributeType.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jItemIDCombo.setSelectedIndex(i);
                bl = true;
            }
            if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                if (!bl) {
                    LOGGER.log(Level.SEVERE, "Could not find the item id even though it is valid");
                } else {
                    this.statusItemId.setVisible(false);
                }
            } else {
                this.statusItemId.setVisible(true);
                if (!bl) {
                    MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
                    caseIdItem = new CaseIdItem((AttributeType)miningAttributeType);
                    this.jItemIDCombo.setEditable(true);
                    this.jItemIDCombo.setSelectedItem(caseIdItem);
                    this.jItemIDCombo.setEditable(false);
                }
            }
        }
    }

    private void initItemValueUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        AttributeType attributeType = associationBuildNodeType.getItemValue();
        this.jItemValueCombo.removeAllItems();
        this.jItemValueCombo.addItem(BuildEditorLrb.get("BUILD_NODE_ITEMVALUE_EXISTENCE"));
        for (AttributeType attributeType2 : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, attributeType2.getDataType())) continue;
                this.jItemValueCombo.addItem(new CaseIdItem(attributeType2));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        if (attributeType == null) {
            this.jItemValueCombo.setSelectedIndex(0);
            this.statusItemValue.setVisible(false);
        } else {
            CaseIdItem caseIdItem;
            boolean bl = false;
            for (int i = 0; i < this.jItemValueCombo.getItemCount(); ++i) {
                if (!(this.jItemValueCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                caseIdItem = (CaseIdItem)this.jItemValueCombo.getItemAt(i);
                if (!attributeType.getName().equals(caseIdItem.item.getName()) || !attributeType.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jItemValueCombo.setSelectedIndex(i);
                bl = true;
            }
            if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                if (!bl) {
                    LOGGER.log(Level.SEVERE, "Could not find the item value even though it is valid");
                } else {
                    this.statusItemValue.setVisible(false);
                }
            } else {
                this.statusItemValue.setVisible(true);
                if (!bl) {
                    MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
                    caseIdItem = new CaseIdItem((AttributeType)miningAttributeType);
                    this.jItemValueCombo.setEditable(true);
                    this.jItemValueCombo.setSelectedItem(caseIdItem);
                    this.jItemValueCombo.setEditable(false);
                }
            }
        }
    }

    public boolean doWork() {
        TableCellEditor tableCellEditor;
        return !this.jModelsTable.isEditing() || (tableCellEditor = this.jModelsTable.getCellEditor()).stopCellEditing();
    }

    private void handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        this.editBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.duplicateBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
    }

    public void setIsDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private static class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(AttributeType attributeType) {
            this.item.setAlias(attributeType.getAlias());
            this.item.setDataType(attributeType.getDataType());
            this.item.setName(attributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)attributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }

    private static class TargetItem {
        AttributeType item = new AttributeType();

        TargetItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }

    class ModelsTableModel
    extends GenericBaseTableModel
    implements BuildNodeTableModel {
        private List<ModelType> data;
        public static final int NAME = 0;
        public static final int ALGORITHM = 1;
        public static final int MODEL_CREATED_ON = 2;
        public static final int AUTO = 3;

        public ModelsTableModel(List<ModelType> list, String[] stringArray) {
            this.data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.data.size());
        }

        public int[] getIndexesOf(List<String> list) {
            Vector<Integer> vector = new Vector<Integer>();
            for (String string : list) {
                for (int i = 0; i < this.data.size(); ++i) {
                    ModelType modelType = this.data.get(i);
                    if (!modelType.getName().equals(string)) continue;
                    vector.add(i);
                }
            }
            if (vector.size() == 0) {
                return new int[0];
            }
            Object object = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Integer)vector.get(i);
            }
            return object;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return String.class;
            }
            if (n == 2) {
                return XMLGregorianCalendar.class;
            }
            return String.class;
        }

        public void reload(List<ModelType> list) {
            this.data = list;
            this.setRowCount(this.data.size());
            this.fireTableDataChanged();
        }

        public int addModel(ModelType modelType) {
            this.data.add(modelType);
            int n = this.data.size() - 1;
            this.setRowCount(this.data.size());
            this.fireTableRowsInserted(n, n);
            return this.data.size() - 1;
        }

        public void removeRows(int[] nArray) {
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this.data.get(nArray[i]));
            }
            for (ModelType modelType : arrayList) {
                int n = this.data.indexOf(modelType);
                this.fireTableRowsDeleted(n, n);
                this.removeModel(n);
            }
        }

        public void removeModel(int n) {
            this.data.remove(n);
            this.setRowCount(this.data.size());
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = this.data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditModelsPanel.this.nodeData, modelType.getId());
            if (modelType2 != null) {
                string = modelType2.getName();
            }
            return string;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this.data.get(n);
            String string = null;
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditModelsPanel.this.nodeDataCopy, modelType.getId());
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            switch (n2) {
                case 0: {
                    string = modelType2.getName();
                    break;
                }
                case 1: {
                    string = MetaDataHelper.getAlgorithmName(modelType2);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType2.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        string = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    string = null;
                    break;
                }
                case 3: {
                    string = modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.AUTO) ? "Auto" : "Custom";
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelType modelType = this.data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditModelsPanel.this.nodeDataCopy, modelType.getId());
            if (modelType2 == null) {
                throw new RuntimeException("Model not found in edit cache");
            }
            if (n2 == 3) {
                InputMiningData inputMiningData = modelType2.getInputMiningData();
                Boolean bl = (Boolean)object;
                if (bl.equals(Boolean.TRUE)) {
                    inputMiningData.setDataUsage(InputMiningDataType.AUTO);
                    inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
                } else {
                    inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
                    inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
                }
            } else if (n2 == 0) {
                modelType2.setName((String)object);
            }
            BuildEditModelsPanel.this.setIsDirty(true);
        }

        @Override
        public List<ModelType> getDataList() {
            return this.data;
        }
    }
}

