/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class NewModelDialog {
    private static final Logger theLogger = Logger.getLogger(NewModelDialog.class.getName());
    protected JEWTDialog _dlg;
    protected String wizName = "addModel";
    private ModelType newModel;
    private BuildNodeType metaData;
    private Collection<String> reservedNames;

    public ModelType getNewModel() {
        return this.newModel;
    }

    private NewModelDialog(BuildNodeType buildNodeType, Collection<String> collection) {
        this.metaData = buildNodeType;
        this.reservedNames = collection;
    }

    protected JEWTDialog buildDialog(Context context, AbstractBuildNode abstractBuildNode) {
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)context.getNode());
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        Collection<String> collection = WorkflowUtils.getInMemoryModelNames(workflowModel, this.metaData);
        collection.addAll(this.reservedNames);
        NewModelPanel newModelPanel = new NewModelPanel(context, abstractBuildNode, collection);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)newModelPanel);
        jEWTDialog.setTitle(BuildEditorLrb.get("NEW_MODEL_DIALOG_TITLE"));
        return jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, AbstractBuildNode abstractBuildNode) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context, abstractBuildNode);
            jEWTDialog.setResizable(true);
            final NewModelPanel newModelPanel = (NewModelPanel)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                        if (!newModelPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                        NewModelDialog.this.newModel = newModelPanel.getNewModel();
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    public static ModelType addNewModel(BuildNodeType buildNodeType, Context context, AbstractBuildNode abstractBuildNode, Collection<String> collection) {
        ModelType modelType = null;
        NewModelDialog newModelDialog = new NewModelDialog(buildNodeType, collection);
        if (newModelDialog.invoke(context, abstractBuildNode)) {
            Object object;
            modelType = newModelDialog.getNewModel();
            MetaDataHelper.setModelTargetPropertiesWithDefaultsFromModel(buildNodeType, modelType);
            MetaDataHelper.disableInvalidInputsInModel(modelType);
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object = (SuperviseBuildNodeType)buildNodeType;
                AttributeType attributeType = object.getTargetAttribute();
                MetaDataHelper.setModelTargetPropertiesWithDefaults(buildNodeType, modelType, attributeType);
            }
            object = buildNodeType.getCaseAttributes().getAttribute();
            MetaDataHelper.setModelCaseIDsPropertiesWithDefaults(buildNodeType, modelType, (List<AttributeType>)object);
        }
        return modelType;
    }

    public static ModelType addNewModel(BuildNodeType buildNodeType, Context context, AbstractBuildNode abstractBuildNode) {
        return NewModelDialog.addNewModel(buildNodeType, context, abstractBuildNode, new ArrayList<String>());
    }
}

