/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.ModelNameValidationDocument;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class NewModelPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(NewModelPanel.class.getName());
    private AbstractBuildNode diagramNode;
    private Collection<String> wfInMemoryModelNames;
    private String modelName;
    private Boolean nameTouched = false;
    private String algorithm;
    private String miningFunction;
    private String comment;
    private ModelType newModel;
    private Context ctx;
    private String[] algorithms;
    private Object[] items;
    private JComboBox jAlgorithm;
    private JLabel jAlgorithmLabel;
    private JLabel jCommentLabel;
    private JTextArea jCommentText;
    private JTextField jModelName;
    private JLabel jModelNameLabel;
    private JScrollPane textScrolPane;
    public static final int NAME_MAX_LEN = 25;

    public NewModelPanel(Context context, AbstractBuildNode abstractBuildNode, Collection<String> collection) {
        this.ctx = context;
        this.diagramNode = abstractBuildNode;
        this.algorithms = null;
        this.items = null;
        this.wfInMemoryModelNames = collection;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jModelNameLabel = new JLabel();
        this.jModelName = new JTextField();
        this.jAlgorithmLabel = new JLabel();
        this.jAlgorithm = new JComboBox();
        this.jCommentLabel = new JLabel();
        this.textScrolPane = new JScrollPane();
        this.jCommentText = new JTextArea();
        this.jModelNameLabel.setText("Name:");
        this.jAlgorithmLabel.setText("Algorithm:");
        this.jAlgorithm.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCommentLabel.setText("Comment:");
        this.jCommentText.setColumns(20);
        this.jCommentText.setRows(5);
        this.textScrolPane.setViewportView(this.jCommentText);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAlgorithmLabel).addComponent(this.jModelNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAlgorithm, 0, 351, Short.MAX_VALUE).addComponent(this.jModelName, -1, 351, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCommentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textScrolPane, -1, 351, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAlgorithmLabel).addComponent(this.jAlgorithm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelNameLabel).addComponent(this.jModelName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCommentLabel).addContainerGap(70, Short.MAX_VALUE)).addComponent(this.textScrolPane, -1, 84, Short.MAX_VALUE))));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAlgorithmLabel, (Component)this.jAlgorithm, (String)BuildEditorLrb.get("MODEL_ALGO"));
        ResourceUtils.resLabel((JLabel)this.jModelNameLabel, (Component)this.jModelName, (String)BuildEditorLrb.get("MODEL_NAME"));
        ResourceUtils.resLabel((JLabel)this.jCommentLabel, (Component)this.jCommentText, (String)BuildEditorLrb.get("MODEL_COMMENT"));
        this.initHelp();
    }

    private void initHelp() {
        if (this.diagramNode instanceof AssociationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"association_node_pi_models_build");
        } else if (this.diagramNode instanceof ClassificationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"classification_node_pi_models_build");
        } else if (this.diagramNode instanceof ClusteringBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"clustering_node_pi_models_build");
        } else if (this.diagramNode instanceof RegressionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"regression_node_pi_models_build");
        } else if (this.diagramNode instanceof AnomalyDetectionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"anomaly_node_pi_models_build");
        } else if (this.diagramNode instanceof FeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"feature_node_pi_models_build");
        }
    }

    public void initUI() {
        BuildNodeType buildNodeType = (BuildNodeType)this.diagramNode.getData();
        Boolean bl = false;
        try {
            Version version = ConnectionFolder.getConnectionFolder(this.ctx).getDbVersion();
            if (version != null && ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
                bl = true;
            }
            this.initAvailableAlgorithms(version, (NodeType)buildNodeType);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.jModelName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                NewModelPanel.this.nameTouched = true;
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        String string = this.algorithms[this.jAlgorithm.getSelectedIndex()];
        try {
            this.modelName = WorkflowUtils.getNewModelNameWfid(this.ctx, this.wfInMemoryModelNames, this.miningFunction, string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            this.modelName = "";
        }
        this.jModelName.setDocument(new ModelNameValidationDocument(25, true));
        this.jModelName.setText(this.modelName);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(this.items);
        this.jAlgorithm.setModel(defaultComboBoxModel);
        this.jAlgorithm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NewModelPanel.this.nameTouched.booleanValue()) {
                    return;
                }
                String string = NewModelPanel.this.algorithms[NewModelPanel.this.jAlgorithm.getSelectedIndex()];
                String string2 = "";
                try {
                    string2 = WorkflowUtils.getNewModelNameWfid(NewModelPanel.this.ctx, NewModelPanel.this.wfInMemoryModelNames, NewModelPanel.this.miningFunction, string);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    string2 = "";
                }
                NewModelPanel.this.jModelName.setText(string2);
            }
        });
    }

    private void initAvailableAlgorithms(Version version, NodeType nodeType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Boolean bl = false;
        if (version != null && ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
            bl = true;
        }
        if (nodeType instanceof ClassificationBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_DT"));
            arrayList.add(BuildEditorLrb.get("ALGO_GLM"));
            arrayList.add(BuildEditorLrb.get("ALGO_NB"));
            arrayList.add(BuildEditorLrb.get("ALGO_SVM"));
            arrayList2.add("ALGO_DECISION_TREE");
            arrayList2.add("ALGO_GENERALIZED_LINEAR_MODEL");
            arrayList2.add("ALGO_NAIVE_BAYES");
            arrayList2.add("ALGO_SUPPORT_VECTOR_MACHINES");
            this.miningFunction = "CLASSIFICATION";
        } else if (nodeType instanceof RegressionBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_GLM"));
            arrayList.add(BuildEditorLrb.get("ALGO_SVM"));
            arrayList2.add("ALGO_GENERALIZED_LINEAR_MODEL");
            arrayList2.add("ALGO_SUPPORT_VECTOR_MACHINES");
            this.miningFunction = "REGRESSION";
        } else if (nodeType instanceof ClusteringBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_KMCL"));
            arrayList.add(BuildEditorLrb.get("ALGO_OCL"));
            arrayList2.add("ALGO_KMEANS");
            arrayList2.add("ALGO_O_CLUSTER");
            if (bl.booleanValue()) {
                arrayList.add(BuildEditorLrb.get("ALGO_EM"));
                arrayList2.add("ALGO_EXPECTATION_MAXIMIZATION");
            }
            this.miningFunction = "CLUSTERING";
        } else if (nodeType instanceof AssociationBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_AR"));
            arrayList2.add("ALGO_APRIORI_ASSOCIATION_RULES");
            this.miningFunction = "ASSOCIATION";
        } else if (nodeType instanceof AnomalyDetectionBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_SVM"));
            arrayList2.add("ALGO_SUPPORT_VECTOR_MACHINES");
            this.miningFunction = "ANOMALY_DETECTION";
        } else if (nodeType instanceof FeatureExtractionBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_NMF"));
            arrayList2.add("ALGO_NONNEGATIVE_MATRIX_FACTOR");
            if (bl.booleanValue()) {
                arrayList.add(BuildEditorLrb.get("ALGO_SVD"));
                arrayList.add(BuildEditorLrb.get("ALGO_PCA"));
                arrayList2.add("ALGO_SINGULAR_VALUE_DECOMP");
                arrayList2.add("ALGO_PRINCIPAL_COMPONENT_ANALYSIS");
            }
            this.miningFunction = "FEATURE_EXTRACTION";
        }
        this.items = arrayList.toArray(new String[0]);
        this.algorithms = arrayList2.toArray(new String[0]);
    }

    public boolean doWork() {
        boolean bl = true;
        this.modelName = this.jModelName.getText();
        this.comment = this.jCommentText.getText();
        this.algorithm = this.algorithms[this.jAlgorithm.getSelectedIndex()];
        if (!NewModelPanel.validateName(this.modelName, this.ctx, this, this.wfInMemoryModelNames, null)) {
            bl = false;
        }
        if (StringUtils.checkDataLossWithMsg(this.ctx, this.modelName, BuildEditorLrb.get("MODEL_NAME_INVALID_TITLE"))) {
            bl = false;
        }
        if (!this.validateComment(this.comment)) {
            bl = false;
        }
        if (bl) {
            this.newModel = this.diagramNode.createNewModel(this.modelName, this.comment, this.miningFunction, this.algorithm);
        }
        if (this.newModel != null) {
            this.newModel.setUseForOutput(true);
        }
        return bl;
    }

    public static boolean validateName(String string, Context context, Component component, Collection<String> collection, String string2) {
        boolean bl = true;
        if (string.length() == 0 || string.length() > 25) {
            Object[] objectArray = new Object[]{25};
            String string3 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.containsOnlyValidDBNameCharacters(string)) {
            Object[] objectArray = new Object[]{25};
            String string4 = MessageFormat.format(BuildEditorLrb.get("MODEL_NAME_INVALID"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)BuildEditorLrb.get("MODEL_NAME_INVALID_TITLE"), null);
            return false;
        }
        if (string2 == null || !string2.equals(string)) {
            bl = WorkflowUtils.validateUserModelName(context, string, component, collection, WorkflowUtils.getAllInMemoryModelNames(context));
        }
        return bl;
    }

    private boolean validateComment(String string) {
        boolean bl = true;
        if (string.length() > 10000) {
            bl = false;
        }
        return bl;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public ModelType getNewModel() {
        return this.newModel;
    }
}

