/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AddStopwordsDialog;
import oracle.dmt.dataminer.workflow.dialog.build.AddStopwordsFromFeaturesDialog;
import oracle.dmt.dataminer.workflow.dialog.build.AddStopwordsFromFeaturesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AddStopwordsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizard;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class StoplistPanel
extends AbstractDialogPanel
implements SearchListener {
    private BuildNodeType _buildNodeType;
    private BuildNodeType.Stoplists _existStoplists;
    private ArrayList<String> _defaultLanguages;
    private boolean _dirty;
    private StoplistTableModel _stoplistModels;
    private StopwordTableModel _stopwordModels;
    private JButton _stoplistResetBtn;
    private JButton _stoplistRemoveBtn;
    private JButton _stoplistAddBtn;
    private JButton _stopwordImportBtn;
    private JButton _stopwordRemoveBtn;
    private JButton _stopwordAddBtn;
    private static Icon _resetIcon;
    private GenericTable _stopwordTable = new DataMinerTable();
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private ToggleToolButton _showWords;
    private ToggleToolButton _showThemes;
    private boolean _bShowWords;
    private boolean _bShowThemes;
    private transient RowFilter<StopwordTableModel, Integer> _tokenFilter;
    private static int SHOW_STOPWORDS;
    private static int SHOW_STOPTHEMES;
    private ComponentWithTitlebar<JComponent> StopwordComponentWithTitlebar;
    private JSplitPane jSplitPane;
    private JPanel jStoplistPanel;
    private JPanel jStopwordPanel;
    private DataMinerTablePanel stoplistTablePanel;
    private String[] _stoplistColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private static final int STOPLIST_NAME = 0;
    private static final int STOPLIST_LANGUAGE = 1;
    private String[] _stopwordColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_TYPE"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private int[] _stopwordColumnWidths = new int[]{180, 100, 100};
    private static final int STOPWORD_NAME = 0;
    private static final int STOPWORD_TYPE = 1;
    private static final int STOPWORD_LANGUAGE = 2;
    private static final int STOPWORD_COLUMN_COUNT = 3;

    public StoplistPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "AbstractBuildNode node must not be null.";
        assert (abstractBuildNode instanceof AbstractBuildNode) : "Must be an instance of AbstractBuildNode node.";
        this.init(buildNodeType, null);
    }

    private void init(BuildNodeType buildNodeType, PropertyModel propertyModel) {
        this._buildNodeType = buildNodeType;
        this._dirty = false;
        this._existStoplists = new BuildNodeType.Stoplists();
        for (StoplistType stoplistType : buildNodeType.getStoplists().getStoplist()) {
            this._existStoplists.getStoplist().add((StoplistType)MetaDataHelper.copyMetadataObject(stoplistType));
            if (!ServerConstants.StoplistLanguage.isDefault(stoplistType.getName())) continue;
            this._defaultLanguages = AbstractTextNode.findStoplistLanguages(stoplistType, "Word");
        }
        this._bShowWords = true;
        this._bShowThemes = true;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        _resetIcon = OracleIcons.getIcon((String)"rollback.png");
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"stoplist");
        this._stoplistModels = new StoplistTableModel();
        this.installStoplistItemFilterActions();
        this.stoplistTablePanel.setup((TableModel)((Object)this._stoplistModels), DialogsLrb.get("STOPLIST_STOPLIST_TABLE_TITLE"), 0, true);
        this.stoplistTablePanel.getTable().setAutoResizeMode(0);
        this.stoplistTablePanel.getTable().setSelectionMode(2);
        this.stoplistTablePanel.getTable().setColumnSelectorAvailable(true);
        this.stoplistTablePanel.getTable().setShowToolTips(true);
        this.stoplistTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.stoplistTablePanel.getTable().setRowSelectionAllowed(true);
        this.stoplistTablePanel.getTable().setSortColumn(0, true);
        TableColumn tableColumn = this.stoplistTablePanel.getTable().getColumnModel().getColumn(0);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._context);
        tableColumn.setCellEditor(dBObjectNameEditor);
        this.stoplistTablePanel.getTable().autoSizeColumnsToFit();
        this.stoplistTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistPanel.this.enableControls();
                int[] nArray = StoplistPanel.this.stoplistTablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length == 1) {
                    StoplistType stoplistType = (StoplistType)StoplistPanel.this._existStoplists.getStoplist().get(nArray[0]);
                    StoplistPanel.this._stopwordModels.resetModel(stoplistType);
                    StoplistPanel.this.resetNiceTableModel(StoplistPanel.this._stopwordModels);
                } else {
                    StoplistPanel.this._stopwordModels.resetModel(null);
                    StoplistPanel.this.resetNiceTableModel(StoplistPanel.this._stopwordModels);
                }
            }
        });
        this._stopwordModels = new StopwordTableModel(null);
        JScrollPane jScrollPane = new JScrollPane((Component)this._stopwordTable);
        this.StopwordComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.installStopwordItemFilterActions(controlBar);
        this.StopwordComponentWithTitlebar.setControlBar(controlBar);
        this._stopwordTable.setModel((TableModel)((Object)this._stopwordModels));
        this._stopwordTable.setResizeColumnOnDoubleClick(true);
        this._stopwordTable.getSelectionModel().setSelectionMode(2);
        this._stopwordTable.setAutoResizeMode(0);
        this._stopwordTable.setSelectionMode(2);
        this._stopwordTable.setColumnSelectorAvailable(true);
        this._stopwordTable.setShowToolTips(true);
        this._stopwordTable.setUpdateSelectionOnSort(true);
        this._stopwordTable.setRowSelectionAllowed(true);
        tableColumn = this._stopwordTable.getColumnModel().getColumn(0);
        StopwordEditor stopwordEditor = new StopwordEditor();
        stopwordEditor.setDocument(new TextFieldLimit(4000));
        tableColumn.setCellEditor(stopwordEditor);
        this._tokenFilter = new RowFilter<StopwordTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends StopwordTableModel, ? extends Integer> entry) {
                String string;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = StoplistPanel.this._searchText != null && StoplistPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                StopwordTableModel stopwordTableModel = entry.getModel();
                String string2 = (String)stopwordTableModel.getValueAt(n, 1);
                if (StoplistPanel.this._bShowWords && ServerConstants.StopTokenType.isWord(string2) || StoplistPanel.this._bShowThemes && ServerConstants.StopTokenType.isTheme(string2)) {
                    bl2 = true;
                }
                String string3 = string = StoplistPanel.this._searchText != null ? StoplistPanel.this._searchText.toLowerCase() : null;
                if (bl2 && bl3 && StoplistPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("STOPLIST_COLUMN_NAME"))) {
                    String string4 = (String)stopwordTableModel.getValueAt(n, 0);
                    if (string4.toLowerCase().startsWith(string)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && StoplistPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("STOPLIST_COLUMN_TYPE"))) {
                    String string5 = (String)stopwordTableModel.getValueAt(n, 1);
                    if (string5.toLowerCase().startsWith(string)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && StoplistPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE"))) {
                    String string6 = (String)stopwordTableModel.getValueAt(n, 2);
                    if (string6.toLowerCase().startsWith(string)) {
                        bl = true;
                    }
                } else if (bl2) {
                    bl = true;
                }
                return bl;
            }
        };
        this.configureSorting();
        int n = 0;
        for (int n2 : this._stopwordColumnWidths) {
            this._stopwordTable.getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._stopwordTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistPanel.this.enableControls();
            }
        });
        this.enableControls();
    }

    private void processAddStoplist() {
        StoplistWizard stoplistWizard = new StoplistWizard();
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this._data;
        if (stoplistWizard.runWizard(this, null, this._context, abstractBuildNode, null)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractBuildNode.getStoplistNextId(this._existStoplists) + "";
            stoplistType.setId(string);
            this._existStoplists.getStoplist().add(stoplistType);
            this._stoplistModels = new StoplistTableModel();
            this.stoplistTablePanel.getTable().setModel((TableModel)((Object)this._stoplistModels));
            this._dirty = true;
            this.enableControls();
        }
    }

    private void installStoplistItemFilterActions() {
        this._stoplistResetBtn = new JButton(_resetIcon);
        this._stoplistResetBtn.setToolTipText(DialogsLrb.get("STOPLIST_RESET_STOPLIST_TOOLTIP"));
        this._stoplistResetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistPanel.this.stoplistTablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length == 1 && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_RESET_DEFAULT"), (String)DialogsLrb.get("STOPLIST_DIALOG"), null, (boolean)true)) {
                    StoplistType stoplistType = AbstractTextNode.generateDefaultStoplist(StoplistPanel.this._context, StoplistPanel.this._defaultLanguages);
                    StoplistPanel.this._existStoplists.getStoplist().set(nArray[0], stoplistType);
                    StoplistPanel.this._dirty = true;
                    StoplistPanel.this._stoplistModels.fireTableDataChanged();
                    StoplistPanel.this._stopwordModels.resetModel(stoplistType);
                    StoplistPanel.this.resetNiceTableModel(StoplistPanel.this._stopwordModels);
                    StoplistPanel.this.enableControls();
                }
            }
        });
        this._stoplistRemoveBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_ATTRIBUTE_REMOVE));
        this._stoplistRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPLIST_TOOLTIP"));
        this._stoplistRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistPanel.this.stoplistTablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistPanel.this._stoplistModels.removeSelectedRows(nArray);
                    StoplistPanel.this._stoplistModels.fireTableDataChanged();
                    StoplistPanel.this.enableControls();
                }
            }
        });
        this._stoplistAddBtn = new JButton(DataMinerIcons.get(Icons.ADD));
        this._stoplistAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPLIST_TOOLTIP"));
        this._stoplistAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistPanel.this.processAddStoplist();
            }
        });
        this.stoplistTablePanel.addControlBarComponents(this._stoplistResetBtn, this._stoplistRemoveBtn, this._stoplistAddBtn);
    }

    private void resetNiceTableModel(StopwordTableModel stopwordTableModel) {
        stopwordTableModel.fireTableDataChanged();
        this._stopwordTable.clearSelection();
        this._stopwordTable.updateUI();
        this.configureSorting();
    }

    public void configureSorting() {
        TableRowSorter<StopwordTableModel> tableRowSorter = (TableRowSorter<StopwordTableModel>)this._stopwordTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<StopwordTableModel>(this._stopwordModels);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._tokenFilter);
        this._stopwordTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._stopwordTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._stopwordTable.scrollToSelection();
    }

    private void processImport() {
        AddStopwordsFromFeaturesDialog addStopwordsFromFeaturesDialog = new AddStopwordsFromFeaturesDialog();
        int[] nArray = this.stoplistTablePanel.getTable().getSelectedRowsInModel();
        int n = nArray[0];
        if (nArray.length == 1) {
            AddStopwordsFromFeaturesPanel addStopwordsFromFeaturesPanel;
            StoplistType stoplistType = (StoplistType)this._existStoplists.getStoplist().get(nArray[0]);
            if (addStopwordsFromFeaturesDialog.invoke(this.getContext(), this, (AbstractBuildNode)this.getData(), this._buildNodeType, stoplistType) && (addStopwordsFromFeaturesPanel = addStopwordsFromFeaturesDialog.getPanel()).isDirty()) {
                stoplistType = addStopwordsFromFeaturesPanel.getStoplist();
                this._existStoplists.getStoplist().set(n, stoplistType);
                this._stopwordModels.resetModel(stoplistType);
                this.resetNiceTableModel(this._stopwordModels);
                AbstractTextNode.updateStoplistTypeAndLanguage(stoplistType);
                this._dirty = true;
                this.enableControls();
            }
        }
    }

    private void processAddStopwords() {
        AddStopwordsPanel addStopwordsPanel;
        AddStopwordsDialog addStopwordsDialog = new AddStopwordsDialog();
        int[] nArray = this.stoplistTablePanel.getTable().getSelectedRowsInModel();
        int n = nArray[0];
        StoplistType stoplistType = (StoplistType)this._existStoplists.getStoplist().get(n);
        if (addStopwordsDialog.invoke(this._context, null, this, stoplistType) && (addStopwordsPanel = addStopwordsDialog.getPanel()).isDirty()) {
            stoplistType = addStopwordsPanel.getStoplist();
            this._existStoplists.getStoplist().set(n, stoplistType);
            this._stopwordModels.resetModel(stoplistType);
            this.resetNiceTableModel(this._stopwordModels);
            AbstractTextNode.updateStoplistTypeAndLanguage(stoplistType);
            this._dirty = true;
            this.enableControls();
        }
    }

    private void installStopwordItemFilterActions(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        IdeAction ideAction = IdeAction.get((int)SHOW_STOPWORDS);
        this._showWords = new ToggleToolButton((ToggleAction)ideAction);
        this._showWords.setIcon(OracleIcons.getIcon((String)"text.png"));
        this._showWords.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPWORDS_TIP"));
        controlBar.add((Component)this._showWords);
        this._showWords.setSelected(this._bShowWords);
        this._showWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                StoplistPanel.this._bShowWords = toggleToolButton.isSelected();
                StoplistPanel.this.configureSorting();
            }
        });
        IdeAction ideAction2 = IdeAction.get((int)SHOW_STOPTHEMES);
        this._showThemes = new ToggleToolButton((ToggleAction)ideAction2);
        this._showThemes.setIcon(OracleIcons.getIcon((String)"catalog.png"));
        this._showThemes.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPTHEMES_TIP"));
        controlBar.add((Component)this._showThemes);
        controlBar.addSeparator();
        this._showThemes.setSelected(this._bShowThemes);
        this._showThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                StoplistPanel.this._bShowThemes = toggleToolButton.isSelected();
                StoplistPanel.this.configureSorting();
            }
        });
        this._stopwordImportBtn = new JButton(DataMinerIcons.get(Icons.ATTR_OUTPUT));
        this._stopwordImportBtn.setToolTipText(DialogsLrb.get("STOPLIST_IMPORT_STOPWORD_TOOLTIP"));
        this._stopwordImportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistPanel.this.processImport();
            }
        });
        controlBar.add((Component)this._stopwordImportBtn);
        this._stopwordRemoveBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_ATTRIBUTE_REMOVE));
        this._stopwordRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPWORD_TOOLTIP"));
        this._stopwordRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistPanel.this._stopwordTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistPanel.this._stopwordModels.removeSelectedRows(nArray);
                    StoplistPanel.this.resetNiceTableModel(StoplistPanel.this._stopwordModels);
                    StoplistPanel.this.enableControls();
                }
            }
        });
        controlBar.add((Component)this._stopwordRemoveBtn);
        this._stopwordAddBtn = new JButton(DataMinerIcons.get(Icons.ADD));
        this._stopwordAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPWORD_TOOLTIP"));
        this._stopwordAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistPanel.this.processAddStopwords();
            }
        });
        controlBar.add((Component)this._stopwordAddBtn);
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("STOPLIST_COLUMN_NAME")), new SearchCategory(DialogsLrb.get("STOPLIST_COLUMN_TYPE")), new SearchCategory(DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE"))}) {
            this._searchField.addCategory(searchCategory);
        }
        controlBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    private void enableControls() {
        int[] nArray = this.stoplistTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length > 1) {
            this._stoplistRemoveBtn.setEnabled(true);
        } else if (nArray.length == 1) {
            StoplistType stoplistType = (StoplistType)this._existStoplists.getStoplist().get(nArray[0]);
            this._stoplistRemoveBtn.setEnabled(!ServerConstants.StoplistLanguage.isDefault(stoplistType.getName()));
            this._stoplistResetBtn.setEnabled(ServerConstants.StoplistLanguage.isDefault(stoplistType.getName()));
        } else {
            this._stoplistRemoveBtn.setEnabled(false);
        }
        this._stoplistAddBtn.setEnabled(true);
        this._stopwordImportBtn.setEnabled(nArray.length == 1);
        this._stopwordAddBtn.setEnabled(nArray.length == 1);
        nArray = this._stopwordTable.getSelectedRowsInModel();
        this._stopwordRemoveBtn.setEnabled(nArray.length > 0);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jStoplistPanel = new JPanel();
        this.stoplistTablePanel = new DataMinerTablePanel();
        this.jStopwordPanel = new JPanel();
        this.StopwordComponentWithTitlebar = new ComponentWithTitlebar();
        this.jSplitPane.setDividerLocation(215);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        GroupLayout groupLayout = new GroupLayout(this.jStoplistPanel);
        this.jStoplistPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.stoplistTablePanel, -1, 483, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.stoplistTablePanel, -1, 192, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setTopComponent(this.jStoplistPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jStopwordPanel);
        this.jStopwordPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.StopwordComponentWithTitlebar, -1, 483, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.StopwordComponentWithTitlebar, -1, 188, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setRightComponent(this.jStopwordPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 431, Short.MAX_VALUE));
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._existStoplists;
    }

    static {
        SHOW_STOPWORDS = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.buildText.showWords");
        SHOW_STOPTHEMES = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.buildText.showThemes");
    }

    private class StopwordEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField _textField = new JTextField();

        public StopwordEditor() {
            this._textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StopwordEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this._textField.setText(string);
            } else if (object == null) {
                this._textField.setText("");
            }
            return this._textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this._textField.getText();
        }

        public void setDocument(Document document) {
            this._textField.setDocument(document);
        }
    }

    private class StopwordTableModel
    extends GenericBaseTableModel {
        private StoplistType _stoplist;

        public StopwordTableModel(StoplistType stoplistType) {
            this._stoplist = stoplistType;
            this.setColumnIdentifiers(StoplistPanel.this._stopwordColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public void resetModel(StoplistType stoplistType) {
            this._stoplist = stoplistType;
        }

        public int getRowCount() {
            if (this._stoplist == null || this._stoplist.getStopTokens() == null) {
                return 0;
            }
            return this._stoplist.getStopTokens().getToken().size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType.StopTokens.Token> vector = new Vector<StoplistType.StopTokens.Token>();
            StoplistType.StopTokens.Token token = null;
            for (int i = 0; i < nArray.length; ++i) {
                token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(nArray[i]);
                vector.add(token);
            }
            this._stoplist.getStopTokens().getToken().removeAll(vector);
            this.setRowCount(this._stoplist.getStopTokens().getToken().size());
            AbstractTextNode.updateStoplistTypeAndLanguage(this._stoplist);
            StoplistPanel.this._dirty = true;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._stoplist.getStopTokens() == null || this._stoplist.getStopTokens().getToken().size() == 0) {
                return null;
            }
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = token.getItem();
                    break;
                }
                case 1: {
                    string = ServerConstants.StopTokenType.toHuman(token.getType());
                    break;
                }
                case 2: {
                    string = ServerConstants.StoplistLanguage.toHuman(token.getLanguage());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (!this.validateStopwords(n, string, token.getLanguage(), token.getType(), this._stoplist.getStopTokens().getToken())) {
                        return;
                    }
                    StoplistPanel.this._dirty = true;
                    token.setItem(string);
                    StoplistPanel.this._dirty = true;
                }
            }
        }

        private boolean validateStopwords(int n, String string, String string2, String string3, List<StoplistType.StopTokens.Token> list) {
            boolean bl = true;
            int n2 = 0;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_STOPWORD_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            for (StoplistType.StopTokens.Token token : list) {
                String string4 = string2 + ":" + string3 + ":" + string;
                String string5 = token.getLanguage() + ":" + token.getType() + ":" + token.getItem();
                if (n != n2 && string4.compareTo(string5) == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPWORD"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                ++n2;
            }
            return bl;
        }
    }

    private class StoplistTableModel
    extends GenericBaseTableModel {
        public StoplistTableModel() {
            this.setColumnIdentifiers(StoplistPanel.this._stoplistColumnNames);
            this.setRowCount(this.getRowCount());
        }

        public int getRowCount() {
            return StoplistPanel.this._existStoplists.getStoplist().size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType> vector = new Vector<StoplistType>();
            StoplistType stoplistType = null;
            for (int i = 0; i < nArray.length; ++i) {
                stoplistType = (StoplistType)StoplistPanel.this._existStoplists.getStoplist().get(nArray[i]);
                if (ServerConstants.StoplistLanguage.isDefault(stoplistType.getName())) continue;
                vector.add(stoplistType);
            }
            StoplistPanel.this._existStoplists.getStoplist().removeAll(vector);
            this.setRowCount(StoplistPanel.this._existStoplists.getStoplist().size());
            StoplistPanel.this._dirty = true;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (StoplistPanel.this._existStoplists.getStoplist().size() == 0) {
                return "Loading...";
            }
            StoplistType stoplistType = (StoplistType)StoplistPanel.this._existStoplists.getStoplist().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = stoplistType.getName();
                    break;
                }
                case 1: {
                    String string2 = stoplistType.getType();
                    if (string2.equals("Basic")) {
                        string = ServerConstants.StoplistLanguage.toHuman(stoplistType.getLanguage());
                        break;
                    }
                    string = ServerConstants.StoplistLanguage.toHuman("Multi");
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType stoplistType = (StoplistType)StoplistPanel.this._existStoplists.getStoplist().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    String string2 = stoplistType.getName();
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                        string2 = StringUtils.addDoubleQuotes(string2);
                    }
                    if (string.length() != 0 && !StringUtils.isDoubleQuotedString(string)) {
                        string = string.toUpperCase();
                    }
                    if (!this.validateStoplistName(n, string, StoplistPanel.this._existStoplists.getStoplist())) {
                        return;
                    }
                    if (string2 != null && string2.compareTo(string) == 0) {
                        return;
                    }
                    string = StringUtils.trimDoubleQuotes(string);
                    stoplistType.setName(string);
                    StoplistPanel.this._dirty = true;
                }
            }
        }

        private boolean validateStoplistName(int n, String string, List<StoplistType> list) {
            boolean bl = true;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (!this.isNameUnique(n, string, list)) {
                return false;
            }
            if (!AttributeNameValidator.isNameLengthValidInDB(StoplistPanel.this._context, string, false)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            return bl;
        }

        private boolean isNameUnique(int n, String string, List<StoplistType> list) {
            int n2 = 0;
            if (list == null) {
                return true;
            }
            for (StoplistType stoplistType : list) {
                if (n != n2 && stoplistType.getName().compareTo(string) == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPLIST"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

